/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Structures                           */
/*                          Section  2.2.1.7                                 */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  5/23/84                                                  */
/*  Source File :           source/decl.22174.c                              */
/*  Revisions :             05/18/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           For an automatic array of structures, verify     */
/*                          that the members of the structure can be         */
/*                          referenced.                                      */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.22.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/*      Test Method :  Initialize an external structure, assign the values to
                       the automatic structure pages, and verify that the
                       members of the automatic structure can be referenced.
*/
 
#include <stdio.h>
#define TRUE 1
 
int fail= 0;
 
struct telephonebook {
          int phone;
          char *name;
          char *street;
          char *city;
          int zip;
}book[] = { 1230000,"Davis Harry","1020 Oakland Pk Blvd","Ft. Lauderdale",33313,
            1230001,"Davis Hazel","213 SW 70th Ave","Miramar",33310,
            1230002,"Davis Helen","5300 Jefferson St","Dania",33713 };
 
main()
{
FILE *fp;
int a;
 
struct phonebook {
          int phone;
          char *name;
          char *street;
          char *city;
          int zip;
}pages[3];
 
fp=fopen("decl_res bloc=y","a");
 
/*  Assign values to members of the automatic structure pages. */
 
        for( a = 0; a < 3 ; a++ )
        {
           pages[a].phone = book[a].phone;
           pages[a].name = book[a].name;
           pages[a].street = book[a].street;
           pages[a].city = book[a].city;
           pages[a].zip = book[a].zip;
        }
 
 
/*  Verify that the members of the automatic structure can be referenced. */
 
        for ( a = 0; a < 3; a++ )
        {   if ( book[a].phone != pages[a].phone )
               { fail = TRUE;
                 fprintf(fp,"  ** declaration, structures 2.2.1.7.4-1 class 2 fail exit return code : %d\n", pages[a].phone );
                 printf("  ** declaration, structures 2.2.1.7.4-1 class 2 fail exit return code : %d\n", pages[a].phone );
               }
 
            if ( compare( book[a].name, pages[a].name ) )
               { fail = TRUE;
                 fprintf(fp,"  ** declaration, structures 2.2.1.7.4-2 class 2 fail exit return code : %s\n", pages[a].name );
                 printf("  ** declaration, structures 2.2.1.7.4-2 class 2 fail exit return code : %s\n", pages[a].name );
               }
 
            if ( compare( book[a].street, pages[a].street ) )
               { fail = TRUE;
                 fprintf(fp,"  ** declaration, structures 2.2.1.7.4-3 class 2 fail exit return code : %s\n", pages[a].street );
                 printf("  ** declaration, structures 2.2.1.7.4-3 class 2 fail exit return code : %s\n", pages[a].street );
               }
 
            if ( compare( book[a].city, pages[a].city ) )
               { fail = TRUE;
                 fprintf(fp,"  ** declaration, structures 2.2.1.7.4-4 class 2 fail exit return code : %s\n", pages[a].city );
                 printf("  ** declaration, structures 2.2.1.7.4-4 class 2 fail exit return code : %s\n", pages[a].city );
               }
 
            if ( book[a].zip != pages[a].zip )
               { fail = TRUE;
                 fprintf(fp,"  ** declaration, structures 2.2.1.7.4-5 class 2 fail exit return code : %d\n", pages[a].zip );
                 printf("  ** declaration, structures 2.2.1.7.4-5 class 2 fail exit return code : %d\n", pages[a].zip );
               }
        }
 
 
    if ( !fail ){
       fprintf(fp,"  .. declaration, structures 2.2.1.7.4 class 2 pass\n");
       printf("  .. declaration, structures 2.2.1.7.4 class 2 pass\n");
       }
       fclose(fp);
}
 
/*      COMPARE:  function - compare two given strings
                  inputs   - two strings, s1 and s2
                  outputs  - == 0, if s1 is equal to s2
                              > 0, if s1 is greater than s2
                              < 0, if s1 is less than s2
*/
 
compare( s1, s2 )
 
char *s1, *s2;
{
        for( ; *s1 == *s2 ; s1++, s2++ )
           if ( *s1 == '\0' )
              return 0;
        return( *s1 - *s2 );
}
