/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declaration - fields                             */
/*                          Section  - 2.3                                   */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/decl.231.c                                */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*  Date :                  10/25/83                                         */
/*  Descriptions :          Verify that fields of different bit lengths are  */
/*                          allocated correctly and can be referenced.       */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.23.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
 
 
/* global data for test 2.3.1-1                                         */
/* define flags to be 32 bits (4 bytes)                                 */
int    FSIZE = 4;
struct {
         unsigned keyword  : 1 ;        /* assign 1 bit field to keyword */
         unsigned extn     : 1;         /*        1 bit field to extern  */
         unsigned statc    : 2;         /*        2 bit field to static  */
         unsigned rest     : 28;        /*        rest of the field      */
       } flags;
 
 
/* global data for test 2.3.1-2                                         */
/* define words less than 32 bits ( exactly 3 bytes )                   */
int    WSIZE = 4;
struct {
         unsigned field1   : 8;
         unsigned field2   : 8;
         unsigned field3   : 8;
       } words;
 
main()
{
    FILE *fp;
 /* local variables used */
         int error,                     /* error return code */
             pass       ;               /* pass indicator    */
             fp=fopen("decl_res bloc=y","a");
 
 /* Test 2.3.1-1 */
 
   flags.keyword = 3;                   /* turn on two bits              */
   if (  flags.keyword != 1 )
         {
         fprintf(fp,"  ** declaration, fields 2.3.1-1 class 2 fail exit return code : %d\n",flags.keyword);
         printf("  ** declaration, fields 2.3.1-1 class 2 fail exit return code : %d\n",flags.keyword);
         }
   else
   {
      flags.extn = 2;                   /* turn on second bit            */
      if (  flags.extn != 0 )
            {
            fprintf(fp,"  ** declaration, fields 2.3.1-1 class 2 fail exit return code : %d\n",flags.extn);
            printf("  ** declaration, fields 2.3.1-1 class 2 fail exit return code : %d\n",flags.extn);
            }
      else
      {
            flags.statc = 5;
            if (  flags.statc != 1 )
                  {
                  fprintf(fp,"  ** declaration, fields 2.3.1-1 class 2 fail exit return code : %d\n",flags.statc);
                  printf("  ** declaration, fields 2.3.1-1 class 2 fail exit return code : %d\n",flags.statc);
                  }
            else
               if (  (error = sizeof(flags)) != FSIZE )
                  {
                  fprintf(fp,"  ** declaration, fields 2.3.1-1 class 2 fail exit return code : %d\n",error);
                  printf("  ** declaration, fields 2.3.1-1 class 2 fail exit return code : %d\n",error);
                  }
                else
                        pass = TRUE;
       }
   }
 
 
 
   /* Test 2.3.1-2 */
   if ( (error = sizeof(words)) != WSIZE )
      {
      fprintf(fp,"  ** declaration, fields 2.3.1-2 class 2 fail exit return code : %d\n",error);
      printf("  ** declaration, fields 2.3.1-2 class 2 fail exit return code : %d\n",error);
      }
   else
      pass = TRUE;
 
if ( pass ){
      fprintf(fp,"  .. declaration, fields 2.3.1   class 2 pass\n");
      printf("  .. declaration, fields 2.3.1   class 2 pass\n");
      }
      fclose(fp);
 
}
 
