/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declaration - fields                             */
/*                          Section  - 2.3.2                                 */
/*  Product and Revision :  1.3                                              */
/*  Author :                Suifun Law                                       */
/*  Date :                  3/15/84                                                  */
/*  Source File :           source/decl.238.c                                */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                                                                           */
/*                          03/01/84    T. Aleksa  UTX-32 1.0 Release        */
/*                          --  Removed extern definitions on field and      */
/*                              field2.                                      */
/*                          --  Fixed error in comparison test.              */
/*                                                                           */
/*  Descriptions :          Verify that static or external field that is     */
/*                          not explicitly initialized is initialized to zero*/
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.23.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
 
     struct {
                unsigned  bit1 : 3;
                unsigned  bit2 : 32;
            } field ;
 
       struct { unsigned  bit3 : 1;
                unsigned  bit4 : 31;
              } field2;
 
 
main()
{
FILE *fp;
static struct {
         unsigned  bit1    : 1;
         unsigned  rest    : 31;
       } boundary;
 
fp=fopen("decl_res bloc=y","a");
if ( (field.bit1 | field.bit2) != 0  ||
     (field2.bit3 | field2.bit4) != 0 ||
     (boundary.bit1 | boundary.rest) != 0 )
   {
   fprintf(fp,"  ** declaration, fields 2.3.8   class 2 fail exit return code : %x%x%x\n",field,field2,boundary);
   printf("  ** declaration, fields 2.3.8   class 2 fail exit return code : %x%x%x\n",field,field2,boundary);
   }
else
   {
   fprintf(fp,"  .. declaration, fields 2.3.8   class 2 pass\n");
   printf("  .. declaration, fields 2.3.8   class 2 pass\n");
   }
   fclose(fp);
}
