/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declaration - fields                             */
/*                          Section  - 2.3.2                                 */
/*  Product and Revision :  1.3                                              */
/*  Author :                Suifun Law                                       */
/*  Date :                  3/15/84                                                  */
/*  Source File :           source/decl.239.c                                */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                                                                           */
/*                          03/01/84    T. Aleksa   UTX-32 1.0 Release       */
/*                          -- Modified test to avoid machine dependence.    */
/*                             Previous test stored field2 as int. See       */
/*                             pg.139 "C Programming Language",Kernighan     */
/*                             Ritchie.                                      */
/*                          -- Modified comparison (if) which previously     */
/*                             assumed bit ordering.                         */
/*                                                                           */
/*  Descriptions :          Verify that fields can be used as a member of a  */
/*                          union.                                           */
/*                          The compiler fails if this program cannot compile*/
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.23.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
 
 union uname {
                struct { unsigned  bit1 : 2;
                         unsigned  bit2 : 30;
                       } field1 ;
                struct { unsigned  bit3 : 2;
                         unsigned  bit4 : 30;
                       } field2 ;
             }  uval;
 
main()
{
FILE *fp;
fp=fopen("decl_res bloc=y","a");
     /* initialize field1 */
     uval.field1.bit1 = 0;
     uval.field1.bit2 = 0x3fffffff;
     /* field1 and field2 share the same location */
     if ( ( uval.field2.bit3 != uval.field1.bit1 ) ||
          ( uval.field2.bit4 != uval.field1.bit2 ) ) {
        fprintf(fp,"  ** declaration, fields 2.3.9 class 2 fail exit return code : %x\n",uval.field2);
        printf("  ** declaration, fields 2.3.9 class 2 fail exit return code : %x\n",uval.field2);
        }
     else
        {
        fprintf(fp,"  .. declaration, fields 2.3.9 class 2 pass\n");
        printf("  .. declaration, fields 2.3.9 class 2 pass\n");
        }
fclose(fp);
}
