/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Union Reference                      */
/*                          Section  2.4.3                                   */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  6/19/84                                          */
/*  Source File :           source/decl.2431.c                               */
/*  Revisions :             05/24/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that members of a union containing basic  */
/*                          types can be referenced and that each member is  */
/*                          treated as a structure member with the offset of */
/*                          zero.                                            */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.24.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
 
int fail=0;
 
union key {
        int t1;
        short t2;
        long t3;
        short int t4;
        long int t5;
        unsigned int t6;
        unsigned t7;
        unsigned short t8;
        unsigned long t9;
        unsigned char t10;
        char t11;
        float t12;
        double t13;
        long float t14;
} types;
 
main()
{
        FILE *fp;
 
/*      Each member of the union is verified by initializing it with a
        constant and then referencing it.  The address of the member is
        stored in a pointer and compared with the address of the first
        member of the union to verify that each member is treated as a
        structure member with the offset of zero.  ( Exception:  The test
        for the address of the first member is compared with the address
        of the second member.)
*/
        int a, b;
        fp=fopen("decl_res bloc=y","a");
 
/* Test 1 */
        a = (int) &types.t1;
        b = (int) &types.t2;
        types.t1 = 1;
        if ( types.t1 != 1 || a != b )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.3.1-1 class 1 fail exit return code : %d %d\n", types.t1, a );
             printf("  ** declaration, unions 2.4.3.1-1 class 1 fail exit return code : %d %d\n", types.t1, a );
           }
 
/* Test 2 */
        b = (int) &types.t2;
        types.t2 = 2;
        if ( types.t2 != 2 || b != a )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.3.1-2 class 1 fail exit return code : %d %d\n", types.t2, b );
             printf("  ** declaration, unions 2.4.3.1-2 class 1 fail exit return code : %d %d\n", types.t2, b );
           }
 
/* Test 3 */
        b = (int) &types.t3;
        types.t3 = 3;
        if ( types.t3 != 3 || b != a )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.3.1-3 class 1 fail exit return code : %d %d\n", types.t3, b );
             printf("  ** declaration, unions 2.4.3.1-3 class 1 fail exit return code : %d %d\n", types.t3, b );
           }
 
/* Test 4 */
        b = (int) &types.t4;
        types.t4 = 4;
        if ( types.t4 != 4 || b != a )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.3.1-4 class 1 fail exit return code : %d %d\n", types.t4, b );
             printf("  ** declaration, unions 2.4.3.1-4 class 1 fail exit return code : %d %d\n", types.t4, b );
           }
 
/* Test 5 */
        b = (int) &types.t5;
        types.t5 = 5;
        if ( types.t5 != 5 || b != a )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.3.1-5 class 1 fail exit return code : %d %d\n", types.t5, b );
             printf("  ** declaration, unions 2.4.3.1-5 class 1 fail exit return code : %d %d\n", types.t5, b );
           }
 
/* Test 6 */
        b = (int) &types.t6;
        types.t6 = 6;
        if ( types.t6 != 6 || b != a )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.3.1-6 class 1 fail exit return code : %d %d\n", types.t6, b );
             printf("  ** declaration, unions 2.4.3.1-6 class 1 fail exit return code : %d %d\n", types.t6, b );
           }
 
/* Test 7 */
        b = (int) &types.t7;
        types.t7 = 7;
        if ( types.t7 != 7 || b != a )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.3.1-7 class 1 fail exit return code : %d %d\n", types.t7, b );
             printf("  ** declaration, unions 2.4.3.1-7 class 1 fail exit return code : %d %d\n", types.t7, b );
           }
 
/* Test 8 */
        b = (int) &types.t8;
        types.t8 = 8;
        if ( types.t8 != 8 || b != a )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.3.1-8 class 1 fail exit return code : %d %d\n", types.t8, b );
             printf("  ** declaration, unions 2.4.3.1-8 class 1 fail exit return code : %d %d\n", types.t8, b );
           }
 
/* Test 9 */
        b = (int) &types.t9;
        types.t9 = 9;
        if ( types.t9 != 9 || b != a )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.3.1-9 class 1 fail exit return code : %d %d\n", types.t9, b );
             printf("  ** declaration, unions 2.4.3.1-9 class 1 fail exit return code : %d %d\n", types.t9, b );
           }
 
/* Test 10 */
        b = (int) &types.t10;
        types.t10 = 't';
        if ( types.t10 != 't' || b != a )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.3.1-10 class 1 fail exit return code : %c %d\n", types.t10, b );
             printf("  ** declaration, unions 2.4.3.1-10 class 1 fail exit return code : %c %d\n", types.t10, b );
           }
 
/* Test 11 */
        b = (int) &types.t11;
        types.t11 = 'y';
        if ( types.t11 != 'y' || b != a )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.3.1-11 class 1 fail exit return code : %c %d\n", types.t11, b );
             printf("  ** declaration, unions 2.4.3.1-11 class 1 fail exit return code : %c %d\n", types.t11, b );
           }
 
/* Test 12 */
        b = (int) &types.t12;
        types.t12 = 12.0;
        if ( types.t12 != 12.0 || b != a )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.3.1-12 class 1 fail exit return code : %f %d\n", types.t12, b );
             printf("  ** declaration, unions 2.4.3.1-12 class 1 fail exit return code : %f %d\n", types.t12, b );
           }
 
/* Test 13 */
        b = (int) &types.t13;
        types.t13 = 13.0;
        if ( types.t13 != 13.0 || b != a )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.3.1-13 class 1 fail exit return code : %f %d\n", types.t13, b );
             printf("  ** declaration, unions 2.4.3.1-13 class 1 fail exit return code : %f %d\n", types.t13, b );
           }
 
/* Test 14 */
        b = (int) &types.t14;
        types.t14 = 14.0;
        if ( types.t14 != 14.0 || b != a )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, unions 2.4.3.1-14 class 1 fail exit return code : %f %d\n", types.t14, b );
             printf("  ** declaration, unions 2.4.3.1-14 class 1 fail exit return code : %f %d\n", types.t14, b );
           }
 
        if ( !fail ) {
           fprintf(fp,"  .. declaration, unions 2.4.3.1 class 1 pass \n");
           printf("  .. declaration, unions 2.4.3.1 class 1 pass \n");
           }
           fclose(fp);
}
