/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Reference - Enumerations                         */
/*                          Section  2.5                                     */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  6/19/84                                          */
/*  Source File :           source/decl.252.c                                */
/*  Revisions :             05/29/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that an enumerator with = gives the       */
/*                          associated identifier the value indicated and    */
/*                          that the subsequent identifier continues the     */
/*                          progression from the assigned value.             */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.25.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
 
/*  Syntax:     enum { enum-list, enumerator }
                enum identifier { enum-list, enumerator }
*/
 
enum test { TRUE, FALSE };
enum test fail;
 
enum  { jan = 1, feb, mar, apr, may, jun = 10, jul, aug, sep,
        oct = 20, nov, dec };
 
main()
{
FILE *fp;
 
enum season { spring, summer = 10, fall, winter };
 
fp=fopen("decl_res bloc=y","a");
fail = FALSE;   /*  initialize enumeration constant to false */
 
if ( jan != 1  || feb != 2  || mar != 3  || apr != 4  ||
     may != 5  || jun != 10 || jul != 11 || aug != 12 ||
     sep != 13 || oct != 20 || nov != 21 || dec !=22    )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, enumeration 2.5.2-1 class 3 fail exit return code : %d%d%d%d%d%d%d%d%d%d%d%d\n",jan, feb, mar, apr, may, jun, jul, aug, sep, oct, nov, dec );
     printf("  ** declaration, enumeration 2.5.2-1 class 3 fail exit return code : %d%d%d%d%d%d%d%d%d%d%d%d\n",jan, feb, mar, apr, may, jun, jul, aug, sep, oct, nov, dec );
   }
 
if ( spring != 0 || summer != 10 || fall != 11 || winter != 12 )
   { fail = TRUE;
     fprintf(fp,"  ** declaration, enumeration 2.5.2-2 class 3 fail exit return code : %d%d%d%d\n",spring, summer, fall, winter );
     printf("  ** declaration, enumeration 2.5.2-2 class 3 fail exit return code : %d%d%d%d\n",spring, summer, fall, winter );
   }
 
if ( fail == FALSE ){
   fprintf(fp,"  .. declaration, enumeration 2.5.2 class 3 pass\n" );
   printf("  .. declaration, enumeration 2.5.2 class 3 pass\n" );
   }
   fclose(fp);
 
}
