/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations, Initialization and Variable        */
/*                          Section - 2.6.1                                  */
/*  Product and Revision :  Unix 1.3                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/decl.2611.c                               */
/*                                                                           */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                          06/01/84    T. Aleksa     UTX-32 1.0 Release     */
/*                          -- Modified test description to include single   */
/*                             and double dimension arrays.                  */
/*                          -- Added double dimension array tests for types  */
/*                             int, float, double, char.                     */
/*                          -- Added tests for types short, short int, long, */
/*                             long int, unsigned short, unsigned long, un-  */
/*                             signed char, unsigned int, unsigned and long  */
/*                             float.                                        */
/*                                                                           */
/*  Date :                  6/19/84                                          */
/*  Description :           For single and double dimension arrays, verify   */
/*                          that storage is allocated correctly for arrays   */
/*                          of all basic types.                              */
/*                          The compiler fails if this program cannot        */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/decl.26.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
#define FALSE 0
 
main()
{   FILE *fp;
  int fail, pass;
  fp=fopen("decl_res bloc=y","a");
   fail=pass=0;
/* Test 2.6.1.1-1  arrays for type int */
   {
        int E, E1[10], E2[10][10];
        int i, j;
        for ( i = 0; i < 10 ; i++ )   /* initialize arrays */
        {
          E1[i] = i;
          for ( j = 0; j < 10 ; j++ )
                E2[i][j] = j;
        }
 
        E1[3] = 10;
        E = *(E1+3);
 
        if ( E != E1[3] || E1[3] != 10 )  /* verify values for array E1 */
        {  fail = TRUE;
           fprintf(fp,"  ** declaration, arrays 2.6.1.1-1 class 1 fail exit return code : %d\n",E);
           printf("  ** declaration, arrays 2.6.1.1-1 class 1 fail exit return code : %d\n",E);
        }
 
        pass = TRUE;                   /* verify values for array E2 */
        for ( i = 0; i < 10 ; i++ )
        {
            for ( j = 0; j < 10; j++ )
                if ( E2[i][j] != j )
                    pass = FALSE;
        }
 
        if ( pass == FALSE )
        {  fail = TRUE;
           fprintf(fp,"  ** declaration, arrays 2.6.1.1-1 class 1 fail exit return code : E2[i][j]\n\n" );
           printf("  ** declaration, arrays 2.6.1.1-1 class 1 fail exit return code : E2[i][j]\n\n" );
           for ( i= 0; i < 10; i++ )
           {
             for ( j = 0; j < 10; j++ )
             {
                 fprintf(fp," %d ", E2[i][j] );
                 printf(" %d ", E2[i][j] );
                 }
             fprintf(fp,"\n");
             printf("\n");
           }
        }
   }
 
/* Test 2.6.1.1-2  arrays for type float */
   {
        float  E, E1[10], E2[10][10];
        int i, j;
        for ( i = 0; i < 10 ; i++ )  /* initialize arrays */
        {
           E1[i] = i;
           for ( j = 0; j < 10; j++ )
               E2[i][j] = j * 5.0;
        }
 
        E1[9] = 10.;
        E = *(E1+9);
        if ( E != E1[9] || E1[9] != 10.  )  /* verify values for array E1 */
        {  fail = TRUE;
           fprintf(fp,"  ** declaration, arrays 2.6.1.1-2 class 1 fail exit return code : %d\n",E);
           printf("  ** declaration, arrays 2.6.1.1-2 class 1 fail exit return code : %d\n",E);
        }
 
        pass = TRUE;                   /* verify values for array E2 */
        for ( i = 0; i < 10 ; i++ )
        {
            for ( j = 0; j < 10; j++ )
                if ( E2[i][j] != j * 5.0 )
                    pass = FALSE;
        }
 
        if ( pass == FALSE )
        {  fail = TRUE;
           fprintf(fp,"  ** declaration, arrays 2.6.1.1-2 class 1 fail exit return code : E2[i][j]\n\n" );
           printf("  ** declaration, arrays 2.6.1.1-2 class 1 fail exit return code : E2[i][j]\n\n" );
           for ( i= 0; i < 10; i++ )
           {
             for ( j = 0; j < 10; j++ )
             {
                 fprintf(fp," %f ", E2[i][j] );
                 printf(" %f ", E2[i][j] );
                 }
             fprintf(fp,"\n");
             printf("\n");
           }
        }
   }
 
/* Test 2.6.1.1-3  arrays for type double */
   {
        double  E, E1[10], E2[10][10];
        int i, j;
        for ( i = 0; i < 10 ; i++ )  /* initialize arrays */
        {
            E1[i] = i;
            for ( j = 0; j < 10; j++ )
                E2[i][j] = j * 1.3;
        }
 
        E1[1] = 10.;
        E = *(E1+1);
        if ( E != E1[1] || E1[1] != 10  ) /* verify values for array E1 */
        {  fail = TRUE;
           fprintf(fp,"  ** declaration, arrays 2.6.1.1-3 class 1 fail exit return code : %23.2e\n",E);
           printf("  ** declaration, arrays 2.6.1.1-3 class 1 fail exit return code : %23.2e\n",E);
        }
 
        pass = TRUE;                   /* verify values for array E2 */
        for ( i = 0; i < 10 ; i++ )
        {
            for ( j = 0; j < 10; j++ )
                if ( E2[i][j] != j * 1.3 )
                    pass = FALSE;
        }
 
        if ( pass == FALSE )
        {  fail = TRUE;
           fprintf(fp,"  ** declaration, arrays 2.6.1.1-3 class 1 fail exit return code : E2[i][j]\n\n" );
           printf("  ** declaration, arrays 2.6.1.1-3 class 1 fail exit return code : E2[i][j]\n\n" );
           for ( i= 0; i < 10; i++ )
           {
             for ( j = 0; j < 10; j++ )
             {
                 fprintf(fp," %f ", E2[i][j] );
                 printf(" %f ", E2[i][j] );
                 }
             fprintf(fp,"\n");
             printf("\n");
           }
        }
   }
 
/* Test 2.6.1.1-4  arrays for type char */
   {
        char a, E, E1[80], E2[2][13];
        int i, j;
        /* initialize all to null byte */
        for ( i = 0; i < 80 ; i++ )
                E1[i] = '\0';
        /* change the last character to ? */
        E1[79] = '?';
        E = *(E1+79);
        if ( E != E1[79] || E1[79] != '?'  )  /* verify values for array E1 */
        {  fail = TRUE;
           fprintf(fp,"  ** declaration, arrays 2.6.1.1-4 class 1 fail exit return code : %c\n",E);
           printf("  ** declaration, arrays 2.6.1.1-4 class 1 fail exit return code : %c\n",E);
        }
 
        a = 'a';                       /* initialize array E2        */
        for ( i = 0; i < 2; i++ )
        {
          for ( j = 0; j < 13 ; j++, a++ )
              E2[i][j] = a;
        }
 
        pass = TRUE;                   /* verify values for array E2 */
        a = 'a';
        for ( i = 0; i < 2; i++ )
        {
            for ( j = 0; j < 13; j++, a++ )
                if ( E2[i][j] != a )
                    pass = FALSE;
        }
 
        if ( pass == FALSE )
        {  fail = TRUE;
           fprintf(fp,"  ** declaration, arrays 2.6.1.1-4 class 1 fail exit return code : E2[i][j]\n\n" );
           for ( i= 0; i < 2; i++ )
           {
             for ( j = 0; j < 13; j++ )
             {
                 fprintf(fp," %c ", E2[i][j] );
                 printf(" %c ", E2[i][j] );
                 }
             fprintf(fp,"\n");
             printf("\n");
           }
        }
   }
/* Test 2.6.1.1-5 double dimension array */
   {/* verify that w[i][j] = *( *(w+i) + j) */
        int   w[10][10];
        int i,j;
        for ( i=0; i<10;i++ )
            for ( j=0; j<10; j++ )
            {
                *( *(w+i) + j) = j;
                if ( *( *(w+i) + j) != w[i][j])
                {  fail = TRUE;
                   fprintf(fp,"  ** declaration, arrays 2.6.1.1-5 class 1 fail exit return code : %d\n", *(*(w+i)+j) );
                   printf("  ** declaration, arrays 2.6.1.1-5 class 1 fail exit return code : %d\n", *(*(w+i)+j) );
                   break;
                }
            }
    }
/*  Test 2.6.1.1-6 arrays for types short and short int */
    {
        short     E1[10], E2[10][10];
        short int E3[10], E4[10][10];
        int i, j;
 
        for ( i = 0; i < 10; i++ )              /* initialize arrays */
        {
            E1[i] = i;
            E3[i] = i + 5;
            for ( j = 0; j < 10; j++ )
            {
                E2[i][j] = j;
                E4[i][j] = j + 5;
            }
        }
 
        pass = TRUE;                   /* Verify values for arrays E1 and E3 */
        for ( i = 0; i < 10; i++ )
            if ( E1[i] != i || E3[i] != i + 5 )
               pass = FALSE;
 
        if ( pass == FALSE )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, arrays 2.6.1.1-6 class 1 fail exit return code : \n\n E1[i] = ");
             printf("  ** declaration, arrays 2.6.1.1-6 class 1 fail exit return code : \n\n E1[i] = ");
             for ( i = 0; i < 10; i++ )
             {
                 fprintf(fp," %d ", E1[i] );
                 printf(" %d ", E1[i] );
                 }
             fprintf(fp,"\n\n E3[i] = ");
             printf("\n\n E3[i] = ");
             for ( i = 0; i < 10; i++ )
             {
                 fprintf(fp," %d ", E3[i] );
                 printf(" %d ", E3[i] );
                 }
             fprintf(fp,"\n\n");
             printf("\n\n");
           }
 
        pass = TRUE;                   /* Verify values for arrays E2 and E4 */
        for ( i = 0; i < 10; i++ )
        {
         for ( j = 0; j < 10; j++ )
            if ( E2[i][j] != j || E4[i][j] != j + 5 )
               pass = FALSE;
        }
 
        if ( pass == FALSE )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, arrays 2.6.1.1-6 class 1 fail exit return code : \n\n E2[i][j] = \n");
             printf("  ** declaration, arrays 2.6.1.1-6 class 1 fail exit return code : \n\n E2[i][j] = \n");
             for ( i = 0; i < 10; i++ )
             {
              for ( j = 0; j < 10; j++ )
              {
                  fprintf(fp," %d ", E2[i][j] );
                  printf(" %d ", E2[i][j] );
                  }
              fprintf(fp,"\n");
              printf("\n");
             }
 
              fprintf(fp,"\n\n E4[i][j] = \n");
              printf("\n\n E4[i][j] = \n");
              for ( i = 0; i < 10; i++ )
              {
               for ( j = 0; j < 10; j++ )
               {
                   fprintf(fp," %d ", E4[i][j] );
                   printf(" %d ", E4[i][j] );
                   }
               fprintf(fp,"\n");
               printf("\n");
              }
              fprintf(fp,"\n");
              printf("\n");
           }
    }
/*  Test 2.6.1.1-7 arrays for types long and long int */
    {
        long     E1[10], E2[10][10];
        long int E3[10], E4[10][10];
        int i, j;
 
        for ( i = 0; i < 10; i++ )              /* initialize arrays */
        {
            E1[i] = i;
            E3[i] = i * 5;
            for ( j = 0; j < 10; j++ )
            {
                E2[i][j] = j;
                E4[i][j] = j * 5;
            }
        }
 
        pass = TRUE;                   /* Verify values for arrays E1 and E3 */
        for ( i = 0; i < 10; i++ )
            if ( E1[i] != i || E3[i] != i * 5 )
               pass = FALSE;
 
        if ( pass == FALSE )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, arrays 2.6.1.1-7 class 1 fail exit return code : \n\n E1[i] = ");
             printf("  ** declaration, arrays 2.6.1.1-7 class 1 fail exit return code : \n\n E1[i] = ");
             for ( i = 0; i < 10; i++ )
             {
                 fprintf(fp," %d ", E1[i] );
                 printf(" %d ", E1[i] );
                 }
             fprintf(fp,"\n\n E3[i] = ");
             printf("\n\n E3[i] = ");
             for ( i = 0; i < 10; i++ )
             {
                 fprintf(fp," %d ", E3[i] );
                 printf(" %d ", E3[i] );
                 }
             fprintf(fp,"\n\n");
             printf("\n\n");
           }
 
        pass = TRUE;                   /* Verify values for arrays E2 and E4 */
        for ( i = 0; i < 10; i++ )
        {
         for ( j = 0; j < 10; j++ )
            if ( E2[i][j] != j || E4[i][j] != j * 5 )
               pass = FALSE;
        }
 
        if ( pass == FALSE )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, arrays 2.6.1.1-7 class 1 fail exit return code : \n\n E2[i][j] = \n");
             printf("  ** declaration, arrays 2.6.1.1-7 class 1 fail exit return code : \n\n E2[i][j] = \n");
             for ( i = 0; i < 10; i++ )
             {
              for ( j = 0; j < 10; j++ )
              {
                  fprintf(fp," %d ", E2[i][j] );
                  printf(" %d ", E2[i][j] );
                  }
              fprintf(fp,"\n");
              printf("\n");
             }
 
              fprintf(fp,"\n\n E4[i][j] = \n");
              printf("\n\n E4[i][j] = \n");
              for ( i = 0; i < 10; i++ )
              {
               for ( j = 0; j < 10; j++ )
               {
                   fprintf(fp," %d ", E4[i][j] );
                   printf(" %d ", E4[i][j] );
                   }
               fprintf(fp,"\n");
               printf("\n");
              }
              fprintf(fp,"\n");
              printf("\n");
           }
    }
/*  Test 2.6.1.1-8 arrays for types unsigned and unsigned int */
    {
        unsigned     E1[10], E2[10][10];
        unsigned int E3[10], E4[10][10];
        int i, j;
 
        for ( i = 0; i < 10; i++ )              /* initialize arrays */
        {
            E1[i] = i;
            E3[i] = i * 2;
            for ( j = 0; j < 10; j++ )
            {
                E2[i][j] = j;
                E4[i][j] = j * 2;
            }
        }
 
        pass = TRUE;                   /* Verify values for arrays E1 and E3 */
        for ( i = 0; i < 10; i++ )
            if ( E1[i] != i || E3[i] != i * 2 )
               pass = FALSE;
 
        if ( pass == FALSE )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, arrays 2.6.1.1-8 class 1 fail exit return code : \n\n E1[i] = ");
             printf("  ** declaration, arrays 2.6.1.1-8 class 1 fail exit return code : \n\n E1[i] = ");
             for ( i = 0; i < 10; i++ )
             {
                 fprintf(fp," %d ", E1[i] );
                 printf(" %d ", E1[i] );
                 }
 
             fprintf(fp,"\n\n E3[i] = ");
             printf("\n\n E3[i] = ");
             for ( i = 0; i < 10; i++ )
             {
                 fprintf(fp," %d ", E3[i] );
                 printf(" %d ", E3[i] );
                 }
             fprintf(fp,"\n\n");
             printf("\n\n");
           }
 
        pass = TRUE;                   /* Verify values for arrays E2 and E4 */
        for ( i = 0; i < 10; i++ )
        {
         for ( j = 0; j < 10; j++ )
            if ( E2[i][j] != j || E4[i][j] != j * 2 )
               pass = FALSE;
        }
 
        if ( pass == FALSE )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, arrays 2.6.1.1-8 class 1 fail exit return code : \n\n E2[i][j] = \n");
             printf("  ** declaration, arrays 2.6.1.1-8 class 1 fail exit return code : \n\n E2[i][j] = \n");
             for ( i = 0; i < 10; i++ )
             {
              for ( j = 0; j < 10; j++ )
              {
                  fprintf(fp," %d ", E2[i][j] );
                  printf(" %d ", E2[i][j] );
                  }
              fprintf(fp,"\n");
              printf("\n");
             }
 
              fprintf(fp,"\n\n E4[i][j] = \n");
              printf("\n\n E4[i][j] = \n");
              for ( i = 0; i < 10; i++ )
              {
               for ( j = 0; j < 10; j++ )
                 {
                   fprintf(fp," %d ", E4[i][j] );
                   printf(" %d ", E4[i][j] );
                   }
               fprintf(fp,"\n");
               printf("\n");
              }
              fprintf(fp,"\n");
              printf("\n");
           }
    }
/*  Test 2.6.1.1-9 arrays for types unsigned long, unsigned short  */
    {
        unsigned short E1[10], E2[10][10];
        unsigned long  E3[10], E4[10][10];
        int i, j;
 
        for ( i = 0; i < 10; i++ )            /* initialize arrays */
        {
            E1[i] = i;
            E3[i] = i * 10;
            for ( j = 0; j < 10; j++ )
            {
                E2[i][j] = j;
                E4[i][j] = j * 20;
            }
        }
 
        pass = TRUE;                   /* Verify values for arrays E1 and E3 */
        for ( i = 0; i < 10; i++ )
            if ( E1[i] != i || E3[i] != i * 10 )
               pass = FALSE;
 
        if ( pass == FALSE )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, arrays 2.6.1.1-9 class 1 fail exit return code : \n\n E1[i] = ");
             printf("  ** declaration, arrays 2.6.1.1-9 class 1 fail exit return code : \n\n E1[i] = ");
             for ( i = 0; i < 10; i++ )
             {
                 fprintf(fp," %d ", E1[i] );
                 printf(" %d ", E1[i] );
                 }
 
             fprintf(fp,"\n\n E3[i] = ");
             printf("\n\n E3[i] = ");
             for ( i = 0; i < 10; i++ )
             {
                 fprintf(fp," %d ", E3[i] );
                 printf(" %d ", E3[i] );
                 }
             fprintf(fp,"\n\n");
             printf("\n\n");
           }
 
        pass = TRUE;                   /* Verify values for arrays E2 and E4 */
        for ( i = 0; i < 10; i++ )
        {
         for ( j = 0; j < 10; j++ )
            if ( E2[i][j] != j || E4[i][j] != j * 20 )
               pass = FALSE;
        }
 
        if ( pass == FALSE )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, arrays 2.6.1.1-9 class 1 fail exit return code : \n\n E2[i][j] = \n");
             printf("  ** declaration, arrays 2.6.1.1-9 class 1 fail exit return code : \n\n E2[i][j] = \n");
             for ( i = 0; i < 10; i++ )
             {
              for ( j = 0; j < 10; j++ )
              {
                  fprintf(fp," %d ", E2[i][j] );
                  printf(" %d ", E2[i][j] );
                  }
              fprintf(fp,"\n");
              printf("\n");
             }
 
              fprintf(fp,"\n\n E4[i][j] = \n");
              printf("\n\n E4[i][j] = \n");
              for ( i = 0; i < 10; i++ )
              {
               for ( j = 0; j < 10; j++ )
               {
                   fprintf(fp," %d ", E4[i][j] );
                   printf(" %d ", E4[i][j] );
                   }
               fprintf(fp,"\n");
               printf("\n");
              }
              fprintf(fp,"\n");
              printf("\n");
           }
    }
/*  Test 2.6.1.1-10 arrays for types unsigned char and long float */
    {
        unsigned char    E1[10], E2[2][13];
        long float       E3[10], E4[2][13];
        char a;
        int i, j;
 
        for ( a = 'a', i = 0; i < 10; i++, a++ ) /* initialize arrays E1 & E3 */
        {
            E1[i] = a;
            E3[i] = i * 1.5;
        }
 
        for ( a = 'a', i = 0; i < 2; i++ )    /* initialize arrays E2 and E4 */
        {
            for ( j = 0; j < 13; j++, a++ )
            {
                E2[i][j] = a;
                E4[i][j] = j * 7.5;
            }
        }
 
        pass = TRUE;                   /* Verify values for arrays E1 and E3 */
        for ( a = 'a', i = 0; i < 10; i++, a++ )
            if ( E1[i] != a || E3[i] != i * 1.5 )
               pass = FALSE;
 
        if ( pass == FALSE )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, arrays 2.6.1.1-10 class 1 fail exit return code : \n\n E1[i] = ");
             printf("  ** declaration, arrays 2.6.1.1-10 class 1 fail exit return code : \n\n E1[i] = ");
             for ( i = 0; i < 10; i++ )
             {
                 fprintf(fp," %c ", E1[i] );
                 printf(" %c ", E1[i] );
                 }
             fprintf(fp,"\n\n E3[i] = ");
             printf("\n\n E3[i] = ");
             for ( i = 0; i < 10; i++ )
             {
                 fprintf(fp," %f ", E3[i] );
                 printf(" %f ", E3[i] );
                 }
             fprintf(fp,"\n\n");
             printf("\n\n");
           }
 
        pass = TRUE;                   /* Verify values for arrays E2 and E4 */
        for ( a = 'a', i = 0; i < 2; i++ )
        {
         for ( j = 0; j < 13; j++, a++ )
            if ( E2[i][j] != a || E4[i][j] != j * 7.5 )
               pass = FALSE;
        }
 
        if ( pass == FALSE )
           { fail = TRUE;
             fprintf(fp,"  ** declaration, arrays 2.6.1.1-10 class 1 fail exit return code : \n\n E2[i][j] = \n");
             printf("  ** declaration, arrays 2.6.1.1-10 class 1 fail exit return code : \n\n E2[i][j] = \n");
             for ( i = 0; i < 2; i++ )
             {
              for ( j = 0; j < 13; j++ )
              {
                  fprintf(fp," %c ", E2[i][j] );
                  printf(" %c ", E2[i][j] );
                  }
              fprintf(fp,"\n");
              printf("\n");
             }
 
              fprintf(fp,"\n\n E4[i][j] = \n");
              printf("\n\n E4[i][j] = \n");
              for ( i = 0; i < 2; i++ )
              {
               for ( j = 0; j < 13; j++ )
               {
                   fprintf(fp," %f ", E4[i][j] );
                   printf(" %f ", E4[i][j] );
                   }
               fprintf(fp,"\n");
               printf("\n");
              }
              fprintf(fp,"\n");
              printf("\n");
           }
    }
 
   if (!fail)
        fprintf(fp,"  .. declaration, arrays 2.6.1.1 class 1 pass\n");
        printf("  .. declaration, arrays 2.6.1.1 class 1 pass\n");
        fclose(fp);
}
 
