/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Declarations - Pointer Reference                 */
/*                          Section - 2.8.2                                  */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/decl.282.c                                */
/*  Revisions :             01/09/83    Sqa     Original UTX 2.0 Release     */
/*  Date :                  10/25/83                                         */
/*  Description :           Verify that "char s[]" and "char *s" declaration */
/*                          are equivalent.                                  */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/misc.28.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/* Character Pointers and Functions */
/* Test method : Two strings are initialized to be equal to each other.
                 Procedure cmpare1 is then used to compare these two strings
                 using the declaration "char s[]", the result obtained should
                 be zero.
                 Procedure cmpare2 is then used to compare these two strings
                 again using declaration "char *s", the result obtained should
                 also be zero.
                 The compiler fails if both result1 and result2 are not equal
                 to each other, or this program cannot be compiled.
*/
 
#include <stdio.h>
 
main()
{
FILE *fp;
  char buf[256];                   /* reserve space */
   char *s,*t=buf;                  /* initialize  pointer t to where string
                                       will be copied */
   int  result1, result2 ;
 
fp=fopen("decl_res bloc=y","a");           /* OPEN FILE FOR WRITTING RESULTS */
   s = "Hello, how are you ?";      /* initialize the first string         */
   copy ( s, t );                   /* copy over to t*/
 
 
                                    /* first version of compare routine    */
   result1 = cmpare1 ( s, t );      /* compare the result of two strings   */
                                    /* They should be equal to each other  */
   if (result1) {
      fprintf(fp,"  ** declaration, pointer ref. 2.8.2-1 class 1 fail exit return code : %d\n",result1);
      printf("  ** declaration, pointer ref. 2.8.2-1 class 1 fail exit return code : %d\n",result1);
      }
       
                                   /* Second version of compare routine    */
 
   result2  = cmpare2 ( s, t );
   if ( ( result1 - result2 ) ){
       fprintf (fp,"  ** declaration, pointer ref. 2.8.2-2 class 1 fail exit return code : %d\n",result2);
       printf("  ** declaration, pointer ref. 2.8.2-2 class 1 fail exit return code : %d\n",result2);
       }
   else 
     {
       fprintf (fp,"  .. declaration, pointer ref. 2.8.2 class 1 pass\n");
       printf("  .. declaration, pointer ref. 2.8.2 class 1 pass\n");
       }
        
}
 
/* COPY */
/* function               : copy one string to another
   inputs                 : address of two strings
   outputs                : s2 = s1
   global variable used   : none
*/
copy ( s1, s2 )
char *s1, *s2;
 
{
   while ( *s2++ = *s1++ );
}
 
/* CMPARE1 */
/* function               : compare two given strings
   inputs                 : two string s1, s2
   outputs                : =0, if s1 is equal to s2
                          : >0, if s1 is greater than s2
                          : <0, if s1 is less than s2
   global variable used   : none
*/
cmpare1 ( s1, s2 )
char s1[], s2[];
{
    int i;
 
    i = 0;
    while (s1[i] == s2[i] )                   /* cmpare each character  */
       if ( s1[i++] == '\0' )                 /* until there is no match */
          return (0);                         /* or end of string        */
 
 
    return ( s1[i] - s2[i] );
}
 
/* cmpare2 */
/* This is a second version of procedure cmpare */
/* Verify char *s is equivalent to char s[]      */
 
cmpare2 ( s1, s2 )
char *s1, *s2;
 
{
    for ( ; *s1 == *s2 ;  s1++, s2++ )
        if ( *s1 == '\0' )
              return(0);
 
    return ( *s1 - *s2 );
}
