/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Expressions - Sizeof operator                    */
/*                          Section - 4.1.1.8                                */
/*  Product and Revision :  Unix 1.5                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/expr.4118.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                          03/13/84    T. Aleksa  UTX-32 1.0 Release        */
/*                          -- Changed from class 2 to class 1.              */
/*                          07/30/84    T. Aleksa  UTX-32 1.0 Release        */
/*                          -- Updated test 1.                               */
/*                          09/28/85    T. Aleksa  UTX-32 1.2 Release        */
/*                          -- Updated test 1.                               */
/*                                                                           */
/*  Date :                  9/28/85                                          */
/*  Description :           Verify sizeof(type-name) yields the number of    */
/*                          bytes of storage that a type uses.               */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/expr.41.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define   TRUE          1
 
 
main()
{
      FILE *fp;
      int a,b,c,d,e,f,g,h,i,j;
      int fail=0;
      char *s;
      fp=fopen("expr_res bloc=y","a");    /* OPEN FILE FOR WRITTING RESULTS */
 
      a = sizeof(char) + sizeof(int);           /* a = 1 + 4 = 5 */
      b = sizeof( "0123456789");                /* since a string returns the
                                                   length of a string
                                                   which is 11 bytes.  */
      c = sizeof('\0');                         /* the value of a character
                                                   constant is the numerical
                                                   value of the character in
                                                   the machine's char set */
      d = sizeof(double);                       /* d = 8 */
      e = sizeof(long);                         /* e = 4 */
      f = sizeof(float);                        /* f = 4 */
      g = sizeof(s);                            /* g = 4 */
      h = sizeof(*s);                           /* h = 1 , pointer to char */
      i = sizeof(short int);
      j = sizeof(long int);                     /* j = 4 */
 
      if ( a != 5 || b != 11 || c != 4 ||  d != 8 || e != 4 ||
           f != 4 || g != 4  || h != 1 ||  i != 2 || j != 4  )
         {  fail = TRUE;
            fprintf(fp,"  ** expression, sizeof operator 4.1.1.8-1 class 1 fail exit return code : %d%d%d%d%d%d%d%d%d%d\n",a,b,c,d,e,f,g,h,i,j );
            printf("  ** expression, sizeof operator 4.1.1.8-1 class 1 fail exit return code : %d%d%d%d%d%d%d%d%d%d\n",a,b,c,d,e,f,g,h,i,j );
         }
 
        /* Test 2 : sizeof( sturct variable) */
        /*          The following test is machine dependent,
                    we have to do more investigation on these.
        */
    {
        struct tag  { char x;   char     y; } x ,y,tag;
        struct tag1 { char x1;   int    y1; } x1,y1,tag1;
        struct tag2 { int  x2;   int    y2; } x2,y2,tag2;
        struct tag3 { int  x3;   long   y3; } x3,y3,tag3;
        struct tag4 { int  x4;   float  y4; } x4,y4,tag4;
        struct tag5 { char x5;   double y5; } x5,y5,tag5;
        struct tag6 { int  x6;   double y6; } x6,y6,tag6;
        struct tag7 { double x7; double y7; } x7,y7,tag7;
        struct tag8 { char   x8; double y8; } x8,y8,tag8;
        int s,s1,s2,s3,s4,s5,s6,s7,s8;
 
        s  = sizeof(tag );
        s1 = sizeof(tag1);
        s2 = sizeof(tag2);
        s3 = sizeof(tag3);
        s4 = sizeof(tag4);
        s5 = sizeof(tag5);
        s6 = sizeof(tag6);
        s7 = sizeof(tag7);
        s8 = sizeof(tag8);
        if ( s != 2 || s1 != 8 || s2 != 8 || s3 != 8
                    || s4 != 8 || s5 != 16 || s6 != 16
                    || s7 != 16 || s8 != 16 )
        {   fail = TRUE;
            fprintf(fp,"  ** expression, sizeof operator 4.1.1.8 class 1 fail exit return code : %d%d%d%d%d%d%d%d%d\n",s,s1,s2,s3,s4,s5,s6,s7,s8);
            printf("  ** expression, sizeof operator 4.1.1.8 class 1 fail exit return code : %d%d%d%d%d%d%d%d%d\n",s,s1,s2,s3,s4,s5,s6,s7,s8);
        }
     }
        if (!fail){
         fprintf(fp,"  .. expression, sizeof operator 4.1.1.8 class 1 pass\n");
         printf("  .. expression, sizeof operator 4.1.1.8 class 1 pass\n");
         }
         fclose(fp);
}
 
