/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Expressions - Sizeof operator                    */
/*                          Section - 4.1.1.9                                */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/expr.4119.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*  Date :                  10/25/83                                         */
/*  Description :           Verify sizeof operator is semantically an integer*/
/*                          constant and may be used anywhere a constant is  */
/*                          required.                                        */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/expr.41.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define   TABSIZE (sizeof(keytab)/sizeof(struct key))
#define   TRUE          1
 
struct key {
             char *keyword;
             int  keycount;
           } keytab[]={        {"auto",0},
                               {"break",0},
                               {"case",0},
                               {"char",0},
                               {"continue",0}
                      };
 
/* use sizeof within main program declaration and expression.*/
main()
{
   FILE *fp;
   char s[TABSIZE];
   char ss[sizeof(keytab)];
   int a,b;
   fp=fopen("expr_res bloc=y","a");    /* OPEN FILE FOR WRITTING RESULTS */
   a = sizeof(s) - 2;
   b =(sizeof(s))- 2;
   if ( a != b){
      fprintf(fp,"  ** expression, sizeof operator 4.1.1.9 class 1 fail exit return code : %d%d\n",a,b);
      printf("  ** expression, sizeof operator 4.1.1.9 class 1 fail exit return code : %d%d\n",a,b);
      }
   else
      {
      fprintf(fp,"  .. expression, sizeof operator 4.1.1.9 class 1 pass\n");
      printf("  .. expression, sizeof operator 4.1.1.9 class 1 pass\n");
      }
      fclose(fp);
 
}
 
/* use sizeof within function declaration. */
function()
{  char s[TABSIZE];
   char ss[sizeof(struct key)];
}
