/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Expressions - Bitwise logical operators          */
/*                          Section - 4.1.3.1.1                              */
/*  Product and Revision :  Unix 1.5                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/expr.41311.c                              */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                                                                           */
/*                          04/11/83    T. Aleksa     UTX-32 1.0 Release     */
/*                          --  Modified test 4.                             */
/*                                                                           */
/*  Date :                  6/19/84                                                  */
/*  Description :           Verify that the right-shift operator >> will     */
/*                          right-shift the integral right operand by the    */
/*                          number of bit positions given by the integral    */
/*                          right operand.                                   */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/expr.41.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE  1
int NO_EXTN=0,SIGN_EXTN=0;
int fail;
main ()
{ 
 
FILE *fp;
fp=fopen("expr_res bloc=y","a");
  { /* Test 1 */
    register int a,b;
    int          c;
    a = c =  3 ; b  = 2;
    a = a >> b;
    c = c >> 2;
    if ( a != 0 || c != 0 || b != 2 )
       {  fail = TRUE;
          fprintf(fp,"  ** expression, right shift 4.1.3.1.1-1 class 1 fail -  exit return code : %x%x%x\n",a,b,c);
          printf("  ** expression, right shift 4.1.3.1.1-1 class 1 fail -  exit return code : %x%x%x\n",a,b,c);
       }
  }
 
  { /* Test 2 */
    unsigned a,b,c;
    a = c = 3 ; b = 2;
    a = a >> b;
    c = c >> 3;
    if ( a != 0 || b != 2 || c != 0 )
       { fail = TRUE;
         fprintf(fp,"  ** expression, right shift 4.1.3.1.1-2 class 1 fail -  exit return code : %x%x%x\n",a,b,c);
         printf("  ** expression, right shift 4.1.3.1.1-2 class 1 fail -  exit return code : %x%x%x\n",a,b,c);
       }
  }
 
  { /* Test 3 */
    short  a,b,c;
    a = c =  3 ; b = 2;
    a = a >> b;
    c = c >> 3;
    if ( a != 0 || b != 2 || c != 0 )
       { fail = TRUE;
         fprintf(fp,"  ** expression, right shift 4.1.3.1.1-3 class 1 fail -  exit return code : %x%x%x\n",a,b,c);
         printf("  ** expression, right shift 4.1.3.1.1-3 class 1 fail -  exit return code : %x%x%x\n",a,b,c);
       }
  }
 
  { /* Test 4 */
   int a,b;
   a = -3; b = 2;
   a = a >> b;
   if ( a !=  0x3fffffff )
      if ( a != 0xffffffff )
         {  fail = TRUE;
            fprintf(fp,"  ** expression, right shift 4.1.3.1.1-4 class 1 fail -  exit return code : %x%x\n",a,b);
            printf("  ** expression, right shift 4.1.3.1.1-4 class 1 fail -  exit return code : %x%x\n",a,b);
         }
       else
         SIGN_EXTN = TRUE;
    else
      if ( a == 0x3fffffff )
         NO_EXTN = TRUE;
      else
         { fail = TRUE;
           fprintf(fp,"  ** expression, right shift 4.1.3.1.1-4 class 1 fail-  exit return code : %x%x\n",a,b);
           printf("  ** expression, right shift 4.1.3.1.1-4 class 1 fail-  exit return code : %x%x\n",a,b);
         }
  }
 
 
  if ( SIGN_EXTN && !fail )
  {
         fprintf(fp,"  !! expression, right shift 4.1.3.1.1 class 1\n");
         printf("  !! expression, right shift 4.1.3.1.1 class 1\n");
         fprintf(fp,"     Right shifting a signed quantity will fill with sign bits \n     Please check documentation\n");
         printf("     Right shifting a signed quantity will fill with sign bits \n     Please check documentation\n");
  }
  else
  if ( NO_EXTN && !fail )
  {
         fprintf(fp,"  !! expression, right shift 4.1.3.1.1 class 1\n");
         printf("  !! expression, right shift 4.1.3.1.1 class 1\n");
         fprintf(fp,"     Right shifting a signed quantity will fill with 0-bits\n     Please check documentation\n");
         printf("     Right shifting a signed quantity will fill with 0-bits\n     Please check documentation\n");
 fclose(fp);
  }
}
 
