/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Expressions - Bitwise logical operators          */
/*                          Section - 4.1.3.3.2                              */
/*  Product and Revision :  1.4                                              */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/expr.41332.c                              */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                          04/04/84    T. Aleksa   UTX-32 1.0 Release       */
/*                          -- Renumbered tests.                             */
/*                          07/02/84    T. Aleksa   UTX-32 1.0 Release       */
/*                          -- Added cast to unsigned in test 5.             */
/*                                                                           */
/*  Date :                  7/2/84                                                   */
/*  Description :           Verify that the bitwise AND &, OR |, and XOR ^   */
/*                          operators result in the correct operation on     */
/*                          integral types.                                  */
/*                          This program tests the bitwise OR, the rest of   */
/*                          the tests are on expr.41333.c                    */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/expr.41.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE  1
int fail;
main ()
{               
  int test;                                     /* use to identify test no.*/
 
FILE *fp;
fp=fopen("expr_res bloc=y","a");
/* Bitwise OR */
  {/* Test 1 */
    register int a,b;
    int          c;
    a = c =  2 ; b  = 3;                        /* a = 010   b = 011        */
    a = a | b;                                  /* a = 010 & 011 = 010      */
    c = c | 3;
    if ( a != 3 || b != 3 || c != 3 )
       {  fail = TRUE;
          fprintf(fp,"  ** expression, bitwise OR 4.1.3.3.2-1 class 1 fail -  exit return code : %x%x%x\n",a,b,c);
          printf("  ** expression, bitwise OR 4.1.3.3.2-1 class 1 fail -  exit return code : %x%x%x\n",a,b,c);
       }
  }
 
  {/* Test 2 */
    unsigned a,b,c;
    a = c = 2 ; b = 3;
    a = a | b;
    c = c | 3;
    if ( a != 3 || b != 3 || c != 3 )
       { fail = TRUE;
         fprintf(fp,"  ** expression, bitwise OR 4.1.3.3.2-2 class 1 fail -  exit return code : %x%x%x\n",a,b,c);
         printf("  ** expression, bitwise OR 4.1.3.3.2-2 class 1 fail -  exit return code : %x%x%x\n",a,b,c);
       }
  }
 
  {/* Test 3 */
    short  a,b,c;
    a = c =  2 ; b = 3;
    a = a | b;
    c = c | 3;
    if ( a != 3 || b != 3 || c != 3 )
       { fail = TRUE;
         fprintf(fp,"  ** expression, bitwise OR 4.1.3.3.2-3 class 1 fail -  exit return code : %x%x%x\n",a,b,c);
         printf("  ** expression, bitwise OR 4.1.3.3.2-3 class 1 fail -  exit return code : %x%x%x\n",a,b,c);
       }
  }
 
  {/* Test 4 */
   int a,b;
   a = -2; b = 3;
   a = a | b;
   if ( a != 0xffffffff )
         {  fail = TRUE;
            fprintf(fp,"  ** expression, bitwise OR 4.1.3.3.2-4 class 1 fail -  exit return code : %x%x\n",a,b);
            printf("  ** expression, bitwise OR 4.1.3.3.2-4 class 1 fail -  exit return code : %x%x\n",a,b);
         }
  }
 
  {/* Test 5 */
     unsigned a,b ;
     a = 0x0f0f0f0f;
     b = 0xf0f0f0f0;
     a = a | b;
     if ( a != (unsigned) 0xffffffff )
        { fail = TRUE;
          fprintf(fp,"  ** expression, bitwise OR 4.1.3.3.2-5 class 1 fail -  exit return code : %x%x\n",a,b);
          printf("  ** expression, bitwise OR 4.1.3.3.2-5 class 1 fail -  exit return code : %x%x\n",a,b);
        }
  }
 
  {/* Test 6 */
     int a,b,c,d;
     a =  1 | 1 | 0  |  1 | 1  ;
     b =  1 | ( 1 | 0 ) | ( 1 | 1 );
     c =  ( 1 | 1 ) | ( 0 | 1 ) | 1;
     if ( a != 1 || b != 1 || c != 1 )
        { fail = TRUE;
          fprintf(fp,"  ** expression, bitwise OR 4.1.3.3.2-6 class 1 fail -  exit return code : %x%x%x\n",a,b,c);
          printf("  ** expression, bitwise OR 4.1.3.3.2-6 class 1 fail -  exit return code : %x%x%x\n",a,b,c);
        }
  }
 
  {/* Test 7 */
   /*         use AND, OR, and complement operators */
    int a,b ;
    a = ~  0177 &  ~ 0611;
    b = ~ ( 0177 | 0611 );
    if ( a != b)
       { fail = TRUE;
         fprintf(fp,"  ** expression, bitwise operators 4.1.3.3.2-7 class 1 fail -  exit return code : %x%x\n",a,b);
         printf("  ** expression, bitwise operators 4.1.3.3.2-7 class 1 fail -  exit return code : %x%x\n",a,b);
       }
  }
  if ( !fail)
    {fprintf(fp,"  .. expression, bitwise OR  4.1.3.3.2 class 1 pass\n");
     printf("  .. expression, bitwise OR  4.1.3.3.2 class 1 pass\n");}
 fclose(fp);
}
 
