/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Expressions, Operators                           */
/*                          Relational Operators                             */
/*                          Section  4.1.4                                   */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  4/23/84                                          */
/*  Source File :           source/expr.4146.c                               */
/*  Revisions :             03/22/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that each relational operator works       */
/*                          correctly on unsigned integers.                  */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/expr.41.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/*   This test was originally qar155 written against UTX Release 2.0.         */
 
/*   Problem description:  Truthtable test shows a problem in relational op-  */
/*                         operators on unsigned integers.                    */
 
#include <stdio.h>
#define TRUE 1
int fail;
#define HI 0x70000000
#define LO 0x00000001
 
struct truth {
        int t_upl;
        int t_upr;
        int t_lowl;
        int t_lowr;
};
 
struct truth truthtbl[] = {
        0, 0, LO, LO,
        0, 0, LO, HI,
        0, 0, HI, LO,
        0, 0, HI, HI,
        0, 1, LO, LO,
        0, 1, LO, HI,
        0, 1, HI, LO,
        0, 1, HI, HI,
        1, 0, LO, LO,
        1, 0, LO, HI,
        1, 0, HI, LO,
        1, 0, HI, HI,
        1, 1, LO, LO,
        1, 1, LO, HI,
        1, 1, HI, LO,
        1, 1, HI, HI,
};
FILE *fp;
 
 
main()
{
        register struct truth *tt;
        unsigned left, right;
 
fp=fopen("expr_res bloc=y","a");
        for ( tt = truthtbl; tt < &truthtbl[16]; tt++ )
        {
 
        /*  left shift t_upl 31 bits and set bits set in t_lowl  */
        /*  left shift t_upr 31 bits and set bits set in t_lowr  */
 
                left = (tt -> t_upl << 31) | (tt -> t_lowl);
                right = (tt -> t_upr << 31) | (tt -> t_lowr);
                compare ( left, right );
        }
        if ( !fail )
               {fprintf(fp,"  .. expression, relational operator 4.1.4.6 class 1 pass\n");
                printf("  .. expression, relational operator 4.1.4.6 class 1 pass\n");}
}
/*     This routine performs the relational operator test     */
/*     for each left, right pair.                             */
 
compare( lf, rt )
register unsigned lf;
unsigned rt;
{
        switch ( lf ) {
        case 0x00000001 :
                switch ( rt ) {
                case 0x00000001 :
                        if ( ((lf > rt) != 0 ) || ((lf >= rt) != 1) ||
                            ((lf == rt) != 1) || ((lf <= rt) != 1) ||
                            ((lf < rt) != 0 ) )
                        {
                                fail = TRUE;
                                fprintf(fp,"  ** expression, relational operator 4.1.4.6-1 ");
                                printf("  ** expression, relational operator 4.1.4.6-1 ");
                                fprintf(fp,"class 1 fail -  exit return code ");
                                printf("class 1 fail -  exit return code ");
                                fprintf(fp,"%d%d%d%d%d%x\n",lf>rt,lf>=rt,lf==rt,lf<=rt,lf<rt,rt);
                                printf("%d%d%d%d%d%x\n",lf>rt,lf>=rt,lf==rt,lf<=rt,lf<rt,rt);
                        }
                        break;
                case 0x70000000 :
                case 0x80000001 :
                case 0xf0000000 :
                        if ( ((lf > rt) != 0 ) || ((lf >= rt) != 0) ||
                            ((lf == rt) != 0) || ((lf <= rt) != 1) ||
                            ((lf < rt) != 1 ) )
                        {
                                fail = TRUE;
                                fprintf(fp,"  ** expression, relational operator 4.1.4.6-2 ");
                                printf("  ** expression, relational operator 4.1.4.6-2 ");
                                fprintf(fp,"class 1 fail -  exit return code ");
                                printf("class 1 fail -  exit return code ");
                                fprintf(fp,"%d%d%d%d%d%x\n",lf>rt,lf>=rt,lf==rt,lf<=rt,lf<rt,rt);
                                printf("%d%d%d%d%d%x\n",lf>rt,lf>=rt,lf==rt,lf<=rt,lf<rt,rt);
                        }
                        break;
                };
                break;
        case 0x70000000 :
                switch ( rt ) {
                case 0x00000001 :
                        if ( ((lf > rt) != 1 ) || ((lf >= rt) != 1) ||
                            ((lf == rt) != 0) || ((lf <= rt) != 0) ||
                            ((lf < rt) != 0 ) )
                        {
                                fail = TRUE;
                                fprintf(fp,"  ** expression, relational operator 4.1.4.6-3 ");
                                printf("  ** expression, relational operator 4.1.4.6-3 ");
                                fprintf(fp,"class 1 fail -  exit return code ");
                                printf("class 1 fail -  exit return code ");
                                fprintf(fp,"%d%d%d%d%d%x\n",lf>rt,lf>=rt,lf==rt,lf<=rt,lf<rt,rt);
                                printf("%d%d%d%d%d%x\n",lf>rt,lf>=rt,lf==rt,lf<=rt,lf<rt,rt);
                        }
                        break;
                case 0x80000001 :
                case 0xf0000000 :
                        if ( ((lf > rt) != 0 ) || ((lf >= rt) != 0) ||
                            ((lf == rt) != 0) || ((lf <= rt) != 1) ||
                            ((lf < rt) != 1 ) )
                        {
                                fail = TRUE;
                                fprintf(fp,"  ** expression, relational operator 4.1.4.6-4 ");
                                printf("  ** expression, relational operator 4.1.4.6-4 ");
                                fprintf(fp,"class 1 fail -  exit return code ");
                                printf("class 1 fail -  exit return code ");
                                fprintf(fp,"%d%d%d%d%d%x\n",lf>rt,lf>=rt,lf==rt,lf<=rt,lf<rt,rt);
                                printf("%d%d%d%d%d%x\n",lf>rt,lf>=rt,lf==rt,lf<=rt,lf<rt,rt);
                        }
                        break;
                case 0x70000000 :
                        if ( ((lf > rt) != 0 ) || ((lf >= rt) != 1) ||
                            ((lf == rt) != 1) || ((lf <= rt) != 1) ||
                            ((lf < rt) != 0 ) )
                        {
                                fail = TRUE;
                                fprintf(fp,"  ** expression, relational operator 4.1.4.6-5 ");
                                printf("  ** expression, relational operator 4.1.4.6-5 ");
                                fprintf(fp,"class 1 fail -  exit return code ");
                                printf("class 1 fail -  exit return code ");
                                fprintf(fp,"%d%d%d%d%d%x\n",lf>rt,lf>=rt,lf==rt,lf<=rt,lf<rt,rt);
                                printf("%d%d%d%d%d%x\n",lf>rt,lf>=rt,lf==rt,lf<=rt,lf<rt,rt);
                        }
                        break;
                };
                break;
        case 0x80000001 :
                switch ( rt ) {
                case 0x80000001 :
                        if ( ((lf > rt) != 0 ) || ((lf >= rt) != 1) ||
                            ((lf == rt) != 1) || ((lf <= rt) != 1) ||
                            ((lf < rt) != 0 ) )
                        {
                                fail = TRUE;
                                fprintf(fp,"  ** expression, relational operator 4.1.4.6-6 ");
                                printf("  ** expression, relational operator 4.1.4.6-6 ");
                                fprintf(fp,"class 1 fail -  exit return code ");
                                printf("class 1 fail -  exit return code ");
                                fprintf(fp,"%d%d%d%d%d%x\n",lf>rt,lf>=rt,lf==rt,lf<=rt,lf<rt,rt);
                                printf("%d%d%d%d%d%x\n",lf>rt,lf>=rt,lf==rt,lf<=rt,lf<rt,rt);
                        }
                        break;
                case 0x00000001 :
                case 0x70000000 :
                        if ( ((lf > rt) != 1 ) || ((lf >= rt) != 1) ||
                            ((lf == rt) != 0) || ((lf <= rt) != 0) ||
                            ((lf < rt) != 0 ) )
                        {
                                fail = TRUE;
                                fprintf(fp,"  ** expression, relational operator 4.1.4.6-7 ");
                                printf("  ** expression, relational operator 4.1.4.6-7 ");
                                fprintf(fp,"class 1 fail -  exit return code ");
                                printf("class 1 fail -  exit return code ");
                                fprintf(fp,"%d%d%d%d%d%x\n",lf>rt,lf>=rt,lf==rt,lf<=rt,lf<rt,rt);
                                printf("%d%d%d%d%d%x\n",lf>rt,lf>=rt,lf==rt,lf<=rt,lf<rt,rt);
                        }
                        break;
                case 0xf0000000 :
                        if ( ((lf > rt) != 0 ) || ((lf >= rt) != 0) ||
                            ((lf == rt) != 0) || ((lf <= rt) != 1) ||
                            ((lf < rt) != 1 ) )
                        {
                                fail = TRUE;
                                fprintf(fp,"  ** expression, relational operator 4.1.4.6-8 ");
                                printf("  ** expression, relational operator 4.1.4.6-8 ");
                                fprintf(fp,"class 1 fail -  exit return code ");
                                printf("class 1 fail -  exit return code ");
                                fprintf(fp,"%d%d%d%d%d%x\n",lf>rt,lf>=rt,lf==rt,lf<=rt,lf<rt,rt);
                                printf("%d%d%d%d%d%x\n",lf>rt,lf>=rt,lf==rt,lf<=rt,lf<rt,rt);
                        }
                        break;
                };
                break;
        case 0xf0000000 :
                switch ( rt ) {
                case 0xf0000000 :
                        if ( ((lf > rt) != 0 ) || ((lf >= rt) != 1) ||
                            ((lf == rt) != 1) || ((lf <= rt) != 1) ||
                            ((lf < rt) != 0 ) )
                        {
                                fail = TRUE;
                                fprintf(fp,"  ** expression, relational operator 4.1.4.6-9 ");
                                printf("  ** expression, relational operator 4.1.4.6-9 ");
                                fprintf(fp,"class 1 fail -  exit return code ");
                                printf("class 1 fail -  exit return code ");
                                fprintf(fp,"%d%d%d%d%d%x\n",lf>rt,lf>=rt,lf==rt,lf<=rt,lf<rt,rt);
                                printf("%d%d%d%d%d%x\n",lf>rt,lf>=rt,lf==rt,lf<=rt,lf<rt,rt);
                        }
                        break;
                case 0x00000001 :
                case 0x70000000 :
                case 0x80000001 :
                        if ( ((lf > rt) != 1 ) || ((lf >= rt) != 1) ||
                            ((lf == rt) != 0) || ((lf <= rt) != 0) ||
                            ((lf < rt) != 0 ) )
                        {
                                fail = TRUE;
                                fprintf(fp,"  ** expression, relational operator 4.1.4.6-10 ");
                                printf("  ** expression, relational operator 4.1.4.6-10 ");
                                fprintf(fp,"class 1 fail -  exit return code ");
                                printf("class 1 fail -  exit return code ");
                                fprintf(fp,"%d%d%d%d%d%x\n",lf>rt,lf>=rt,lf==rt,lf<=rt,lf<rt,rt);
                                printf("%d%d%d%d%d%x\n",lf>rt,lf>=rt,lf==rt,lf<=rt,lf<rt,rt);
                                fclose(fp);
                        }
                        break;
                };
                break;
        };
}
