/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Expressions, Logical Operators                   */
/*                          Section 4.1.5.1                                  */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  4/23/84                                          */
/*  Source File :           source/expr.41522.c                              */
/*  Revisions :             04/02/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           For the logical operator  OR, verify that        */
/*                          operands of one of the fundamental types or a    */
/*                          pointer yield the correct result.                */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/expr.41.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
int fail;
 
main()
{
 
/*  Tests 1 thru 4 were originally spr0009 written against UTX Release 2.0.  */
/*  Problem Description :  Logical operator  OR sometimes produces incorrect */
/*          results when either operand is of type "unsigned short".         */
 
        unsigned short a, b;
        float c, d;
 
FILE *fp;
fp=fopen("expr_res bloc=y","a");
        a = c = 0;
        b = d = 1;
 
        if ( a || c )
         { fail = TRUE;
           fprintf(fp,"  ** expression, logical operator 4.1.5.2.2-1 class 1 fail  -  exit return code : %d%d\n", a, c );
           printf("  ** expression, logical operator 4.1.5.2.2-1 class 1 fail  -  exit return code : %d%d\n", a, c );
         }
 
        if ( a || d )
            ;
        else
         { fail = TRUE;
           fprintf(fp,"  ** expression, logical operator 4.1.5.2.2-2 class 1 fail -  exit return code : %d%d\n", a, d );
           printf("  ** expression, logical operator 4.1.5.2.2-2 class 1 fail -  exit return code : %d%d\n", a, d );
         }
 
        if ( b || c )
            ;
        else
         { fail = TRUE;
           fprintf(fp,"  ** expression, logical operator 4.1.5.2.2-3 class 1 fail -  exit return code : %d%d\n", b, c );
           printf("  ** expression, logical operator 4.1.5.2.2-3 class 1 fail -  exit return code : %d%d\n", b, c );
         }
 
        if ( b || d )
            ;
        else
         { fail = TRUE;
           fprintf(fp,"  ** expression, logical operator 4.1.5.2.2-4 class 1 fail -  exit return code : %d%d\n", b, d );
           printf("  ** expression, logical operator 4.1.5.2.2-4 class 1 fail -  exit return code : %d%d\n", b, d );
         }
        if ( !fail )
          {fprintf(fp,"  .. expression, logical operator 4.1.5.2.2 class 1 pass\n");
           printf("  .. expression, logical operator 4.1.5.2.2 class 1 pass\n");}
        fclose(fp);
}
