/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      External Definitions and Declarations            */
/*                          External Data - Section 3.1                      */
/*                          Remote Basic Types  - Section 3.1.3              */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Tina Aleksa                                      */
/*  Source File :           source/extn.3131b.c                              */
/*  Revisions :             04/16/85    Sqa     Original UTX-32 1.2 Release  */
/*                                                                           */
/*  Revisions :             04/30/90   Mike Bennett                          */
/*                          Changed format of test and changed variable      */
/*                          lf from 15.7 to 15.6.                            */
/*  Revisions :             05/03/90   Mindy Pheterson                       */
/*                          Changed format of test to account for long       */
/*                          float precision differences for lf.              */
/*  Descriptions :          For basic types defined and declared in          */
/*                          different files:                                 */
/*                          Verify that an identifier which is declared      */
/*                          within a function can be referenced within that  */
/*                          function.  The compiler fails if this program    */
/*                          cannot be compiled.                              */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/extn.31.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.  Associated files include                */
/*                          source/extn.3131a.c which is compiled with this  */
/*                          program.                                         */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
extern int fail;
extern FILE *fp;
 
/*  This function decrements the external variables defined and declared
in file source/extn.3131a.c,  by 1.
*/
 
dec ()
{
   extern int in;
   extern short int si;
   extern long int li;
   extern short sh;
   extern long lg;
   extern char ch;
   extern unsigned un;
   extern unsigned int ui;
   extern unsigned short us;
   extern unsigned short int usi;
   extern unsigned long ul;
   extern unsigned long int uli;
   extern unsigned char uc;
   extern float fl;
   extern long float lf;
   extern double db;
 
   fail = 0;
   --in;
   --si;
   --li;
   --sh;
   --lg;
   --ch;
   --un;
   --ui;
   --us;
   --usi;
   --ul;
   --uli;
   --uc;
   --fl;
   --lf;
   --db;
 
   if (in != 2) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-2a class 1 fail - exit return code: %d\n", in);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-2a class 1 fail - exit return code: %d\n", in);
   }
   if (si != 3) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-2b class 1 fail - exit return code: %d\n", si);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-2b class 1 fail - exit return code: %d\n", si);
   }
   if (li != 4) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-2c class 1 fail - exit return code: %d\n", li);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-2c class 1 fail - exit return code: %d\n", li);
   }
   if (sh != 5) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-2c class 1 fail - exit return code: %d\n", sh);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-2c class 1 fail - exit return code: %d\n", sh);
   }
   if (lg != 6) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-2d class 1 fail - exit return code: %d\n", lg);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-2d class 1 fail - exit return code: %d\n", lg);
   }
   if (ch != 'b') {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-2e class 1 fail - exit return code: %c\n", ch);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-2e class 1 fail - exit return code: %c\n", ch);
   }
   if (un != 7) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-2f class 1 fail - exit return code: %d\n", un);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-2f class 1 fail - exit return code: %d\n", un);
   }
   if (ui != 8) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-2g class 1 fail - exit return code: %d\n", ui);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-2g class 1 fail - exit return code: %d\n", ui);
   }
   if (us != 9) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-2h class 1 fail - exit return code: %d\n", us);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-2h class 1 fail - exit return code: %d\n", us);
   }
   if (usi != 10) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-2i class 1 fail - exit return code: %d\n", usi);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-2i class 1 fail - exit return code: %d\n", usi);
   }
   if (ul != 11) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-2j class 1 fail - exit return code: %d\n", ul);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-2j class 1 fail - exit return code: %d\n", ul);
   }
   if (uli != 12) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-2k class 1 fail - exit return code: %d\n", uli);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-2k class 1 fail - exit return code: %d\n", uli);
   }
   if (uc != 'c') {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-2l class 1 fail - exit return code: %c\n", uc);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-2l class 1 fail - exit return code: %c\n", uc);
   }
   if (fl != 13.5) {
      fail = TRUE;
      printf("   ** external, remote basic types 3.1.3.1-2m class 1 fail - exit return code: %f\n", fl);
      fprintf(fp, "   ** external, remote baseic type 3.1.3.1-2m class 1 fail - exit return code: %f\n", fl);
   }
   if (lf != 15.7) {
      fail = TRUE;
      printf("   lf should equal 15.700000.  lf equals: %f\n", lf);
      fprintf("   lf should equal 15.700000.  lf equals: %f\n", lf);
   }
   if (db != 0.0565E2) {
      fail = TRUE;
      printf ("   ** external, remote basic types 3.1.3.1-2o class 1 fail - exit return code: %f\n", db);
      fprintf (fp, "   ** external, remote basic types 3.1.3.1-2o class 1 fail - exit return code: %f\n", db);
   }
}
 
