/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      External Definitions and Declarations            */
/*                          - Functions                                      */
/*                          Section 3.3.1.7                                  */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/extn.3317.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*  Date :                  10/11/83                                         */
/*  Description :           Verify that experssions can be used in the       */
/*                          argument list and that the expression is         */
/*                          evaluated before the function call.              */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/extn.33.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
 
#include <stdio.h>
FILE *fp;
main()
{
       /* The compiler fails if this program cannot be compiled */
 
       int A,B,C ;
       int expr;
       fp=fopen("extn_res bloc=y","a");
 
       A = B = C = 2;
       F1 ( A * B * C * A * B );
       expr = F2 ( F1(A*B*C*A*B), F1(A*B*C*A*B) );
       if ( expr == 32 )
         {fprintf(fp,"  .. external, functions 3.3.1.7 class 1 pass\n");
          printf("  .. external, functions 3.3.1.7 class 1 pass\n");}
       fclose(fp);
}
 
 
F1(expr)
int expr;
{
   /* at this point expr should have been evaluated */
 
   if ( expr != 32 )
     {fprintf(fp,"  ** external, functions 3.3.1.7 class 1 fail-  exit return code : %d\n",expr);
      printf("  ** external, functions 3.3.1.7 class 1 fail-  exit return code : %d\n",expr);}
   return(expr);
}
F2(expr1,expr2)
int expr1, expr2;
{
   /* at this point expr1 and expr2 should have been evaluated */
 
   if ( expr1 != 32 || expr2 != 32 )
     {fprintf(fp,"  ** external, functions 3.3.1.7 class 1 fail -  exit return code : %d\n",expr1);
      printf("  ** external, functions 3.3.1.7 class 1 fail -  exit return code : %d\n",expr1);}
   return(expr1);
}
 
