/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      External Definitions and Declarations            */
/*                          - Functions                                      */
/*                          Section 3.3.2.3                                  */
/*  Product and Revision :  Unix 1.3                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/extn.3323.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                                                                           */
/*                          03/27/84    T. Aleksa  UTX-32 1.0 Release        */
/*                          --  Added test for qar172.                       */
/*  Date :                  4/23/84                                          */
/*  Description :           Verify that basic types returned from functions  */
/*                          can be referenced.                               */
/*                          The compiler fails if the pass message is not    */
/*                          displayed.                                       */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/extn.33.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
 
/*     Functions
*/
 
unsigned short sub()
{
    register long i;
    i = 5;
    return(i);
}
 
main()
{  int    fail,test;
   char   cval;
   double val,mult,dval;
   double f2();                                 /* must state that f2 return
                                                   a non-int value.         */
   int    sign;
 
FILE *fp;
fp=fopen("extn_res bloc=y","a");
   test = 1;
   cval = f1 ();
   if ( cval != 'p' )
    { fail = TRUE;
      fprintf(fp,"  ** external, functions 3.3.2.3 class 1 fail-  exit return code : %d%c\n",test,cval);
      printf("  ** external, functions 3.3.2.3 class 1 fail-  exit return code : %d%c\n",test,cval);
    }
 
   test = 2;
   sign = -1; mult = 9; val = 10;
   dval = f2();
   if ( dval != ( sign * mult * val ) )
    { fail = TRUE;
      fprintf(fp,"  ** external, functions 3.3.2.3 class 1 fail -  exit return code : %d%f\n",test,dval);
      printf("  ** external, functions 3.3.2.3 class 1 fail -  exit return code : %d%f\n",test,dval);
    }
   /*   Test 3 was originally qar172 written against UTX Release 2.0.
        Problem Description:  If an expressiion of type long is used
                in a return statement in a function declared as returning
                type short, the compiler is unable to compile the return
                statement. */
 
   test = 3;
   {
        register long a;
        a = sub();
 
        if ( a != 5 )
         { fail = TRUE;
           fprintf(fp,"  ** external, functions 3.3.2.3 class 1 fail - exit return code : %d%d\n",test,a);
           printf("  ** external, functions 3.3.2.3 class 1 fail - exit return code : %d%d\n",test,a);
         }
   }
   if ( !fail )
       {fprintf(fp,"  .. external, functions 3.3.2.3 class 1 pass\n");
        printf("  .. external, functions 3.3.2.3 class 1 pass\n");}
   fclose(fp);
}
 
 
f1() { return 'p';}
 
double f2()
{
  double val, mult;
  int    sign;
 
  sign = -1 ;
  mult = 9;
  val = 10;
  return ( sign * mult * val );
}
 
