/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Miscellaneous - Integer Constants                */
/*                          Section - 1.2.1.3                                */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/misc.1213.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*  Date :                  10/25/83                                         */
/*  Description :           Verify that an integer constant which begins     */
/*                          with 0x or 0X is taken to be a hexadecimal.      */
/*                          Both upper and lower case of a-f hex digits are  */
/*                          equivalent.                                      */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/misc.12.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
int fail;
 
main()
{int test;
 int a,b,c,d;
 FILE *fp;
 fp=fopen("misc_res bloc=y","a");
 
 /* Test 1 */
 /* verify that 0x and 0X are the same */
 a = 0xab;
 b = 0XAB;
 c = 10 * 16 + 11;
 if ( a != c || b != c )
    {fail = TRUE;
     fprintf(fp,"  ** miscellaneous, constants 1.2.1.3-1 class 1 fail -  exit return code : %x%x\n",a,b);
     printf("  ** miscellaneous, constants 1.2.1.3-1 class 1 fail -  exit return code : %x%x\n",a,b);
    }
 
/* Test 2 */
 /* verify that mixing upper and lower case is allowed */
 a = 0xaB;
 b = 0xAb;
 c = 0xa * 16 + 0xb ;
 d = 10  * 16 + 11 ;
 if ( a != c || b != c || c != d )
    {fail = TRUE;
     fprintf(fp,"  ** miscellaneous, constants 1.2.1.3-2 class 1 fail -  exit return code : %x%x\n",a,b);
     printf("  ** miscellaneous, constants 1.2.1.3-2 class 1 fail -  exit return code : %x%x\n",a,b);
    }
 
 
 if ( !fail)
   {fprintf(fp,"  .. miscellaneous, constants 1.2.1.3 class 1 pass\n");
    printf("  .. miscellaneous, constants 1.2.1.3 class 1 pass\n");}
 fclose(fp);
}
 
