/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Miscellaneous - Integer Constants                */
/*                          Section - 1.2.1.5                                */
/*  Product and Revision :  Unix 1.4                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/misc.1215.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                          04/06/84    T. Aleksa  UTX-32 1.0 Release        */
/*                          -- Added test for spr0251 written against        */
/*                             UTX 2.0 Release.                              */
/*                          04/10/84    T. Aleksa  UTX-32 1.0 Release        */
/*                          -- Added test for UTX Release 2.0, spr0232.      */
/*                          05/14/84    T. Aleksa  UTX-32 1.0 Release        */
/*                          -- Added test to verify that 0x0 through 0xffff  */
/*                             are represented correctly.                    */
/*                                                                           */
/*  Date :                  5/18/84                                          */
/*  Description :           Verify that short unsigned integer are           */
/*                          represented correctly.                           */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/misc.12.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
int fail;
 
main()
{
FILE *fp;
fp=fopen("misc_res bloc=y","a");
 /* Test 1
        verify that the short unsigned value 65535 represented correctly.
 */
        {
        unsigned short  a,b;
        a = 65535;
        b = 0x0;
        if ( a != 0xffff || b != 0 )
           { fail = TRUE;
             fprintf(fp,"  ** miscellaneous, constants 1.2.1.5-1 class 3 fail    -  exit return code : %x%x\n",a,b );
             printf("  ** miscellaneous, constants 1.2.1.5-1 class 3 fail    -  exit return code : %x%x\n",a,b );
           }
       }
 /* Test 2
       This test was originally spr0251 written against UTX Release 2.0.
       Problem description: Test 2 would not compile under UTX Release 2.0.
 */
       {
       register short *operand, *work_bottom;
       short op, work;
       int value;
 
       op = 10;
       work = 20;
       operand = &op;
       work_bottom = &work;
       value = (unsigned)(*work_bottom & 0xffff) / /* this statement produced */
               (unsigned)(*operand & 0xffff);      /*  incorrect code         */
 
       if ( value != 2 )
          { fail = TRUE;
            fprintf(fp," ** miscellaneous, constants 1.2.1.5-2 class 3 fail   -  exit return code : %d%d%d\n", value );
            printf(" ** miscellaneous, constants 1.2.1.5-2 class 3 fail   -  exit return code : %d%d%d\n", value );
          }
       }
/* Test 3
      This test was originally spr0232 written against UTX Release 2.0.
      Problem Description :  Sign extension strangeness when assigning an
              unsigned short to an integer.
*/
      {
      unsigned short x;
      char c;
      int i, j, k;
 
      c = 1;
      x = 0100000;
 
      i = x;
      j = x + 1;
      k = x + c;
 
      if ( i != 32768 || j != 32769 || k != 32769 )
         { fail = TRUE;
            fprintf(fp," ** miscellaneous, constants 1.2.1.5-3 class 3 fail   -  exit return code : %d%d%d\n", i, j, k );
            printf(" ** miscellaneous, constants 1.2.1.5-3 class 3 fail   -  exit return code : %d%d%d\n", i, j, k );
         }
      }
 
/* Test 4
        Verify that 0x1 through 0xffff are represented correctly.
        Test Method:  Hexadecimal values are compared with their decimal
                      and octal representations.
*/
 
     {  unsigned short d, x, o;
 
        /*  while d is not zero, perform the loop     */
 
        for ( d = 65535, x = 0xffff, o = 0177777; d != 0; d--, x--, o-- )
          {  if ( (d != x) || (d != o) || (x != o)  )
                { fail = TRUE;
                  fprintf(fp,"  ** miscellaneous, constants 1.2.1.5-4 class 3 fail - exit return code : %d%x%o\n",d,x,o);
                }
          }
}
 
       if ( ! fail )
         {fprintf(fp,"  .. miscellaneous, constants 1.2.1.5 class 3 pass\n");
          printf("  .. miscellaneous, constants 1.2.1.5 class 3 pass\n");}
       fclose(fp);
}
 
