/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Miscellaneous Concepts - Constants               */
/*                          Section  1.2.1                                   */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.4                                         */
/*  Date :                  9/27/85                                          */
/*  Source File :           source/misc.1217.c                               */
/*  Revisions :             06/15/84    Sqa  Original UTX-32 (1.0) Release   */
/*                          09/26/85    T. Aleksa     UTX-32 (1.2) Release   */
/*
/*                                                                           */
/*  Description :           Verify that unsigned variables compared to       */
/*                          constants are handled correctly.                 */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/misc.12.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
int fail;
 
FILE *fp;
main()
{
fp=fopen("misc_res bloc=y","a");
        uns1();
        uns2();
 
        if ( !fail )
           { fprintf(fp,"  .. miscellaneous, constants 1.2.1.7 class 1 pass\n");
             printf("  .. miscellaneous, constants 1.2.1.7 class 1 pass\n");
           }
        fclose(fp);
 
 
}
/*  This test is qar399 written against UTX-32 1.0 Release.
    Problem Description:  Unsigned variables compared to constant
            expression is not handled correctly.
*/
uns1()
{
        unsigned u;
 
        u = ( 1 << 31 );           /* Constant expression 1<<31 is a signed
                                      quantity                              */
 
        if ( u != ( (unsigned) 1 << 31 ) )
           { fail = TRUE;
             fprintf(fp,"  ** miscellaneous, constants 1.2.1.7-1 class 1 fail   -  exit return code : %x\n", u );
             printf("  ** miscellaneous, constants 1.2.1.7-1 class 1 fail   -  exit return code : %x\n", u );
           }
}
 
/*  This test is qar396 written against UTX-32 1.0 Release.
    Problem Description:  Unsigned constants are not handled correctly.
 
    Note:  There seems to be a problem concerning the type of a constant
           when compared to a different type ( such as unsigned ).  The
           following test would always pass if the constant was cast to
           type unsigned.  However, it seems that the compiler should be
           able to handle the comparison without casting the constant
           to the appropriate type.
 
    Resolution 09/26/85 :
    OA survey of recent literature indicates that our interpretation of
    the sign extension properties of constants is most compatible with the
    outside world.  The following quote from the proposed ANSI C standard,
    XJ-311, dated 4/30/85 illustrates this:
 
        "The type of an integer constant is the first of the
        corresponding list in which its value can be represented.
        Unsuffixed decimal: int, long int;  unsuffixed octal or
        hexadecimal: int, unsigned int, long int, unsigned long int,
        suffixed by the letter u or U: unsigned int, unsigned long int;
        suffixed by the letter l or L: long int, unsigned long int;
        suffixed by both the letters u or U and l or L: unsigned long int."
 
    Further evidence comes from "A C Reference Manual", by Samuel Harrison and
    Guy Steele Jr, both from Tartan Labs.  This book gives a table on page 19
    that illustrates the equivalent decimal values of various octal and
    hexadecimal values.  Although the table is defined in terms of a 16-bit
    implementation of type "int", it can be easily extrapolated to define the
    equivalent meaning for a 32-bit "int" implementation such as ours.  Some
    excerpts from the table are listed below:
 
        C constant       True Value     C Type          C Value
 
       0x80000000        2**31          long            -214783648
       0xffffffff        2**32 - 1      long               -1
 
    In light of this evidence, we have deemed it best to retain our current
    interpretation of the sign properties of constants.  The problems we
    encountered in attempting to compile existing software are further
    evidence that this decision is best.  This is a retraction from the
    previous resolution for this SPR, in which we intended to treat
    octal and hexadecimal constants as type "unsigned".   The cc(1) manual
    page has been updated accordingly.
 
*/
uns2()
{
        unsigned i, j;
        i = (-1);
        j = 0xf0ffffff;
 
        if ( i != (unsigned) 0xffffffff || j != (unsigned) 0xf0ffffff ||
             i != (unsigned) 037777777777 )
           { fail = TRUE;
             fprintf(fp,"  ** miscellaneous, constants 1.2.1.7-2 class 1 fail  -  exit return code : %x %x\n", i, j );
             printf("  ** miscellaneous, constants 1.2.1.7-2 class 1 fail  -  exit return code : %x %x\n", i, j );
           }
 
 
}
