/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Miscellaneous Concepts - Constants               */
/*                          Section  1.2                                     */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/misc_1232.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*  Date :                  10/25/83                                         */
/*  Description :           Constants   Gould S.E.L. Unix reference Manual,  */
/*                          Vol I, chapter 4 states that a floating constant */
/*                          of an integer part, a decimal point, a fraction  */
/*                          part, an e or E, and an optionally signed integer*/
/*                          exponent.                                        */
/*                          This program tests the conformance of the        */
/*                          compiler to the syntax productions for numbers   */
/*                          specified by the reference manual.               */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/misc.12.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
int fail;
 
main()
{   int test;
    float  a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p ;
    FILE *fp;
    fp=fopen("misc_res bloc=y","a");
 
    /* verify the upper case E and lower case e are equivalent.*/
    e = 123.123E+2;
    f = 123.123e+2;
 
    g = 123.123E-2;
    h = 123.123e-2;
    if ( ( e != f ) || ( g != h ) )
    {  fail = TRUE;
       fprintf(fp,"  ** miscellaneous, constants 1.2.3.2-1 class 1 fail-  exit return code : %23.3e %23.3e \n",e,g);
       printf("  ** miscellaneous, constants 1.2.3.2-1 class 1 fail-  exit return code : %23.3e %23.3e \n",e,g);
    }
 
    /* verify that the optionally signed integer exponent are represented
        correctly.
    */
    i = 123E2;
    j = 123E+2;
 
    k = 123E-2;
    l = 1.23;
    if (  ( i != j ) || ( k != l ) )
    {  fail = TRUE;
       fprintf(fp,"  ** miscellaneous, constants 1.2.3.2-2 class 1 fail -  exit return code : %23.3e %23.3e \n",i,k);
       printf("  ** miscellaneous, constants 1.2.3.2-2 class 1 fail -  exit return code : %23.3e %23.3e \n",i,k);
    }
    /* verify that the parser can recognize the negative representation */
 
    m = .123 ;
    n = -.123;
 
    o = 123. ;
    p = 123  ;
    if (  ( m == n) || ( o != p ) )
    {  fail = TRUE;
       fprintf(fp,"  ** miscellaneous, constants 1.2.3.2-3 class 1 fail -  exit return code : %23.3e %23.3e \n",m,o);
       printf("  ** miscellaneous, constants 1.2.3.2-3 class 1 fail -  exit return code : %23.3e %23.3e \n",m,o);
    }
 
if ( !fail )
      {fprintf(fp,"  .. miscellaneous, constants 1.2.3.2 class 1 pass\n");
       printf("  .. miscellaneous, constants 1.2.3.2 class 1 pass\n");}
fclose(fp);
}
 
