/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Miscellaneous Concepts - Constants               */
/*                          Section  1.2                                     */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/misc_1232.c                               */
/*  Revisions :             01/09/83    Sqa     Original UTX 2.0 Release     */
/*  Date :                  10/25/83                                         */
/*  Description :           Constants   Gould S.E.L. Unix reference Manual,  */
/*                          Vol I, chapter 4 states that a floating constant */
/*                          of an integer part, a decimal point, a fraction  */
/*                          part, an e or E, and an optionally signed integer*/
/*                          exponent.                                        */
/*                          This program tests the conformance of the        */
/*                          compiler to the syntax productions for numbers   */
/*                          specified by the reference manual.               */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/misc.12.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
int fail;
 
main()
{   int test;
 
FILE *fp;
fp=fopen("misc_res bloc=y","a");
    /* verify the upper case E and lower case e are equivalent.
       and either the decimal point or the exponent ( not both )
       may be missing.
    */
  { float e,f,g,h;
    test = 1;
    e = 123.123E+2;
    f = 12312.3;
 
    g = 123.123E-2;
    h = 1.23123;
 
 
 
    if ( ( e != f ) ||  ( g != h ) )
      {fprintf(fp,"  ** miscellaneous, constants 1.2.3.3 class 1 fail -  exit return code : %f%f\n",e,g);
       printf("  ** miscellaneous, constants 1.2.3.3 class 1 fail -  exit return code : %f%f\n",e,g);}
    else
      {fprintf(fp,"  .. miscellaneous, constants 1.2.3.3 class 1 pass\n");
       printf("  .. miscellaneous, constants 1.2.3.3 class 1 pass\n");}
    fclose(fp);
  }
}
