/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Miscellaneous Concepts - Constants               */
/*                          Section  1.2                                     */
/*  Product and Revision :  Unix 1.5                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/misc.1234.c                               */
/*  Revisions :             01/09/83    Sqa     Original UTX 2.0 Release     */
/*                                                                           */
/*                          02/21/84    T. Aleksa   UTX-32 1.0 Release       */
/*                          -- Restructured and modified test so that the    */
/*                             value of the variables are compared within    */
/*                             the program rather than visual comparisons    */
/*                             output to the result file.                    */
/*                          -- Changed from class 1 to 3.                    */
/*                                                                           */
/*                          04/27/84    T. Aleksa   UTX-32 1.0 Release       */
/*                          -- Added test for qar297 written against this    */
/*                             release.                                      */
/*                                                                           */
/*  Date :                  5/18/84                                          */
/*  Description :           Verify that +7.2e75 through +5.4e-7              */
/*                          (-7.2e75 through -5.4e-7) are represented        */
/*                          correctly.                                       */
/*                          This program tests the conformance of the        */
/*                          compiler to the syntax productions for numbers   */
/*                          specified by the reference manual.               */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/misc.12.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
/*  All floating arithmetic in C is carried out in single precision.
*/
 
#include <stdio.h>
#define TRUE 1
int fail;
 
main ()
{
     float fa,fb,fc,fd,fe,ff;
     double da,db,dc,dd,de,df;
     FILE *fp;
     fp=fopen("misc_res bloc=y","a");
 
     /*  Test 1  */
 
     fa = 7.2e75;
     fb = -7.2e75;
     fc = -fa;
 
     fd = 5.4e-7;
     fe = -5.4e-7;
     ff = -fd;
 
     if (( fc != fb ) || ( ff != fe ))
     {  fail = TRUE;
        fprintf(fp,"  ** miscellaneous, constants 1.2.3.4-1 class 3 fail-  exit return code : %23.20e,%23.20e\n",fc,ff);
        printf("  ** miscellaneous, constants 1.2.3.4-1 class 3 fail-  exit return code : %23.20e,%23.20e\n",fc,ff);
     }
 
     /*  Test 2  */
 
     da = 7.2e75;
     db = -7.2e75;
     dc = -db;
 
     dd = 5.4e-7;
     de = -5.4e-7;
     df = -de;
 
     if (( dc != da ) || ( df != dd ))
     {  fail = TRUE;
        fprintf(fp,"  ** miscellaneous, constants 1.2.3.4-2 class 3 fail -  exit return code : %23.20e,%23.20e\n",dc,df);
        printf("  ** miscellaneous, constants 1.2.3.4-2 class 3 fail -  exit return code : %23.20e,%23.20e\n",dc,df);
     }
 
     /*  Test 3  */
 
     fa = -da;
     fd = -dd;
 
     if (( fa != fc ) || ( fd != ff ))
     {  fail = TRUE;
        fprintf(fp,"  ** miscellaneous, constants 1.2.3.4-3 class 3 fail -  exit return code : %23.20e,%23.20e\n",fa,fd);
        printf("  ** miscellaneous, constants 1.2.3.4-3 class 3 fail -  exit return code : %23.20e,%23.20e\n",fa,fd);
     }
 
     /*  Test 4  */
 
     /*  This test is currently qar297 written against UTX-32 Release 1.0.
         Problem description:  When two identical values that have different
                 representations, for example ( 1.00e-2 and .010e0 ), which
                 are compared in an if statement, result in failure.
     */
 
     da = 1.00e-2;
     db = .010e0;
 
     if ( da != db )
     {  fail = TRUE;
        fprintf(fp,"  ** miscellaneous, constants 1.2.3.4-4 class 3 fail -  exit return code : %20.10e,%20.10e\n",da,db);
        printf("  ** miscellaneous, constants 1.2.3.4-4 class 3 fail -  exit return code : %20.10e,%20.10e\n",da,db);
     }
 
     if ( !fail )
       {fprintf(fp,"  .. miscellaneous, constants 1.2.3.4 class 3 pass\n");
        printf("  .. miscellaneous, constants 1.2.3.4 class 3 pass\n");}
     fclose(fp);
 
}
