/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Miscellaneous Concepts - Constants               */
/*                          Section  1.2                                     */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/misc.1243.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*  Date :                  10/25/83                                                 */
/*  Description :           Verify that a character constant is a character  */
/*                          enclosed in single quotes, and that uppercase    */
/*                          letter is not equivalent to lowercase letter in  */
/*                          a character constant.                            */
/*                          This program tests the conformance of the        */
/*                          compiler to the syntax productions for character */
/*                          specified by the reference manual.               */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/misc.12.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
main()
{
        char NL,HT,BS,CR,FF,Bslash,Squote,
             BitNL,BitHT,BitBS;
             FILE *fp;
             fp=fopen("misc_res bloc=y","a");
 
        NL = '\n';      BitNL = '\012';
        HT = '\t';      BitHT = '\011';
        BS = '\b';      BitBS = '\010';
        CR = '\r';
        FF = '\f';
        Bslash = '\\';
        Squote = '\'';
 
 
/* The compiler fails if the message is not printed as expected.            */
 
        fprintf(fp,"%c%c",' ',BS);
        printf("%c%c",' ',BS);
        if ( NL != BitNL  || HT != BitHT || BS != BitBS )
          {fprintf(fp,"  ** miscellaneous, constants 1.2.4.3 class 1 fail %c%c-  exit return code : %c%c%c",HT,BitHT,NL,BitNL);
           printf("  ** miscellaneous, constants 1.2.4.3 class 1 fail %c%c-  exit return code : %c%c%c",HT,BitHT,NL,BitNL);}
        else
          {fprintf(fp,"  .. miscellaneous, constants 1.2.4.3 class 1 pass%c",NL);
           printf("  .. miscellaneous, constants 1.2.4.3 class 1 pass%c",NL);}
        fclose(fp);
}
 
