/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Miscellaneous Concepts - Strings                 */
/*                          Section 1.2.5.3                                  */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Suifun Law                                       */
/*  Date :                  10/25/83                                         */
/*  Source File :           source/misc_1253.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                                                                           */
/*  Description :           Varify that uppercase letters are not equivalent */
/*                          to lowercase letters in string constants.        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/misc.12.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
int result;
 
main()
{
        char *s,*s1,*s2, *s3 ;
        FILE *fp;
        fp=fopen("misc_res bloc=y","a");
 
        s  = "abcdefgh";
        s1 = "abcdefgh";
        s2 = "ABCDEFGH";
        s3 = "aBcDeFgH";
 
        /* first compare s and s1 to make sure they are equal */
        if ( result = compare(s,s1) )
           /* s != s1 */
          {fprintf(fp,"  << miscellaneous, constants 1.2.5.3 class 1 fail    -  exit return code : %d\n",result);
           printf("  << miscellaneous, constants 1.2.5.3 class 1 fail    -  exit return code : %d\n",result);}
        else
        {  /* s == s1 , then continue to compare with s2 , and s3 which
              should not be equal to s1 */
           result = compare(s1,s2);
           if (!result)
             {fprintf(fp,"  ** miscellaneous, constants 1.2.5.3 class 1 fail -  exit return code : %d\n",result);
              printf("  ** miscellaneous, constants 1.2.5.3 class 1 fail -  exit return code : %d\n",result);}
           else
           {
              result = compare(s1,s3);
              if (!result)
               {fprintf(fp,"  ** miscellaneous, constants 1.2.5.3 class 1 fail    -  exit return code : %d\n",result);
                printf("  ** miscellaneous, constants 1.2.5.3 class 1 fail    -  exit return code : %d\n",result);}
              else
               {fprintf(fp,"  .. miscellaneous, constants 1.2.5.3 class 1 pass\n");
                printf("  .. miscellaneous, constants 1.2.5.3 class 1 pass\n");}
           }
        }
        fclose(fp);
}
 
/* COMPARE
        function - compare two given strings
        inputs   - two strings s1, and s2
        outputs  - =0, if s1 is equal to s2
                   >0, if s1 is greater than s2
                   <0, if s1 is less than s2
        global variables used - none
*/
compare(s1,s2)
char *s1, *s2;
 
{
        for ( ;*s1 == *s2; s1++,s2++ )
            if ( *s1 == '\0' )
                return 0;
        return ( *s1 - *s2 );
}
