/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Statements                                       */
/*                          5.2 Compound                                     */
/*  Product and Revision :  Unix 1.3                                         */
/*  Author :                Suifun Law                                       */
/*  Date :                  3/5/84                                           */
/*  Source File :           source/stat.521.c                                */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                                                                           */
/*                          03/05/84    T. Aleksa   UTX-32 1.0 Release       */
/*                          --  Initialized i and R to zero in main in order */
/*                              to properly test Test 3.  Previous test      */
/*                              assumed auto and register variables were     */
/*                              automatically initialized.                   */
/*                                                                           */
/*  Description :           This program verify that any initializations of  */
/*                          auto or register variables are performed each    */
/*                          time the block is entered at the top.            */
/*                          The compiler fails if this program does not      */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/stat.52.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
 
int fail;
FILE *fp;
main()
{   auto i=0;
    register R=0;
    fp=fopen("stat_res bloc=y","a");
/*  call the function block which use auto i and register R in its
    declaration.
*/
    f1();
    f1();
    f1();
    f1();
    f1();
/*  setup block structure enclosed with { and } , verify the result
    of i and R which should be as same  as the initialization within
    the block.
*/
    {
      auto i= 1; register R=2;
      if ( i != 1 || R !=2 )
         { fail = TRUE;
           fprintf(fp,"  ** statement, compound 5.2.1-2 class 1 fail -  exit return code : %d%d\n",i,R);
           printf("  ** statement, compound 5.2.1-2 class 1 fail -  exit return code : %d%d\n",i,R);
         }
    }
 
/*  verify the result of i and R which should remain 0 after leaving
    the block.
*/
      if ( i != 0 || R != 0 )
         {  fail = TRUE;
           fprintf(fp,"  ** statement, compound 5.2.1-3 class 1 fail -  exit return code : %d%d\n",i,R);
           printf("  ** statement, compound 5.2.1-3 class 1 fail -  exit return code : %d%d\n",i,R);
         }
 
    if (!fail)
       {fprintf(fp,"  .. statement, compound 5.2.1 class 1 pass\n");
        printf("  .. statement, compound 5.2.1 class 1 pass\n");}
    fclose(fp);
}
f1()
{
        auto i=1;
        register R=1;
 
        /* verify that i and R are initialized each time the
           block is entered.
        */
        if ( i != 1 || R != 1 )
        {  fail = TRUE;
           fprintf(fp,"  ** statement, compound 5.2.1-1 class 1 fail -  exit return code : %d%d\n",i,R);
           printf("  ** statement, compound 5.2.1-1 class 1 fail -  exit return code : %d%d\n",i,R);
        }
        /* change the value of i and R */
        i = 2;
        R = 2;
 
}
 
