/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Statements                                       */
/*                          5.2 Compound                                     */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Suifun Law                                       */
/*  Date :                  10/25/83                                         */
/*  Source File :           source/stat.522.c                                */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*  Description :           This program verify that the outer declaration   */
/*                          is pushed down for the duration of the block,    */
/*                          If any of the identifiers in the declaration-    */
/*                          list within the block were previously declared.  */
/*                          The compiler fails if this program does not      */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/stat.52.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
/*      verify the syntax of compound statemnt
        compound statement :
                { optional declaration-list
                  optional statement-list
                }
*/
#include <stdio.h>
#define TRUE 1
 
int fail;
FILE *fp;
main()
{   auto i; register R;
    static j;
    fp=fopen("stat_res bloc=y","a");
/* Test 1 */
    i = 0; R = 0; j = 0;
 
    /*  jump to function block which use auto i and register R */
    f1();
    f1();
 
    /*  setup block structure enclosed with { and } , verify the result
    of i and R which should remaind 0 and 0 respectively  after leaving
    the block..
    */
    {
      auto i= 1; register R=2; static j = 1;
    }
 
    /*  setup another structure block
    */
    { auto i= 2; register R= 3; static j = 2;
      if ( i != 2 || R != 3 || j != 2 )
         {  fail = TRUE;
           fprintf(fp,"  ** statement, compound 5.2.2-1 class 1 fail -  exit return code : %d%d%d\n",i,R,j);
           printf("  ** statement, compound 5.2.2-1 class 1 fail -  exit return code : %d%d%d\n",i,R,j);
         }
    }
 
 
 
/* Test 2 */
 
    /*  verify compound statement used in while structure
    */
        while (TRUE) {  auto i = 3; register R=3; break;}
 
/* verify the final result which should be all zero.
*/
if ( i != 0 || R != 0 || j != 0 )
         {  fail = TRUE;
           fprintf(fp,"  ** statement, compound 5.2.2-2 class 1 fail -  exit return code : %d%d%d\n",i,R,j);
           printf("  ** statement, compound 5.2.2-2 class 1 fail -  exit return code : %d%d%d\n",i,R,j);
         }
 
if (!fail)
       {fprintf(fp,"  .. statement, compound 5.2.2 class 1 pass\n");
        printf("  .. statement, compound 5.2.2 class 1 pass\n");}
fclose(fp);
}
f1()
{
        auto i=1;
        register R=1;
 
        /* verify that i and R are initialized each time the
           block is entered.
        */
        if ( i != 1 || R != 1 )
        {  fail = TRUE;
           fprintf(fp,"  ** statement, compound 5.2.2-1 class 1 fail -  exit return code : %d%d\n",i,R);
           printf("  ** statement, compound 5.2.2-1 class 1 fail -  exit return code : %d%d\n",i,R);
        }
        /* change the value of i and R */
        i = 2;
        R = 2;
 
}
 
