/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Statements                                       */
/*                          5.5.3 Return                                     */
/*  Product and Revision :  Unix 1.3                                         */
/*  Author :                Suifun Law                                       */
/*  Date :                  3/15/84                                          */
/*  Source File :           source/stat.5532.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                                                                           */
/*                          03/09/84    T. Aleksa     UTX-32 1.0 Release     */
/*                          -- Cast buf to type struct lab in F4.            */
/*                                                                           */
/*  Description :           This program verify that "return expression"     */
/*                          will return the value of the expression.         */
/*                          The compiler fails if this program does not      */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/stat.55.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
int fail;
 
main ()
{  int result;
FILE *fp;
fp=fopen("stat_res bloc=y","a");
   /* Test 1 : verify the expression ( x>y?1:0) is evaluated */
   if(result=F1())
     { fail = TRUE;
       fprintf(fp,"  statement, return 5.5.3.2-1 class 1 fail -  exit return code : %d\n",result);
       printf("  statement, return 5.5.3.2-1 class 1 fail -  exit return code : %d\n",result);
     }
 
   /* Test 2 : verify the expression (-1) is returned */
   if ((result=F2()) != -1 )
      { fail = TRUE;
       fprintf(fp,"  statement, return 5.5.3.2-2 class 1 fail -  exit return code : %d\n",result);
       printf("  statement, return 5.5.3.2-2 class 1 fail -  exit return code : %d\n",result);
     }
   /* Test 3 : verify the expression (0) is returned */
   if (result=F3())
      { fail = TRUE;
       fprintf(fp,"  statement, return 5.5.3.2-3 class 1 fail -  exit return code : %d\n",result);
       printf("  statement, return 5.5.3.2-3 class 1 fail -  exit return code : %d\n",result);
     }
   /* Test 4 : verify the expression related to pointer  ( ++p->x )
               is returned */
   if ((result=F4()) != 1 )
      { fail = TRUE;
       fprintf(fp,"  statement, return 5.5.3.2-4 class 1 fail -  exit return code : %d\n",result);
       printf("  statement, return 5.5.3.2-4 class 1 fail -  exit return code : %d\n",result);
     }
   /* Test 5 : verify the expression related to another function
               is returned */
   if ((result=F5()) != 1 )
      { fail = TRUE;
       fprintf(fp,"  statement, return 5.5.3.2-5 class 1 fail -  exit return code : %d\n",result);
       printf("  statement, return 5.5.3.2-5 class 1 fail -  exit return code : %d\n",result);
     }
   /* Test 6 : verify the expression related to addition of two function
               values is returned correctly */
   if ((result=F6()) != 2 )
      { fail = TRUE;
       fprintf(fp,"  statement, return 5.5.3.2-6 class 1 fail -  exit return code : %d\n",result);
       printf("  statement, return 5.5.3.2-6 class 1 fail -  exit return code : %d\n",result);
     }
if (!fail)
  {fprintf(fp,"  .. statement, return 5.5.3.2 class 1 pass\n");
   printf("  .. statement, return 5.5.3.2 class 1 pass\n");}
fclose(fp);
}
 
F1()
{ int x,y;
  x = 0;
  y = 1;
  return ( x > y ? 1:0);
}
 
F2()
{  return -1;
}
 
F3() { return 0; }
 
F4()
{  
   struct lab { int x;
          } p[3] = {0,1,2};
   return ++p->x ;
}
 
F5() { return F1()+1 ;}
 
F6() { return F5()+F5() ;}
 
