-- 	(c) Copyright 1986 Gould Inc.
-- 	    All Rights Reserved.
--
#if	defined(RCSID) && !defined(lint)
	.fardata
.ascii "@(#) (Gould) $Header: udiv.s,v 1.1 86/11/08 18:17:54 root UTX $";
	.align 2
/* --	@(#) UTX/32   udiv.s ver 1.4 */
--*	ASSEMRCS is defined so that the include file stackdef.h will
--*	use .ascii syntax for RCS ID string
#define ASSEMRCS

#endif	RCSID

	.text
--
-- NAME:
--	udiv 
--
-- PURPOSE:
--	unsigned division for GOULD Concept 32 base register machines
--
-- PRECONDITIONS:
--	arguments: dividend, divisor.
--
-- POSTCONDITIONS:
--	result: quotient.
--	uses r0,r1,r3
--
-- ALGORITHM:
--	If 1 < divisor <= 2147483647, zero-extend the dividend
--	to 64 bits and let divw do the work.  If the divisor is 1,
--	divw will overflow if bit 31 of the dividend is on, so
--	just return the dividend unchanged.  If the divisor is 0,
--	do the divw also, so it will generate the proper exception.
--	All other values of the divisor have bit 31 on: in this case
--	the quotient must be 0 if divisor > dividend, and 1 otherwise,
--	provided that the comparison is made as unsigned.
--
-- HISTORY:
--	adapted for GOULD UNIX base register compiler from
-- 30 July 1983	J. M. Feldman of Compion	Initial adaptation
--

#include  "DEFS.h"

#define _udiv udiv

ENTER5(udiv, .fartext)
	movw	ARGOFFSET[b2],r1	-- Dividend 
	movw	r1,r0		-- might just return dividend later (nodiv)
	movw	ARGOFFSET+1w[b2],r3	-- Divisor
	jeq	Ldiv		-- If divisor=0, force exception
	cmpw	#1,r3		-- If divisor <= 1 (signed),
	jeq	Lout		-- if divisor==1, return dividend
	jle	Lnodiv		--  no division is necessary
Ldiv:	movw	#0,r0		-- Don't sign-extend the dividend!
	divw	r3,r0		-- Divide.  q->r1, r->r0 (discarded)
	movw	r1,r0		-- quotient returned in r0
	retn			-- return quotient in r0 (or exception)

Lnodiv:	movw	#0,ARGOFFSET[b2] -- most significant bits of 16w+17w doubleword
	movw	#0,r0		-- r0+r1 doubleword has dividend (odd least sig)
	cmpl	ARGOFFSET[b2],r0 -- Signed double comparison between
	jlt	Lout		--  dividend (r0+r1) and divisor (16w+17w)
	   	   		-- Dividend < divisor, return 0

Lone:	movw	#1,r0		-- Dividend >= divisor, return 1

Lout:
	retn
	.ef	1

-- 	(c) Copyright 1986 Gould Inc.
-- 	    All Rights Reserved.
