


     MSGGET(2)                 UNIX System V                 MSGGET(2)



     NAME
          msgget - get message queue

     SYNTAX
          #include <sys/types.h>
          #include <sys/ipc.h>
          #include <sys/msg.h>

          int msgget (key, msgflg)
          key_t key;
          int msgflg;

     DESCRIPTION
          Msgget returns the message queue identifier associated with
          key.

          A message queue identifier and associated message queue and
          data structure (see intro(2)) are created for key if one of
          the following are true:

          10   Key is equal to IPC_PRIVATE.

               Key does not already have a message queue identifier
               associated with it, and (msgflg & IPC_CREAT) is
               ``true''.

          Upon creation, the data structure associated with the new
          message queue identifier is initialized as follows:

               Msg_perm.cuid, msg_perm.uid, msg_perm.cgid, and
               msg_perm.gid are set equal to the effective user ID and
               effective group ID, respectively, of the calling
               process.

               The low-order 9 bits of msg_perm.mode are set equal to
               the low-order 9 bits of msgflg.

               Msg_qnum, msg_lspid, msg_lrpid, msg_stime, and
               msg_rtime are set equal to 0.

               Msg_ctime is set equal to the current time.

               Msg_qbytes is set equal to the system limit.

          Msgget will fail if one or more of the following are true:

          [EACCES] 13    A message queue identifier exists for key,
                         but operation permission (see intro(2)) as
                         specified by the low-order 9 bits of msgflg
                         would not be granted.

          [ENOENT]  2    A message queue identifier does not exist for



     Page 1                                         (printed 11/18/90)






     MSGGET(2)                 UNIX System V                 MSGGET(2)



                         key and (msgflg & IPC_CREAT) is ``false''.

          [ENOSPC] 28    A message queue identifier is to be created
                         but the system-imposed limit on the maximum
                         number of allowed message queue identifiers
                         system wide would be exceeded.

          [EEXIST]  17   A message queue identifier exists for key but
                         ( (msgflg & IPC_CREAT) & ( msgflg & IPC_EXCL)
                         ) is ``true''.

     RETURN VALUE
          Upon successful completion, a non-negative integer, namely a
          message queue identifier, is returned.  Otherwise, a value
          of -1 is returned and errno is set to indicate the error.

     SEE ALSO
          intro(2), msgctl(2), msgop(2).





































     Page 2                                         (printed 11/18/90)



