


     MSGOP(2)                  UNIX System V                  MSGOP(2)



     NAME
          msgop - message operations

     SYNTAX
          #include <sys/types.h>
          #include <sys/ipc.h>
          #include <sys/msg.h>

          int msgsnd (msqid, msgp, msgsz, msgflg)
          int msqid;
          struct msgbuf *msgp;
          int msgsz, msgflg;

          int msgrcv (msqid, msgp, msgsz, msgtyp, msgflg)
          int msqid;
          struct msgbuf *msgp;
          int msgsz;
          long msgtyp;
          int msgflg;

     DESCRIPTION
          Msgsnd is used to send a message to the queue associated
          with the message queue identifier specified by msqid (see
          intro(2), Message Operation Permissions).  Msgp points to a
          structure containing the message.  This structure is
          composed of the following members:

               long    mtype;      /* message type */
               char    mtext[];    /* message text */

          Mtype is a positive integer that can be used by the
          receiving process for message selection (see msgrcv below).
          Mtext is any text of length msgsz bytes.  Msgsz can range
          from 0 to a system-imposed maximum.

          Msgflg specifies the action to be taken if one or more of
          the following are true:

               The number of bytes already on the queue is equal to
               msg_qbytes (see intro(2)).

               The total number of messages on all queues system-wide
               is equal to the system-imposed limit.

          These actions are as follows:

               If (msgflg & IPC_NOWAIT) is ``true'', the message will
               not be sent and the calling process will return
               immediately.

               If (msgflg & IPC_NOWAIT) is ``false'', the calling
               process will suspend execution until one of the



     Page 1                                         (printed 11/18/90)






     MSGOP(2)                  UNIX System V                  MSGOP(2)



               following occurs:

                       The condition responsible for the suspension no
                       longer exists, in which case the message is
                       sent.

                       Msqid is removed from the system (see
                       msgctl(2)).  When this occurs, errno is set
                       equal to EIDRM, and a value of -1 is returned.

                       The calling process receives a signal that is
                       to be caught.  In this case the message is not
                       sent and the calling process resumes execution
                       in the manner prescribed in signal(2)).

          Msgsnd will fail and no message will be sent if one or more
          of the following are true:

          [EINVAL]       Msqid is not a valid message queue
                         identifier.

          [EACCES]       Operation permission is denied to the calling
                         process (see intro(2)).

          [EINVAL]       Mtype is less than 1.

          [EAGAIN]       The message cannot be sent for one of the
                         reasons cited above and (msgflg & IPC_NOWAIT)
                         is ``true''.

          [EINVAL]       Msgsz is less than zero or greater than the
                         system-imposed limit.

          [EFAULT]       Msgp points to an illegal address.

          Upon successful completion, the following actions are taken
          with respect to the data structure associated with msqid
          (see intro(2)).

               Msg_qnum is incremented by 1.

               Msg_lspid is set equal to the process ID of the calling
               process.

               Msg_stime is set equal to the current time.

          Msgrcv reads a message from the queue associated with the
          message queue identifier specified by msqid and places it in
          the structure pointed to by msgp (see intro(2)).  This
          structure is composed of the following members:

               long    mtype;      /* message type */



     Page 2                                         (printed 11/18/90)






     MSGOP(2)                  UNIX System V                  MSGOP(2)



               char    mtext[];    /* message text */

          Mtype is the received message's type as specified by the
          sending process.  Mtext is the text of the message.  Msgsz
          specifies the size in bytes of mtext.  The received message
          is truncated to msgsz bytes if it is larger than msgsz and
          (msgflg & MSG_NOERROR) is ``true''.  The truncated part of
          the message is lost and no indication of the truncation is
          given to the calling process.

          Msgtyp specifies the type of message requested as follows:

               If msgtyp is equal to 0, the first message on the queue
               is received.

               If msgtyp is greater than 0, the first message of type
               msgtyp is received.

               If msgtyp is less than 0, the first message of the
               lowest type that is less than or equal to the absolute
               value of msgtyp is received.

          Msgflg specifies the action to be taken if a message of the
          desired type is not on the queue.  These are as follows:

               If (msgflg & IPC_NOWAIT) is ``true'', the calling
               process will return immediately with a return value of
               -1 and errno set to ENOMSG.

               If (msgflg & IPC_NOWAIT) is ``false'', the calling
               process will suspend execution until one of the
               following occurs:

                       A message of the desired type is placed on the
                       queue.

                       Msqid is removed from the system.  When this
                       occurs, errno is set equal to EIDRM, and a
                       value of -1 is returned.

                       The calling process receives a signal that is
                       to be caught.  In this case a message is not
                       received and the calling process resumes
                       execution in the manner prescribed in
                       signal(2)).

          Msgrcv will fail and no message will be received if one or
          more of the following are true:

          [EINVAL]       Msqid is not a valid message queue
                         identifier.




     Page 3                                         (printed 11/18/90)






     MSGOP(2)                  UNIX System V                  MSGOP(2)



          [EACCES]       Operation permission is denied to the calling
                         process.

          [EINVAL]       Msgsz is less than 0.

          [E2BIG]        Mtext is greater than msgsz and (msgflg &
                         MSG_NOERROR) is ``false''.

          [ENOMSG]       The queue does not contain a message of the
                         desired type and (msgtyp & IPC_NOWAIT) is
                         ``true''.

          [EFAULT]       Msgp points to an illegal address.

          Upon successful completion, the following actions are taken
          with respect to the data structure associated with msqid
          (see intro (2)).

               Msg_qnum is decremented by 1.

               Msg_lrpid is set equal to the process ID of the calling
               process.

               Msg_rtime is set equal to the current time.

     RETURN VALUES
          If msgsnd or msgrcv return due to the receipt of a signal, a
          value of -1 is returned to the calling process and errno is
          set to EINTR.  If they return due to removal of msqid from
          the system, a value of -1 is returned and errno is set to
          EIDRM.

          Upon successful completion, the return value is as follows:

               Msgsnd returns a value of 0.

               Msgrcv returns a value equal to the number of bytes
               actually placed into mtext.

          Otherwise, a value of -1 is returned and errno is set to
          indicate the error.

     SEE ALSO
          intro(2), msgctl(2), msgget(2), signal(2).











     Page 4                                         (printed 11/18/90)



