


     SHMGET(2)                 UNIX System V                 SHMGET(2)



     NAME
          shmget - get shared memory segment

     SYNTAX
          #include <sys/types.h>
          #include <sys/ipc.h>
          #include <sys/shm.h>

          int shmget (key, size, shmflg)
          key_t key;
          int size, shmflg;

     DESCRIPTION
          Shmget returns the shared memory identifier associated with
          key.

          A shared memory identifier and associated data structure and
          shared memory segment of size size bytes (see intro(2)) are
          created for key if one of the following are true:

               Key is equal to IPC_PRIVATE.

               Key does not already have a shared memory identifier
               associated with it, and (shmflg & IPC_CREAT) is
               ``true''.

          Upon creation, the data structure associated with the new
          shared memory identifier is initialized as follows:

               Shm_perm.cuid, shm_perm.uid, shm_perm.cgid, and
               shm_perm.gid are set equal to the effective user ID and
               effective group ID, respectively, of the calling
               process.

               The low-order 9 bits of shm_perm.mode are set equal to
               the low-order 9 bits of shmflg.  Shm_segsz is set equal
               to the value of size.

               Shm_lpid, shm_nattch, shm_atime, and shm_dtime are set
               equal to 0.

               Shm_ctime is set equal to the current time.

          Shmget will fail if one or more of the following are true:

          [EINVAL]       Size is less than the system-imposed minimum
                         or greater than the system-imposed maximum.

          [EACCES]       A shared memory identifier exists for key but
                         operation permission (see intro(2)) as
                         specified by the low-order 9 bits of shmflg
                         would not be granted.



     Page 1                                         (printed 11/18/90)






     SHMGET(2)                 UNIX System V                 SHMGET(2)



          [EINVAL]       A shared memory identifier exists for key but
                         the size of the segment associated with it is
                         less than size and size is not equal to zero.

          [ENOENT]       A shared memory identifier does not exist for
                         key and (shmflg & IPC_CREAT) is ``false''.

          [ENOSPC]       A shared memory identifier is to be created
                         but the system-imposed limit on the maximum
                         number of allowed shared memory identifiers
                         system wide would be exceeded.

          [ENOMEM]       A shared memory identifier and associated
                         shared memory segment are to be created but
                         the amount of available physical memory is
                         not sufficient to fill the request.

          [EEXIST]       A shared memory identifier exists for key but
                         ( (shmflg & IPC_CREAT) and ( shmflg &
                         IPC_EXCL) ) is ``true''.

     RETURN VALUE
          Upon successful completion, a non-negative integer, namely a
          shared memory identifier is returned.  Otherwise, a value of
          -1 is returned and errno is set to indicate the error.

     SEE ALSO
          intro(2), shmctl(2), shmop(2).



























     Page 2                                         (printed 11/18/90)



