


     SHMOP(2)                  UNIX System V                  SHMOP(2)



     NAME
          shmop - shared memory operations

     SYNTAX
          #include <sys/types.h>
          #include <sys/ipc.h>
          #include <sys/shm.h>

          char *shmat (shmid, shmaddr, shmflg)
          int shmid;
          char *shmaddr
          int shmflg;

          int shmdt (shmaddr)
          char *shmaddr

     DESCRIPTION
          Shmat attaches the shared memory segment associated with the
          shared memory identifier specified by shmid to the data
          segment of the calling process.  The segment is attached at
          the address specified by one of the following criteria:

               If shmaddr is equal to zero, the segment is attached at
               the first available address as selected by the system.

               If shmaddr is not equal to zero and (shmflg & SHM_RND)
               is ``true'', the segment is attached at the address
               given by (shmaddr - (shmaddr modulus SHMLBA)).

               If shmaddr is not equal to zero and (shmflg & SHM_RND)
               is ``false'', the segment is attached at the address
               given by shmaddr.

          The segment is attached for reading if (shmflg & SHM_RDONLY)
          is ``true'' {READ}; otherwise it is attached for reading and
          writing {READ/WRITE}.

          Shmdt detaches from the calling process's data segment the
          shared memory segment located at the address specified by
          shmaddr.

          Shmat will fail and not attach the shared memory segment if
          one or more of the following are true:

          [EINVAL]       Shmid is not a valid shared memory
                         identifier.

          [EACCES]       Operation permission is denied to the calling
                         process (see intro(2)).

          [ENOMEM]       The available data space is not large enough
                         to accommodate the shared memory segment.



     Page 1                                         (printed 11/18/90)






     SHMOP(2)                  UNIX System V                  SHMOP(2)



          [EINVAL]       Shmaddr is not equal to zero, and the value
                         of (shmaddr - (shmaddr modulus SHMLBA)) is an
                         illegal address.

          [EINVAL]       Shmaddr is not equal to zero, (shmflg &
                         SHM_RND) is ``false'', and the value of
                         shmaddr is an illegal address.

          [EMFILE]       The number of shared memory segments attached
                         to the calling process would exceed the
                         system-imposed limit.

          [EINVAL]       Shmdt will fail and not detach the shared
                         memory segment if shmaddr is not the data
                         segment start address of a shared memory
                         segment.

     RETURN VALUES
          Upon successful completion, the return value is as follows:

               Shmat returns the data segment start address of the
               attached shared memory segment.

               Shmdt returns a value of 0.

          Otherwise, a value of -1 is returned and errno is set to
          indicate the error.

     SEE ALSO
          exec(2), exit(2), fork(2), intro(2), shmctl(2), shmget(2).

























     Page 2                                         (printed 11/18/90)



