
     Name
          yacc - Invokes a compiler-compiler.

     Syntax
          yacc [ -VD ] grammar

     Description
          yacc converts a context-free grammar into a set of tables
          for a simple automaton which executes an LR parsing
          algorithm.  The grammar may be ambiguous; specified
          precedence rules are used to break ambiguities.

          The output file, y.tab.c, must be compiled by the C compiler
          to produce a program yyparse.  This program must be loaded
          with the lexical analyzer program, yylex, as well as main
          and yyerror, an error handling routine.  These routines must
          be supplied by the user; lex is useful for creating lexical
          analyzers usable by yacc.

          If the -V flag is given, the file y.output is prepared,
          which contains a description of the parsing tables and a
          report on conflicts generated by ambiguities in the grammar.

          If the -D flag is used, the file y.tab.h is generated with
          the #define statements that associate the yacc-assigned
          ``token codes'' with the user-declared ``token names''.
          This allows source files other than y.tab.c to access the
          token codes.

     Files
          y.output
          y.tab.c
          y.tab.h               Defines for token names
          yacc.tmp, yacc.acts   Temporary files
          /system/lib/yaccpar   Parser prototype for C programs


     See Also
          lex.man

     Diagnostics
          The number of reduce-reduce and shift-reduce conflicts is
          reported on the standard output; a more detailed report is
          found in the y.output file.  Similarly, if some rules are
          not reachable from the start symbol, this is also reported.

     Notes
          Because filenames are fixed, at most one yacc process can be
          active in a given directory at a time.

          (printed 9/27/90 - J B Systems)
