/*~!MKEASY.C*/
/* Name: MKEASY.C Part No.: _______-___r
 *
 *				SOFTWARE ENGINEERING
 *
 *  The recipient of this product specifically agrees not to distribute,
 *  disclose, or disseminate in any way, to any one, nor use for its own
 *  benefit, or the benefit of others,  any information contained herein
 *  without the expressed written consent of Software Engineering.
 */
/*							*/
/*
 *			 I S C   A s s e m b l e r
 *
 *			      M K E A S Y . C
 *
 *			     Revision History
 *			     ----------------
 */

#include	"has.h"

/* handles op code only instructions OP */
noarg (token, fieldp)
register char	*token;
char	**fieldp;
{
	static struct noarg_tab {
		char	*opcode;
		short	qword;
	} noarg_tab[] = {
		"bei",		0x0006,
		"cea",		0x000f,
		"dae",		0x000e,
		"eae",		0x0008,
		"es",		0x0004,
		"halt",		0x0000,
		"nop",		0x0002,
		"sea",		0x000d,
		"uei",		0x000e,
		"wait",		0x0001,
		0,			0
	};
	register struct noarg_tab *tp;

	for (tp = noarg_tab; tp->opcode != 0; tp++)
		if (strcmp (tp->opcode, token) == SAME)
			return (dumpqword (tp->qword));
	bomb ("opcode '%s' not in table", token);
}

/* handles only zr opcode */
d (token, fieldp)
register char	*token;
char	**fieldp;
{
	static struct d_tab {
		char	*opcode;
		short	qword;
	} d_tab[] = {
		"zr",		0x0c00,
		"\177",		0
	};
	short	dreg;
	register struct d_tab *tp;
	int k;

	for (tp = d_tab; tp->opcode[0] < *token; tp++)
		;
	while ((k = strcmp(tp->opcode, token)) < 0)
		tp++;
	if (k == SAME) {
		if (dregister (fieldp[1], &dreg))
			return (-1);
		else
			return (dumpqword (tp->qword | ((dreg & 7) << 7) | ((dreg & 7) <<4)));
	}
	bomb ("opcode '%s' not in table", token);
}

/* handles instructions of the form OP REG */
ds1 (token, fieldp)
register char *token;
char	**fieldp;
{
	static struct ds1_tab {
		char	*opcode;
		short	qword;
	} ds1_tab[] = {
		"es",		0x0004,
		"lcs",		0x0003,
		"rnd",		0x0005,
		"trsw",		0x2800,
		"\177",		0
	};
	short	dreg;
	register struct ds1_tab *tp;
	int k;

	for (tp = ds1_tab; tp->opcode[0] < *token; tp++)
		;
	while ((k = strcmp(tp->opcode, token)) < 0)
		tp++;
	if (k == SAME) {
		if (dregister (fieldp[1], &dreg))
			return (-1);
		else
			return (dumpqword (tp->qword | ((dreg & 7) << 7)));
	}
	bomb ("opcode '%s' not in table", token);
}
	
/* handles bit in reg instruction of form OP REG,BIT */
ds2 (token, fieldp)
register char *token;
char	**fieldp;
{
	static struct ds2_tab {
		char	*opcode;
		short	qword;
	} ds2_tab[] = {
		"abr",		0x2000,
		"sbr",		0x1800,
		"tbr",		0x2400,
		"zbr",		0x1c00,
		0,			0
	};
	short	dreg;
	short	bitn;
	register struct ds2_tab *tp;
	int k;

	for (tp = ds2_tab; tp->opcode[0] < *token; tp++)
		;
	while ((k = strcmp(tp->opcode, token)) < 0)
		tp++;
	if (k == SAME) {
		if (dregister (fieldp[1], &dreg)
		 || evalqword (fieldp[2], &bitn))
			return (-1);
		else {
			bitn &= 0x1f;
			return (dumpqword (tp->qword | ((bitn % 8) << 7)
				| ((dreg & 7) << 4) | (bitn/4)));
		}
	}
	bomb ("opcode '%s' not in table", token);
}
	
/* handles instructions od type OP REGS,REGD */
ds1s2 (token, fieldp)
register char *token;
char	**fieldp;
{
	static struct ds1s2_tab {
		char	*opcode;
		short	qword;
	} ds1s2_tab[] = {
		"adr",		0x3800,
		"adrm",		0x3808,
		"anr",		0x0400,
		"car",		0x1000,
		"cmr",		0x1400,
		"dvr",		0x4400,
		"eor",		0x0c00,
		"eorm",		0x0c08,
		"mpr",		0x4000,
		"orr",		0x0800,
		"orrm",		0x0808,
		"sur",		0x3c00,
		"surm",		0x3c08,
		"trc",		0x2c03,
		"trcm",		0x2c0b,
		"trn",		0x2c04,
		"trnm",		0x2c0c,
		"trr",		0x2c00,
		"trrm",		0x2c08,
		"trsc",		0x2c0e,
		"tscr",		0x2c0f,
		"xcr",		0x2c05,
		"xcrm",		0x2c0d,
		"\177",		0
	};
	short	dreg;
	short	sreg;
	register struct ds1s2_tab *tp;
	int k;

	for (tp = ds1s2_tab; tp->opcode[0] < *token; tp++)
		;
	while ((k = strcmp(tp->opcode, token)) < 0)
		tp++;
	if (k == SAME) {
		if (sregister (fieldp[1], &sreg)
		 || dregister (fieldp[2], &dreg))
			return (-1);
		else
			return (dumpqword (tp->qword | ((dreg & 7) << 7) | ((sreg & 7) << 4)));
	}
	bomb ("opcode '%s' not in table", token);
}

/* handles shift instructions of form OP REG,CNT */
s1s2 (token, fieldp)
register char *token;
char	**fieldp;
{
	static struct s1s2_tab {
		char	*opcode;
		short	qword;
	} s1s2_tab[] = {
		"sla",		0x6c40,
		"slad",		0x7840,
		"slc",		0x7440,
		"sll",		0x7040,
		"slld",		0x7c40,
		"sra",		0x6c00,
		"srad",		0x7800,
		"src",		0x7400,
		"srl",		0x7000,
		"srld",		0x7c00,
		0,			0
	};
	short	dreg;
	short	cnt;
	register struct s1s2_tab *tp;
	int k;

	for (tp = s1s2_tab; tp->opcode[0] < *token; tp++)
		;
	while ((k = strcmp(tp->opcode, token)) < 0)
		tp++;
	if (k == SAME) {
		if (dregister (fieldp[1], &dreg)
		 || evalqword (fieldp[2], &cnt))
			return (-1);
		else {
			cnt &= 0x1f;
			return (dumpqword (tp->qword | cnt | ((dreg & 7) << 4)));
		}
	}
	bomb ("opcode '%s' not in table", token);
}

/* handles instructions od type OP REGD,REGS */
ds2s1 (token, fieldp)
register char *token;
char	**fieldp;
{
	static struct ds2s1_tab {
		char	*opcode;
		short	qword;
	} ds2s1_tab[] = {
		"nor",		0x6000,
		"nord",		0x6400,
		"scz",		0x6800,
		"\177",		0
	};
	short	dreg;
	short	sreg;
	register struct ds2s1_tab *tp;
	int k;

	for (tp = ds2s1_tab; tp->opcode[0] < *token; tp++)
		;
	while ((k = strcmp(tp->opcode, token)) < 0)
		tp++;
	if (k == SAME) {
		if (dregister (fieldp[1], &dreg)
		 || sregister (fieldp[2], &sreg))
			return (-1);
		else
			return (dumpqword (tp->qword | ((dreg & 7) << 7) | ((sreg & 7) << 4)));
	}
	bomb ("opcode '%s' not in table", token);
}
