/*~!OUTPUT.C*/
/* Name:  OUTPUT.C Part No.: _______-____r
 *			
 *	            	SOFTWARE ENGINEERING
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of Software Engineering.
 *
 *                     RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure by the Government is  subject  to
 * restriction  as  set forth in paragraph (b) (3) (B) of the Rights
 * in Technical Data and Computer Software  Clause  in  DAR  7-104.9
 * (a).
 */
/*
 *			 I S C   A s s e m b l e r
 *
 *			      O U T P U T . C
 *
 *				Revision History
 *				----------------
*/

#include	"has.h"

extern	short	debug;
extern	FILE	*reltfile;
extern	FILE	*reldfile;
extern	long	trsize;
extern	long	drsize;
extern	short	curspace;
extern	long	*addrp;
extern  short   listing;
extern	struct output	*curout;

dump4qw (q0, q1, q2, q3)
short	q0, q1, q2, q3;
{
	WORD	w;

	w = q0 << 16 | q1;

	prtloc();
	prtss(q0, q1);
	dump ((char*)&w, (short)sizeof (WORD));
	return(0);
}

dump2qw (q0, q1)
short	q0, q1;
{
	char ol[4];


	ol[0] = q0>>8;
	ol[1] = q0&0xff;
	ol[2] = q1>>8;
	ol[3] = q1&0xff;

	prtloc();
	prtss(q0, q1);
	dump (ol, (short)sizeof (int32));
	return(0);
}

dumpqword (qw)
short	qw;
{
	prtloc();
	if (*addrp % 4 == 0)
		prtsb(qw);
	else
		prtbs(qw);
	dump ((char*)&qw, (short)sizeof (qw));
	return(0);
}

dumphword (hw)
int32 	hw;							
{
	char	ol[4];
	short	out1, out2;

	ol[0] = hw>>24;
	ol[1] = hw>>16 & 0xff;
	ol[2] = hw>>8 & 0xff;
	ol[3] = hw & 0xff;

	prtloc();
	out1 = (short)(hw >> 16);
	out2 = (short)hw;
	prtss(out1, out2);	
	dump (ol, (short)sizeof (hw));
	return(0);
}

dumpfword (wp)
/* WORD	*wp; */
int	*wp;
{
	short	out1, out2;

	DEBUG (8, "dumpfword(): wp is 0x%0lx\n", (long)wp);
	prtloc();
	out1 = (short)(wp[0] >> 16);
	out2 = (short)wp[0];
	prtss(out1, out2);	
	if (listing)
		printf("\n");
	prtloc();
	out1 = (short)(wp[-1] >> 16);
	out2 = (short)wp[-1];
	prtss(out1, out2);	
	dump ((char*)wp, (short)sizeof (WORD)); 
	dump ((char*)&wp[-1], (short)sizeof (WORD)); 
	return(0);
}

dumpstr (addr, size)
char	*addr;
short	size;
{
	register struct output *op;
	register int rsize;

	DEBUG (8, "dumpstr(%s, ", addr);
	DEBUG (8, "%d);\n", size);

	if (size == 0)
		return(0);
	if (curspace == N_BSS || curout == NULL) {
		error ("No initialization of BSS");
		return;
	}
	rsize = size;
	op = curout;
#ifdef DEBUG
	if (op->o_ptr < (char *)&op->o_word
	    || op->o_ptr > (char *)((&op->o_word)+9))
		bomb ("o_ptr out of range! (%o)", op->o_ptr);
#endif
	DEBUG (10, "dumpstr(): op->o_ptr is 0x%x\n", op->o_ptr);
	while (rsize--) {
	/* don't byte swap if you're running on the HEP */	
	*(op->o_ptr++) = *addr++;			
		if (--op->o_nleft == 0) {
		    DEBUG(8,"dumpstr():flushing 0x%lx\n",op->o_word);
		    if (fwrite (&op->o_word, sizeof (WORD),1,op->o_file) !=1)
	 	    {
			perror ("dumpstr()");
			bomb ("Curspace = %d", curspace);
		    }
		    DEBUG(10,"\top->o_word now 0x%lx\n",op->o_word);
		    op->o_nleft = sizeof (WORD);
		    op->o_ptr = (char *)&op->o_word;
		}
	}
	*addrp += size;
	return(0);
}

dump (addr, size)
char	*addr;
short	size;
{
	register struct output *op;
	register int rsize;

	DEBUG (1, "dump(0x%16x, ", addr);			
	DEBUG (1, "%d );", size);				
	DEBUG (1, "  string is 0x%02x\n", *addr);	
	if (curspace == N_BSS || curout == NULL) {
		error ("No initialization of BSS");
		return;
	}
	rsize = size;
	op = curout;
#ifdef DEBUG
	if (op->o_ptr < (char *)&op->o_word
	    || op->o_ptr > (char *)((&op->o_word)+9))
		bomb ("o_ptr out of range! (%o)", op->o_ptr);
#endif
	DEBUG (1, "dump(): op->o_ptr is %0x\n", op->o_ptr);
	while (rsize--) {
		*(op->o_ptr++) = *addr++;
		if (--op->o_nleft == 0) {
			DEBUG(8,"dump():flushing 0x%lx\n",op->o_word);
			if (fwrite (&op->o_word, sizeof (WORD),
			     1, op->o_file) != 1) {
				perror ("dump()");
				bomb ("Curspace = %d", curspace);
			}
			op->o_nleft = sizeof (WORD);
			op->o_ptr = (char *)&op->o_word;
		}
	}
	*addrp += size;
	DEBUG (8, "dump: loc is %0lx\n", *addrp);
}

dumpreloc (rp)
struct	relocation *rp;
{
	FILE	*file;

	if (curspace == N_BSS) {
		error ("No initialization of BSS");
		return;
	}
	rp->r_pad = 0;
	if (curspace == N_TEXT) {
		trsize += sizeof (struct relocation);
		file = reltfile;
	} else {
		drsize += sizeof (struct relocation);
		file = reldfile;
	}

	fwrite (rp, sizeof (struct relocation), 1, file);
	if (ferror (file))
		bomb ("Error write relocation data");
}
