 */
/* Name:  SYMTAB.C Part No.: _______-____r
 *			
 *	            	SOFTWARE ENGINEERING
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of Software Engineering.
 *
 *                     RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure by the Government is  subject  to
 * restriction  as  set forth in paragraph (b) (3) (B) of the Rights
 * in Technical Data and Computer Software  Clause  in  DAR  7-104.9
 * (a).
 */
/*
 *		     I S C  A s s e m b l e r
 *
 *			      S Y M T A B . C
 *
 *
 *				Revision History
 *				----------------
 */

#include	"has.h"

struct	symbol	{
	struct	symbol	*snext;
	struct	nlist	n;
};

#define NNULL	(struct nlist *) NULL
#define	SNULL	(struct symbol *) NULL

struct	symbol	*shead;
struct	nlist	*symlist[MAXSYMS];
int 	ltnum;			/* used to create unique temp name */

extern	short	debug;
extern	long	*addrp;
extern	short	curspace;
extern	short	numsyms;
extern	char	*malloc(), *realloc();
extern	char	*mymalloc();

char *
malloc(amt)
int amt;
{
	char *rv;

	rv = mymalloc(amt);
	return(rv);
}

#ifdef debug
#define ASSERT(p) if(!(p))botch("p");else
botch(s)
char *s;
{
	printf("assertion botched: %s\n",s);
	abort();
}
#else
#define ASSERT(p)
#endif

/*	avoid break bug */
#define GRANULE 0

/*	C storage allocator
 *	circular first-fit strategy
 *	works with noncontiguous, but monotonically linked, arena
 *	each block is preceded by a ptr to the (pointer of) 
 *	the next following block
 *	blocks are exact number of words long 
 *	aligned to the data type requirements of ALIGN
 *	pointers to blocks must have BUSY bit 0
 *	bit in ptr is 1 for busy, 0 for idle
 *	gaps in arena are merely noted as busy blocks
 *	last block of arena (pointed to by alloct) is empty and
 *	has a pointer to first
 *	idle blocks are coalesced during space search
 *
 *	a different implementation may need to redefine
 *	ALIGN, NALIGN, BLOCK, BUSY, int
 *	where int is integer type to which a pointer can be cast
*/

#define ALIGN double

#define NALIGN 1
#define WORD sizeof(union store)
#define BLOCK 1024	/* a multiple of WORD*/
#define BUSY 1
#define NULL 0
#define testbusy(p) ((int)(p)&BUSY)
#define setbusy(p) (union store *)((int)(p)|BUSY)
#define clearbusy(p) (union store *)((int)(p)&~BUSY)

union store { union store *ptr;
	      ALIGN dummy[NALIGN];
	      int calloc;	/*calloc clears an array of integers*/
};

static	union store allocs[2];	/*initial arena*/
static	union store *allocp;	/*search ptr*/
static	union store *alloct;	/*arena top*/
static	union store *allocx;	/*for benefit of realloc*/
char	*sbrk();

static mcallcnt = 0;	/* Force failures to test fake malloc() */
char *
mymalloc(nbytes)
unsigned nbytes;
{
	register union store *p, *q;
	register nw;
	static temp;	/*coroutines assume no auto*/


	if(allocs[0].ptr==0) {	/*first time*/
		allocs[0].ptr = setbusy(&allocs[1]);
		allocs[1].ptr = setbusy(&allocs[0]);
		alloct = &allocs[1];
		allocp = &allocs[0];
	}
	nw = (nbytes+WORD+WORD-1)/WORD;
	ASSERT(allocp>=allocs && allocp<=alloct);
	ASSERT(allock());
	for(p=allocp; ; ) {
		for(temp=0; ; ) {
			if(!testbusy(p->ptr)) {
				while(!testbusy((q=p->ptr)->ptr)) {
					ASSERT(q>p&&q<alloct);
					p->ptr = q->ptr;
				}
				if(q>=p+nw && p+nw>=p)
					goto found;
			}
			q = p;
			p = clearbusy(p->ptr);
			if(p>q)
				ASSERT(p<=alloct);
			else if(q!=alloct || p!=allocs) {
				ASSERT(q==alloct&&p==allocs);
				return(NULL);
			} else if(++temp>1)
				break;
		}
		temp = ((nw+BLOCK/WORD)/(BLOCK/WORD))*(BLOCK/WORD);
		q = (union store *)sbrk(0);
		if(q+temp+GRANULE < q) {
			return(NULL);
		}
		q = (union store *)sbrk(temp*WORD);
		if((int)q == -1) {
			return(NULL);
		}
		ASSERT(q>alloct);
		alloct->ptr = q;
		if(q!=alloct+1)
			alloct->ptr = setbusy(alloct->ptr);
		alloct = q->ptr = q+temp-1;
		alloct->ptr = setbusy(allocs);
	}
found:
	allocp = p + nw;
	ASSERT(allocp<=alloct);
	if(q>allocp) {
		allocx = allocp->ptr;
		allocp->ptr = p->ptr;
	}
	p->ptr = setbusy(allocp);
	return((char *)(p+1));
}

/*	freeing strategy tuned for LIFO allocation
*/
free(ap)
register char *ap;
{
	register union store *p = (union store *)ap;

	ASSERT(p>clearbusy(allocs[1].ptr)&&p<=alloct);
	ASSERT(allock());
	allocp = --p;
	ASSERT(testbusy(p->ptr));
	p->ptr = clearbusy(p->ptr);
	ASSERT(p->ptr > allocp && p->ptr <= alloct);
}

/*	realloc(p, nbytes) reallocates a block obtained from malloc()
 *	and freed since last call of malloc()
 *	to have new size nbytes, and old content
 *	returns new location, or 0 on failure
*/

char *
realloc(p, nbytes)
register union store *p;
unsigned nbytes;
{
	register union store *q;
	union store *s, *t;
	register unsigned nw;
	unsigned onw;

	if(testbusy(p[-1].ptr))
		free((char *)p);
	onw = p[-1].ptr - p;
	q = (union store *)malloc(nbytes);
	if(q==NULL || q==p)
		return((char *)q);
	s = p;
	t = q;
	nw = (nbytes+WORD-1)/WORD;
	if(nw<onw)
		onw = nw;
	while(onw--!=0)
		*t++ = *s++;
	if(q<p && q+nw>=p)
		(q+(q+nw-p))->ptr = allocx;
	return((char *)q);
}
#define INSTALL	1
#define N_INSTALL	0

/*
 *	NHASH	= the size of the hash symbol table
 */
#define NHASH	MAXSYMS+61				
struct	symbol	*hashtab[NHASH];

/*
 *	"newent" is a function that is used by the lookup routine to
 *	create a new symbol table entry for an ordinary symbol.  The
 *	string representing the symbol is passed as a parameter.  This
 *	function obtains storage for the symbol table entry from
 *	"alloc" (in strings.c).  It makes a permanent copy of the symbol
 *	using "newstr" (in strings.c) and stores a pointer to this copy
 *	in the symbol table entry.  The type of the symbol is set
 *	to undefined.  All other fields of the entry are set to zero.
 */
struct	symbol *
newent (symstr)
char *symstr;
{
	struct symbol *sp;

	if (numsyms >= MAXSYMS)
		bomb ("Too many symbols (Max is %d)", MAXSYMS);
	if ((sp = (struct symbol *) malloc (sizeof (struct symbol))) == SNULL)
		bomb ("Memory used up, %d symbols\n", numsyms);
	sp = (struct symbol *) ((int)sp & ~3);
	DEBUG (8, "NEWENT: shead is %x,", shead);
	DEBUG (8, " sp is %x\n", sp);
	strncpy (sp->n.n_name, symstr, SYMSIZ);
	sp->n.n_symnum = numsyms;
	sp->n.n_type = sp->n.n_align = sp->n.n_spare = 0;
	sp->n.n_value = 0;
	sp->snext = shead;
	DEBUG (8, "NEWENT: now sp->snext = %x\n", sp->snext);
	shead = sp;
	symlist[numsyms] = &sp->n;
	DEBUG (8, "NEWENT: and symlist[%d] is ", numsyms);
	DEBUG (8, "%x\n", symlist[numsyms]);
#ifdef DEBUG
if(debug>7) fprintf (stdout, "NEWENT: %-16.16s  0x%08lx  %06x  %3d  %06x\n",
			sp->n.n_name, sp->n.n_value,
			sp->n.n_type, sp->n.n_symnum, sp->snext);
#endif
	numsyms++;
	return (sp);
}

/*
 *	lookup(string)	Looks up the symbol whose name is "string" in
 *			the symbol table and returns a pointer to the
 *			entry for that symbol.  If the symbol does not
 *			already appear in the table, an entry is
 *			created for it.
 */
struct	symbol	*
lookup(sptr,install)
	char	 *sptr;
	int	install;
{
	unsigned short
		ihash = 0,
		probe,
		hash;
	struct	symbol
		**hp,
		**ohp;
	register char
		*ptr1,
		*ptr2;

	ptr1 = sptr;
	while (*ptr1) {
		ihash = ihash*4 + *ptr1++;
	}
	probe = 1;
	ihash += *--ptr1 * 32;
	hash = ihash % NHASH;
	hp = ohp = &hashtab[hash];
	do {
		if ((*hp) == SNULL) {	/* free */
			if (install) {
				(*hp) = newent(sptr);
				return(*hp);
			}
			if (strcmp (LOCNAME, sptr) == SAME) {
			/* location counter symbol --
			   create symbol with the current addr & space type */
				ptr2 = "L%xxxxxx";
				sprintf (&ptr2[2], "%d", ltnum++);
				(*hp) = newent (ptr2);
				(*hp)->n.n_type |= curspace;
				(*hp)->n.n_value = *addrp;
				return (*hp);
			}
			return(SNULL);	/* not found */
		}
		else {
			if (strncmp ((*hp)->n.n_name, sptr, SYMSIZ) == SAME
				&& !install) return (*hp); /* found it */

			hash = (hash + probe) /*% NHASH*/;
			hash -= (hash >= NHASH) ? NHASH : 0;
			probe += 2;
		} /* else */
	} while ((hp = &hashtab[hash]) != ohp);
	bomb("Hash overflow, %d symbols\n", numsyms);
	return(SNULL); /* can't reach here since `bomb' exits */
}

symtabinit()
{
	DEBUG (6, "Sizeof a SYMBOL is %d\n", sizeof (struct symbol));
	DEBUG (6, "Sizeof a NLIST is %d\n", sizeof (struct nlist));
	shead = SNULL;
	numsyms = 0;
	ltnum = 0;
}

struct nlist *
new (symstr)
char *symstr;
{
	struct symbol *sp;

	sp = lookup(symstr, INSTALL);	/* install new symbol using lookup */
	return (&sp->n);
}

struct nlist *
get (symstr)
char *symstr;
{
	struct symbol *p;

	p = lookup(symstr, N_INSTALL);
	if(p != SNULL) return(&p->n);
	return (NNULL);
}

printsymbols (where)
register FILE *where;
{
	register struct nlist *np;
	register int i;

	fprintf (where, "Symbol                Value       Flags    Symnum   Alignment\n");
	for (i = 0; i < numsyms; i++) {
		np = symlist[i];
		fprintf( where, "    %-16.16s", np->n_name );
		if( (np->n_type & N_TYPE) == N_TEXT )
		    fprintf( where, "  0x%08lx ", np->n_value);
		else
		    fprintf(where,"  0x%08lx ",np->n_value);
		fprintf( where, " %06x   %3d", np->n_type, np->n_symnum);
		fprintf( where, "       %3d\n",np->n_align);
	}

	if (ferror(where))
		bomb ("Write error listing symbol table");
}

dumpsymbols (where)
register FILE *where;
{
register int i;
#define	SWSIZE	128					

DEBUG(8,"dumpsymbols (0x%lx);\n", where);			

	/* Write out symbol table entries verbatim */
	for (i = 0; i < numsyms; i++)
	    {							
	    DEBUG(10,"\tdumpsymbols (); i is %d\n", i);	
		fwrite (symlist[i], sizeof (struct nlist), 1, where);
	}	/* end of symbol dump loop */

	fflush (where);
	if (ferror(where))
		bomb ("Write error dumping symbol table");
}

bssfix (datasize)
long	datasize;
{
	long val;
	register int i;
	register struct nlist *np;

	for (i = 0; i < numsyms; i++) {
		np = symlist[i];
		if( np->n_type == N_BSS ) {
			val = datasize + np->n_value;
			np->n_value = val;
		}
	}
}
