  @  A         TITLE     'MPX-32 C-Language Support Routine: mpxintsvc' A          PROGRAM   MPXINTSVC  "         LIST      ON,DATA,MAC,REP " @**************************************************************** @ @*                                                              * @ C*        Function mpxintsvc                                       * C @*                                                              * @ @*        CALLING SEQUENCE:                                     * @ C*                  cc = mpxintsvc (svcnum,inreg,outreg)           * C @*                                                              * @ @*        INPUT(S): svcnum, inreg                               * @ @*                                                              * @       @  @*        OUTPUT(S): outreg, cc (function result)               * @ @*                                                              * @ @*        PURPOSE:  This function is callable from C programs.  * @ @*                  It does an MPX SVC call, given an SVC       * @ @*                  number (svcnum), an array of input          * @ @*                  registers (inreg), and an array of output   * @ @*                  registers (outreg).  Both inreg and outreg  * @ @*                  must be int arrays with at least 8 elements * @ @*                  and each must be allocated on a file        * @ @*                  boundary (for a LF/STF instruction).  To be * @ @*                  sure they are so bounded, declare inreg and * @                @  @*                  and outreg as the first two local variables * @ @*                  in the calling routine.                     * @ @*                                                              * @ @*                  The parameter svcnum must be encoded as     * @ @*                  follows: 0xT0SS, where T is the type of SVC * @ @*                  (0, 1, or 2) and SS is the SVC number       * @ @*                  (e.g., 2E).  For example:                   * @ C*                      mpxintsvc2(0x2050,inreg,outreg)            * C @*                  calls M.QATIM.                              * @ @*                                                              * @ @*                  The function result is the value of the     * @             @  @*                  condition codes after the SVC call.  The    * @ @*                  interpretation of this result, and of the   * @ @*                  contents of inreg and outreg, are dependent * @ @*                  on the SVC call.  Note that it is permitted * @ @*                  for inreg and outreg to be the same array.  * @ @*                                                              * @ @**************************************************************** @ 
         PAGE 
          DEF       _MPXINTSVC  9*        SET'S FOR REGISTER DEFINITIONS AND STACK OFFSETS 9 *  7SP.      SET       3                 STACK POINTER REG. 7 :LSTACK   EQU       32W               AMOUNT OF LOCAL STACK :                                                   @  6ARGS     EQU        LSTACK+8W   OFFSET TO ARGUMENTS TO 6 3*                                      THIS ROUTINE 3 +SVCNUM   EQU        ARGS+0W          svcnum + 3INREG    EQU        ARGS+1W          ADDR. OF inreg 3 4OUTREG   EQU        ARGS+2W          ADDR. OF outreg 4          CSECT  _MPXINTSVC EQU       $  2*        STANDARD C ENTRY SEQUENCE AND STACK SETUP 2 9         TRR       SP.,1            MOVE SP TO 1 FOR SAVE 9 9         ADI       SP.,-LSTACK       ALLOCATE STACK SPACE 9 6         STD       0,2W,SP.         SAVE RETURN AND SP 6 -         STF       4,4W,SP.         SAVE 4-R7 - *  ?*        THE FOLLOWING CODE IS NON-REENTRANT BUT IT IS SHARABLE ? *  <         STW       SP.,SAVESP        SAVE SP ACROSS SVC CALL <                         @  7         LW        0,OUTREG,SP.     GET ADDR. OF outreg 7 2         STW       0,POUTREG           AND SAVE IT 2 9         LW        0,BASESVC        LOAD BASIC SVC INSTR. 9 C         ORMH      0,SVCNUM+1H,SP.  PUT IN USER'S SVC TYPE AND NUM. C 3         STW       0,SVCSAVE        SAVE IT FOR EXM 3 8         LW        2,INREG,SP.      GET ADDRESS OF INREG 8 +         LW        7,7W,2           INREG 7 +          LW        6,6W,2           LW        5,5W,2           LW        4,4W,2           LW        3,3W,2           LW        1,1W,2           LW        0,0W,2  +         LW        2,2W,2           INREG 2 + 0         EXM       SVCSAVE           EXECUTE SVC 0 3         STD       0,SAVER0          PRESERVE R0,R1 3                             @  7         BL        $+1W              PUT CC'S IN REG. 0 7 8         SLL       0,1              CLEAR HIGH-ORDER BIT 8 1         SRL       0,28             RIGHT-JUSTIFY 1 5         LW        1,POUTREG        ADDRESS OF OUTREG 5 ,         STW       7,7W,1           OUTREG 7 ,          STW       6,6W,1           STW       5,5W,1           STW       4,4W,1           STW       3,3W,1           STW       2,2W,1  -         LD        6,SAVER0         REG0,REG1 - -         STW       7,1W,1            OUTREG 1 - ,         STW       6,0W,1           OUTREG 0 , /         LW        SP.,SAVESP        RESTORE SP / *  !*        STANDARD C EXIT SEQUENCE ! *  5         LF        2,2W,SP.         RESTORE REGISTERS 5                                         @  *         TRSW      2                RETURN * *  7BASESVC  SVC       0,0               PROTOTYPE SVC CALL 7 *  ;         DSECT                       DATA SECTION -- STATIC ; 1SVCSAVE  RES       1W                SAVE FOR SVC 1 7SAVESP   RES       1W                SAVE FOR STACK PTR 7 ;POUTREG  RES       1W                SAVE FOR PTR TO outreg ; ;SAVER0   RES       1D                TEMP STORAGE FOR R0,R1 ;          END                                                                                                                                                                                                                                                                                                                                         