  @  #include "defines.red"  extern fcbtype volfcb;  BIO(op,bstart,size,destination)  int op,bstart,size;  char *destination;  I/*=====================================================================*/ I I/*                                                                     */ I I/* MODULE NAME : BIO                                                   */ I I/*                                                                     */ I I/* FILE NAME   : bio.proj.c                                            */ I I/*                                                                     */ I I/* AUTHOR NAME : A CRANNY.    DATE : 21feb83                           */ I I/*                                                                     */ I                @  I/* FUNCTION    : to perform a read (op = 1) or a write (op = 0) to     */ I I/*               the lfc VOL, starting at block bstart for size bytes  */ I I/*               to or from address destination                        */ I I/*                                                                     */ I I/* INPUTS      : operation code (op),block address (bstart), size in   */ I I/*               bytes (size), source or destination (destination)     */ I I/* OUTPUTS     : 0 if succesful.                                       */ I I/*                                                                     */ I I/*                           EDIT HISTORY                              */ I                                                                       @  I/*                                                                     */ I I/* EDIT DATE |              LINE NO'S AND DESCRIPTION                  */ I I/* --------------------------------------------------------------------*/ I I/*                                                                     */ I I/*=====================================================================*/ I {  int reg[8];     G      /* prepare the file control block - this is a system structure */ G @      /* used to communicate between a task and the IO system */ @    C      volfcb.fcb_ctl = 0x0a000000; /* random access expanded fcb */ C @      volfcb.fcb_eraa = bstart; /* random access block number */ @ 7      volfcb.fcb_eqty = size; /* transfer size bytes */ 7        @  I      volfcb.fcb_erwa = destination; /* address to transfer to or from */ I    4      reg[1] = &volfcb; /* operation is on volfcb */ 4    3      /* check the opcode for the operation type */ 3          if (op == READ)  7            mpxsvc(0x1031,reg,reg); /* submit a read */ 7       else /* op is write */  8            mpxsvc(0x1032,reg,reg); /* submit a write */ 8    .      /* check the status of the IO request */ .    2      if ((volfcb.fcb_status & 0xff000000) != 0) { 2 >            printf(" i/o error in BIO, op = %d,status = %x\n", > .                        op,volfcb.fcb_status); .              reg[5] = 0x20454454;   #            mpxsvc(0x1057,reg,reg); #       }        return(0);  }                                         