#ifndef NOBBS
/*~!bbio.c*/
/* Name:  bbio.c Part No.: _______-____r
 *
 * Copyright 1994 - J B Systems, Morrison, CO
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of J B Systems.
 *
 *                     RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure by the Government is  subject  to
 * restriction  as  set forth in paragraph (b) (3) (B) of the Rights
 * in Technical Data and Computer Software  Clause  in  DAR  7-104.9
 * (a).
 */

#ident	"@(#)nblib:bbio.c	1.1"

#ifdef mpx
#include <fcb.h>
#endif

/********************************************************************/
/* These routines handle blocked and optionally compressed MPX files */

#define IOCMAX 10	/* max users, start with 10 for now */
#define BLKMAX 10	/* buffered disk blocks per user */

struct ioc {
    int 	fd;		/* file descriptor for i/o */
    struct fcb *afcb;		/* callers fcb address */
    unsigned char * cba;	/* current buffer address */
    unsigned char * rcba;	/* record control block pointer */
    int		cpp;		/* current pool position */
    int		cfp;		/* current file position */
    char	cbn;		/* current buffer number */
    char	nab;		/* number of active buffers */
    struct {			/* ioc bit flags */
    	unsigned openop	 : 1;	/* open flag */
    	unsigned writop	 : 1;	/* last op was write */
    	unsigned weofop	 : 1;	/* last op was write EOF */
    	unsigned outaop	 : 1;	/* output active flag */
	unsigned iocaloc : 1;	/* ioc allocated */
	unsigned free	 : 3;	/* free flags, available */
    } flag;
    unsigned char * bufa;	/* start of contiguous buffers */
    unsigned int iostat;	/* I/O status from operation */
#define ERRFLAG 0x40000000
#define BOMFLAG 0x04000000
#define EOFFLAG 0x02000000
#define EOMFLAG 0x01000000
};

int rmerror;			/* current error code */
struct ioc ioc[IOCMAX];

#define RCBEOF	0x80		/* bit 0 */
#define RCBBOB	0x40		/* bit 1 */
#define RCBEOB	0x20		/* bit 2 */
#define RCBNULL	0x10		/* bit 3 */
#define RCBCONT	0x08		/* bit 4 */

#define SBLR 0			/* status byte, last record */
#define BCLR 1			/* byte count, last record */
#define SBTR 2			/* status byte, this record */
#define BCTR 3			/* byte count, this record */

#define BLKSIZE 768
#define BLKS (BLKMAX*BLKSIZE)

/* ircont - establish ioc address for this file descriptor */
/* input - file descriptor */
/* output - ioc address */

static struct ioc * ircont (cfd)
register int cfd;
{
    register int	i;
    register struct ioc * wioc;		/* current ioc */

    rmerror = 0;			/* no errors yet */
    for (i = 0, wioc = &ioc[0]; i < IOCMAX; wioc = &ioc[++i]) {
      /* see if allocated */
      if (wioc->flag.iocaloc)
    	/* set callers file descriptor */
    	if (wioc->fd == cfd) {
    	  /* initialize callers fcb */
    	  wioc->afcb->sflg = 0;		/* status flags */
    	  wioc->afcb->errt |= 0x00ffffff;	/* special flags */
    	  wioc->afcb->recl = 0;		/* transfer count */
    	  wioc->afcb->ist1 = 0;		/* expanded status */
    	  wioc->afcb->ist2 = 0;		/* expanded status */
    	  return(wioc);
    	}
    }
    /* not yet allocated, get a new one */
    for (i = 0, wioc = &ioc[0]; i < IOCMAX; wioc = &ioc[++i]) {
      /* see if allocated yet */
      if (!wioc->flag.iocaloc) {
    	/* no, try to allocate buffer first */
    	/* get a big blocking buffer */
    	if((wioc->bufa = (unsigned char *)malloc(BLKS)) <= 0) {
#ifdef DBUG
    	  fprintf(stderr, "ioc malloc error\n");
#endif
    	  rmerror = 15;		/* can not malloc buffer space */
    	  return (0);
    	}
    	/* allocate it */
    	wioc->flag.iocaloc = 1;		/* ioc allocated */
    	/* initialize new ioc */
    	/* set callers file descriptor */
    	wioc->fd = cfd;
    	/* save callers fcb address */
    	wioc->afcb = (struct fcb *)curfcb;	/* fcbadr(cfd) */
    	/* initialize callers fcb */
    	wioc->afcb->sflg = 0;		/* status flags */
    	wioc->afcb->errt |= 0x00ffffff;	/* special flags */
    	wioc->afcb->recl = 0;		/* transfer count */
    	wioc->afcb->ist1 = 0;		/* expanded status */
    	wioc->afcb->ist2 = 0;		/* expanded status */
    	wioc->afcb->erwa = (char *)wioc->bufa;	/* set buffer addr in fcb */
    	wioc->afcb->cbra = 0x02000000;	/* just exp fcb in cntrl flags */
    	wioc->cba = wioc->bufa;		/* set current buffer addr */
    	wioc->cbn = 0;			/* no curr buf number */
    	wioc->nab = 0;			/* no active bufs */
    	/* clear flags */
    	wioc->flag.openop = 0;		/* open ioc */
    	wioc->flag.weofop = 0;
    	wioc->flag.writop = 0;
    	wioc->flag.outaop = 0;
    	wioc->cpp = 0;			/* pool empty */
    	wioc->cfp = 1;			/* curr position is 1st blk */
    	return (wioc);
      }
    }
#ifdef DBUG
    fprintf(stderr, "no ioc space left\n");
#endif
    rmerror = 3;			/* show no space left */
    return (0);
}

/* rmopen - open up a file stream */
static int rmopen (cfd)
int cfd;
{
    register struct ioc * wioc;

    wioc = ircont(cfd);
    /* wioc is 0 if bad open */
    if(wioc == (struct ioc *)0)	/* see if error */
      return(0);		/* return error */
    /* not open yet, do open */
    wioc->flag.openop = 1;	/* mark open */
    return(1);			/* return o.k. */
}

/* rmclose - close a file stream */
static int rmclose (cfd)
int cfd;
{
    register struct ioc * wioc;

    wioc = ircont (cfd);
    /* wioc is 0 if bad open */
    if(wioc == (struct ioc *)0)	/* see if error */
    	return(0);		/* return error */

    /* see if file open, must close if it is */
    if(wioc->flag.openop) {
#ifdef DBUG
printf("rmclose(%d): cbn %d, nab %d, cpp %d, cfp %d\n",
 wioc->fd, wioc->cbn, wioc->nab, wioc->cpp, wioc->cfp);
#endif
      /* open, do close */
      if (wioc->flag.writop) {
    	if(!wioc->flag.weofop)	/* did we need an EOF */
    	    irweof(wioc);	/* yes, write eof */
      }
      if (wioc->flag.outaop)
    	plwrit(wioc);		/* if pool active, purge */
    }

    wioc->flag.openop = 0;	/* mark closed */
    wioc->flag.iocaloc = 0;	/* mark unallocated */
    free (wioc->bufa);		/* free buffer */
    wioc->bufa = 0;		/* clear buffer address */
    wioc->fd = -1;		/* clear file descriptor */
    return (1);
}

/* rmrwnd - rewind a file stream */
static int rmrwnd (cfd)
int cfd;
{
    register struct ioc * wioc;

    wioc = ircont (cfd);
    if(wioc == (struct ioc *)0)	/* see if error */
    	return(0);		/* return error */
    if(!wioc->flag.openop) {
        wioc->flag.openop = 1;	/* set open */
    	goto rwd01;		/* if not open, return o.k. */
    }
#ifdef DBUG
printf("rmrwnd(%d): cbn %d, nab %d, cpp %d, cfp %d\n",
 wioc->fd, wioc->cbn, wioc->nab, wioc->cpp, wioc->cfp);
#endif
    if (wioc->flag.writop) {	/* if writing, see if EOF needed */
    	if(!wioc->flag.weofop)	/* did we need an EOF */
    	    irweof(wioc);	/* yes, write eof */
    }
    if (wioc->cpp == 0)		/* pool initialized */
    	goto rwd01;		/* no, just return O.K. */
    /* set buffer tables for rewind */
    plrwnd(wioc);		/* rewind pool to 1st block */
    if (wioc->cpp) {		/* 1st pool in memory */
      wioc->cbn = 1;		/* 1st buffer */
      wioc->cba = wioc->bufa;	/* beginning of buffer */
      wioc->rcba = wioc->cba + 4;	/* set rec cont buf address */
    } else {
      wioc->cbn = 0;		/* no buffers in memory */
    }
rwd01:
    wioc->afcb->sflg &= ~EOFFLAG;	/* turn off eof in callers fcb */
    wioc->afcb->sflg |= BOMFLAG;	/* turn on bom in callers fcb */
    return (1);
}

/* rmweof - write eof on file stream */
static int rmweof (cfd)
int cfd;
{
    register struct ioc * wioc;

    wioc = ircont (cfd);
    if(wioc == (struct ioc *)0)	/* see if error */
    	return(0);		/* return error */
    if(!wioc->flag.openop) {
        wioc->flag.openop = 1;	/* set open */
    }
#ifdef DBUG
printf("rmweof(%d): cbn %d, nab %d, cpp %d, cfp %d\n",
 wioc->fd, wioc->cbn, wioc->nab, wioc->cpp, wioc->cfp);
#endif
    irweof(wioc);		/* write eof */
    wioc->flag.writop = 1;	/* set writing */
    return (1);
}

/* rmback - backspace record on file stream */
static int rmback (cfd)
register int cfd;
{
    register struct ioc * wioc;
    register int cnt;

    wioc = ircont (cfd);
    if(wioc == (struct ioc *)0)	/* see if error */
    	return(0);		/* return error */
    if(!wioc->flag.openop) {
        wioc->flag.openop = 1;	/* set open */
    	goto bsxt;		/* if not open, return o.k. */
    }
#ifdef DBUG
printf("rmback(%d): cbn %d, nab %d, cpp %d, cfp %d\n",
 wioc->fd, wioc->cbn, wioc->nab, wioc->cpp, wioc->cfp);
#endif
    if (wioc->flag.writop) {	/* if writing, see if EOF needed */
    	if(!wioc->flag.weofop) {	/* do we need an EOF */
    	    irweof(wioc);	/* yes, write eof */
#ifdef FFIX
    	    bfback(wioc);	/* back over eof just written */
#else
    	    wioc->rcba -= 4;	/* back over eof just written */
#endif
    	}
    }
    /* see if pool empty */
    if (wioc->cpp != 0) {	/* if not empty */
    	bfback(wioc);		/* back over previous record */
    }
bsxt:
    wioc->flag.writop = 0;		/* not writing */
    wioc->afcb->sflg &= ~EOFFLAG;	/* turn off eof in callers fcb */
    return (1);
}

/* rmread - read from file stream */
static int rmread (cfd, buffer, rcnt)
int cfd;
unsigned char * buffer;
int rcnt;
{
    register struct ioc * wioc;
    int	fillcnt, i, bytecnt;
    unsigned char * buffp;

    wioc = ircont (cfd);
    if(wioc == (struct ioc *)0)	/* see if error */
    	return(0);		/* return error */
    if(!wioc->flag.openop) {
        wioc->flag.openop = 1;	/* set open */
    }
#ifdef DBUG
printf("rmread(%d): cbn %d, nab %d, cpp %d, cfp %d\n",
 wioc->fd, wioc->cbn, wioc->nab, wioc->cpp, wioc->cfp);
#endif
#ifdef DBUG
printf("rmread in: rcnt = %d, buffer = %x\n", rcnt, buffer);
#endif
    /* see if read after a write */
    if (wioc->flag.writop) {
#ifdef DBUG
      printf("read after write not allowed\n");
#endif
      rmerr(wioc, 9);		/* user tried to read after write */
      return(0);		/* return error */
    }
    bytecnt = 0;		/* no bytes to caller yet */
    buffp = buffer;		/* save caller buff addr */
    /* see if any data in pool yet */
    if ((wioc->cpp == 0) ||	/* if no data in pool yet, read it in */
      /* see if end of the block */
      (wioc->rcba[SBLR] & RCBEOB)) {
      /* yes, read next block */
      if (bfredf(wioc) == -1) {		/* test for EOF */
        wioc->afcb->sflg |= EOFFLAG;	/* set EOF for caller */
    	return(-1);
      }
      wioc->rcba = wioc->cba + 4;	/* where we start */
    }
    /* test for end of file */
    if (wioc->rcba[SBTR] & RCBEOF) {
      /* at EOF, set EOF bit in FCB */
      wioc->afcb->sflg |= EOFFLAG;
      return(-1);			/* return EOF */
    }

    /* get byte count to transfer */
    bytecnt = wioc->rcba[BCTR];
    /* copy data to user */
    if (bytecnt > 8)
      memcpy (buffer, &wioc->rcba[4], bytecnt);
    else
      for (i = 0; i < bytecnt; i++)
    	buffer[i] = wioc->rcba[i+4];
    wioc->afcb->recl = bytecnt;		/* save count in fcb */
    wioc->afcb->erwa = (char *)buffer;	/* reset buffer address in caller fcb */
    wioc->rcba += (bytecnt + 4);	/* point to next record */
#ifdef DBUG
printf("rmread: recl = %d, buffer = %x\n", bytecnt, buffer);
#endif
    return (bytecnt);			/* return byte count */
}

#ifdef NOT_FOR_NOW
/* rmadvr - advance record on file stream */
static int rmadvr (cfd)
int cfd;
{
    register struct ioc * wioc;

    wioc = ircont (cfd);
    if(wioc == (struct ioc *)0)	/* see if error */
    	return(0);		/* return error */
    if (wioc->flag.writop) {	/* was last op a write */
#ifdef DBUG
      printf("adv record after write not allowed\n");
#endif
      rmerr(wioc, 9);		/* user tried adv after write */
      return (-1);		/* return error */
    }
    if(!wioc->flag.openop) {
        wioc->flag.openop = 1;	/* set open */
        bfredf (wioc);		/* read in a block */
        wioc->rcba = wioc->cba + 4;	/* calc rcb address */
        goto adv02;
    }
    /* see if any data in memory */
    if (wioc->cpp == 0) {	/* if no data in pool yet, read it in */
      bfredf (wioc);		/* read in a block */
      wioc->rcba = wioc->cba + 4;	/* calc rcb address */
    }
    /* see if at EOB */
    if (wioc->rcba[SBLR] & RCBEOB) {
      bfredf(wioc);		/* EOB, get next record */
      wioc->rcba = wioc->cba + 4;	/* calc rcb address */
    }
adv02:
    /* see if at EOF */
    if (wioc->rcba[SBTR] & RCBEOF) {
      wioc->afcb->sflg |= EOFFLAG;	/* set EOF for user */
      return (1);
    }
    wioc->rcba += (wioc->rcba[BCTR] + 4);	/* point to next record */
    return (1);
}
#endif

/* rmadvf - advance to EOF on file stream */
static int rmadvf (cfd)
int cfd;
{
    register struct ioc * wioc;

    wioc = ircont (cfd);
    if(wioc == (struct ioc *)0)	/* see if error */
    	return(0);		/* return error */
    if (wioc->flag.writop) {
#ifdef DBUG
      printf("adv file after write not allowed\n");
#endif
      rmerr(wioc, 9);		/* user tried adv after write */
      return (-1);
    }
    if(!wioc->flag.openop) {
      wioc->flag.openop = 1;	/* set open */
      bfredf (wioc);		/* read in a block */
      wioc->rcba = wioc->cba + 4;
#ifdef DFIX
      goto af02;
#endif
    }
af00:
    if (wioc->cpp == 0) {	/* if no data in pool yet, read it in */
      bfredf (wioc);		/* read in a block */
      wioc->rcba = wioc->cba + 4;
    }
    /* see if at EOB */
    if (wioc->rcba[SBLR] & RCBEOB) {
      bfredf(wioc);		/* yes, read in next block */
      wioc->rcba = wioc->cba + 4;
    }
af02:
    /* see if at EOF yet */
    if (wioc->rcba[SBTR] & RCBEOF) {
      wioc->afcb->sflg |= EOFFLAG;	/* set EOF for caller */
      return (1);		/* return O.K. */
    }
    wioc->rcba += (wioc->rcba[BCTR] + 4);	/* next record address */
    goto af00;			/* continue looking for EOF */
}

/* rmwrit - write data on file stream */
static int rmwrit (cfd, buffer, cnt)
int cfd;
unsigned char * buffer;		/* callers buffer */
int cnt;			/* byte count */
{
    register struct ioc * wioc;
    unsigned char * buffp;
    int bcnt, i;

    wioc = ircont (cfd);
    if(wioc == (struct ioc *)0)	/* see if error */
    	return(0);		/* return error */
    if(!wioc->flag.openop) {
        wioc->flag.openop = 1;	/* set open */
    }
#ifdef DBUG
printf("rmwrit(%d): cbn %d, nab %d, cpp %d, cfp %d\n",
 wioc->fd, wioc->cbn, wioc->nab, wioc->cpp, wioc->cfp);
#endif
#ifdef DBUG
printf("rmwrit in: cnt = %d, buffer = %x\n", cnt, buffer);
#endif
    wioc->flag.writop = 1;	/* show output active */
    wioc->flag.outaop = 1;	/* show pool output active */
    wioc->flag.weofop = 0;	/* last op was not weof */
    if (wioc->cpp == 0) {	/* if no data in pool yet, initialize */
      wioc->cba = wioc->bufa;	/* point to 1st buffer */
      wioc->nab = 1;		/* 1st active block */
      wioc->cbn = 1;		/* 1st buffer */
      wioc->cpp = 1;		/* 1st pool */
      irbinit(wioc);		/* initialize buffer */
    }
    buffp = buffer;		/* save caller buff addr */
    bcnt = cnt;
#ifdef DBUG
    if (bcnt >= 0xff) {
      printf("write: char cnt over 254 bytes\n");
      rmerr(wioc, 8);		/* record too big error */
      return (-1);
    }
#endif
    /* see if enough space in current block */
    if((bcnt + 4) > (wioc->cba + BLKSIZE - wioc->rcba - 2)) {
    	irfinis(wioc);		/* finish block with zero fill */
    	bfwrit(wioc);		/* write it out */
    	irbinit(wioc);		/* initialize next block */
    }
    /* transfer user data to buffer */
    wioc->rcba[SBTR] = 0;	/* zero status byte */
    wioc->rcba[BCTR] = bcnt;	/* set byte count */
    cnt = bcnt;			/* save for caller */
    /* copy in user data */
    if (bcnt > 8)
      memcpy (&wioc->rcba[4], buffer, bcnt);
    else
      for (i = 0; i < bcnt; i++)
    	wioc->rcba[i+4] = buffer[i];
    wioc->rcba += (bcnt + 4);		/* next record address */
    wioc->rcba[SBLR] = 0;		/* zero status byte */
    wioc->rcba[BCLR] = bcnt;		/* set byte count */
    bcnt = wioc->rcba - wioc->cba;	/* set new block cnt */
#ifdef mpx
    *(int *)wioc->cba = bcnt;		/* set block count */
#else
    wioc->cba[2] = (bcnt >> 8) & 0xff;	/* upper byte */
    wioc->cba[3] = bcnt & 0xff;		/* lower byte */
#endif
    wioc->afcb->recl = cnt;		/* save count in fcb */
    wioc->afcb->erwa = (char *)buffer;	/* reset buffer address in caller fcb */
#ifdef DBUG
printf("rmwrit: recl = %d, buffer = %x\n", cnt, buffer);
#endif
    return (cnt);			/* return O.K. */
}

/* bfback - position to previous record */
static int bfback (wioc)
register struct ioc * wioc;
{
    register int cnt;

#ifdef DBUG
printf("bfback(%d): cbn %d, nab %d, cpp %d, cfp %d\n",
 wioc->fd, wioc->cbn, wioc->nab, wioc->cpp, wioc->cfp);
#endif
    if (wioc->cpp == 0)			/* if pool empty, return */
        return(1);			/* get out */
#ifndef FFIX
    if (wioc->rcba[SBTR] & RCBEOF)	/* is it an EOF */
    	return(1);			/* ignore, get out */
#endif
    if (wioc->rcba[SBLR] & RCBBOB) {	/* is it a beg of blk */
      /* 1st block in pool? */
      if (wioc->cbn > 1)		/* ignore if not 1st blk */
    	goto bs02;
      /* 1st pool in memory? */
      if (wioc->cpp == 1) {
    	/* we are already at BOM */
#ifdef DBUG
printf("return0 bfback(%d): cbn %d, nab %d, cpp %d, cfp %d\n",
 wioc->fd, wioc->cbn, wioc->nab, wioc->cpp, wioc->cfp);
#endif
        return(1);			/* get out */
      }
bs02:
      /* read previous buffer from pool */
      /* see if previous buffer in memory */
      if (wioc->cbn == 1) {
        /* we are at 1st buffer, read in previous pool */
        /* position file to previous pool*/
        flposs(wioc, wioc->cpp - BLKMAX);	/* position file */
        plredf(wioc);		/* now read in the pool */
        wioc->cbn = BLKMAX;	/* we start at last buffer */
        /* reset address pointer to start of last block */
        wioc->cba = wioc->bufa + BLKS - BLKSIZE;
      } else {
        --wioc->cbn;		/* last buffer number */
        wioc->cba -= BLKSIZE;	/* last buffer address */
      }
#ifdef mpx
      cnt = *(int *)wioc->cba;		/* get count */
#else
      cnt = (wioc->cba[2] << 8) | wioc->cba[3];	/* get count */
#endif
      wioc->rcba = wioc->cba + cnt;
    }
    /* backspace to previous record in this block */
    wioc->rcba -= (wioc->rcba[BCLR] + 4);
#ifdef DBUG
printf("return bfback(%d): cbn %d, nab %d, cpp %d, cfp %d\n",
 wioc->fd, wioc->cbn, wioc->nab, wioc->cpp, wioc->cfp);
#endif
    return(1);				/* get out */
}

/* bfredf - read next buffer from file stream */
static int bfredf (wioc)
register struct ioc * wioc;
{
    int bcnt;

#ifdef DBUG
printf("bfredf(%d): cbn %d, nab %d, cpp %d, cfp %d\n",
 wioc->fd, wioc->cbn, wioc->nab, wioc->cpp, wioc->cfp);
#endif
    /* see if next buffer in memory */
    if (wioc->cbn >= wioc->nab) {
      /* no, read in next pool */
      if (plredf(wioc) == -1)	/* read next pool */
    	return (-1);		/* show EOF */
      wioc->cbn = 1;		/* we start at 1st buffer */
      wioc->cba = wioc->bufa;	/* reset address pointer */
    } else {
      ++wioc->cbn;		/* bump buffer number */
      wioc->cba += BLKSIZE;	/* next buffer address */
    }
#ifndef TRY_THIS_FRIDAY
#ifdef mpx
    bcnt = *(int *)wioc->cba;	/* get count */
#else
    bcnt = (wioc->cba[2] << 8) | wioc->cba[3];	/* get count */
#endif
    /* check for cnt < 0x300 (768) */
    if (bcnt >= 0x300) {
#ifdef DBUG
      printf("bfredf - block count greater than 768 bytes\n");
#endif
      rmerr(wioc, 5);		/* bad block count */
      return (-1);
    }
    /* check for just BOB on in control bits */
    wioc->rcba = wioc->cba + 4;
    if (((wioc->rcba[SBLR] & (RCBBOB | RCBEOB | RCBEOF)) == RCBBOB))
      return(1);		/* return O.K. */
    /* no BOB, set EOF in user FCB */
    wioc->afcb->sflg |= EOFFLAG;	/* set EOF for caller */
    rmerr(wioc, 5);		/* bad block count */
    return (-1);
#else
    return(1);		/* return O.K. */
#endif
}

/* bfwrit - write this buffer into pool */
static int bfwrit(wioc)
register struct ioc * wioc;
{
#ifdef DBUG
printf("bfwrit(%d): cbn %d, nab %d, cpp %d, cfp %d\n",
 wioc->fd, wioc->cbn, wioc->nab, wioc->cpp, wioc->cfp);
#endif
    /* see if more buffers in memory */
    if (wioc->cbn < BLKMAX) {
      ++wioc->cbn;		/* current buffer number */
      wioc->nab = wioc->cbn; 	/* set number of active buffers */
      wioc->cba += BLKSIZE;	/* next buffer address */
      return (1);		/* return O.K. */
    }
    /* no, write out current pool */
    plwrit(wioc);		/* write out current pool */
    wioc->cpp += BLKMAX;	/* incr current pool position */
    wioc->nab = 1;		/* set number of active buffers */
    wioc->cbn = 1;		/* buffer number one */
    wioc->cba = wioc->bufa;	/* point to start of buffer */
    return (1);			/* return O.K. */
}

/* plredf - read next buffer pool from file stream */
static int plredf (wioc)
register struct ioc * wioc;
{
    register int fcba = (int)wioc->afcb;
    int retc;

#ifdef DBUG
printf("plredf(%d): cbn %d, nab %d, cpp %d, cfp %d\n",
 wioc->fd, wioc->cbn, wioc->nab, wioc->cpp, wioc->cfp);
#endif
    /* read the file */
#ifdef mpx
    wioc->afcb->eqty = BLKS;	/* set byte count */
    wioc->afcb->erwa = (char *)wioc->bufa;	/* set buffer address */
    wioc->afcb->sflg = 0;	/* clear any error flags */
    asm (" trr r6,r1");		/* get fcb address */
    asm (" svc 1,x'31'");	/* do read */
    if (wioc->afcb->sflg & ERRFLAG) {
      rmerr(wioc, 4);		/* error condition found */
      return(-1);		/* return error */
    }
    if (wioc->afcb->sflg & EOFFLAG) {
      rmerr(wioc, 5);		/* premature EOF */
      return(-1);		/* return error */
    }
    if (wioc->afcb->sflg & EOMFLAG) {
      rmerr(wioc, 6);		/* EOM encountered */
      return(-1);		/* return error */
    }
    retc = wioc->afcb->recl;	/* get amount read */
#ifdef DBUG
printf("plredf: retc = %d\n", retc);
#endif
#else
    retc = read(wioc->fd, wioc->bufa, BLKS);
    wioc->afcb->recl = retc;	/* set amount read */
#ifdef DBUG
printf("plredf: retc = %d\n", retc);
#endif
#endif
    if (retc <= 0 || (retc % BLKSIZE != 0)) {
      wioc->afcb->sflg |= ERRFLAG;
      rmerr(wioc, 1);		/* less than 1 block read */
      return (-1);		/* show EOF for error */
    }
    /* compute # of blocks we read */
    wioc->nab = retc / BLKSIZE;
    wioc->cpp = wioc->cfp;	/* update curr pool position */
    wioc->cfp += wioc->nab;	/* update current file position */
#ifdef DBUG
printf("return plredf(%d): cbn %d, nab %d, cpp %d, cfp %d\n",
 wioc->fd, wioc->cbn, wioc->nab, wioc->cpp, wioc->cfp);
#endif
    return (1);			/* return O.K. */
}

/* plwrit - write this buffer pool to file stream */
static int plwrit (wioc)
register struct ioc * wioc;
{
    register int fcba = (int)wioc->afcb;
    int retc;
    int bytcnt;

#ifdef DBUG
printf("plwrit(%d): cbn %d, nab %d, cpp %d, cfp %d\n",
 wioc->fd, wioc->cbn, wioc->nab, wioc->cpp, wioc->cfp);
#endif
#ifdef DBUG
    /* see if file at correct poition */
    if (wioc->cpp > wioc->cfp) {
      /* this should never happen */
      rmerr(wioc, 12);		/* internal positioning error */
      return (-1);		/* error */
    }
#endif
    if (wioc->cpp < wioc->cfp) {
      /* file needs positioning */
      flposs(wioc, wioc->cpp);	/* position file */
    }
    /* determine bytes to write */
    bytcnt = wioc->nab * BLKSIZE;
    /* write the file */
#ifdef mpx
    wioc->afcb->eqty = bytcnt;	/* set byte count */
    wioc->afcb->erwa = (char *)wioc->bufa;	/* set buffer address */
    asm (" trr r6,r1");		/* get fcb address */
    asm (" svc 1,x'32'");	/* do write */
    if (wioc->afcb->sflg & ERRFLAG) {
      rmerr(wioc, 10);		/* error condition found */
      return(-1);		/* return error */
    }
    if (wioc->afcb->sflg & EOMFLAG) {
      rmerr(wioc, 11);		/* EOM encountered */
      return(-1);		/* return error */
    }
    retc = wioc->afcb->recl;	/* get amount written */
#ifdef DBUG
printf("plwrit: retc = %d, bytcnt = %d\n", retc, bytcnt);
#endif
#else
    retc = write(wioc->fd, wioc->bufa, bytcnt);
    wioc->afcb->recl = retc;	/* get amount written */
#ifdef DBUG
printf("plwrit: retc = %d, bytcnt = %d\n", retc, bytcnt);
#endif
#endif
    if (retc < bytcnt) {
      rmerr(wioc, 10);		/* error condition found */
      return (-1);		/* show EOF for error */
    }
    /* update current file position with # block we wrote */
    wioc->cfp += wioc->nab;	/* update current file position */
#ifdef DBUG
printf("return plwrit(%d): cbn %d, nab %d, cpp %d, cfp %d\n",
 wioc->fd, wioc->cbn, wioc->nab, wioc->cpp, wioc->cfp);
#endif
    return (1);			/* return O.K. */
}

/* plrwnd - rewind this file */
static int plrwnd (wioc)
register struct ioc * wioc;
{
#ifdef DBUG
printf("plrwnd(%d): cbn %d, nab %d, cpp %d, cfp %d\n",
 wioc->fd, wioc->cbn, wioc->nab, wioc->cpp, wioc->cfp);
#endif
    if (wioc->cpp != 1) {	/* 1st pool in memory? */
      /* no, see if output active */
      if (wioc->flag.outaop) {
    	/* write active pool first */
    	wioc->flag.outaop = 0;	/* not output active anymore */
    	wioc->flag.writop = 0;	/* not writing anymore */
    	plwrit(wioc);		/* write the pool */
      }
      wioc->cpp = 0;		/* no data in pool */
      wioc->nab = 0;		/* no active blocks */
      wioc->cbn = 0;		/* no current buffer */
    }
    /* is file at beginning */
    if (wioc->cfp != 1) {	/* file at beginning? */
      flposs(wioc, 1);		/* position file to start */
    }
    wioc->flag.writop = 0;	/* not writing anymore */
    return (1);			/* return O.K. */
}

/* flposs - position file to correct pool */
static int flposs (wioc, position)
register struct ioc * wioc;
int position;
{
    register int fcba = (int)wioc->afcb;
    register int delta = position - wioc->cfp;

#ifdef DBUG
printf("flposs(%d): cbn %d, nab %d, cpp %d, cfp %d\n",
 wioc->fd, wioc->cbn, wioc->nab, wioc->cpp, wioc->cfp);
printf("flposs cpp = %d, cfp = %d, position = %d, delta = %d\n",
 wioc->cpp, wioc->cfp, position, delta);
#endif
    wioc->cfp = position;	/* set new position */
    if (delta == 0)
      return (1);		/* we are there, return O.K. */
#ifdef mpx
    /* see if file is to be advanced */
    if (delta > 0) {
      /* skip to new poition */
      while (delta--)
        asm (" trr r6,r1");	/* get fcb address */
    	asm (" svc 1,x'33'");	/* advance 1 record (sector) */
      return (1);		/* return O.K. */
    }
    if (position <= 1) {	/* see if to beginning of file */
      asm (" trr r6,r1");	/* get fcb address */
      asm (" svc 1,x'37'");	/* rewind to BOF */
      return (1);		/* return O.K. */
    }
    /* here we want to backspace the file */
    while (delta++)
      asm (" trr r6,r1");	/* get fcb address */
      asm (" svc 1,x'35'");	/* backspace 1 record (sector) */
    return (1);			/* return O.K. */
#else
    /* seek to new position */
    if (lseek(wioc->fd, delta*BLKSIZE, 1) == -1) {
#ifdef DBUG
printf("flposs position error\n");
#endif
      return(-1);		/* go an error */
    }
    return (1);			/* return O.K. */
#endif
}

/* irweof - write EOF to block */
static int irweof (wioc)
register struct ioc * wioc;
{
    register int room;

#ifdef DBUG
printf("irweof(%d): cbn %d, nab %d, cpp %d, cfp %d\n",
 wioc->fd, wioc->cbn, wioc->nab, wioc->cpp, wioc->cfp);
#endif
    wioc->flag.writop = 1;	/* show output active */
    wioc->flag.outaop = 1;	/* show pool output active */
    if (wioc->cpp == 0) {	/* if no data in pool yet, initialize */
      wioc->cba = wioc->bufa;	/* point to 1st buffer */
      wioc->nab = 1;		/* 1st active block */
      wioc->cbn = 1;		/* 1st buffer */
      wioc->cpp = 1;		/* 1st pool */
      irbinit(wioc);		/* initialize buffer */
    } else {
      /* see if enough room for EOF */
#ifdef mpx
      room = *(int *)wioc->cba;	/* get count */
#else
      room = (wioc->cba[2] << 8) | wioc->cba[3];	/* get count */
#endif
      room = BLKSIZE - room;	/* space left */
      if (room < 6) {		/* need 6 bytes for EOF */
        /* not enough room, put EOF in next block */
        irfinis(wioc);		/* finish block */
        bfwrit(wioc);		/* write it */
        irbinit(wioc);		/* initialize next buffer */
      }
    }
    /* set up EOF flags */
    wioc->rcba[SBTR] = 0;
    wioc->rcba[BCTR] = 0;
    wioc->rcba[SBTR] |= (RCBEOF);	/* set EOF */
    wioc->rcba += 4;			/* next word */
    wioc->rcba[SBLR] = 0;
    wioc->rcba[BCLR] = 0;
    wioc->rcba[SBLR] |= (RCBEOF | RCBEOB);	/* set EOF & EOB */
    wioc->flag.weofop = 1;	/* show we just did EOF */
    room = (wioc->rcba - wioc->cba);	/* set new record cnt */
#ifdef mpx
    *(int *)wioc->cba = room;		/* set count */
#else
    wioc->cba[2] = (room >> 8) & 0xff;	/* upper byte */
    wioc->cba[3] = room & 0xff;		/* lower byte */
#endif
    /* EOF is always last block, so write it and ready new block */
    irfinis(wioc);		/* complete block */
    bfwrit(wioc);		/* write it */
    irbinit(wioc);		/* initialize next one */
#ifdef FFIX
    bfback(wioc);		/* now backup to EOF */
#endif
    wioc->nab = wioc->cbn;	/* reset current buffer number */
    return (1);			/* return O.K. */
}

/* irfinis - finish buffer by padding with zeros */
static int irfinis (wioc)
register struct ioc * wioc;
{
    register int cnt;

    wioc->rcba[SBLR] |= RCBEOB;		/* set EOB */
#ifdef mpx
    cnt = *(int *)wioc->cba;	/* get count */
#else
    cnt = (wioc->cba[2] << 8) | wioc->cba[3];	/* get count */
#endif
    cnt = BLKSIZE - cnt - 2;		/* chars to zero */
    memset (&wioc->rcba[SBTR], 0, cnt);	/* zero rest of buffer */
}

/* irbinit - initialize current buffer for write */
static int irbinit (wioc)
register struct ioc * wioc;
{
#ifdef mpx
    *(int *)wioc->cba = 4;	/* set byte count word */
#else
    wioc->cba[0] = 0;		/* clear the count word */
    wioc->cba[1] = 0;
    wioc->cba[2] = 0;
    wioc->cba[3] = 4;		/* set byte count, this record */
#endif
    wioc->rcba = wioc->cba + 4;	/* where to start */
    wioc->rcba[SBTR] = 0;	/* clear the rcb bytes */
    wioc->rcba[BCTR] = 0;
    wioc->rcba[SBLR] = RCBBOB;	/* set beginning of block bit */
    wioc->rcba[BCLR] = 0;	/* */
}

/* rmerr - handle errors encountered */
static int rmerr(wioc, num)
register struct ioc * wioc;
register int num;
{
#ifdef DBUG
printf("rmerr: error = %d\n", num);
#endif
    switch (num) {
      case 1:		/* less than 1 block on read */
      case 2:		/* not a multiple of blocks read */
/*    case 3:		/* no ioc's available */
      case 4:		/* error condition on read */
      case 7:		/* write attempted on unopen file */
      case 8:		/* user record too large (>254) */
      case 9:		/* read not allowed after write */
      case 10:		/* error on write */
      case 12:		/* internal file positioning error */
      case 13:		/* open resource error */
      case 14:		/* internal file positioning error */
    	wioc->afcb->sflg |= 0x40000000;	/* set error flag in fcb */
    	break;
      case 5:		/* premature EOF */
    	wioc->afcb->sflg |= 0x02000000;	/* set EOF in FCB */
    	break;
      case 6:		/* end of medium encountered */
      case 11:		/* EOM found */
    	wioc->afcb->sflg |= 0x01000000;	/* set EOM in FCB */
    	break;
    }
    wioc->flag.openop = 0;	/* close the ioc */
    wioc->flag.iocaloc = 0;	/* deallocate it */
    free(wioc->bufa);		/* free the buffer */
    wioc->bufa = 0;		/* clear buffer address */
    wioc->fd = -1;		/* clear file descriptor */
    rmerror = num;		/* set error number */
    return;
}
#endif /* NOBSS */
