/**** REV 1.0   -  FIXED UP BAD LINES AND ADDED EOM PROCESSING */
/* CHANGED 02/11/83 BY JCB  10000  */
/*  */
/*                 Entry: seq  [-stanp] file.....                 */

/* This program acts exactly like "cat" except for the sequencing */
/* and tabbing functions.  If the "-s" option is specified, four  */
/* columns of sequence number and one column of padding is        */
/* prefixed to the output data.  If the "-t" option is used, all  */
/* tab characters in the text are expanded as if tab settings     */
/* were: 1, 5, 9, 13, 17, etc.  If the -"a" option is used, tabs  */
/* are expanded according to SEL assembler language conventions.  */
/* The "-t" and "-a" options are mutually exclusive, but otherwise*/
/* all options, once set, remain in effect for all named files    */
/* unless cancelled (see following).  The "-r" option, when       */
/* specified, resets all of the above options to "off", thus      */
/* allowing cancellation or changing of options during the course */
/* of command processing.                                         */
/* */
/* Files may be concatenated with this command as with "cat" and  */
/* options may be reset and/or changed anywhere within the command*/
/* line by cancellation ("-r" option) or by simple restatement,   */
/* e.g. to change from "-t" to "-a", which exclude one another or */
/* to introduce sequencing ("-s") for the first time, etc.  Since */
/* the major use of this command is to obtain sequenced, printed  */
/* listings of ASCII files, two additional options are available: */
/* "-p" (page) will issue a form-feed character to the standard   */
/* to cause the next file to begin on a new page but it continues */
/* the sequencing of lines with the next sequential number.       */
/* "-n" (newfile) issues a form-feed as well but causes the       */
/* sequencing of the next file to begin with the Number 1 rather  */
/* than the next sequential number.                               */
/* A "-" alone or at the end of an option string causes the next  */
/* input to be read from the standard input rather than from the  */
/* named file.                                                    */
/*  */
/* Sample entry: seq -s file1 -t file2 -n- file3 - -rap file4 | lpr */
/*  */
/* results of above: file1 concatenenated with file2, statements  */
/* numbered in sequence, with tabs in file2 expanded to spaces but*/
/* not those of file1.  Then file3, sequenced and tabbed, is      */
/* printed on a new page, but only after some input lines are     */
/* prepended from the terminal.  Sequence numbers begin again     */
/* with 1.  After file3 is printed, the program returns again to  */
/* the terminal for more input, still sequenced  and tabbed, to   */
/* be appended to file3.  Finally, all options are reset (cleared)*/
/* and file4 is printed  on a new page, unsequenced, with         */
/* assembler-language tabbing.                                    */
/*  */

#include <stdio.h>                          /*10000 */
#include <sys/types.h>                       /* 10000*/
#include <sys/stat.h>                            /* 10000*/

#define LINELEN 132    /* was 130  10000  */
#define NEWLINE '\n'
#define FORMFEED '\014'  /*  used to skip to top of page  */
#define NEWFILE '\002' /* used to restart sequencing from 1 (STX char)*/
#define EOM -1

/* char forms[] = {"\033E\033&l0O\033(0U\033(s0p16.66h8.5v0s0b0T"}; */
char forms[] = {0x1b,0x45,0x1b,0x26,0x6c,0x30,0x4f,0x1b,0x28,
    0x30,0x55,0x1b,0x28,0x73,0x30,0x70,0x31,0x36,
    0x2e,0x36,0x36,0x68,0x38,0x2e,0x35,0x76,
    0x30,0x54,0x00,0x00,0x1b,0x26,0x6c,0x34,0x2e,
    0x33,0x36,0x37,0x63,0x31,0x30,0x38,0x46,0x1b,
    0x26,0x61,0x31,0x30,0x4c,0x00};
char forms2[] = {0x0c,0x1b,0x45};
int    print=0;
char   ff = FORMFEED;
char   chr;                     /* character holder */
char   line[LINELEN],*lineptr;  /* line buffer and pointer */
int tabs = {0};    /*  global access to -t argument -- initialized off  */

int normtbl[132] = {
      0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,
      0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,
      0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,
      0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,
      0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,
      1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
      1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
      1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
      1,1,1,1 }; /*   'normal' tabs -- 5,9,13,17,21, etc.  */

int asmtbl [132] = {
      0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
      0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
      0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,
      0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,
      0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,
      1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
      1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
      1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
      1,1,1,1 }; /*   'special' tabs for the assembler  */

char newpage[] = { FORMFEED }; /*  used to skip to new page  */

main(argc,argv)
   char   **argv;

{
   register FILE *fi;
   struct stat statb;
   int dev, ino, fflg; /*  I/O variables  */
   int    seq,n;                   /* sequence numbers */
   int    i,j,count;               /* character counters */  /* 10000 */
   int    forcend, noline;         /* line length & paging control variables */
   int   savchar;                 /* temporary character holder */

   fflg=seq=forcend=noline=n=0;   /* initialize flags & indicators */
   dev = ino = -1;
   fstat(fileno(stdout), &statb);
   statb.st_mode &= S_IFMT;
   if (statb.st_mode!=S_IFCHR && statb.st_mode!=S_IFBLK) {
      dev = statb.st_dev;
      ino = statb.st_ino;
   }
   if (argc < 2) {
      argc = 2;
      fflg++;
   }
   while (--argc > 0) {

      for ( i = 1; (*++argv)[0]=='-'; argc-- ) {
      if ((*argv)[1] != 0) {
      while ((*argv)[i] != 0x0)    /* pass through all flags */
         { switch ((*argv)[i++]) {
              case 's':           /* sequencing ('-s') option */
              case 'S':
                   seq = n ? n : 1; break;  /* set up for sequence numbering */
              case 't':           /* tabbing ('-t') option */
              case 'T':
                   tabs=1; break;  /* set up for tab expansion */
              case 'r':
              case 'R':
                   n=tabs=seq=0; /*  reset all options  */
                   break;
              case 'a':           /* assembler tabbing ("-a") option */
              case 'A':
                   tabs=2; /* set up for tab expansion */
                   break;
              case 'n':           /*  "newfile" option  */
              case 'N':
                   if (write(1,newpage,1)!=1) exit(3);
                   if (seq) seq = 1; /*  re-sequence  */
                   break;
	      case 'L':		/* outputing to lp */
	      case 'l':
		   write(1,forms,sizeof(forms));
		   print++;
		   break;
              case 'p':           /*  "newpage" option  */
              case 'P':
                   if (write(1,newpage,1) != 1) exit(3); break;
              case '-':           /*  revert to terminal standard input */
                   fflg++; goto data_now; }
         }
   } else { fflg++; goto data_now; } /* for 'special case' when '-' is entered by itself  */
   }
data_now:
   if (fflg || argc < 1)
      fi = stdin;
   else {
      if ((fi = fopen(*argv, "r")) == NULL) {
         fprintf(stderr, "seq: can't open %s\n", *argv);
         continue;
      }

   }
   fstat(fileno(fi), &statb);
   if (statb.st_dev==dev && statb.st_ino==ino) {
      fprintf(stderr, "seq: input %s is output\n", fflg ? "-" : *argv);
      fclose(fi);
      fflg = 0;
      continue;
   }
   line[5] = ' ';                  /* clear padding column */
   i = 6;                          /* initialize line buffer pointer */
   while ((savchar = getc(fi)) != EOF) {   /* read until EOF or ERROR */
       chr = savchar;     /*  convert getc(return) to character  */
/*
 *
 *  First handle any "special" characters
 *
*/
      /*  is this a newline after FORMFEED or NEWFILE  */
      if (noline && chr == '\n')  
         {
            /*  if so, reset this flag (only 1 newline is ignored)  */
            noline=0; 
            /*  and skip over this newline character as if it never existed  */
            continue;  
         }
      noline=0;             /*  this flag is very temporary!!!  */
      if (chr == FORMFEED)  /*  is this a "skip to next page"  */
         {
            if (write(1,newpage,1) != 1)  /*  write it out "invisibly" */
               exit(3);	/*  or die trying!!  */
            noline=1;	/*  skip any immediately-following carriage return  */
            continue;  	/*  read next input character  */
         }

      if (chr == NEWFILE)   /*  is this a separate output file  */
         {
            if (write(1,newpage,1) != 1)  /*  write out page control "invisibly"  */
               exit(3); /*  or die trying!!  */
            noline=1;   /*  skip any immediately-following carriage return  */
            if (seq)    /*  if sequencing, re-initialize to line 1   */
               seq=1;
            continue;   /*  read next input character  */
         }

/*  */
/*  */
/*  Now the "regular" character input can be handled  */
/*  */
/*  */
      if (forcend && chr != '\n')  /* do we have to 'split' this line */
             {  chr = '\n';        /*  force newline at end of line  */
                line[i++] = chr;          /* move newline into buffer */
	line[i++] = '\r';
          if (seq) {                /* sequencing in effect? */
             lineptr = &line[4];    /* point to last character in sequence */
             n = seq;               /* put sequence number in temporary */
             do {
                *(lineptr--) = n % 10 + '0'; /* put last digit in line buffer */
             } while ((n /= 10) > 0); /* take last digit off number */
             while (lineptr >= line)
                 *(lineptr--) = ' '; /* pad on left with blanks */
             lineptr = line;        /* write out entire line buffer */
             count = i;
          } else {                  /* no sequencing */
             lineptr = &line[6];    /* write just the text part of the line */
             count = i - 6;
          }
          if ((j = write(1,lineptr,count))!= count) /* write out line, error? */
             exit((j == EOM) ? 0 : 0);        /* yes, abort */
          for (i=5; i < 15; i++)     /*  reset line pointer to 15 and insert leading blanks  */
              line[i] = ' ';
              chr = savchar;     /*  retrieve original character read */
          }
      forcend = 0;                 /*  reset line 'split' control  */
      if (chr == '\t')             /* is this a tab character? */
          i = dotab(i);            /* if so, handle it         */
      if (chr == '\n') {           /* is character a newline? */
         line[i++] = chr;          /* move newline into buffer */
	line[i++] = '\r';
         if (seq) {                /* sequencing in effect? */
       lineptr = &line[4];    /* point to last character in sequence */
            n = seq++;          /* put sequence number in temporary */
            do {
               *(lineptr--) = n % 10 + '0'; /* put last digit in line buffer */
            } while ((n /= 10) > 0); /* take last digit off number */
            while (lineptr >= line)
               *(lineptr--) = ' '; /* pad on left with blanks */
            lineptr = line;        /* write out entire line buffer */
            count = i;
         } else {                  /* no sequencing */
            lineptr = &line[6];    /* write just the text part of the line */
            count = i - 6;
         }
    if (( j= write(1,lineptr,count))!= count) /* write out line, error? */
         exit((j == EOM)? 0 : 0);  /* yes, abort */
         i = 6;                    /* initialize line pointer */
      } else {                     /* character not new line */
         line[i++] = chr;          /* stuff character in line */
         if (i >= (LINELEN - 1))   /* too many characters before new line? */
             forcend = 1;          /* indicate line may have to be 'split' */
      }
   }
   if (fi == stdin) fflg = 0; else fclose(fi);
   }
   if (i != 6)                   /* END or ERROR at the wrong place? */
      exit(2);                     /* yes, abort */
   else {
      if(print) write(1,forms2,sizeof(forms2));
	exit(0);                     /* exit gracefully */
   }
}


dotab(i)   /*   subroutine to handle tabs   */
int i;     /*   argument is current line pointer  */

{
 int * tabtbl;   /*  will point to proper tab table  */

 if (!tabs)   /*  if tab handling not requested, forget it  */
  return(i);

 chr = ' ';             /*  force tab character to be a space  */
 tabtbl = (tabs > 1) ? asmtbl : normtbl;  /*  set table address  */

 while (tabtbl[i - 6] == 0)  /*  insert spaces to next tab stop  */
  line[i++] = chr;
 return(i);  /*  exit now  */
}
