         LIST      NOMAC,NODATA,NONG
         TITLE     STORAGE FOR ASSEMBLER
BLKNUM   REZ       1W              COMMON AREA BLOCK NUMBER     S8700508
SIZE     REZ       1W              SIZE OF COMMON AREA ORG.     S8700508
HWERRF   RES       1W              THIS WORD CONTAINS 32 BIT FLAGS INDIC
*        ATING THE TYPE OF ERRORS FOUND SINCE THE LAST ERROR FLAGS WERE
*        PRINTED.  EACH BIT POSITION WILL CAUSE A SPECIFIC CHARACTER TO
*        BE PRINTED.     BIT 0 THE CODE FOR ASCII   X'40' , BIT 1 FOR
*        X'41', BIT 31 FOR ASCII X'5F' AND SO FORTH
HWLTBS   RES       1W              BASE ADDRESS OF THE LITERAL POOL,
*        FORMAT IS THAT OF THE PROGRAM COUNTERS
HWLTPE   RES       1W              HOLDS ENDING ADDRESS OF THE LITERAL P
*        OOL SO THAT WE MAY TELL THE LOADER ABOUT ANY RES'S AT THE END O
*        F A PROGRAM  AND SO KEEP THE LOADER FROM OVERLAYING  THEM.
HWENDL   RES       1W              T. S. FOR END PROCESSOR
HHVFX    RES       1H              THIS IS A RIGHT TO LEFT PUSHING BIT S
*        TACK FOR VFD/GEN DATA
HHVFO    RES       1H              THE NUMBER OF BITS IN THE BIT STACK
*        THAT HAVE NOT BEEN RELEASED
HHVFS    RES       1H              NUMBER OF BITS DESIRED IN THE CURRENT
*        ELEMENT OF THE GEN STATEMENT
HHVFF    RES       1H              NUMBER OF BITS OF DATA SENT TO THE
*        VFD/GEN PACKING ROUTINE
HHVFGB   RES       1H              NUMBER OF BITS OF DATA ACCEPTED BY TH
*        E VFD/GEN PACKER FOR OUTPUT TO THE STACK
HHODP    RES       1H              MASTER VARIABLE FOR OUTPUT INFO
HHODPA   RES       1H              ALTERNATE FOR HHODP
TOT      EQU       HHODP           LENGTH CONSTANT FOR TDAT
*                                  TOT=1,2,4,OR 8 DEPENDING ON DATA BND
HBTTTF   EQU       HHODP+1B        VALUE IS A POINTER  FOR DATA BEING
*        GENERATED BY THE TRANSLATORS, 0 MEANS FOR DATA, 1 FOR GEN, 2
*        FOR LITERALS, 3 FOR VALUE EXPRESSION
HHTDB    RES       1H              B+-N DATA ENTERED IN CONSTANT
HHTDE    RES       1H              E+-N DATA ENTERED IN CONSTANT
HHTDBN   RES       1H              HOLDS DESIRED B SCALING CONSTANT
inscntT  RES       1B              TEMP HOLDS inscnt DURING TMD ROUTINE
inscntS  RES       1B              TEMP HOLDS inscnt DURING SORG ROUTINE
ENDFLAG  RES       1B              END CARD FOUND LAST FLAG
HBCCCT   RES       1B              NUMBER FOR NEXT COMMON BLOCK
BARA     RES       1W              BASE ADR OF USER'S AREA AND QTY
READSIP  RES       1W
READPIP  RES       1W
READSKP  RES       1W
PREFLG   RES       1W              PRE FILE FLAGS
DCMPRS3  RES       1W
EORA     RES       1W
CMPRFR   RES       1W              LOCATION AND LGTH OF SOURCE BUFFER
CMPRTO   RES       1W              LOCATION AND LGTH OF DESTINATION BUF
* 0-11 EQ LGTH, 12-31 = ADR. SET BY CALLING ROUTINE
CMPRLOB  RES       1B              LENGHT OF OUTPUT BUF IN BYTES
IMIP     RES       1B              IMAGE IN PROCESS IND
CMPRLIB  RES       1B              LENGHT OF INPUT BUF IN BYTES
CMPRQTYR RES       1B              QTY READ
CMPRSTC  RES       1B              STRING COUNT
CMPRSPC  RES       1B              SPCAE COUNT
CMPRTSPC EQU       CMPRSPC         TRAILING SPACE COUNT
READCKSM RES       1H              CHECK SUM FOR COSY RECORD
         RES       8W              FIRST SAFETY FILE
RELEASF  RES       8W              FILE STORAGE BLOCK FOR RELEAS
         RES       8W              LAST SAFETY FILE
GBYC     RES       1W              GBYT TERMINATOR LIST
HDUN00   RES       2D
HDUNJF   RES       1D              HOLDS UNDEFS FOR LISTING
HDERCT   RES       4D
SSUFB    RES       1D              DOUBLEWORD SCRATCH FOR ROUTINE SS
GRPV     RES       1D              ADR OF HWNL1 IN 1ST WORD,HWNM1 IN 2ND
BTXA     RES       1W              T.S. FOR BTX
BTXB     RES       1W              T.S. FOR BTX
HBTDFN   RES       1B
HBCNUL   RES       1B              BIT 7 HOLDS POS/NEG INTEGER FLAG
HBTFN1   RES       1B              PREVIOUS TERMINATOR POINTER
HBTFN2   RES       1B              LATEST   TERMINATOR POINTER
HBTFN3   RES       1B              CHARACTER STORE POINTER
HBTITM   RES       1B              CHAR COUNT FOR TITLE
VALS1    RES       1B              TS FOR VAL
VALT     RES       1B              NUMERIC EQU OF NON-NUMERIC TERMINATOR
PPT      RES       1B              BINARY RECORD LENGTH, 0=UNUSABLE DEV
PBNB     RES       1B              NUMBER OF BYTES
PBNC     RES       1B              LOADER FUNC CODE
LOCHS1   RES       1W
TDGS6    RES       1W              HOLDS BYTE FOR OUTPUT DURING TDG MESS
TDGS1    RES       1W
VFDOS1   RES       1W
CCTU     RES       1W              HOLD QUERY FLAG
CCTW     RES       1W              RUNNING PROG CT DURING BLOCK MAKE-UP
         BOUND     1W
PRNT     RES       30W             SPACE FOR 120 CHARACTER OUTPUT  LINE
* THE PRODUCT, REV, AND COPYRIGHT INFO IS ORDER DEPENDENT.         11010
* DO NOT MOVE WITHOUT THOROUGH INVESTIGATION.                      11010
*
         BOUND     1W
PRODRTCW GEN       12/A(CPYR.MSG-PRODREV),20/B(PRODREV)            11010
HDRL1TCW GEN       12/A(CPYR.END-PRODREV),20/B(PRODREV)            11010
PRODREV  DATAB     C' MPX-32 UTILITIES RELEASE 3.2 '
         DATAB     C'(ASSEMBLE R3.2.12) '
*
*        DATA FOR COPYRIGHT MESSAGE AND TCW
*
*        ALSO SERVES FOR MESSAGE IN OBJECT
*
CPYR.MSG DATAB C' (C) COPYRIGHT 1983 ENCORE COMPUTER CORPORATION '
         DATAB C', ALL RIGHTS RESERVED'
CPYR.END DEQU      $                                            ESCT-32
         BOUND     1W
CPYR.TCW GEN       12/A(CPYR.END-CPYR.MSG),20/B(CPYR.MSG)
*
CARR.C1  DATAB     C'-'            CARRIAGE CONTROL FOR HDR LINE 1 11010
CARR.C2  DATAB     C'-'            CARRIAGE CONTROL FOR HDR LINE 2 11010
*
LO.TSMD  DATAB     0               0 IF LO NOT A TSM ASSOC FAT     11011
*
* THIS FIELD IS PULLED FROM THE PROGRAM DIRECTIVE AFTER THE PROG   11005
* NAME. IF NOT SPECIFIED, LENGTH IS ZERO AND NO PROCESSING OCCURS. 11005
* THE SIZE IS LIMITED TO 20 BYTES BECAUSE OF THE 26 BYTE OUTPUT    11006
* BUFFER THAT THE ASSEMBLER USES FOR 'PUBLISHING' BINARY.          11006
*
FMTD.DT  RES       2D              FORMATTED DATE AND TIME         11005
*
* THIS FIELD IS ALREADY FORMATTED AND READY FOR INCLUSION IN OBJ   11005
*
         SPACE     1
SECTLGF  EQU       64W             SIZE OF BI/SI/BO/UT BUFFERS
SBUF     RES       SECTLGF         SCRATCH BUFFER FOR UT1
IBUF     RES       SECTLGF         SI INPUT BUFFER
IBUF2    RES       SECTLGF         PRE INPUT BUFFER
REFS1    RES       1W              T.S.
BFCS2    RES       1W              T.S.
PBBA     RES       1W              BASE ADR OF DATA TO OUTPUT
UOUTS2   RES       1W              T.S.
REFS2    RES       1W

MGBD     RES       4D
MUNSTA   RES       2D              HOLDS NAME FOR SUBSTITUTION
         BOUND     8W
REGSAV   RES       8W              HOLDS REGS WHILE SS PROCESSES AN
*                                  INTERNALLY GENERATED SYMBOL
INSIG    EQU       5               1 MEAN THE NEXT SPACE IS INSIGNIGANT

SETPROV  RES       1W              HOLDS VALUE OF THE SET
MUNSTAP  RES       1W
HWREPSP  RES       1W         TEMP BASE ADDRESS OF THE REPEATED CODE STO
HWREPSS  RES       1W         PERM BASE ADDRESS OF THE REPEATED CODE STO
EPHEMS1  RES       1W
PREVRELO RES       1W              HOLDS PREVIOUS IF RELATION OPERAOTR
IFET     RES       1W              HOLDS TEMP TRUE/FALSE
MUNSTS6  RES       1W              HOLDS POINTER TO EXPND AREA

HHRCOUNT RES       1H              NUMBER OF TIMES TO REPEAT
INSYMARG RES       1B              HOLD % NUMBER OF UNSTRUNG DUMMYS
*                                  DURING EXPANSION
VALUNDF  DATAB     0               BIT 0 SET INDICATES UNDEF IN VAL FOR
****                                                                  **
SKCNT    DATAW     0               TRANSFER CNT FOR SK FILE     *JCB*
HWPCMODE RES       1B              MODE OF PC WHEN SYMBOL WAS   *JCB*
*                                  EVALUATED BEFORE PASS 1      *JCB*
*                                                               *JCB*
         SPACE     3                                            *JCB*
*                                                               *JCB*
NEWLINE  EQU       X'A'            NEW LINE CHARACTER (LINEFEED)*JCB*
TABCHAR  EQU       X'9'            ASCII TAB                    *JCB*

HAERCT   GEN       12/32,20/B(HDERCT)
HAUN00   GEN       12/24,20/B(HDUN00)
HAIN     GEN       12/80,20/B(IN)  BASE ADDRESS OF INPUT AREA AND BYTE C
QAFCBLO  GEN       12/40,20/B(PRNT)    PRNT QTY AND ADR OF PRINT BUFFER
         GEN       12/120,20/B(PRNT)     LONG LINE FOR IMAGE OUTPUT
HABS     ACB       HBBS            BASE ADR OF BINARY BYTE STREAM STACK
UNDEFC   DATAD     C' UNDEFINED'
ERRORS   DATAD     C'0*        ERRORS'       CONSTANT FOR ERROR COUNT
ERRORS2  DATAW     C' IN '
ERRORS3  DATAW     C'    '
SYMOFLOW GEN       12/28,20/B(STOFMESS)  FOR OUTPUT OF MESSAGE.
STOFMESS DATAB     C'1** SYMBOL TABLE OVERFLOW **'
         BOUND     1W
*        TABLE OF LOGICAL OPERATORS
CONDBEG  DEQU      $                                            ESCT-32
         DATAW     C'.AND'         CONDITIONAL TEST
         DATAW     C'.OR.'
         DATAW     C'.LT.'
         DATAW     C'.GT.'
         DATAW     C'.GE.'
         DATAW     C'.LE.'
         DATAW     C'.EQ.'
         DATAW     C'.NE.'
CONDLIST DEQU      $                                            ESCT-32
SIZCOND  DEQU      $-CONDBEG                                    ESCT-32
         BU        IFPRAND         .AND.
         BU        IFPROR          .OR.
         BCF    LE,IFPRO5          MAKE .TRUE. FOR .LT.
         BCF    GE,IFPRO5          .GT. IS THE .TRUE. CASE
         BCT    LE,IFPRO5          .GE. IS THE .TRUE. CASE
         BCT    GE,IFPRO5          .LE. IS THE .TRUE. CASE
         BCT    EQ,IFPRO5          .EQ. IS THE .TRUE. CASE
         BCF    EQ,IFPRO5          .NE. IS THE .TRUE. CASE
IFCONDBR CEQU      $                                            ESCT-32
         BU        IFINIT          INITIAL CASE
OVFLCONT GEN       12/21,20/B(OVFLMESS)    FOR OUTPUT OF MESSAGE
OVFLMESS DATAB     C' MACRO TABLE OVERFLOW'
STERMESS DATA      C' MACRO STACK ERROR'
         BOUND     1W
STERCONT GEN       12/18,20/B(STERMESS)  OUTPUT MESSAGE FOR ABORT.
* LIST OF LEGAL DIRECTIVES FOR LIST PSEUDO-OP
         DATAW     C'REP '         LIST REPT EXPANSIONS
         DATAW     C'NORE'         DON'T LIST REPT EXPANSIONS
         DATAW     C'MAC '         LIST MACRO EXPANSIONS
         DATAW     C'NOMA'         DON'T LIST MACRO EXPANSIONS
         DATAW     C'NGLI'         LIST ALL SOURCE LINES
         DATAW     C'NONG'         DONT LIST NON-ASSEMBLED SOURCE
         DATAW     C'ON '          LISTING ON
         DATAW     C'OFF '         LISTING OFF
         DATAW     C'DATA'         ALLOW LISTING OF EXTENSIONS
LISTD    DATAW     C'NODA'         DON'T ALLOW LISTING OF EXTENSIONS
* LIST OF ADDRESSES OF LISTING CONTROL FLAGS
         ZBM       REPPRINT,bits2  LIST REPT EXPANSIONS
         SBM       REPPRINT,bits2  DON'T LIST REPT EXPANSIONS
         ZBM       MACPRINT,bits2  LIST MACRO EXPANSIONS
         SBM       MACPRINT,bits2  DON'T LIST MACRO EXPANSIONS
         ZBM       NGPRINT,bits  LIST ALL SOURCE LINES
         SBM       NGPRINT,bits  DONT LIST NON-ASSEMBLED SOURCE
         ZBM       APON,bits     ALLOW LISTING
         SBM       APON,bits     DONT ALLOW LISTING
         ZBM       APEX,bits     ALLOW EXTENSIONS
LISTP    SBM       APEX,bits     DONT ALLOW EXTENSIONS
         BOUND     1W
TCTS     GEN     8/00,24/H(TCD1)   C TYPE CONSTANT
         GEN     8/00,24/H(TGD1)   G TYPE CONSTANT
         GEN     8/00,24/H(TXD1)   X TYPE CONSTANT
         GEN     8/31,24/H(TNFER)  N TYPE CONSTANT
         GEN     8/63,24/H(TNFER)  F TYPE CONSTANT
         GEN     8/08,24/H(TNFER)  E TYPE CONSTANT
         GEN     8/40,24/H(TNFER)  R TYPE CONSTANT
TFDD     GEN       8/C' ',24/H(TFI) 0W
         GEN       8/C'.',24/H(TFF) 1W      -5W
         GEN       8/C'E',24/H(TFX) 2W      -4W
         GEN       8/C'B',24/H(TFB) 3W      -3W
         GEN       8/C',',24/H(TFO) 4W      -2W  ALL DONE
         GEN      8/C'"'',24/H(TFO) 5W      -1W  ALL DONE
TFDE     DEQU      $                                            ESCT-32
TDMP     DATA      0,0,0,0         0X16 IN DIGIT DECIMAL INVERTED FORM
         DATA      6,1,0,0         1X16
         DATA      2,3,0,0         2X16
         DATA      8,4,0,0         3X16
         DATA      4,6,0,0         4X16
         DATA      0,8,0,0         5X16
         DATA      6,9,0,0         6X16
         DATA      2,1,1,0         7X16
         DATA      8,2,1,0         8X16
         DATA      4,4,1,0         9X16
MSKTBL   DEQU      $                                            ESCT-32
         DATAW     X'00000001'                                  EBRM-33
         DATAW     X'00000002'                                  EBRM-33
         DATAW     X'00000004'                                  EBRM-33
         DATAW     X'00000008'                                  EBRM-33
         DATAW     X'00000010'                                  EBRM-33
         DATAW     X'00000020'                                  EBRM-33
         DATAW     X'00000040'                                  EBRM-33
         DATAW     X'00000080'                                  EBRM-33
         DATAW     X'00000100'                                  EBRM-33
         DATAW     X'00000200'                                  EBRM-33
         DATAW     X'00000400'                                  EBRM-33
         DATAW     X'00000800'                                  EBRM-33
         DATAW     X'00001000'                                  EBRM-33
         DATAW     X'00002000'                                  EBRM-33
         DATAW     X'00004000'                                  EBRM-33
         DATAW     X'00008000'                                  EBRM-33
         DATAW     X'00010000'                                  EBRM-33
         DATAW     X'00020000'                                  EBRM-33
         DATAW     X'00040000'                                  EBRM-33
         DATAW     X'00080000'                                  EBRM-33
         DATAW     X'00100000'                                  EBRM-33
         DATAW     X'00200000'                                  EBRM-33
         DATAW     X'00400000'                                  EBRM-33
         DATAW     X'00800000'                                  EBRM-33
         DATAW     X'01000000'                                  EBRM-33
         DATAW     X'02000000'                                  EBRM-33
         DATAW     X'04000000'                                  EBRM-33
         DATAW     X'08000000'                                  EBRM-33
         DATAW     X'10000000'                                  EBRM-33
         DATAW     X'20000000'                                  EBRM-33
         DATAW     X'40000000'                                  EBRM-33
         DATAW     X'80000000'                                  EBRM-33
OPTMSK   DATAW     X'000C63FF'     MASKS OPTS 11-13,16-18,21-32 EBRM-33
CNUE     SLLD      6,5             PSEUDO MULTIPLIER FOR F
         SLLD      6,0                                   BLANK
         SLLD      6,0                                   B
         SLLD      6,1                                   H
         SLLD      6,2                                   W
         SLLD      6,3                                   D
         SLLD      6,0                                    B
         SLLD      6,1                                    H
         SLLD      6,2                                    W
         SLLD      6,3                                    D
CNUD     DATAB     N'32',N'1',N'1',N'2',N'4',N'8' ASSOCIATED MULTIPLIERS
CNUC     DATAB     C'F'            'FILE' TERMINATOR
         DATAB     C' BHW'         CONSTANT TYPE AND TERMINATOR LIST
TCTF     DATAB     C'DACGXNFE'
TCTE     DATAB     C'R'
*        LIST OF CONVERSION FACTORS FROM VAL INTERNAL CODES TO
*        NORMAL SYMBOL TABLE CODES
VDTO     GEN       8/A(TYPP*2),8/A(TYPP*2+1),8/A(TYPC*2),8/A(TYPX*2)
* ID FOR ABOVE       PROG ABS    PROG REL      COMMON      EXTERNAL
BTX4     DATA      C'0123456789ABCDEF'   HEX DIGIT TO ASCII LOOK-UP TABL
DSRC     SRC       3,0
DSLLD    SLLD      2,0
DSRL     SRL       2,0
         IFT       UNIXF,SKIP                                   *JCB*
HWKSPA   DATAW     C'    ',0                                    *JCB*
SKIP     ANOP                                                   *JCB*
         IFF       UNIXF,SKIP                                   *JCB*
HWKSPA   DATAW     C'    '
SKIP     ANOP                                                   *JCB*
HWUP1    GEN       12/4,20/B(HWKSPA)       GETS A VERY SHORT BLANK LINE
TALLS1   GEN       8/A(TYPU),24/0  REQUEST INDICATOR. CK LABL VS SYM TBL
SECTYPES DATAB     TYPU,TYPL,TYPP,TYPM,TYPX,TYSETSYM
NSECTYPS DEQU      $                                            ESCT-32
*
         SPACE     3
TEMP     RES       1D
BASE     DATAD     X'41A0000000000000'      10.**1    DO NOT MOVE
         DATAD     X'4264000000000000'      10.**2    DO NOT MOVE
         DATAD     X'4427100000000000'      10.**4    DO NOT MOVE
         DATAD     X'475F5E1000000000'      10.**8    DO NOT MOVE
         DATAD     X'4E2386F26FC10000'      10.**16   DO NOT MOVE
         DATAD     X'5B4EE2D6D415B85A'      10.**32   DO NOT MOVE
         DATAD     X'76184F03E93FF9F4'      10.**64   DO NOT MOVE
ONE      DATAD     X'4110000000000000'

************************************************************************
*        D A T A    A R E A                                            *
************************************************************************
         SPACE     1
         BOUND     1W
READSIPC GEN       8/0,4/0,20/A(IBUF)
READPRPC GEN       8/0,4/0,20/A(IBUF2)
         IFT       UNIXF,SKIP                                   *JCB*
READSKPC ACW       IN              INPUT BUFFER POINTER         *JCB*
SBUFTCW  GEN       12/A(BRL),20/B(SBUF)                      *JCB*
SKIP     ANOP                                                   *JCB*
         SPACE     1
CMPRS1   DATAB     0,2,3           NUMBER OF BYTES REQD IN BUFFER
         SPACE     1
PARAMBLK RES       11W             PARAMETER BLOCK               11010
XRSECSIZ EQU       768*20          SIZE EQUATE                  S880752
FCBXR    GEN       8/0,24/C'UT2'                                S880752
         DATAW     0                                            S880752
         GEN       1/0,1/0,1/0,1/0,1/0,1/1,1/1,1/0,4/0,20/0     S880752
         DATAW     0,0,0                                        S880752
         ACW       IOERUT2                                      S880752
         DATAW     0                                            S880752
         DATAW     A(XRBUF)                                     S880752
         DATAW     XRSECSIZ                                     S880752
         DATAW     0,0,0,0,0,0                                  S880752
         BOUND     1D                                           S880752
XRBUF    RES       XRSECSIZ        REPORT RECORD BUFFER         S880752
XRBUFP   RES       1W                                           S880752
BUFFADD  DATAW     A(XRBUF)        ADDR AND SIZE OF XRBUF FOR   S880752
         DATAW     XRSECSIZ        FCBXR INITIALIZATION         S880752
         SPACE     2
         BOUND     1F                                            11003
INQ.INFO RES       1F              8W FOR M.INQUIRY INFO         11003
         SPACE     2
*        CNPS FOR NATIVE MODE OPENS
         SPACE     1
FLAGS    DATAW     0
ERROCCUR EQU       0               0 - NO ERROR HAS OCCURRED
*                                  1 - AN ERROR HAS OCCURRED
EOFA     RES       1W
FCBA     RES       1W
IBUFA    RES       1W
READPTR  RES       1W
MPP      DATAW     0               ADDR OF CURR LEVEL IN MACRO STACK
MACT     DATAW     0               TEMP STKP LOCATION DURING MACRO CALL
DEFCNT   DATAW     0               # PARMS BYT 0, MACRO BYT CNT IN 1-3
STACKP   DATAW     STACK           INTERNAL MACRO PARAMETER STACK
STACK    RES       768W            ENOUGH FOR 256 PARAMETERS

         TITLE     READ-ONLY       SPACE
* PROCESS SPACE PSEUDO-OP
         SPACE
SPACE    LI        2,2             SIGNAL VAL TO SKIP LEADING SPACES
         BL        VAL             EVALUATE EXPRESSION
         ANMW      R7,=X'7FFFFF'   LOP OFF ANY TYPE CODES
         CI        7,1             LOWER THAN THIS DEFAULTS TO 1
         BGE       $+2W            IT IS HIGHER-THEN DONT DEFAULT
         LI        7,1             DEFAULT SPACE COUNT
         CI        7,60            MAX NO. OF SPACES ALLOWED
         BLT       SPACEA
	if (yeanay()) {	/* are we assembling */
	  seterr ('G');		/* set invalid space error */
	}
         BU        NEXT            GO RELEASE IMAGE AND DON'T SPACE.
SPACEA   TRN       7,5             NEG NUMBER OF LINES TO SPACE
         TBM       7,PASS        IS THIS PASS 2
         BS        NEXT         NO, IGNORE SPACE PSEUDO
         TBM       APON,bits     CHECK WHETHER LISTING IS ALLOWED.
         BS        NEXT         NO LISTING REQUIRED.
         TBM       EXPAND,macstate EXPANDING?
         BNS       SPACEA1      NO.
         TBM       MACPRINT,bits2  EXPANSION LIST ALLOWED?
         BS        NEXT         NO.
SPACEA1  TBM       RPTGEN,macstate  GENERATING REPEATED CODE?
         BNS       SPACE1       NO.
         TBM       REPPRINT,bits2   REPEAT EXPANSION LIST ALLOWED?
         BS        NEXT         NO.
SPACE1   LW        1,HWUP1         TCW FOR A SHORT BLANK LINE
	if (!yeanay()) return;	/* return if not assembling */
         ZR        7               SIGNALS CPPP THAT NO ERRORS EXIST
*                                  FOR THIS LINE.
         BL        PPP            PRINT ONE SPACE EQ BLANK LINE
         TBR       7,31            DID WE GO TO A NEW PAGE
         BS        $+2W         YES, ON A NEW PAGE NO MORE SPACES
         BIB       5,SPACE1
	bits &= ~IMIN;	/* indicate no buffer image ready */
	return;			/* return */
}

         TITLE     READ-ONLY       LIST
* PROCESS LIST PSEUDO-OP TO CONTROL PRINTOUTS
         SPACE
LIST     TBM       APON,bits     IS 'LIST OFF' ?
         BS        LIST00       YES.
         TBM       EXPAND,macstate   EXPANDING?
         BNS       LIST01       NO.
         TBM       MACPRINT,bits2  EXPANSION LIST ALLOWED?
         BS        LIST00       NO.
LIST01   TBM       RPTGEN,macstate  GENERATING REPEATED CODE?
         BNS       LIST0        NO.
         TBM       REPPRINT,bits2   REPEAT EXPANSION LIST ALLOWED?
         BNS       LIST0        YES.
LIST00   ZBM       IMIN,bits     SUPPRESS P/O OF LIST DIRECTIVE.
LIST0    LW        1,=X'80080000'  SP AND ,
         BL        UNST            UNSTRING ONE DESIGNATOR (TERM.IN R7)
         LW        6,usname        FETCH UNSTRUNG DESIGNATOR
         IFT       ULC,SKIP                                     *JCB*
         LI        R0,-4           FOUR BYTES TO TEST           *JCB*
LIST.U   TBR       R6,1            THIS A LETTER                *JCB*
         BNS       LIST.U1         BR IF NOT                    *JCB*
         ZBR       R6,2            YES, CONVER TO UPPER CASE    *JCB*
LIST.U1  SRC       R6,8            NEXT BYTE                    *JCB*
         BIB       R0,LIST.U       DO 4 BYTES                   *JCB*
SKIP     ANOP                                                   *JCB*
         LI        1,-10W          NEGATIVE NUMBER OF LIST OPTIONS
         CAMW      6,LISTD+1W,1    COMPARE AGAINST ITEM IN LIST
         BEQ       LIST1        A FIND
         BIW       1,$-2W          NO FIND, SEARCH ALL OF LIST
	if (yeanay()) {	/* are we assembling */
	  seterr ('K');		/* set invalid list directive error */
	}
         BU        LIST2           CHECK TERMINATOR
         SPACE
* COME HERE WHEN A MATCH IS FOUND IN THE DIRECTIVE LIST
         SPACE
LIST1    BL        YEANAY          CHECK WHETHER ASSEMBLY IS ALLOWED
	if (yeanay()) {	/* are we assembling */
         BNS    LIST2           DONT ASSEMBLE
         EXM         LISTP+1W,1    FLAG VALUE FOR FIND
LIST2    CI        7,G','          IS TERMINATOR A COMMA
         BEQ       LIST0        YES--GO PROCESS OTHER DIRECTIVES.
         BU        NEXT            NO, PRINT CARD OUT
*
         TITLE     READ-ONLY       DATA
* PROCESS DATA,DATAB,DATAH,DATAW,DATAD
         SPACE
DATA     CEQU      $                                            ESCT-32
         ZMW       HWINDR          CLEAR INDIECT ADDRESSING INDICATOR
         LB        2,HWACT         0,0,1,2,3 FOR DATA,DATAB,H,W,D
         LB        6,TCTG,2        NUMBER OF BYTES REQD
         STB       6,TOT           STORE FOR DATA TRANSLATOR (1,2,4,8)
         ZMB       HBTTTF          INDICATE DATA STATEMENT
         ZMW       HWINAC          CLEAR ADDRESS ATTRIBUTE AREA
         BL        TDAT            TRANSLATE REST OF DATA STATEMENT
         LB        6,hbstac        LATEST TERMINATOR
         CI        6,G','          WAS IT A COMMA
         BEQ       DATA         YES- GET THE NEXT CONSTANT
         BU        NEXT
         TITLE     READ-ONLY       VFD
* GEN DATA PROCESSING
         SPACE
VFD      CEQU      $                                            ESCT-32
         ZMW       HWINDR          CLEAR INDIECT ADDRESSING INDICATOR
         ZMH       HHVFX           CLEAR BIT STACK
         ZMH       HHVFO           CLEAR BIT STACK POSITION POINTER
VFD1     ZMH       HHVFF           CLEAR BITS SCANNED COUNTER
         ZMH       HHVFGB          CLEAR GOOD BITS FROM THIS ELEMENT CT
         TBM       FORMGET,inptstat   ARE WE EXPANDING A FORM
         BS        FORMEXP2     YES-THEN GET THE FIELD COUNT FROM MCL
         LW        1,=X'80010000'
         BL        UNST            UNSTRING LENGTH
         CI        7,G'/'          IS TERMINATOR A /
         BNE       VFDE         NO MARK ERROR
         LI        2,10            RADIX
         BL        CNUM            CONV TO NUMERIC IN R6,7
         CI        7,4096
         BLE       VFD2         WITHIN LIMIT
VFDE:
	if (yeanay()) {	/* are we assembling */
	  seterr ('H');		/* set invalid VFD statement error */
	}
         LI        7,32            ASSUME SMALL SIZE
VFD2     STH       7,HHVFS         FIELD SIZE
         LI        6,8             ALL GEN ARE IMPLICIT DOUBLE WORD
         STB       6,TOT
         LI        6,1W            IDENTIFY AS GEN STATEMENT
         STB       6,HBTTTF
         ZMW       HWINAC          DEFAULT TO A NULL ADR ATTRIBUTE
         LW        1,HWKSPA        WORD OF BLANKS.
         STW       1,hbstac        CLEAR TERMINATOR LIST.
         BL        TDAT            CONVERT THE CONSTANT
VFD3     LH        6,HHVFGB        NUMBER OF BITS PUT INTO OUTPUT STREAM
         CAMH      6,HHVFS         NUMBER WANTED IN OUTPUT STREAM
         BGE       VFD4         BRANCH IF DONE
         LW        6,HWKSPA        NOT DONE PAD WITH SPACES
         LI        7,8             IN EACH BYTE
         BL        VFDO            PUSH OUT ONE MORE BYTE
         BU        VFD3            SEE IF WE ARE DONE
VFD4     LB        6,hbstac        GET THE TERMINATOR
         CI        6,G','          IS IT A COMMA
         BEQ       VFD1         YES, GO DO ANOTHER ELEMENT
         ZR        6               NOT A COMMA
         LI        7,7             PUSH OUT 1 BIT LESS THAN BYTE TO
*                                  EMPTY HHVFX
         BL        VFDO
         BU        NEXT
/*
 * bound - process bound statement
 * input - normal
 */
int	bound ()
{
	val(2);			/* skip leading spaces */
	if (!yeanay()) return;	/* if not assembling, return */
         ANMW      7,=X'007FFFFF'  MASK OFF TYPE
         BEQ       BOUNE        VALUE OF BOUND TO SMALLL
         TRR       7,6             VALUE TO R6 FOR NORMALIZATION
         SCZ       6,1             NORMALIZE THE THING
         TRR       6,6             CHECK THE CONTENTS AFTER THE SCZ
         BNE       BOUNE        PROPER IS COMPLETELY NORMALIZED
         CI        1,26            CHECK FOR OVER SCALING
         BGE       BOUR         WIHTIN THE LIMITS
BOUNE    EQU	$
	  seterr ('Q');		/* set label error */
         BU        NEXT            DON'T PROCESS LABEL ON ERR   EASC-32
* ABOVE CHANGE MADE AT EASC-32 FOR CLARITY OF PROCESSING        EASC-32
BOUR     CEQU      $                                            ESCT-32
         TBM       ASCT.OPT,OPTION  ARE WE IN AUTO-SECT MODE    EASC-32
         BNS       BOUR.1           CONTINUE IF NOT!            EASC-32
         SBM       ASCT.BND,ASCT.FLG  INDICATE DEFERRED BND     EASC-32
         STW       R7,ASCT.BVL        TO SECTION CHOOSER        EASC-32
         LW        R7,lict          GET LINE COUNTER          EASC-32
         STW       R7,ASCT.BLC       AND SAVE FOR SECTION CHSR  EASC-32
         LD        R6,label          AND ALLOCATE LABEL        EASC-32
         STD       R6,ASCT.BLB        AT THAT TIME              EASC-32
         BU        NEXT            AND FORGET THIS FOR NOW      EASC-32
BOUR.1   CEQU      $               CONTINUE                     ESCT-32
         BL        BOUC            GO BOUND IT                  EASC-32
*  NOTE THAT IF MULTIPLE BOUNDS ARE DEFERRED ONLY THE LAST      EASC-32
*  ONE WILL BE PROCESSED, ANY LABELS ON PREVIOUS ONES WILL      EASC-32
*  BE UNDEFINED!                                                EASC-32
	currpc = sectpc[pcmode];	/* staticize PC */
	tall();			/* allocate current label */
	if (yeanay()) {		/* are we assembling */
	  bits |= CVFL;	/* set flag to print prog cntr */
	}
	return;
}

         TITLE     READ-ONLY       ORG
* PROCESS ORG STATEMENT
         SPACE
*
ORG      CEQU      $                                            ESCT-32
         TBM       ASCT.OPT,OPTION     ARE WE IN AUTO-SECT MODE EASC-32
         BNS       ORG.0               SKIP IF NOT              EASC-32
         LW        R2,usname           GET OPCODE               EASC-32
         IFT       ULC,SKIP                                     *JCB*
         LI        R0,-4           FOUR BYTES TO TEST           *JCB*
ORG.U    TBR       R2,1            THIS A LETTER                *JCB*
         BNS       ORG.U1          BR IF NOT                    *JCB*
         ZBR       R2,2            YES, CONVER TO UPPER CASE    *JCB*
ORG.U1   SRC       R2,8            NEXT BYTE                    *JCB*
         BIB       R0,ORG.U        DO 4 BYTES                   *JCB*
SKIP     ANOP                                                   *JCB*
         CAMW      R2,=C'ORG '         IS IT JUST ORG?          EASC-32
         BNE       ORG.0               SKIP IF NOT              EASC-32
         SBM       ASCT.NOD,ASCT.FLG   ELSE SET NO $ TO VAL     EASC-32
ORG.0    CEQU      $                   AND CONTINUE             ESCT-32
         LI        2,2             INDICATE SKIP LEADING SPACES
         BL        VAL             EVALUATE EXPRESSION
	if (yeanay()) {	/* are we assembling */
         BL        YEANAY
         BNS       NEXT         NO PROCESSING OF THIS DIRECTIVE
         LW        3,HWINAC        GET TYPE AND VALUE
         ZR        2
         SLLD      2,8
         ZBR       2,24            CLEAR DSECT/CSECT FLAG
         CI        2,TYPC          IS IT COMMON TYPE
         BEQ       ORG3         YES
	if (pcmode == PCCOM) {	/* error, can't chg from com in org */
	  seterr ('Q');		/* set label error */
	currpc = sectpc[pcmode];	/* staticize PC */
	tall();			/* allocate current label */
	if (yeanay()) {		/* are we assembling */
	  bits |= CVFL;	/* set flag to print prog cntr */
	}
	return;
	}
	r6 = sectpc[pcmode];	/* get current prog ctn fro section */
         CAR       R6,R3           BACKWARDS ORG ?              S8700512
         BGE       ORG.1           NO IF NON-NEGATIVE           S8700512
         CAMW      R6,MAX          IS P.C. GREATER THAN MAX ?   S8700512
         BLE       ORG.1           CONTINUE IF NOT              S8700512
         STW       R6,MAX          SAVE NEW MAX VALUE           S8700512
ORG.1    CEQU      $                                            ESCT-32
         LW        4,=X'FF800000'  MASK FOR TYPE
         CMMW      6,HWINAC        DO INPUT TYPE AND PC TYPE AGREE
         BEQ       ORG4         YES, OK
         TRR       1,1             SET CC BITS (0 = ABS MODE)
         BEQ       ORG2         ERROR, ABS NOW GOING TO REL
         TBM       9,HWINAC        TRYING TO GO TO ABS MODE?
         BS        ORG1            NO
         SPACE
*             FORGET IT CHARLIE, YOUR'E STAYING IN
*             RELOCATABLE MODE AT THE OFFSET IN HWINAC
         SPACE
         SBM       8,HWINAC        SET TO RELOCATABLE
         BU        ORG4
*
*   SWITCH FROM ONE REL SECTION TO ANOTHER
*
ORG1     LI        1,1W            DSECT INDICATOR
         TBM       0,HWINAC        TRYING TO ORG INTO DSECT
         BNS       ORG1.1          YEAH, YOUR'E COOL.
         LI        1,3W            CSECT INDICATOR
ORG1.1   STB       1,pcmode        UPDATE PROG CTR PTR
         BU        ORG4
         SPACE
* ERROR
         SPACE
ORG2     EQU	$
	  seterr ('Q');		/* set label error */
	currpc = sectpc[pcmode];	/* staticize PC */
	tall();			/* allocate current label */
	if (yeanay()) {		/* are we assembling */
	  bits |= CVFL;	/* set flag to print prog cntr */
	}
	return;
         SPACE
* COMMON TYPE
         SPACE
ORG3     CEQU      $                                            ESCT-32
         LB        1,sectpc+1B+2W  GET CURRENT COMMON BLOCK NUMBER
         SLL       1,2             TURN INTO AN INDEX
         TBM       0,HWCMSIZE,1    IS IT AN SSECT
         BNS       ORG3.1          NO, DON;T NEED TO SAVE SIZE
         LH        5,sectpc+1H+2W  GET CURRENT SIZE
         CAMH      5,HWCMSIZE+1H,1 CHECK IF CURRENT IS BIGGER
         BLT       ORG3.1
         STH       5,HWCMSIZE+1H,1 SAVE NEW LARGER SIZE
ORG3.1   CEQU      $                                            ESCT-32
         LW        5,HWINAC        THE TYPE AND VALUE FROM VAL
         TRR       R5,R7           MOVE INPUT VALUE TO R7       S8700508
         ANMW      R7,=X'7FFFFF'   CLEAR OUT TYPE FIELD         S8700508
         STW       R7,SIZE         SAVE INPUT ORG SIZE          S8700508
         LB        1,HWINACBN      GET THE COMMON BLOCK NUMBER
         SLL       1,2             TURN INTO AN ADDR.           C007-30
         TBM       7,PASS        IS THIS PASS 2?              S8701703
         BNS       $+4W            SKIP SIZE CHECK IF SO        S8701703
         LW        R7,HWCMSIZE,R1  GET COMMON AREA SIZE         S8700508
         CAMW      R7,SIZE         COMPARE ACTUAL TO INPUT      S8700508
         BLT       ORG2            INPUT GREATER, REPORT ERROR  S8700508
         TBM       0,HWCMSIZE,1    WAS IT CREATED BY SSECT?
         BS        ORG2            YES, ORG INVALID, OUTPUT ERROR
ORG3.2   CEQU      $                                            ESCT-32
         STW       5,sectpc+2W     SAVE IT.
         LB        1,HWINACBN      PICK UP THE COMMON BLOCK NUMBER
         STB       1,sectpc+1B+2W  PUT IN THE COMMON PROG. CTR.
	pcmode = PCCOM;		/* set the PC pointer to common */
	currpc = sectpc[pcmode];	/* staticize PC */
	tall();			/* allocate current label */
	if (yeanay()) {		/* are we assembling */
	  bits |= CVFL;	/* set flag to print prog cntr */
	}
	return;
         SPACE
ORG4     LW        5,HWINAC        THE TYPE AND VALUE FROM VAL
         STW       5,sectpc,1      SET PROGRAM COUNTER
         LB        5,HWINACBN      GET THE COMMON BLOCK NUMBER
         STB       5,sectpc+1B+2W  PUT IT IN COMMON PROG CNTR
	currpc = sectpc[pcmode];	/* staticize PC */
	tall();			/* allocate current label */
	if (yeanay()) {		/* are we assembling */
	  bits |= CVFL;	/* set flag to print prog cntr */
	}
	return;
*
         TITLE     READ-ONLY       SDIR'S
*
SDIRS    CEQU      $                                            ESCT-32
         LB        1,HWACT+1B      GET AUGMENT + 4 BITS OF JUNK
         SRL       1,4
         SLL       1,2             MAKE IT AN INDEX
         BU        *SDIRTBL,1
         SPACE
SDIRTBL  CEQU      $-1W                                         ESCT-32
         ACW       SSECT
         ACW       SORG
         ACW       SEXT
         PAGE
SORG     CEQU      $                                            ESCT-32
         LB        2,inscnt        GET POINTER INTO BUFFER
         STB       2,inscntS       SAVE IT
         LI        2,2             INDICATE SKIP LEADING SPACES
         BL        VAL             EVALUATE EXPRESSION
	if (yeanay()) {	/* are we assembling */
         BL        YEANAY
         BNS       NEXT         NO PROCESSING OF THIS DIRECTIVE
         LW        3,HWINAC        GET TYPE AND VALUE
         ZR        2
         SLLD      2,8
         ZBR       2,24            CLEAR DSECT/CSECT FLAG
         CI        2,TYPC          IS IT COMMON TYPE
         BNE       SORG1        OKAY, DO SOME MORE CHECKS
         LB        1,sectpc+1B+2W  CHECK IF IN SAME SECTION
         CAMB      1,HWINACBN      NEW SECTION NUMBER
         BNE       SORG2        NO MATCH, OUTPUT ERROR
SORG1    CEQU      $                                            ESCT-32
	if (pcmode == PCCOM) {	/* is curr sect common */
         LB        1,sectpc+1B+2W  GET CURRENT COMMON BLOCK NUMBER
         SLL       1,2             MAKE IT AN ADDRESS
         TBM       0,HWCMSIZE,1    IS IT AN SSECT
         BS        SORG3           OKAY, PROCESS IT
	}
SORG2    EQU	$
	  seterr ('Q');		/* set label error */
	currpc = sectpc[pcmode];	/* staticize PC */
	tall();			/* allocate current label */
	if (yeanay()) {		/* are we assembling */
	  bits |= CVFL;	/* set flag to print prog cntr */
	}
	return;

* COMMON TYPE
         SPACE
SORG3    CEQU      $                                            ESCT-32
         CI        2,TYPC          IS IT ALREADY COMMON
         BEQ       SORG3.1         OKAY, NO NEED TO CHECK FURTHER
         LW        2,=C'+   '      SET UP AS THOUGH + WAS TERM.
         STW       2,hbstac        SAVE IT
         LB        2,inscntS       GET POSITION IN LINE
         STB       2,inscnt        RESTORE IT
         LH        3,sectpc+2W     GET COM. TYPE AND SECT. NUMBER
         SLL       3,16            POSITION IT
         STW       3,HWINAG        SAVE AS NUMERIC EQUIVALENT
         SBM       ALVAL,bits2   INDICATE FIRST OPERAND EVAL.
         BL        VAL             RE-EVALUATE TO CHECK LEGALITY
SORG3.1  CEQU      $                                            ESCT-32
         LB        1,sectpc+1B+2W  GET CURRENT COMMON BLOCK NUMBER
         SLL       1,2             MAKE IT AN INDEX
         LH        5,sectpc+1H+2W  GET CURRENT SIZE
         CAMH      5,HWCMSIZE+1H,1 CHECK IF CURRENT IS BIGGER
         BLT       SORG3.2
         STH       5,HWCMSIZE+1H,1 SAVE NEW LARGER SIZE
SORG3.2  CEQU      $                                            ESCT-32
         LW        5,HWINAC       GET TYPE AND VALUE
         ANMW      5,=X'007FFFFF' ISOLATE VALUE
         SLL       5,8
         ADI       5,TYPC          MAKE IT COMMON
         SRC       5,8             IT NOW LOOKS LIKE COMMON
         STW       5,HWINAC        SAVE IT.
         LB        1,sectpc+1B+2W  GET COMMON BLOCK NUMBER
         STB       1,HWINACBN
         STW       5,sectpc+2W
         STB       1,sectpc+ 1B+2W
	currpc = sectpc[pcmode];	/* staticize PC */
	tall();			/* allocate current label */
	if (yeanay()) {		/* are we assembling */
	  bits |= CVFL;	/* set flag to print prog cntr */
	}
	return;
         PAGE
*
SSECT    CEQU      $                                            ESCT-32
	if (yeanay()) {	/* are we assembling */
         LW        1,=X'80C80000'   TERM ON SP, ( )
         BL        UNST
         LB        6,hbstac
         CI        6,G' '
         BEQ       SSECT1.0         ONLY ONE SYMBOL ITS OKAY
	  seterr ('X');		/* set section error */
	}
SSECT0.5 LW        1,=X'80000000'   TERMINATE ON SPACE
         BL        UNST             FINISH UNSTRINGING LINE
         BU        NEXT
         SPACE
SSECT1.0 CEQU      $                                            ESCT-32
         LI        1,TYPU           UNDEFINED INDICATOR
         SRC       1,8              INTO TYPE POSITION
         LD        4,usname
         ANMW      5,=X'FFFFFF00'   TRUNCATE SYMBOL TO 7 CHARACTERS
         ORMB      5,=G' '          SET LAST CHAR TO SP.
         BL        SS               SEARCH SYMBOL TABLE
         ZR        2
         SLLD      2,8
         ZBR       2,24             CLEAR DSECT/CSECT FLAG
         CI        2,TYPC           IS IT COMMON
         BNE       SSECT1.3         NO
*                                   SYMBOL IS COM., CHECK IF SSECT
         ZR        2
         SLLD      2,8              GET COMMON BLOCK NO.
         SLL       2,2              MAKE IT AN INDEX
         TBM       0,HWCMSIZE,2     IS IT AN SSECT?
         BS        SSECT1.2         OKAY
	  seterr ('M');		/* set multiple definition error */
         BU        NEXT
         SPACE
SSECT1.2 LB        2,usname+7B      CHECK NAME IS <= 7 CHARS
         CI        2,G' '
         BEQ       SSECT2.1
	  seterr ('X');		/* set section definition error */
         BU        SSECT2.1
         SPACE
SSECT1.3 CI        2,TYPU           IS IT UNDEFINED
         BEQ       SSECT1.5         YES, GO DEFINE IT
         CI        2,TYPM           IS IT MULTIPLE DEFINITION
         BNE       SSECT1.4         NO
         ZBM       G'M'-X'40',HWERRF  CHANGE FROM M TO J ERROR
SSECT1.4 SBM       G'J'-X'40',HWERRF  MARK ERROR
	  seterr ('J');		/* set J error */
         BU        NEXT
         SPACE
SSECT1.5 CEQU      $                                            ESCT-32
*                                   DEFINE NEW SSECT
         LB        3,HBCCCT         GET NUMBER FOR NEW BLOCK
         CI        3,254            ARE THERE TOO MANY
         BLT       SSECT1.6         NO
	  seterr ('Z');		/* set ssection definition error */
         BU        NEXT
SSECT1.6 CEQU      $                                            ESCT-32
         SLL       3,2              MAKE IT AN INDEX
         SBM       0,HWCMSIZE,3     MARK IT AS AN SSECT
         SRC       3,10             POSITION IT FOR CONCATENATION
         LI        2,TYPC          TYPE FLAG FOR COMMON SYMBOL
         SRLD      2,8             COM TYPE, BLOCK NO., 0 DISPLACEMENT
         TRR       3,1
         LB        4,usname+7B     CHECK TO SEE IF NAME<=7 CHARACTERS
         CI        4,G' '
         BEQ       SSECT2.0        YES, ITS OKAY
	  seterr ('X');		/* set section definition error */
SSECT2.0 CEQU      $                                            ESCT-32
         LD        4,usname
         ANMW      5,=X'FFFFFF00'  CLEAR LAST BYTE
         ORMB      5,=G' '         SET IT TO SP.
         BL        SS              ALLOCATE SYMBOL TO COMMON BLOCK
         LI        1,TYPD          COMMON BLOCK DEF. TYPE
         SLL       1,8
         ORMB      1,HBCCCT        COMMON BLOCK NUMBER
         SLL       1,16            COM. DEF TYPE, BLOCK NUMBER, 0 SIZE
         LD        4,usname
         SRLD      4,8             CLEAR LAST CHARACTER
         ORMW      4,=X'29000000'  FORM SECTION NAME, ')XXXXXXX'
         BL        SS              DEFINE THE SECTION
         ABM       7,HBCCCT        INCREMENT NUMBER OF COMMON BLOCKS
SSECT2.1 LI        2,G' '          SET LAST BYTE OF SYMBOL TO SP.
         STB       2,usname+7B
         LI        2,1             INDICATE ELEMENT ALREADY UNSTRUNG
         BL        VAL
         LB        1,sectpc+1B+2W  GET CURRENT COMMON BLOCK NUMBER
         CAMB      1,HWINACBN      SAME AS NEW BLOCK NUMBER
         BNE       SSECT2.9        NOT EQUAL CONTINUE
	if (pcmode == PCCOM) {		/* make sure common */
	  currpc = sectpc[pcmode];	/* staticize PC */
	  tall();			/* allocate current label */
	  if (yeanay()) {		/* are we assembling */
	    bits |= CVFL;	/* set flag to print prog cntr */
	  }
	  return;
	}
SSECT2.9 SLL       1,2             MAKE IT AN ADDRESS
         TBM       0,HWCMSIZE,1    IS IT AN SSECT
         BNS       SSECT3          NO NEED TO SAVE CURRENT SIZE
         LH        5,sectpc+1H+2W  GET CURRENT SIZE
         CAMH      5,HWCMSIZE+1H,1 CHECK IF CURRENT IS LARGER
         BLT       SSECT3          NO, DON'T UPDATE
         STH       5,HWCMSIZE+1H,1 SAVE NEW SIZE
SSECT3   LB        1,HWINACBN      GET COM. BLOCK NUMBER
         SLL       1,2             MAKE IT AN INDEX
         LH        5,HWCMSIZE+1H,1 ADD IN PREV. SIZE
         ANMW      5,=X'0000FFFF'  ELIMINATE POSSIBLE SIGN EXTEND
         ADMW      5,HWINAC        TYPE AND VALUE FROM VAL
         STW       5,sectpc+2W     SAVE IN COM. PC
         LB        5,HWINACBN      GET COM. BLOCK NUMBER
         STB       5,sectpc+1B+2W  SAVE IN COM. PC
	pcmode = PCCOM;		/* set common mode */
	currpc = sectpc[pcmode];	/* staticize PC */
	tall();			/* allocate current label */
	if (yeanay()) {		/* are we assembling */
	  bits |= CVFL;	/* set flag to print prog cntr */
	}
	return;
         PAGE
SEXT     CEQU      $                                            ESCT-32
	if (yeanay()) {	/* are we assembling */
         BL        YEANAY          DO WE ALLOW A SEXT DEFINITION
         BNS       SEXT1.0         NO, FINISH UNSTRING STATEMENT
         LI        5,255           VALUE FOR SEXT IN DATAPOOL DEF'S
         STB       5,HWDPNUM
         BU        CCP7.01         GO PROCESS AS A DATAPOOL
         SPACE     2
SEXT1.0  CEQU      $                                            ESCT-32
         LW        1,=X'80000000'  TERMINATE ON SPACE
         BL        UNST            UNSTRING THE REST OF THE LINE
         BU        NEXT

         TITLE     READ-ONLY       CCP1
* COMMON PSEUDO PROCESSOR
         SPACE
CCP1     CEQU      $                                            ESCT-32
	if (yeanay()) {	/* are we assembling */
         BL        YEANAY          DO WE ALLOW A COMMON DEFINITION
         BNS       CCP3         NO
         LD        4,label        GET LABEL
         CAMD      4,DATAPOOL      CHECK FOR DATAPOOL
         BEQ       CCP7.DP      DATAPOOL FOUND GO PROCES
         CAMW      4,DPOO       CHECK FOR MULTIPLE DATAPOOL
         BNE       CCP1.01
         SRL       5,24
         CAMW      5,LXX
         BEQ       CCP7.MDP     GO PROCESS MULTIPLE DATAPOOL
         LD        4,label
CCP1.01  CEQU      $                                            ESCT-32
         LI        1,TYPU          UNDEFINED INDICATOR
         SRC       1,8             INTO TYPE POSITION
         STW       1,CCTU          SAVE IT
         LD        4,label
         BL        SS              SEARCH FOR BLOCK NAME IN SYMBOL TBL
         TBM       INTSS,SPMAC     WAS SYMBOL INTERNALLY GENERATED?
         BNS       CCP1.3       NO--OK.
	  seterr ('I');		/* set section definition error */
CCP1.1   LW        1,=X'80C80000'   TERM ON SP , ( )
         BL        UNST            UNSTRING ONE SYMBOL NAME.
         LB        6,hbstac        GET TERMINATOR.
         CI        6,G' '          WAS IT A BLANK?
         BNE       CCP1.1       NO, FINISH UNSTRINGING LINE.
         BU        NEXT
CCP1.3   CEQU      $                                            ESCT-32
         ZR        2
         SLLD      2,8             TYPE TO R2
         ZBR       2,24            CLEAR DSECT/CSECT FLAG
         CI        2,TYPD          IS IT A COMMON BLOCK DEFINITION
         BEQ       CCP8         YES, WE MUST CHAIN THIS BLOCK    84-587
         CI        2,TYPU          WAS THE BLOCK NAME UNDEFINED
         BEQ       CCF          YES- IT WAS A NEW BLOCK
	  seterr ('J');		/* set common definition error */
         TBM       EXPAND,macstate   ARE WE EXPANDING A MACRO?
         BS        CCP1.1       YES, GO UNSTRING REST OF LINE.
         BU        NEXT            GIVE UP
CCF      LB        3,HBCCCT        A NEW BLOCK, GET A NEW NUMBER FOR IT
         STW       R3,BLKNUM       SAVE COMMON AREA BLOCK NUM.  S8701703
         CI        3,255           ARE THERE TOO MANY
         BLE       CCF1.0          NO
	  seterr ('R');		/* set relocation error */
         BU        NEXT
CCF1.0   CEQU      $                                            ESCT-32
         ABM       7,HBCCCT        INCR NUMBER OF COMMON BLOCKS
         SRC       3,8             POSITION BLOCK NUMBER FOR CONCATENATE
         BU        CCP9            PROCESS BLOCK ENTRIES        84-587
CCP8     TBM       7,PASS        FIRST PASS?                  84-587
         BS        CCP9            IF NOT THEN GO               84-587
         SRL       3,24                                         84-587
         SLL       3,24                                         84-587
CCP9     LI        2,TYPC          TYPE FLAG FOR COMMON SYMBOL RESIDENT
         SRLD      2,8             COM TYPE, BLOCK NO., 0 DISPLACEMENT
         STW       3,CCTW          CURRENT COMMON BLOCK PROG. COUNTER
CCP3     LW        1,=X'80C80000'  TERM ON SP , ( )
         BL        UNST            UNSTRING ONE SYMBOL NAME FOR COMMON
	if (yeanay()) {	/* are we assembling */
         BL        YEANAY          DO WE ALLOW A COMMON DEFINITION
         BNS       CCP34        NO
         LD        4,usname        NAME FOR COMMON
         LW        1,CCTW          ALLOCATE TO CURRENT COM PC IF PASS 1
         TBM       7,PASS        IS THIS PASS 2
         BNS       $+2W         YES, DONT ALLOCATE ANYTHING
         BL        SS              PASS 1,ALLOCATE SYMBOL TO COMMON AREA
CCP34    CEQU      $                                            ESCT-32
         LI        7,4
         LB        6,hbstac        LATEST TERMINATOR
         CI        6,G'('          WAS IT A (
         BNE       CCP4         NO, JUMP TO NEXT WORD
         LW        1,=X'80C80000'  TERM ON SP , ( )
         BL        UNST            UNSTRING DIMENSION SIZE
         LI        2,10            DIMENSION SIZE IN DECIMAL (NO. WORDS)
         BL        CNUM            CONV TO COMPUTATIONAL IN R6,7
         MPI       6,4             CONV WORDS TO BYTES
CCP4     CEQU      $                                            ESCT-32
         LW        6,CCTW          GET SIZE FIELD                 83-133
         SLL       6,16                                           83-133
         SRL       6,16            CLEAR ALL INFO BUT SIZE        83-133
         ADR       7,6             ADD NEW SIZE                   83-133
         SRL       6,16            SHIFT OFF HW OF SIZE           83-133
         TRR       6,6             ANYTHING LEFT ??               83-133
         BZ        CCP4.5          NO - SIZE IS O.K.              83-133
	  seterr ('R');		/* set relocation error */
         ZR        7               CLEAR R7 TO PREVENT DAMAGE     83-133
         SPACE     1
CCP4.5   CEQU      $               ADD SIZE                     ESCT-32
         ARMW      7,CCTW          INCRE COMMON BLOCK PROG. CNTR  83-133
CCP5     LB        6,hbstac        LATEST TERMINATOR
         CI        6,G','          WAS IT A COMMA
         BEQ       CCP3         YES, MORE SYMBOLS IN THIS BLOCK
         CI        6,G' '          WAS IT A SPACE
         BEQ       CCP6         YES, FINISH THIS BLOCK
         LW        1,=X'80C80000'  TERM ON SP , ( )
         BL        RUNST           UNSTRING-WOTHOUT SKIPPING LEFT SPACES
         BU        CCP5            SEE IF WE ARE FINISHED
CCP6     CEQU      $                                            ESCT-32
         LW        R3,BLKNUM       GET COMMON BLOCK NUMBER      S8701703
         SLL       R3,2            TURN INTO AN INDEX           S8701703
         LW        R6,CCTW         GET SIZE INFORMATION         S8701703
         ANMW      R6,=X'0000FFFF' JUST SIZE INFO.              S8701703
         STH       R6,HWCMSIZE+1H,X3   SAVE SIZE                S8701703
         LI        6,TYPD          BLOCK DEFINITION TYPE CODE   S8701703
         STB       6,CCTW          MODIFY TYPE IN CURRENT COUNTER
         LD        4,label        BLOCK NAME
         LW        1,CCTW
         TBM       7,PASS        IS THIS PASS 2
         BNS       NEXT         YES, DONT RESET THE DEF CODE
	if (yeanay()) {	/* are we assembling */
         BL        YEANAY          DO WE ALLOW A COMMON DEFINITION
         BNS       NEXT         NO
         BL        SS
         BU        NEXT            DEFINE COMMON BLOCK NO. AND MAX SIZE
         SPACE
CCP7.MDP CEQU      $               PROCESS MULTIPLE DATAPOOLS   ESCT-32
         LW        5,label+1W     GET 'LXX'
         SLL       5,8             ELIMINATE 'L'
         ORMW      5,=G' '         ADD IN SPACE AS A TERMINATOR
         STW       5,usname
         LI        2,10            SET RADIX
         BL        CNUM            CONVERT TO DECIMAL
         STB       7,HWDPNUM       SAVE NUMBER FOR LATER USE
         CAMW      7,=99           ONLY DPOOL00 - DPOOL99 IS VALID
         BLE       CCP7.01
	if (yeanay()) {	/* are we assembling */
	  seterr ('D');		/* set datapool error */
	}
         BU        CCP7.01
         SPACE
CCP7.DP  CEQU      $               PROCESS DATAPOOL ITEMS       ESCT-32
         LI        5,100           VALUE FOR DATAPOOL
         STB       5,HWDPNUM
CCP7.01  CEQU      $                                            ESCT-32
         LW        1,=X'80C80000'  TERM ON SP , ( )
         BL        UNST            UNSTRING ONE SYMBOL
         LB        6,hbstac        LATEST TERMINATOR
         CI        6,G'('          WAS IT A LEFT PAREN?
         BEQ       CCP7.0       YES-ALLOCATE SYMBOL
         CI        6,G')'          WAS IT A RIGHT PAREN?
         BEQ       CCP7.1       YES-IGNOR TO (,) OR SP
CCP7.0   LD        4,usname        MUST BE COMMA OR SP
         LI        1,TYPDP         GET TYPE CODE
         SRC       1,8
         ORMW      1,HWDP          ADD IN DATAPOOL NUMBER
         BL        SS              ALLOCATE SYMBOL
         CI        6,G' '          TERM ON SP
         BEQ       NEXT         YES-ALL DONE GET NEXT REC.
         CI        6,G'('          TERM ON A (
*        BNE       CCP7.DP      NO- DON'T IGNORE DATA TO   ,
         BNE       CCP7.01      NO- DON'T IGNORE DATA TO   ,
CCP7.1   LW        1,=X'80C80000'  TERM ON SP , ( )
         BL        UNST
         LB        6,hbstac        LAST TERMINATOR
         CI        6,G','          TERM ON COMMA?
*        BEQ       CCP7.DP      YES-GET NEXT ITEM
         BEQ       CCP7.01      YES-GET NEXT ITEM
         CI        6,G' '          NO-TERM ON SPACE?
         BEQ       NEXT         YES-ALL DONE GET NEXT REC
         BU        CCP7.1          NO-IGNORE DATE;LOOK FOR ,

         TITLE     READ-ONLY       REF
* PROCESS DEF AND EXT OPERATIONS
         SPACE
REF      CEQU      $                                            ESCT-32
         LI        1,TYPU          DEFAULT TO DEF (REQUEST FOR SS)
         TBM       3,HWACT+1B      IS IT A DEF
         BNS       $+2W         BU IF DEF
         LI        1,TYPX          EXT TYPE
         SRC       1,8             LEFT JUSTIFY TYPE CODE
         STW       1,REFS1         SAVE IT
         LW        1,=X'80080000'
         BL        UNST            UNSTRING IGNORING LEADING SPACES
REF1     CEQU      $                                            ESCT-32
	if (yeanay()) {	/* are we assembling */
         LD        4,usname        NAME
         CAMW      4,=C'    '      ! IS NAME BLANK?
         BNE       REF1.1       ! BRANCH IF NOT BLANK
	  seterr ('F');		/* set blank name error */
         BU        REF3
REF1.1   LW        1,REFS1         TYPE CODE
         BL        SS              SEARCH AND INSERT IN SYM TBL
         TBM       INTSS,SPMAC     WAS SYMBOL INTERNALLY GENERATED?
         BNS       REF1.5       NO.
	  seterr ('I');		/* set internal ref error */
	}
         BU        REF3
         SPACE
REF1.5   CEQU      $                                            ESCT-32
         TBM       3,HWACT+1B      IS IT A DEF
         BS        REF3         NO
         SPACE
*  PROCESS EXTERNAL DEFINITION. ADDED 01/30/78.
         SPACE
         TBM       7,PASS        WHICH PASS ARE WE IN? (ZERO=PASS 2)
         BS        REF3            PASS 1 - RETURN (NO OUTPUT)
         STW       3,REFS2         SAVE OUTPUT DEFINITION FROM SS
         ZR        2
         SLLD      2,8             TYPE CODE TO R2
         ZBR       2,24            CLEAR SECTION FLAG BIT
         CI        2,TYPP          IS IT NORMAL PROG TYPE ALLOCATION
         BEQ       DEF1         OKAY, PUBLISH IT
         CI        2,TYPC       IS IT COMMON
         BNE       BB.DEF8      NO, MARK ERROR
         LB        2,REFS2+1B   GET COMMON BLOCK NUMBER
         SLL       2,2          TURN INTO AN INDEX
         TBM       0,HWCMSIZE,2 IS IT AN SSECT
         BNS       BB.DEF8      NO,MARK ERROR
         TBM       2,HWACT+1B   IS IT A SEXT?
         BNS       BB.DEF8      NO, MARK ERROR
         ZMB       HBBS         RESET BO STACK POINTER
         BU        BB.DEF3      GENERATE EXPANDED LOADER CODE
DEF1     CEQU      $                                            ESCT-32
         ZMB       HBBS            RESET BO STACK POINTER
         TBM       EXPLFC,bits3  CHECK FOR CSECT OR NON-ZERO DSECT
         BS        BB.DEF3         YES - GENERATE EXPANDED LOADER FUNC.
*                                  NO - GEN STANDARD LOADER FUNCTIONS
         BL        BFN             STACK NAME INTO BO STREAM STACK
         LW        7,REFS2
         BL        BFA             STACK ADR INTO BO STREAM
         LI        6,PTED          LOADER FUNC CODE ENTRY POINT DEF
         BU        BB.DEF7         GO TO PUBLISH OUTPUT
BB.DEF3  equ	$
	bfb(LFEXTDF);		/* put ldr funct sub code into bo stack */
	bfb(0);			/* output dummy byte count */
	bfb(0);			/* output unused byte */
         TBM       2,HWACT+1B      IS IT SEXT?
         BNS       BB.DEF4         NO
         LB        7,REFS2+1B      GET COMMON BLOCK NUMBER
         ADI       7,2             SKIP OVER SECTIONS 0 AND 1
	bfb(-r7-);		/* output common blk number plus 2 */
         LH        7,REFS2+1H      GET ADDRESS
         ANMW      7,=X'0000FFFF'  CLEAR SIGN EXTEND
         BU        BB.DEF5
BB.DEF4  CEQU      $                                            ESCT-32
         LW        7,REFS2         GET OUTPUT DEFINITION
         ZR        6               CLEAR R6
         SLLD      6,1             SHIFT DSECT/CSECT BIT INTO R6
         TRR       6,7             LOAD R7 WITH SECTION
	bfb(-r7-);		/* output section number */
         LW        7,REFS2         GET OFFSET
BB.DEF5  CEQU      $                                            ESCT-32
         BL        BFA       AS13  PUT OFFSET (3 BYTES) INTO BO STACK
*             WAS BL BFA.0   AS13  FIX BO OUTPUT FOR DEF IN CSECT
         BL        BFN.0           PUT NAME INTO BO STACK
         LI        6,EXPFUNC       GET LOADER FUNCTION CODE
BB.DEF7  LW        1,HABS          BASE ADDR OF BIN BYTE STREAM STACK
         BL        PB             PUBLISH BINARY OUTPUT STACK
         BU        REF3            CONTINUE
BB.DEF8  CEQU      $               ERROR OCCURED                ESCT-32
	  seterr ('F');		/* set symbol definition error */
REF3     LB        6,hbstac        GET LATEST TERMINATOR
         CI        6,G'",'         CHECK FOR COMMA
         BNE       NEXT
         LW        1,=X'80080000'  SP AND ,
         BL        UNST            ! UNSTRING IGNORING LEADING SPACES
         BU        REF1

         TITLE     READ-ONLY       MACEXP
MACEXP   BL        YEANAY          CHECK IF ASSEMBLY ALLOWED
	if (yeanay()) {	/* are we assembling */
         BNS       MACEXP3      NO
         LW        1,TALLS1        INDICATE A REQUEST WAS PERFORMED
         LW        3,lict        FOR A MACRO FROM THIS LINE NUMBER
         ZMW       REPTYPE         INDICATE SYMBOL REPORT TO XREF
         BL        REPTR          SO IT WILL SHOW UP IN THE XREF
	tall();			/* allocate current macro label */
         ABM       31,LEVEL        INDICATE A LEVEL OF EXPANSION
         SBM       CALLUS,macstate SET CURRENT MACRO CALL INDICATOR
         LW        R4,STKP         EXPANSION STACK POINTER
         TBM       EXPAND,macstate  SEE IF WE ARE EXPANDING A MACRO NOW
         BS        MACEXP2      YES
         LA        R4,STK          ADDR OF EXPANSION STACK
MACEXP2  STW       R4,STKP         INIT POINTER
         LW        R3,hwcmac       ADDRESS OF PROTOTYPE
         LW        R1,STACKP       CURRENT LEVEL POINTER
         STW       R4,0W,R1        SAVE POINTER TO MACRO PROTO IN STK
         LB        R2,4W,R3        GET # OF PARS DEFINED FOR MACRO
         STB       R2,0W,R1        SAVE PAR COUNT
         ADI       R3,6W           MACRO HEADER SIZE
         STW       R3,1W,R1        SAVE MACRO PROTOTYPE POINTER
         TRR       R4,R3           PAR STORAGE STACK
         TRN       R2,R2           ANY PARAMETERS
         BZ        MACEXP3-1W      BR IF NOT
         LW        R4,=C'    '     ALL SPACES
         LW        R5,=C'    '     ALL SPACES
MACEXP25 STD       R4,0D,R3        INIT STACK
         STD       R4,1D,R3        INIT STACK
         STD       R4,2D,R3        INIT STACK
         ADI       R3,3D           BUMP TO NEXT PAR STORAGE
         BIB       R2,MACEXP25     LOOP TO INIT ALL DUMMY PARS
         STW       R3,MACT         SAVE END OF DUMMY VARIABLES
MACEXP3  LW        1,=X'80080000'  SP AND ,
         BL        UNST            UNSTRING ONE ELEMENT
	if (yeanay()) {	/* are we assembling */
         BL        YEANAY          CHECK WHETHER ASSEMBLY IS ALLOWED
         BNS    MACEXP5         DONT ASSEMBLE
MACEXP33 LD       R6,usname        GET UNSTRUNG NAME
         ZBM       INTGEN,macstate WAS ARGUMENT AN INT SYMBOL ?
         BS        MACEXP4-2W     YES, DON'T REPLACE IN STACK
         CAMW      6,=C'    '      CHECK FOR BEING PRESE T
         BNE       MACEXP4      DONT GO GENERATE AN INTERNAL TAG
MACEXP36 LW       R5,INTTAG        GET THE LATEST INTERNAL TAG
         ABM       31,INTTAG       INCR INT TAG COUNT.
         ANMW      5,=X'FFFF'      INT SYM NUM.
         BL        BTX             CONVERT TO ASCII.
         SLLD      6,24
         ORMW      7,=X'00202020'  PAD INT NUM WITH TRAILING BLANKS.
         ANMW      6,=X'00FFFFFF'  CLEAR BYTE 0.
         ORMW      6,=X'FF000000'  PLACE INT SYM XREF CHAR INTO INT SYM.
MACEXP4  LW        R1,STKP         POINTS TO CURRENT PLACE IN STACK
         CAMW      R1,MACT         TOO MANY PARS SPECIFIED
         BLE       sss             BR IF OK
	  seterr ('X');		/* set xref error */
         BU        MACEXP5         SKIP STORAGE OF PARAMETER
sss	equu $
         ABM       27,STKP         INCR CURR STACK POINTER BY 16
         ABM       28,STKP         INCR CURR STACK POINTER BY 8
         STD       R6,0D,R1        PLACE ITEM INTO STACK
         LD        R6,usname+1D    GET NEXT 8 CHARS
         STD       R6,1D,R1        PLACE ITEM INTO STACK
         LD        R6,usname+2D    GET NEXT 8 CHARS
         STD       R6,2D,R1        PLACE ITEM INTO STACK
MACEXP5  LB        4,hbstac        CHECK TERMINATOR
         CI        4,G','          FOR A COMMA
         BEQ       MACEXP3      GO GET MORE ITEMS
	if (yeanay()) {	/* are we assembling */
         BL        YEANAY          CHECK WHETHER ASSEMBLY IS ALLOWED
         BNS       MACEXP9      DON'T ASSEMBLE
         LW        R4,MACT         POINTER TO PROTOTYPE STOAGE LOCATION
         STW       R4,STKP         SET STACK POINTER
         LW        R1,STACKP       CURRENT LEVEL POINTER
         STW       R1,MPP          SAVE CURR LEV MACRO PAR POINTER
         ABM       28,STACKP       SET FOR NEXT LEVEL
         SBM       EXPAND,macstate    SHOW WE ARE EXPANDING A MACRO NOW
         SBM       CVFL,bits     INDICATE PRINT PROG CNTR
MACEXP9  ZBM       CALLUS,macstate CLR CURRENT MACRO CALL INDICATOR
         BU        NEXT

         TITLE     READ-ONLY       FORMEXP
FORMEXP  CEQU      $               EXPAND A FORM                ESCT-32
         SBM       FORMGET,inptstat      INDICATE STRIPPING DOWN A FORM
         LW        1,hwcmac        THE PLACE WHERE THE FORM PROTOTYPE ST
         STW       1,hwcmacP       SAVE THIS FOR COUNTING
	if (yeanay()) {	/* are we assembling */
         BL        YEANAY          CHECK IF ASSEMBLY ALLOWED
         BNS       VFD          NO
         LW        1,TALLS1        INDICATE A REQUEST WAS PERFORMED
         LW        3,lict        FOR A FORM  FROM THIS LINE NUMBER
         ZMW       REPTYPE         INDICATE SYMBOL REPORT TO XREF
         BL        REPTR          SO IT WILL SHOW UP IN THE XREF
	tall();			/* allocate current form label */
         BU        VFD             FINESSE THIS INTO THE VFD PROCESSOR
         SPACE
FORMEXP1 CEQU      $                                            ESCT-32
         LW        4,hwcmac        THE PLACE WHERE THE FORM PROTOTYPE ST
         STW       4,hwcmacP       SAVE THIS FOR COUNTING
FORMEXP2 CEQU      $               COME HERE FOR A FORM EXPANS  ESCT-32
         LW        1,hwcmacP       POINTER TO A FORM FIELD COUNT ITEM
         ABM       31,hwcmacP      ADVANCE THE POINTER TO THE BIT LENGTH
         LB        R7,0B,R1        GET ONE BYTE OF FIELD COUNT
         CI        7,X'FF'         CHECK FOR LIST TERMINATOR
         BNE       VFD2         WITH THE FIELD SIZE IN R7
         BU        FORMEXP1        BOTTOM OF LIST-THEN RESTART IT
         TITLE     READ-ONLY       IFPRO
IFPRO    CEQU      $                                            ESCT-32
         ZMW       PREVRELO        CLEAR OUT POINTER TO PREV RELATION
         LB        4,HWACT         GET TRUE/FALSE REQUIREMENT FLAG
         CI        R4,3            CHECK FOR IFP/IFA            EIFD-32
         BLE       IFPRO.1B     NOT AN IFP OR IFA               EIFD-32
         LW        1,=X'00080000'  TERM ON COMMA ONLY
         BL        UNST            UNSTRING ENTIRE EXPRESSION
         LB        1,PASS        ARE WE IN PASS 2 ?               AS19
         BNE       IFPRO.1         YES,CONTINUE  NO,SKIP            AS19
         ZBM       0,UNSTCK        RESET AND SET DELIM CHECK BIT    AS19
         BNS       IFPRO.1         SHOULD END IN PARAM, NOT DELIM   AS19
	  seterr ('E');		/* set faulty parm list error */
IFPRO.1  ZBM       0,UNSTCK        RESET DELIM CHECK BIT            AS19
         LB        1,inscnt        BYTE READING POINTER
         CI        1,73            WAS A COMMA FOUND ?
         BGE       IFPRO99      NO - GO MARK ERROR
         BU        IFPROD          GO UNSTRING PLACE TO GO TO
         SPACE
IFPRO.1B CI        R4,2            CHECK FOR IFT/IFF            EIFD-32
         BGE       IFPRO.A         BRANCH IF IFTDEF/IFFDEF      EIFD-32
IFPRO2   CEQU      $                                            ESCT-32
         LW        1,=X'81FD0000'  LONG LIST OF TERMINATORS POSSIBLE
         BL        UNST
         LB        1,PASS        ARE WE IN PASS 2 ?               AS19
         BNE       IFPRO2.1        YES,CONTINUE  NO,SKIP            AS19
         ZBM       0,UNSTCK        RESET AND SET DELIM CHECK BIT    AS19
         BNS       IFPRO2.1        SHOULD END IN PARAM, NOT DELIM   AS19
	  seterr ('E');		/* set faulty parm list error */
IFPRO2.1 ZBM       0,UNSTCK        RESET DELIM CHECK BIT            AS19
         LI        1,-SIZCOND      SIZE OF CONDITIONAL LIST
         LW        4,usname        THE UNSTRING
         CAMW      4,=C'    '      ! IS TOKEN BLANK?
         BEQ       IFPRO9       ! SKIP BLANKS AND CONTINUE SCANNING
         CAMW      4,CONDLIST,1    CHECK FOR MATCH
         BEQ       FIND         A MATCH
         BIW       1,$-2W          CHECK WHOLE LIST
         LI        2,1             SIGNAL FIRST ELEMENT PART UNSTRUNG
         BL        VAL             EVALUATE THE UNSTRUNG ELEMENT
         LW        1,PREVRELO      POINTER TO PREVIOUS RELATION OPERATOR
         LI        4,1
         SLL       7,9             THROW AWAY TYPE CODE.
         SRA       7,9
         CAMW      7,IFET          COMPARE TO PREVIOUS VALUE
         EXM       IFCONDBR,1      EXECUTE THE PROPER JUMP FOR A .TRUE.
         ZR        4               FALL THRU FOR FALSE
IFPRO5   CEQU      $                                            ESCT-32
         STW       4,IFET          SAVE THE TRUE/FALSE INDICATOR
         BU        IFPRO9          GO GET NEXT ELEMENT
         SPACE
IFINIT   CEQU      $                                            ESCT-32
         STW       7,IFET          SAVE THE VALUE FOR THE TERM
         BU        IFPRO9          GO GET NEXT ELEMENT
         SPACE
IFPRAND  CEQU      $                                            ESCT-32
         ANMW      7,IFET         AND PREVIOUS LOG COND WITH LATEST ONE
         STW       7,IFET          UPDATE THE LOGICAL CONDITION
         BU        IFPRO9          GO GET NEXT ELEMENT
         SPACE
IFPROR   CEQU      $                                            ESCT-32
         ORMW      7,IFET          OR PREVIOUS LOG COND WITH LATEST ONE
         STW       7,IFET          UPDATE THE LOGICAL CONDITION
         BU        IFPRO9          GO GET NEXT ELEMENT
         SPACE
FIND     CEQU      $                                            ESCT-32
         STW       1,PREVRELO      SAVE THE POINTER TO THIS OPERATOR
IFPRO9   CEQU      $                                            ESCT-32
         LB        7,hbstac        GET THE LAST ERMINATOR
         CI        7,G','          FOR BEING A COMMA
         BEQ       IFPROD       FOUND A COMMA , NO MORE TERMS
*                                  TO CHECK
         LB        1,inscnt        BYTE READING POINTER
         CI        1,73            DID WE TRY TO GO BEYOND COLUMN 72?
         BLT       IFPRO2       NO, GO CHECK SOME MORE TERMS.
IFPRO99  CEQU      $                                            ESCT-32
	if (yeanay()) {	/* are we assembling */
         BL        YEANAY          ARE WE ASSEMBLING?
         BNS       NEXT         NO.
	  seterr ('E');		/* set faulty parm list error */
         BU        NEXT
         SPACE     2
IFPROD   CEQU      $                                            ESCT-32
         ZBM       INTGEN2,macstate  CLEAR IT OUT INTIALLLY
         TBM       INTGEN,macstate CHECK IND OF INTERNAL LABEL IN EXP.
         BNS       $+2W         INTGEN WAS NOT ON-DONT COPY A 1
         SBM       INTGEN2,macstate  INTGEN IS ON SO COPY IT
         LW        1,=X'80080000'  SP AND ,
         BL        UNST            UNSTRING THE PLACE TO GO TO
         LB        1,PASS        ARE WE IN PASS 2 ?               AS19
         BNE       IFPROD.1        YES,CONTINUE  NO,SKIP            AS19
         ZBM       0,UNSTCK        RESET AND SET DELIM CHECK BIT    AS19
         BNS       IFPROD.1        SHOULD END IN PARAM, NOT DELIM   AS19
	  seterr ('E');		/* set faulty parm list error */
IFPROD.1 ZBM       0,UNSTCK        RESET DELIM CHECK BIT            AS19
         LB        4,HWACT         GET THE TRUE/FALSE REQUIREMENT FLAG
         CI        4,20            CHECK FOR IFP FLAG
         BEQ       IFPROD2      IT IS AN IFP.
         CI        4,21            CHECK FOR IFA FLAG.
         BNE       IFPRO7       NOT AN IFA--MUST BE IFF/IFT.
         TBM       INTGEN2,macstate  ANY INT GEN SYMBOLS PRESENT?
         BS        NEXT         YES--SKIP COND SCAN.
         BU        IFPRO8          ALLOW COND SCAN IF ASSEMBLING
         SPACE
IFPROD2  TBM       INTGEN2,macstate  ANY INT GEN SYMBOLS PRESENT?
         BNS       NEXT         NO--SKIP COND SCAN
         BU        IFPRO8          ALLOW COND SCAN IF ASSEMBLING
         SPACE
IFPRO7   CEQU      $                                            ESCT-32
         EOMB      4,IFET+3        COMPARE IT TO TRUE FALSE CASE OF EXPR
         BNE       NEXT         NO MATCH-GO GET NEXT WHOLE STATEMENT
IFPRO8   CEQU      $                                            ESCT-32
	/* save name where we can resume assemble */
	memcpy (hwscnhp, usname, 8);	/* move 8 bytes of label */
	if (!yeanay()) return;	/* if not assembling return */
	memcpy (lablscan, hwscnhp, 8);	/* save label to scan for */
	macstate |= CONDSCAN;		/* show we are in a conditional scan */
	return;			/* do next input line */
*
IFPRO.A  CEQU      $                                            EIFD-32
         ZBM       1,IFFLG         CLEAR SYMBOL FOUND FLAG      EIFD-32
         LW        1,=X'00080000'  TERMINATE ON COMMA           EIFD-32
         BL        UNST            GET TEST SYMBOL              EIFD-32
         LW        R2,SYMTAB       GET SYMBOL TABLE ADDR        EIFD-32
         BZ        IFPRO.B         NO SYMBOLS IF ZERO           EIFD-32
IFPRO.A2 LW        R4,2W,X2        GET SYMBOL FROM TABLE        EIFD-32
         LW        R5,3W,X2        GET SECOND HALF              EIFD-32
         CAMD      R4,usname       COMPARE WITH TEST SYMBOL     EIFD-32
         BNE       $+3W            NEXT SYMBOL IF NOT EQUAL     EIFD-32
         SBM       1,IFFLG         SHOW SYMBOL DEFINED          EIFD-32
         BU        IFPRO.B         CONTINUE                     EIFD-32
         LW        R2,5W,X2        GET NEXT SYMBOL ADDR         EIFD-32
         BZ        IFPRO.B         NO MORE IF ZERO              EIFD-32
         BU        IFPRO.A2        CONTINUE COMPARING           EIFD-32
IFPRO.B  CEQU      $                                            EIFD-32
         LW        1,=X'80080000'  GET TERMINATORS              EIFD-32
         BL        UNST            GET JUMP LABEL               EIFD-32
         LB        R4,HWACT        GET TRUE/FALSE CONDITION     EIFD-32
         CI        R4,2            IS IT IFTDEF?                EIFD-32
         BEQ       IFPRO.A3        BRANCH IF SO                 EIFD-32
         TBM       1,IFFLG         WAS SYMBOL DEFINED           EIFD-32
         BNS       NEXT            NEXT INSTR IF NOT DEFINED    EIFD-32
	/* save jump name */
	memcpy (hwscnhp, usname, 8);	/* move 8 bytes of label */
	if (!yeanay()) return;	/* if not assembling return */
	memcpy (lablscan, hwscnhp, 8);	/* save label to scan for */
	macstate |= CONDSCAN;		/* show we are in a conditional scan */
	return;			/* do next input line */
IFPRO.A3 TBM       1,IFFLG         WAS SYMBOL DEFINED?H         EIFD-32
         BS        NEXT            NEXT INSTR IF SO             EIFD-32
	/* save jump name */
	memcpy (hwscnhp, usname, 8);	/* move 8 bytes of label */
	if (!yeanay()) return;	/* if not assembling return */
	memcpy (lablscan, hwscnhp, 8);	/* save label to scan for */
	macstate |= CONDSCAN;		/* show we are in a conditional scan */
	return;			/* do next input line */
*                                                               EIFD-32
IFFLG    DATAB     0       SYMBOL DEFINED/UNDEFINED FLAG        EIFD-32
         BOUND     1W                                           EIFD-32
*
         TITLE     READ-ONLY       SETPRO
SETPRO   CEQU      $                                            ESCT-32
         LB        7,HWACT         GET THE POINTER TO SET,SETT,SETF
         CI        7,2             CHECK FOR WHICH SET TYPE
         BLT       SETPRO4      NOT A VALUE SET-JUST TRUE OR FALSE
         LI        2,2             EVALUATE NEXT LINE ELEMENT
         BL        VAL             TO A NUMERIC VALUE
SETPRO4  STW       7,SETPROV       VALUE AMOUNT, OR TRU, OR FALSE
	if (yeanay()) {	/* are we assembling */
         BL        YEANAY          CHECK FOR ASSEMBLY ALLOWED
*        BNS       NEXT         NO ASSEMBLY ALLOWED
         BS        SETPR4.1     ASSEMBLY ALLOWED
         LW        1,=X'80000000'  TERMINATE ON SP
         BL        UNST         UNSTRING REMAINDER OF LINE
         BU        NEXT
SETPR4.1 CEQU      $                                            ESCT-32
         LB        6,HWACT         GET POINTER                  EBRM-33
         CI        6,3             CHECK IF OPTS,OPTR,OPTT      EBRM-33
         BLT       OPT.6           PROCESS SET TYPE DIRECTIVE   EBRM-33
         ANMW      7,=X'003FFFFF'  GET BIT NUMBER               EBRM-33
         CI        7,32            CHECK IF IN RANGE            EBRM-33
         BLE       OPT.1           OKAY, IT'S IN RANGE          EBRM-33
	  seterr ('X');		/* set range error */
         BU        NEXT                                         EBRM-33
OPT.1    CEQU      $                                            ESCT-32
         TRR       7,2                                          EBRM-33
         SUI       2,1             MAKE OPTION # 0-REL          EBRM-33
         SLL       2,2             MAKE IT A WORD INDEX         EBRM-33
         LW        7,MSKTBL,2      GET APPROPRIATE BIT MASK     EBRM-33
         ANMW      7,OPTMSK        MAKE SURE IT'S A LEGAL OPT   EBRM-33
         BZ        OPT.2           OKAY, BRANCH                 EBRM-33
	  seterr ('X');		/* set range error */
         BU        NEXT                                         EBRM-33
         SPACE                                                  EBRM-33
OPT.2    CEQU      $                                            ESCT-32
         LW        7,MSKTBL,2      GET BIT MASK AGAIN           EBRM-33
         CI        6,3             IS IT "OPTS"?                EBRM-33
         BNE       OPT.3           NO, BRANCH                   EBRM-33
         ORMW      7,OPTION        YES, SET THE OPTION          EBRM-33
         STW       7,OPTION                                     EBRM-33
         LI        7,1             INSURE SYMBOL VALUE IS 1     EBRM-33
         BU        OPT.5                                        EBRM-33
         SPACE                                                  EBRM-33
OPT.3    CEQU      $                                            ESCT-32
         CI        6,4             IS IT "OPTR"?                EBRM-33
         BNE       OPT.4           NO, BRANCH                   EBRM-33
         TRC       7,7             YES, COMPLEMENT MASK         EBRM-33
         ANMW      7,OPTION        AND RESET THE OPTION         EBRM-33
         STW       7,OPTION                                     EBRM-33
         ZR        7               INSURE SYMBOL VALUE IS 0     EBRM-33
         BU        OPT.5                                        EBRM-33
         SPACE                                                  EBRM-33
OPT.4    CEQU      $               MUST BE "OPTT"               ESCT-32
         ANMW      7,OPTION        GET THE OPTION               EBRM-33
         BZ        OPT.5           NOT SET, RETURN "FALSE"      EBRM-33
         LI        7,1             OTHERWISE, RETURN "TRUE"     EBRM-33
OPT.5    CEQU      $                                            ESCT-32
         STW       7,SETPROV       SET THE VALUE FOR THE LABEL  EBRM-33
         LB        4,hbstac        CHECK THAT WE TERMINATED ON A SPACE
         CI        4,G' '          YES, ONLY ONE OPTION SPECIFIED
         BEQ       OPT.6
	  seterr ('X');		/* set range error */
         LW        1,=X'80000000'  TERMINATE ON SPACE
         BL        UNST            UNSTRING REST OF LINE
         LW        7,SETPROV
OPT.6    CEQU      $                                            ESCT-32
         LI        7,TYSETSYM
         STB       7,SETPROV       SET TYPE CODE FOR SYMBOL TABLE
         LW        1,HWINAC        FETCH TYPE CODE
         SRL       1,23            AND ALIGN FOR COMPARE
         CI        1,TYPP*2+X'101' IS IT PROG REL CSECT?
         BEQ       SETPRO5         YES
         CI        1,TYPX*2+X'101' IS IT EXT REL CSECT?
         BNE       SETPRO6         NO
SETPRO5  SBM       0,SETPROV       INDICATE CSECT IN SET TYPE
SETPRO6  CEQU      $                                            ESCT-32
         LW        1,SETPROV
         LD        4,label        THE NAME TO WHICH WE SET A COND OR VA
         BL        SS              SET IT TO THE CURRENT ARGUMENT
         TBM       DPFLG,DPFLAGS   IS IT DATAPOOL
         BNS       NEXT            NO, GET NEXT STATEMENT
	  seterr ('V');		/* set datapool error */
         BU        NEXT            GO GET NEXT STATEMENT

int	gotoc;			/* holds count during goto list scan */
char	gotocb;			/* flag for goto list find/nofind */

/*
 * goto processor
 * input - normal
 *
 */

int	gotop()
{
         TITLE     READ-ONLY       GOTOP
GOTOP    CEQU      $               GOTO PROCESSOR               ESCT-32
	unst(0x80080000);	/* get item, terminate by sp or , */
	memcpy (hwscnhp, usname, 8);	/* move 8 bytes of label */
         LB        4,hbstac        GET TERMINATING CHARACTER
         CI        4,G' '          CHECK FRR COMPLETE END
         BEQ       GOTOPE       UNCONDITIONAL GOTO
         LI        2,1             SIGNAL FIRST UNSTRUNG ALREADY
         BL        VAL             EVALUATE THE FIRST LIST ITEM
         LW        4,=X'00FFFFFF'  CHECK ONLY THE VALUE PART
         TRRM      7,7             STRIP OFF TYPE
         TRN       7,7             NEGATE IT FOR USE AS A COUNTER
         STW       7,GOTOC         SAVE FOR COUNTING
         ZBM       7,GOTOCB        SIGNAL WE HAVE NOT FOUND GOTO PLACE Y
GOTOPC   CEQU      $                                            ESCT-32
         LB        7,hbstac        CHECK TERMINATOR
         CI        7,G','          ARE THERE MORE ELEMENTS IN STATEMENT
         BNE       GOTOPD       NO-THEN WE ARE DONE WITH THE LIST
	unst(0x80080000);	/* get item, terminate by sp or , */
         ABM       31,GOTOC        INCREMENT LIST COUNT
         LW        7,GOTOC         CHECK CURRENT COUNT
         BNE       GOTOPC       NOT AT EXACT POINT IN LIST
	/* save name to goto */
	memcpy (hwscnhp, usname, 8);	/* move 8 bytes of label */
         SBM       7,GOTOCB        FLAG THAT WE HAVE FOUND THE ITEM
         BU        GOTOPC          SCAN REST OF LIST
         SPACE
GOTOPD   TBM       7,GOTOCB        HAVE WE FOUND THE PLACE IN THE LIST
         BNS       NEXT         NO-GOTO NOT TO BE DONE THEN
GOTOPE   BL        YEANAY          CHECK WHETHER ASSEMBLY IS ALLOWED
	if (!yeanay()) return;	/* if not assembling return */
	memcpy (lablscan, hwscnhp, 8);	/* save labelto scan for */
	macstate |= CONDSCAN;		/* show we are in a conditional scan */
	return;			/* do next input line */

         TITLE     READ-ONLY       DEFMPRO
DEFMPRO  TBM       CONDSCAN,macstate   ARE WE SKIPPING SOURCE?
         BS        DEFMPROE     YES.
         TBM       RSCAN,macstate      ARE WE IN A REPT SCAN?
         BS        DEFMPROE     YES.
         TBM       EXPAND,macstate     ARE WE EXPANDING?
         BS        DEFMPROB         YES.
         TBM       DEFMBODY,macstate   ARE WE IN A PROTO BODY?
         BNS       DEFMPRO1         NO.
DEFMPROB equ	$
	  seterr ('A');		/* set addressing error */
DEFMPROE LW        1,=X'80080000'  TERM ON A SPACE OR COMMA.
         BL        UNST            UNSTRING ONE PARAMETER.
         LB        6,hbstac        GET THE TERMINATOR.
         CI        6,G' '          WAS IT A SPACE?
         BNE       DEFMPROE     NO-CONTINUE UNSTRINGING PARAMETERS.
         BU        NEXT
         SPACE
DEFMPRO1 TBM       7,PASS        WHICH PASS ARE WE IN?
         BS        $+3W         PASS 1.
         SBM       DEFFRM2,SPMAC   SET PASS 2 DEFM-FORM BIT.
         BU        DEFMPRO3        DON'T RE-ENTER NAME IN SYM TAB.
         LA        R6,STACK        GET PARAMETER STACK ADDR
         STW       R6,STACKP       RESET POINTER
         LND       4,label        THE NEGATED UNSTRUNG FORM NAME
         ZR        R1              CLEAR R1                     S880752
         LI        R1,TYMACDEF     GET MACRO DEF. TYPE CODE     S880752
         SLL       R1,24           POSITION IN REGISTER         S880752
         BL        SS              ENTER IT INTO SYMBOL TABLE
         LW        R1,CURRP        GET STACK POINTER            S880752
         ADI       R1,7B           ROUND TO NEXT DOUBLE WORD BOUND
         ANMW      R1,=X'00FFFFF8' FORCE DOUBLE WORD BOUND
         STW       R1,CURRP        DOUBLE WORD BOUND STACK POINTER
         STW       R1,HEAD         INITIALIZE THIS HEAD CELL
         ADI       R1,6W           HEADER SIZE
         STW       R1,CURRP        UPDATE CURR POINTER          S880752
         CAMW      R1,HIGH         SEE IF OUT OF ROOM IN MAP
         BLT       DEFX2           BR IF ROOM AVAILABLE
         SVC       1,X'69'         GET ANOTHER MAP BLOCK
         TRR       R3,R3           SET CC'S
         BZ        MNOK            BR IF MEM NOT AVAILABLE
         STW       R4,HIGH         UPDATE NEW HIGH ADDR
DEFX2    CEQU      $                                            ESCT-32
         ZMW       DEFCNT          ZERO NUMBER OF NEW MACRO CHARS COUNT
         LW        R2,HEAD         GET CURRENT HEAD CELL ADDR
         STW       R2,HWMSP        SAVE IN PROTOTYPE POINTER    S880752
         LI        R6,TYMACDEF     GET MACRO TYPE CODE          S880752
         STB       R6,HWMSP        SAVE IN ENTRY                S880752
         LW        R1,SYMCURRP     GET CURRENT ENTRY POINTER    S880752
         LW        R6,HWMSP        GET PROTOTYPE POINTER        S880752
         STW       R6,4W,R1        PUT PROTOTYPE PNTR IN ENTRY  S880752
         LD        R6,label       GET MACRO NAME
         STD       R6,2W,R2        SAVE MACRO NAME
         ZMD       0W,R2           CLEAR HEAD CELL POINTERS
         ZMD       4W,R2                CLEAR COUNT AND STRING WORD
DEFMPRO3 LW        1,=X'80080000'  SP AND ,
         BL        UNST            UNSTRING ONE PROTOTYPE PARAMETER
         LW        4,usname        GET THE WORD FROM INPUT
         CAMW      4,=C'    '      CHECK FOR NOTHING THERE
         BEQ       DEFMPRO5     NO MORE ARGUMENTS IN LIST
         TBM       DEFFRM2,SPMAC   IN PASS 2 DEFM-FORM SCAN?
         BS        DEFMPRO7     YES.
         LD        4,usname        THE DUMMY ARGUMENT NAME
         LW        R1,STACKP       GET PARAMETER STACK ADDR
         STW       R4,0W,R1        PLACE ITEM INTO STACK
         STW       R5,1W,R1        AND SECOND WORD OF FORMAL NAME
         ABM       28,STACKP       INCREMENT THE STACK POINTER
         ABM       7,DEFCNT        INCR NUM PARAMETERS FOUND
DEFMPRO7 LB        4,hbstac        GET THE TERMINATOR
         CI        4,G','          THIS MEANS MORE PARAMETERS
         BEQ       DEFMPRO3     GO GET THE REMAINING PARAMETERS
DEFMPRO5 SBM       DEFMBODY,macstate    SHOW WE ARE NOW GOING INTO BODY
         BU        NEXT            LET THE PROTYPE BODY COME IN
         TITLE     READ-ONLY       ENDMPRO
ENDMPRO  TBM       EXPAND,macstate   CHECK FOR EXPANSION ON
         BS        ENDM6        WE ARE EXPANDING A MACRO
         TBM       DEFMBODY,macstate    CHECK IF WE ARE IN A BODY
         BS        ENDM11       YES-NO ERROR
         TBM       CONDSCAN,macstate   ARE WE SKIPPING SOURCE?
         BS        NEXT         YES.
         TBM       RSCAN,macstate      ARE WE IN A REPT SCAN?
         BS        NEXT         YES.
ENDM5    equ	$
	  seterr ('A');		/* set addressing error */
         BU        ENDM10          EQU
         SPACE
ENDM6    LW        R1,STACKP       POINTER TO NAME STACK FOR PROTOTYPE
         SUI       R1,2W           CONTRACT THE POINTER IN THE STACK.
         STW       R1,STACKP       DUMP LAST MACRO DEFINATION
         SPACE
******ADD CODE FOR REPT HERE *******
         SPACE
         CAMW      R1,=A(STACK)     HAVE WE REACHED BOTTOM OF STACK?
         BEQ       ENDM6.3      YES.
         LW        4,LEVEL         IS MACRO DEPTH LEVEL IN REPT ZERO?
         BEQ       ENDM8        YES.
         LI        4,-1            DECREMENT FIELD.
         ARMW      4,LEVEL         DECREAS MACRO DEPTH LEVEL WITHIN REPT
         BU        ENDM8           KEEP LOOKING FOR PROTO PTR.
         SPACE
***** ADD CODE FOR REPT HERE*******
         SPACE
ENDM6.3  ZMW       LEVEL           ZERO MACRO DEPTH LEVEL WITHIN REPT
         LA        R1,STK          PAR STACK ADDR
         STW       R1,STKP         RESET POINTER
         LA        R1,STACK        MACRO LEVEL STACK
         STW       R1,STACKP       REINIT POINTER
         STW       R1,MPP          INIT STACKP FOR THIS LEV
         ZMB       macstate        ZERO OUT ALL MACRO STATUS BITS
         BU        ENDM10          ALL DONE WITH MACRO EXPANSION
         SPACE
ENDM8    SUI       R1,2W           POINT TO PREVIOUS LEVEL
         LB        R5,0W,R1        GET PARAMETER COUNT FOR PREVIOUS LEV
         MPI       R4,3D           MAKE DOUBLE WORD OFFSET
         ADMW      R5,0W,R1        CALC NEW STKP
         STW       R5,STKP         NEW EXPANSION STORAGE
         STW       R1,MPP          THIS LEVEL STACKP
         LW        R4,1W,R1        ADDR OF MACRO STORAGE AREA
         STW       R4,hwcmac       RESTORE MACRO POINTER
ENDM10   ZBM       DEFMBODY,macstate   CLEAR MACRO BODY FLAG
         ZBM       DEFFRM2,SPMAC   CLEAR PASS 2 DEFM-FORM BIT.
         BU        NEXT            DONE WITH ENDM
         SPACE
ENDM11   LA        R1,STACK        MACRO LEVEL STACK
         STW       R1,STACKP       REINIT POINTER
         ZBM       DEFFRM2,SPMAC   TEST FOR PASS 2 DEF BODY
         BS        ENDM10          BR IF PASS 2
         LW        R2,MACP         CONT OF MAC POINTER
         BNZ       ENDMIT          BR IF INITIALIZED
         LW        R2,HEAD         GET STACK POINTER
         STW       R2,MACP         PUT IN MAC POINTER
ENDMIT   LW        R1,HEAD         GET NEW ENTRY ADDRESS
         LW        R7,DEFCNT       GET COUNT OF BYTES/PARMS IN MACRO
         STW       R7,4W,R1        PUT IN STACK FOR LATER
         LD        R4,MACRO,R1    GET MACRO FROM NEW ENTRY
EN15     CAMD      R4,MACRO,R2    COMPARE AGAINST LAST NODE ENTRY
         BLT       EN50            NEW .LT. LAST
         BEQ       EN95            THEY ARE .EQ. (SHOULDN'T HAPPEN)
         LW        R3,RLINK,R2     NEW .GT. LAST, FOLLOW ASSENDING LINK
         BZ        EN90            ZERO MEANS END OF BRANCH
EN30     TRR       R3,R2           GENERATE PATH POINTER
         BU        EN15            GO TRY NEXT BRANCH NODE
         SPACE
EN50     LW        R3,LLINK,R2     GET DECENDING PATH
         BNZ       EN30            IF NOT END, GO UPDATE
         STW       R1,LLINK,R2     UPDATE LINK IN PREVIOUS NODE
         BU        EN95            GO CLEAR NEW ENTRY NODE POINTERS
EN90     STW       R1,RLINK,R2     UPDATE RLINK IN PREVIOUS NODE
EN95     ZMW       RLINK,R1        CLEAR NEW ENTRY NODE POINTERS
         ZMW       LLINK,R1        DITTO
*                                  NOW GO TRANSFER TO USER
         BU        ENDM10
         SPACE
EXITMP   BL        YEANAY          CHECK FOR ASSEMBLY ALLOWED
	if (yeanay()) {	/* are we assembling */
         BNS       NEXT         DONT PROCESS THIS EXITM
         TBM       EXPAND,macstate   ARE WE EXPANDING A MACRO NOW
         BS        ENDM6        YES-THEN TERMINATE IT EARLY
         BU        ENDM5           NO-THEN WE HAVE AN ERROEOUS EXITM
         TITLE     READ-ONLY       FORMP
FORMP    BL        YEANAY          CHECK WHETHER ASSEMBLY IS ALLOWED
	if (yeanay()) {	/* are we assembling */
         BNS       FORMP3       DONT ASSEMBLE
         TBM       EXPAND,macstate  ARE WE EXPANDING?
         BS        $+3W         YES--ERROR.
         TBM       RPTGEN,macstate  ARE WE GENERATING REPT CODE?
         BNS       FORMP2.5     NO.
	  seterr ('A');		/* set addressing error */
FORMP2   LW        1,=X'80080000'   TERM ON A SPACE OR COMMA
         BL        UNST            UNSTRING ONE BIT LENGTH DESCRIPTOR.
         CI        7,G','          ARE WE FINISHED?
         BEQ       FORMP2       NO--FINISH UNSTRINGING.
         BU        NEXT
         SPACE
FORMP2.5 CEQU      $    $                                       ESCT-32
         TBM       7,PASS        WHICH PASS ARE WE IN?
         BS        $+3W         PASS 1.
         SBM       DEFFRM2,SPMAC   SET PASS 2 DEFM-FORM BIT.
         BU        FORMP3          DON'T RE-ENTER NAME IN SYM TAB.
         LND       R4,label       GET NEGATED FORM NAME        S880752
         ZR        R1                                           S880752
         LI        R1,TYFRM        GET FORM DEF. TYPE CODE      S880752
         SLL       R1,24           POSITION IN REGISTER         S880752
         BL        SS              ALLOCATE SYMTAB ENTRY        S880752
         LW        R1,CURRP        GET STACK POINTER            S880752
         ADI       R1,7B           ROUND TO NEXT DOUBLE WORD BOUND
         ANMW      R1,=X'00FFFFF8' FORCE DOUBLE WORD BOUND
         STW       R1,CURRP        DOUBLE WORD BOUND STACK POINTER
         STW       R1,HEAD         INITIALIZE THIS HEAD CELL
FORMX1   CEQU      $                                            ESCT-32
         CAMW      R1,HIGH         SEE IF OUT OF ROOM IN MAP
         BLT       FORMX2          BR IF ROOM AVAILABLE
         SVC       1,X'69'         GET ANOTHER MAP BLOCK
         TRR       R3,R3           SET CC'S
         BZ        MNOK            BR IF MEM NOT AVAILABLE
         STW       R4,HIGH         UPDATE NEW HIGH ADDR
FORMX2   CEQU      $                                            ESCT-32
         ZMW       DEFCNT          ZERO NUM OF NEW MACRO CHARS  S880752
         LW        R2,HEAD         GET CURRENT HEAD CELL ADDR
         STW       R2,HWMSP        SAVE POINTER TO MACRO PROTOTYPE IN EX
         LI        4,TYFRM         TYPE CODE FOR A FORM STATEMENT
         STB       4,HWMSP         DEFINE THE MACRO STORAGE POINTER AS F
         LND       4,label        THE NEGATED UNSTRUNG PROTOTYPE NAME
         LW        1,HWMSP         WHERE IT IS WITHIN MACRO STORAGE
         LW        R2,SYMCURRP     GET CURRENT ENTRY POINTER    S880752
         STW       R1,4W,R2        PUT PROTOTYPE PNTR IN ENTRY  S880752
FORMP3   LI        2,2             INDICATE NOTHING UNSTRUNG YET
         BL        VAL             EVALUATE THE BIT  LENGTH
         ANMW      7,=X'000FFFFF'  LOOK ONLY AT THE VALUE
         CI        7,254           NO MORE THAN 254 BITS ALLOWED
         BGT       FORMPE       ERROR IF OUT OF THE RANGE
         SBM       FORMSCAN,inptstat  SET THE FORM SCAN STATE
         BL        YEANAY          CHECK MODE
	if (yeanay()) {	/* are we assembling */
         BNS       $+2W         DONT ASSEMBLE
         BL        MBYT            COPY THE THING OUT
         ZBM       FORMSCAN,inptstat   WIPE OUT FORM TRACES
         LB        7,hbstac        GET THE TERMINATOR
         CI        7,G'",'         CHECK FOR A CONTINUING MARK
         BEQ       FORMP3       WE HAVE ONE
         SBM       FORMSCAN,inptstat  SET THE FORM SCAN STATE
         LI        7,X'FF'         TERMINATOR CHARACTER
         BL        YEANAY          CHECK MODE
	if (yeanay()) {	/* are we assembling */
         BNS       $+2W         DONT ASSEMBLE
         BL        MBYT            COPY OUT THE TERMINATOR
         ZBM       FORMSCAN,inptstat   WIPE OUT FORM TRACES
         ZBM       DEFFRM2,SPMAC   CLEAR PASS 2 DEFM-FORM BIT.
         BU        NEXT            GO GET NEXT STATEMENT
*
         SPACE
FORMPE   CEQU      $                                            ESCT-32
	if (yeanay()) {	/* are we assembling */
	  seterr ('H');		/* set defm/form error */
	}
         ZBM       DEFFRM2,SPMAC   CLEAR PASS 2 DEFM-FORM BIT.
         BU        NEXT            CANT DO ANYTHING WITH IT
         TITLE     READ-ONLY       REPTP
REPTP    CEQU      $                                            ESCT-32
         ZBM       RSCAN,macstate  ARE WE ALREADY IN A REPT SCAN
         BS        REPTPE       ERROR
	tall();			/* allocate current label */
         LI        2,2             INDICATE TO SKIP SPACES AND UNSTRING
         ZBM       0,VALUNDF       INSURE VALID TEST
         BL        VAL             GET HOW MANY TIMES WE SHOULD REPEAT
         ZBM       0,VALUNDF       WAS VAL UNDEFINED
         BNS       $+2W            BR IF NOT
         ZR        R7              SET REPT COUNT TO ZERO FOR UNDEFINED
         STH       7,HHRCOUNT      SAVE THAT COUNT
         TBM       DEFMBODY,macstate     CHECK FOR BEING IN MIDDLE OF DE
         BS        NEXT         WE ARE IN A DUMMY MACRO-IGNORE THIS S
         TBM       CONDSCAN,macstate   CHECK FOR CONDITIONAL ASSEMBLY.
         BS        NEXT         CONDITIONAL ASSEMBLY--IGNORE THIS.
         ZMH       HHRDCOLC        ZERO TIMES THROUGH COUNTER
         SBM       RSCAN,macstate    INDICATE WE ARE REPEAT SCANNING
         LW        R1,CURRP        GET STACK POINTER            S880752
         ADI       R1,7B           ROUND TO NEXT DOUBLE WORD BOUND
         ANMW      R1,=X'00FFFFF8' FORCE DOUBLE WORD BOUND
         STW       R1,CURRP        DOUBLE WORD BOUND STACK POINTER
         STW       R1,HEAD         INITIALIZE THIS HEAD CELL
         CAMW      R1,HIGH         SEE IF OUT OF ROOM IN MAP
         BLT       REPTX2          BR IF ROOM AVAILABLE
         SVC       1,X'69'         GET ANOTHER MAP BLOCK
         TRR       R3,R3           SET CC'S
         BZ        MNOK            BR IF MEM NOT AVAILABLE
         STW       R4,HIGH         UPDATE NEW HIGH ADDR
REPTX2   ZMW       DEFCNT          ZERO NUMBER OF NEW MACRO CHARS COUNT
         LW        R2,HEAD         GET CURRENT HEAD CELL ADDR
         STW       R2,HWMSP        SAVE POINTER TO REPT CODE STORAGE
         STW      R2,HWREPSS       HOLDS BASE POINT OF REPEATED CODE
         BU        NEXT            GO GET NEXT STATEMENT
         SPACE
REPTPE   CEQU      $                                            ESCT-32
	  seterr ('Y');		/* set rept error */
         BU        NEXT
         TITLE     READ-ONLY       ENDRP
ENDRP    CEQU      $                                            ESCT-32
         TBM       DEFMBODY,macstate     CHECK FOR BEING IN MIDDLE OF DE
         BS        NEXT         WE ARE IN A DUMMY MACRO-IGNORE THIS S
         TBM       CONDSCAN,macstate   CHECK FOR CONDITIONAL ASSEMBLY.
         BNS       ENDRP1       NO.
         ZBM       RPTGEN,macstate ARE WE IN REPEATED GENERATION?
         BNS       NEXT         NO--IGNORE THIS.
         BU        ENDRF           GO TERMINATE REPEATED GENERATION.
ENDRP1   CEQU      $                                            ESCT-32
         ZBM       RPTGEN,macstate CHECK FOR BEING IN REPEATED GENERATIO
         BS        ENDRPR       A NEW PASS-FIDDLE WITH COUNTS
         ZBM       RSCAN,macstate  CHECK FOR A PREVIOUS REPT
         BNS       REPTPE       NOT SO-ERRORONEOUS ENDR
         TBM       EXPAND,macstate  ARE WE EXPANDING A MACRO NOW
         BNS       ENDRPR       NO--NO LEVLEL MANIPULATION TO BE DONE
         SBM       MACREP,macstate INDICATE A REPEAT WITHIN AN EXPANSION
         ZMW       LEVEL           SHOW NO EXPANSIONS WITHIN REPT YET
ENDRPR   CEQU      $                                            ESCT-32
         ABM       15,HHRDCOLC     COUNT THE NUMBER OF TIME  REPEATED
         LH        7,HHRCOUNT      NUMBER OF TIMES LEFT TO REPEAT
         SUI       7,1             TAKE   IT DOWN BY ONE
         BLT       ENDRF        FINISHED   IF NOW LESS THAN ZERO
         STH       7,HHRCOUNT      THE NEW COUNT
         SBM       RPTGEN,macstate    FLAG A GENERATE SCAN TO FOLLOW
         LW        4,HWREPSS       HOLDS BASE POINT OF REPEATED CODE
         STW       4,HWREPSP       TEMPORARY POINTER FOR USE BY INPT
         BU        NEXT            GO GET NEXT STATEMENTFOR REPETITION
         SPACE
ENDRF    CEQU      $                                            ESCT-32
         ZBM       MACREP,macstate   END    A REPEAT WITHIN AN EXPANSION
         LW        4,HWREPSS       THE BASE OF THE REPEATED CODE
         STW       4,HWMSP         GIVE THE REPEAT STORAGE BACK
         BU        NEXT            GO GET THE NEXT STATEMENT

         TITLE     READ-ONLY       MBYT
*        RECEIVE BYTE OF PROTOTYPE FOR STORAGE
         SPACE
MBYT     TBM       RSCAN,inptstat      TEST FOR REPEAT SCAN
         BS        MBYT1           GO STORE IF YES
         TBM       DEFFRM2,SPMAC   IN PASS 2 DEFM-FORM SCAN?
         BS        MBYT3        YES.
         TBM       DEFMBODY,inptstat    IN DEFM
         BS        MBYT1           BR IF YES
         TBM       FORMSCAN,inptstat    IN FORM DEF
         BNS       MBYT3           BR IF NOT
MBYT1    ABM       31,DEFCNT        COUNT BYTES.
         STF       R0,LIBREG       SAVE THE REGS
         LW        1,CURRP         POINTER TO PROTOTYPE STORAGE
         STB       R7,0B,R1        SAVE THE PROTOTYPE BYTE
         ABM       31,CURRP        UPDATE STACK POINTER
         LW        R2,CURRP        GET CURR STACK POINTER
         CAMW      R2,HIGH         WILL WE GO OVER END WITH THIS REC?
         BLE       MBYT2           BR IF STILL ROOM
         SVC       1,X'69'         GET ANOTHER MAP BLOCK
         TRR       R3,R3           TEST FOR OK
         BZ        MNOK            BR IF NO MORE MEM AVAILABLE
         STW       R4,HIGH         SAVE NEW ENDING ADDR
MBYT2    LF        R0,LIBREG       UNSV CALLERS REGS
MBYT3    TRSW      0               RETURN

         TITLE     READ-ONLY       VFDO
* PACKER OF VARIABLE SIZE BIT FIELDS AND ISSUER OF FULL BYTES
* INPUT - R6 CONTAINS RIGHT JUSTIFIED DATA
*      - R7 CONTAINS NUMBER OF BITS TO BE PACKED (1-8)
         SPACE
VFDO     CEQU      $                                            ESCT-32
         STW       1,VFDOS1        SAVE X1
         STW       0,VFDOS0        SAVE RETURN ADDRESS
         LH        2,HHVFX         OLD BYTE STACK
         TRR       6,3             INPUT BITS FOR STACK
         TRR       7,5             NUMBER OF BITS
         ADMH      5,DSRC          DUMMY SHIFT INST + NUMBER OF SHIFTS
         EXRR      5               SHIFT TO POS BITS IN UPPER OF R3
         TRR       7,5             NUMBER OF BITS AGAIN
         ADMH      5,DSLLD         DUMMY SHIFT + NUMBER OF SHIFTS
         EXRR      5               SHIFT TO GET NEW BIT STACK IN R2
         STH       2,HHVFX         NEW BIT STACK
         ARMH      7,HHVFO         INCR NUMBER OF BITS IN STACK COUNT
         ARMH      7,HHVFGB        INCR NUMBER OF BITS RELEASED
         ABM       12,HHVFF        INCREASE NUMBER OF BITS IN
         LH        3,HHVFO         NUMBER OF BITS IN STACK
         CI        3,8             DO WE HAVE A FULL BYTE TO RELEASE
         BCF       GE,*VFDOS0      NO, RETURN
         ANMW      3,=7            GET NUMBER OF BITS LEFT AFTER ISSUE
         STH       3,HHVFO         POINTS TO THE BYTE TO BE ISSUED
         LH        5,HHVFS         NUMBER OF BITS REQD
         CAMH      5,HHVFGB        NUMBER OF GOOD BITS DONE
         BNE       VFDF         NOT AT END,IGNORE REL,EXT,COM CHECKS
         LH        6,HHVFO         NUMBER OF BITS LEFT IN STACK
         BNE       VFDC         SOME BITS LEFT
	r6 = sectpc[pcmode] & 3;	/* get last 2 bit of PC */
         SUI       6,3             MUST BE AT LAST BYTE FOR REL,EXT,COM
         BLT       VFDC         NOT THERE,ENSURE PROG ABS TYPE
         CI        5,19            MIN FIELD SIZE FOR REL,EXT,COM
*                                  COMPARED WITH NUMBER OF BITS REQUEST
         BLT       VFDC         TOO SMALL FORE RELOCATION
         CI        5,32            MAX FIELD SIZE FOR RELOCATION
         BGT       VFDC
         LW        6,HWINAC        FRESULT OF ANY ADR ATTRIBUTION
         STW       6,HWEVAL        ALLOW LOADER TO EXAMINE IN MAKING WRD
         ZBR       6,0             CLEAR DSECT/CSECT FLAG
         SRL       6,24            POSITION TYPE CODE FOR COMPARE
         CI        6,TYPC          COMMON REF TYPE.
         BNE       VFDL.1          NO
         LB        7,HWINACBN      THE BLOCK NUMBER FOR THE EXPRESSION
         STB       7,HBBN          IF ANY IS SAVED FOR OUTPUT
         BU        VFDF
VFDL.1   LW        7,SECNUMAC      SECTION NUMBER, IF ANY
         STB       7,HBBN          STORE LATER OUTPUT
VFDF     LH        2,HHVFX         GET BIT STACK
         ADMH      3,DSRL          NUMBER OF BITS TO REMAIN + DUMMY SHFT
         EXRR      3               SHIFT OFF BITS TO REMAIN
         TRR       2,6             BYTE TO R6 FOR IGEN
	igen (---);		/* gen a byte */
         BL        IGEN            RELEASE BYTE
         LW        1,VFDOS1        UNSV X1
         BU        *VFDOS0         RETURN
VFDC     LH        6,HWINAC        TYPE + GARBAGE
         SRL       6,7             DUMP GARBAGE
         TRR       6,6             SET CC BITS
         BEQ       VFDF         NULL TYPE OK FOR ALL CASES
         SUMB      6,VDTO          IS IT ABSOLUTE TYPE
         BEQ       VFDF         ABSOLUTE TYPE OK
	if (yeanay()) {	/* are we assembling */
	  seterr ('R');		/* set relocation error */
	}
         BU        VFDF
