/* opstab.c */

#include "defs.h"
#include <string.h>

#ifdef DOS
struct optab *opscan(char *);
void	opinit();
void	xopinit(struct optab *);
#endif

/* The opcode table provides information for translation of the
 * instruction into it's binary for.  The table is a linked list
 * with forward and backward pointers to elements.  Each entry
 * has the following form:
 *
 * word 0	rlink - opcode entry address of the next alphabetically
 *			entry greater in value than current node
 * word 1	llink - opcode entry address of the next alphabetically
 *			entry lesser in value than the current node
 * word 2	opcode- the opcode in uppercase ascii form
 * word 3	info  - this word is split into 6 fields
 *  8 bits	binop - the left 6 bits is the binary form of the opcode
 *			the right 2 bits is the bounding flags:
 *				00 - for byte or none
 *				01 - for halfword
 *				10 - for word
 *				11 - for doubleword
 *  4 bits	aug	 - the 4 bit augment code if any
 *  4 bits	varcode  - the address variant code used for setting the
 *			   proper F & C bits
 *  4 bits	fieldnum - the field number in which relative, common, or
 *			   external addressing is allowed
 *  4 bits	subaug   - sub element coding with following flags:
 *				leftmost bit - check argument 1 for even
 *				    next bit - check argument 2 for even
 *				 next 2 bits - min/max arg cnt table offset
 *  8 bits	opproc   - the function number to use for this opcode
 */

struct optab opstab[] = {
/* these next 9 entries must not be moved, they are modified */
/* at execution time based on mode seis or reis being in effect */
 0, 0, "LCB", 0x00, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "LCH", 0x00, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "LCW", 0x00, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "LCD", 0x00, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "STCB", 0x00, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "STCH", 0x00, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "STCW", 0x00, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "STCD", 0x00, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "LCRA", 0x00, 0x0, 0x4, 0x2, 0x3, 15

,0, 0, "LPSD", 0xFA, 0x3, 0x2, 0x1, 0x1, 16
,0, 0, "LB", 0xAE, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "LH", 0xAE, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "LW", 0xAE, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "LD", 0xAE, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "STB", 0xD6, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "STH", 0xD6, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "STW", 0xD6, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "STD", 0xD6, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "LNB", 0xB6, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "LNH", 0xB6, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "LNW", 0xB6, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "LND", 0xB6, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "LMB", 0xB2, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "LMH", 0xB2, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "LMW", 0xB2, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "LMD", 0xB2, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "STMB", 0xDA, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "STMH", 0xDA, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "STMW", 0xDA, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "STMD", 0xDA, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "ADMB", 0xBA, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "ADMH", 0xBA, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "ADMW", 0xBA, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "ADMD", 0xBA, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "SUMB", 0xBE, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "SUMH", 0xBE, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "SUMW", 0xBE, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "SUMD", 0xBE, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "CAMB", 0x92, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "CAMH", 0x92, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "CAMW", 0x92, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "CAMD", 0x92, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "CMMB", 0x96, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "CMMH", 0x96, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "CMMW", 0x96, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "CMMD", 0x96, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "ANMB", 0x86, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "ANMH", 0x86, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "ANMW", 0x86, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "ANMD", 0x86, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "ORMB", 0x8A, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "ORMH", 0x8A, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "ORMW", 0x8A, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "ORMD", 0x8A, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "EOMB", 0x8E, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "EOMH", 0x8E, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "EOMW", 0x8E, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "EOMD", 0x8E, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "ARMB", 0xEA, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "ARMH", 0xEA, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "ARMW", 0xEA, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "ARMD", 0xEA, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "BGT", 0xEE, 0x2, 0x1, 0x1, 0x1, 16
,0, 0, "BLT", 0xEE, 0x3, 0x1, 0x1, 0x1, 16
,0, 0, "BEQ", 0xEE, 0x4, 0x1, 0x1, 0x1, 16
,0, 0, "BGE", 0xEE, 0x5, 0x1, 0x1, 0x1, 16
,0, 0, "BLE", 0xEE, 0x6, 0x1, 0x1, 0x1, 16
,0, 0, "BNE", 0xF2, 0x4, 0x1, 0x1, 0x1, 16
,0, 0, "BOV", 0xEE, 0x1, 0x1, 0x1, 0x1, 16
,0, 0, "BP", 0xEE, 0x2, 0x1, 0x1, 0x1, 16
,0, 0, "BN", 0xEE, 0x3, 0x1, 0x1, 0x1, 16
,0, 0, "BZ", 0xEE, 0x4, 0x1, 0x1, 0x1, 16
,0, 0, "BNOV", 0xF2, 0x1, 0x1, 0x1, 0x1, 16
,0, 0, "BNP", 0xF2, 0x2, 0x1, 0x1, 0x1, 16
,0, 0, "BNN", 0xF2, 0x3, 0x1, 0x1, 0x1, 16
,0, 0, "BNZ", 0xF2, 0x4, 0x1, 0x1, 0x1, 16
,0, 0, "BS", 0xEE, 0x1, 0x1, 0x1, 0x1, 16
,0, 0, "BNS", 0xF2, 0x1, 0x1, 0x1, 0x1, 16
,0, 0, "BANY", 0xEE, 0x7, 0x1, 0x1, 0x1, 16
,0, 0, "BAZ", 0xF2, 0x7, 0x1, 0x1, 0x1, 16
,0, 0, "DATAB", 0x00, 0x0, 0x0, 0x0, 0x0, 29
,0, 0, "DATAH", 0x01, 0x0, 0x0, 0x0, 0x0, 29
,0, 0, "DATAW", 0x02, 0x0, 0x0, 0x0, 0x0, 29
,0, 0, "DATAD", 0x03, 0x0, 0x0, 0x0, 0x0, 29
,0, 0, "BEI", 0x01, 0x6, 0x0, 0x0, 0x0, 1
,0, 0, "UEI", 0x01, 0x7, 0x0, 0x0, 0x0, 1
,0, 0, "EWCS", 0x02, 0xA, 0x0, 0x0, 0x0, 1
,0, 0, "RWCS", 0x01, 0xB, 0x0, 0x0, 0x2, 6
,0, 0, "WWCS", 0x01, 0xC, 0x0, 0x0, 0x2, 6
,0, 0, "JWCS", 0xFA, 0x4, 0x0, 0x1, 0x1, 16
,0, 0, "SVC", 0xCA, 0x6, 0x0, 0x0, 0x1, 72
,0, 0, "LEAR", 0x82, 0x0, 0x4, 0x2, 0x3, 15
,0, 0, "SIO", 0xFE, 0x7, 0x2, 0x0, 0x3, 74
,0, 0, "TIO", 0xFE, 0x7, 0x3, 0x0, 0x3, 74
,0, 0, "HIO", 0xFE, 0x7, 0x6, 0x0, 0x3, 74
,0, 0, "GRIO", 0xFE, 0x7, 0x7, 0x0, 0x3, 74
,0, 0, "ECI", 0xFE, 0x7, 0xC, 0x0, 0x3, 74
,0, 0, "DCI", 0xFE, 0x7, 0xD, 0x0, 0x3, 74
,0, 0, "ACI", 0xFE, 0x7, 0xE, 0x0, 0x3, 74
,0, 0, "DACI", 0xFE, 0x7, 0xF, 0x0, 0x3, 74
,0, 0, "LA", 0x36, 0x0, 0x4, 0x2, 0x3, 15
,0, 0, "LMAP", 0x2E, 0x7, 0x2, 0x0, 0x0, 20
,0, 0, "EAE", 0x01, 0x8, 0x0, 0x0, 0x0, 1
,0, 0, "DAE", 0x01, 0xE, 0x0, 0x0, 0x0, 1
,0, 0, "LCS", 0x01, 0x3, 0x0, 0x0, 0x0, 7
,0, 0, "ES", 0x01, 0x4, 0x0, 0x0, 0x8, 7
,0, 0, "RND", 0x01, 0x5, 0x0, 0x0, 0x8, 7
,0, 0, "HALT", 0x01, 0x0, 0x0, 0x0, 0x0, 1
,0, 0, "WAIT", 0x01, 0x1, 0x0, 0x0, 0x0, 1
,0, 0, "NOP", 0x01, 0x2, 0x0, 0x0, 0x0, 1
,0, 0, "SIPU", 0x01, 0xA, 0x0, 0x0, 0x0, 1
,0, 0, "SEA", 0x01, 0xD, 0x0, 0x0, 0x0, 1
,0, 0, "CEA", 0x01, 0xF, 0x0, 0x0, 0x0, 1
,0, 0, "ANR", 0x05, 0x0, 0x0, 0x0, 0x2, 6
,0, 0, "ORR", 0x09, 0x0, 0x0, 0x0, 0x2, 6
,0, 0, "ORRM", 0x09, 0x8, 0x0, 0x0, 0x2, 6
,0, 0, "EOR", 0x0D, 0x0, 0x0, 0x0, 0x2, 6
,0, 0, "EORM", 0x0D, 0x8, 0x0, 0x0, 0x2, 6
,0, 0, "ZR", 0x0D, 0x0, 0x0, 0x0, 0x0, 12
,0, 0, "CAR", 0x11, 0x0, 0x0, 0x0, 0x2, 6
,0, 0, "CMR", 0x15, 0x0, 0x0, 0x0, 0x2, 6
,0, 0, "SBR", 0x19, 0x0, 0x0, 0x0, 0x2, 9
,0, 0, "ZBR", 0x1D, 0x0, 0x0, 0x0, 0x2, 9
,0, 0, "ABR", 0x21, 0x0, 0x0, 0x0, 0x2, 9
,0, 0, "TBR", 0x25, 0x0, 0x0, 0x0, 0x2, 9
,0, 0, "TRSW", 0x29, 0x0, 0x0, 0x0, 0x0, 8
,0, 0, "TRCC", 0x29, 0x5, 0x0, 0x0, 0x0, 7
,0, 0, "TCCR", 0x29, 0x4, 0x0, 0x0, 0x0, 7
,0, 0, "TRR", 0x2D, 0x0, 0x0, 0x0, 0x2, 6
,0, 0, "TRBR", 0x2D, 0x1, 0x0, 0x0, 0x2, 6
,0, 0, "TBRR", 0x2D, 0x2, 0x0, 0x0, 0x2, 6
,0, 0, "TRC", 0x2D, 0x3, 0x0, 0x0, 0x2, 6
,0, 0, "TRN", 0x2D, 0x4, 0x0, 0x0, 0x2, 6
,0, 0, "XCR", 0x2D, 0x5, 0x0, 0x0, 0x2, 6
,0, 0, "XCBR", 0x29, 0x2, 0x0, 0x0, 0x2, 6
,0, 0, "TRRM", 0x2D, 0x8, 0x0, 0x0, 0x2, 6
,0, 0, "TRCM", 0x2D, 0xB, 0x0, 0x0, 0x2, 6
,0, 0, "TRNM", 0x2D, 0xC, 0x0, 0x0, 0x2, 6
,0, 0, "XCRM", 0x2D, 0xD, 0x0, 0x0, 0x2, 6
,0, 0, "TRSC", 0x2D, 0xE, 0x0, 0x0, 0x2, 6
,0, 0, "TSCR", 0x2D, 0xF, 0x0, 0x0, 0x2, 6
,0, 0, "CALM", 0x32, 0x0, 0x0, 0x0, 0x0, 4
,0, 0, "ADR", 0x39, 0x0, 0x0, 0x0, 0x2, 6
,0, 0, "ADRM", 0x39, 0x8, 0x0, 0x0, 0x2, 6
,0, 0, "SUR", 0x3D, 0x0, 0x0, 0x0, 0x2, 6
,0, 0, "SURM", 0x3D, 0x8, 0x0, 0x0, 0x2, 6
,0, 0, "MPR", 0x41, 0x0, 0x0, 0x0, 0x6, 6
,0, 0, "DVR", 0x45, 0x0, 0x0, 0x0, 0x6, 6
,0, 0, "NOR", 0x61, 0x0, 0x0, 0x0, 0x2, 11
,0, 0, "NORD", 0x65, 0x0, 0x0, 0x0, 0xA, 11
,0, 0, "SCZ", 0x69, 0x0, 0x0, 0x0, 0x2, 11
,0, 0, "SLA", 0x6D, 0x1, 0x0, 0x0, 0x2, 10
,0, 0, "SRA", 0x6D, 0x0, 0x0, 0x0, 0x2, 10
,0, 0, "SLL", 0x71, 0x1, 0x0, 0x0, 0x2, 10
,0, 0, "SRL", 0x71, 0x0, 0x0, 0x0, 0x2, 10
,0, 0, "SLC", 0x75, 0x1, 0x0, 0x0, 0x2, 10
,0, 0, "SRC", 0x75, 0x0, 0x0, 0x0, 0x2, 10
,0, 0, "SLAD", 0x79, 0x1, 0x0, 0x0, 0xA, 10
,0, 0, "SRAD", 0x79, 0x0, 0x0, 0x0, 0xA, 10
,0, 0, "SLLD", 0x7D, 0x1, 0x0, 0x0, 0xA, 10
,0, 0, "SRLD", 0x7D, 0x0, 0x0, 0x0, 0xA, 10
,0, 0, "SBM", 0x9A, 0x0, 0x0, 0x2, 0x3, 5
,0, 0, "ZBM", 0x9E, 0x0, 0x0, 0x2, 0x3, 5
,0, 0, "ABM", 0xA2, 0x0, 0x0, 0x2, 0x3, 5
,0, 0, "TBM", 0xA6, 0x0, 0x0, 0x2, 0x3, 5
,0, 0, "EXM", 0xAA, 0x0, 0x1, 0x1, 0x1, 16
,0, 0, "MPMB", 0xC2, 0x0, 0x0, 0x2, 0xB, 15
,0, 0, "MPMH", 0xC2, 0x0, 0x1, 0x2, 0xB, 15
,0, 0, "MPMW", 0xC2, 0x0, 0x2, 0x2, 0xB, 15
,0, 0, "DVMB", 0xC6, 0x0, 0x0, 0x2, 0xB, 15
,0, 0, "DVMH", 0xC6, 0x0, 0x1, 0x2, 0xB, 15
,0, 0, "DVMW", 0xC6, 0x0, 0x2, 0x2, 0xB, 15
,0, 0, "LI", 0xCA, 0x0, 0x0, 0x0, 0x2, 19
,0, 0, "ADI", 0xCA, 0x1, 0x0, 0x0, 0x2, 19
,0, 0, "SUI", 0xCA, 0x2, 0x0, 0x0, 0x2, 19
,0, 0, "MPI", 0xCA, 0x3, 0x0, 0x0, 0xA, 19
,0, 0, "DVI", 0xCA, 0x4, 0x0, 0x0, 0xA, 19
,0, 0, "CI", 0xCA, 0x5, 0x0, 0x0, 0x2, 19
,0, 0, "EXR", 0xCA, 0x7, 0x0, 0x0, 0x0, 20
,0, 0, "EXRR", 0xCA, 0x7, 0x2, 0x0, 0x0, 20
,0, 0, "LF", 0xCE, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "LFBR", 0xCE, 0x0, 0x6, 0x2, 0x3, 15
,0, 0, "LEA", 0xD2, 0x0, 0x4, 0x2, 0x3, 15
,0, 0, "STF", 0xDE, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "STFBR", 0xDE, 0x0, 0x6, 0x2, 0x3, 15
,0, 0, "ADFW", 0xE2, 0x1, 0x2, 0x2, 0x3, 18
,0, 0, "ADFD", 0xE2, 0x1, 0x3, 0x2, 0x3, 18
,0, 0, "SUFW", 0xE2, 0x0, 0x2, 0x2, 0x3, 18
,0, 0, "SUFD", 0xE2, 0x0, 0x3, 0x2, 0x3, 18
,0, 0, "MPFW", 0xE6, 0x1, 0x2, 0x2, 0x3, 18
,0, 0, "MPFD", 0xE6, 0x1, 0x3, 0x2, 0x3, 18
,0, 0, "DVFW", 0xE6, 0x0, 0x2, 0x2, 0x3, 18
,0, 0, "DVFD", 0xE6, 0x0, 0x3, 0x2, 0x3, 18
,0, 0, "BCT", 0xEE, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "BU", 0xEE, 0x0, 0x1, 0x1, 0x1, 16
,0, 0, "BFT", 0xF2, 0x0, 0x1, 0x1, 0x1, 16
,0, 0, "BCF", 0xF2, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "BIB", 0xF6, 0x0, 0x1, 0x2, 0x2, 17
,0, 0, "BIH", 0xF6, 0x1, 0x1, 0x2, 0x2, 17
,0, 0, "BIW", 0xF6, 0x2, 0x1, 0x2, 0x2, 17
,0, 0, "BID", 0xF6, 0x3, 0x1, 0x2, 0x2, 17
#ifdef OLDWAY
,0, 0, "ZMB", 0xFA, 0x0, 0x0, 0x1, 0x1, 16
,0, 0, "ZMH", 0xFA, 0x0, 0x1, 0x1, 0x1, 16
,0, 0, "ZMW", 0xFA, 0x0, 0x2, 0x1, 0x1, 16
,0, 0, "ZMD", 0xFA, 0x0, 0x3, 0x1, 0x1, 16
#else
,0, 0, "ZMB", 0xFA, 0x0, 0x0, 0x1, 0x1, 24
,0, 0, "ZMH", 0xFA, 0x0, 0x1, 0x1, 0x1, 24
,0, 0, "ZMW", 0xFA, 0x0, 0x2, 0x1, 0x1, 24
,0, 0, "ZMD", 0xFA, 0x0, 0x3, 0x1, 0x1, 24
#endif
,0, 0, "BL", 0xFA, 0x1, 0x1, 0x1, 0x1, 16
,0, 0, "BRI", 0xFA, 0x2, 0x1, 0x1, 0x1, 16
,0, 0, "TRP", 0xFA, 0x6, 0x0, 0x0, 0x2, 14
,0, 0, "TPR", 0xFA, 0x7, 0x0, 0x0, 0x2, 14
,0, 0, "EI", 0xFE, 0x0, 0x0, 0x0, 0x1, 22
,0, 0, "DI", 0xFE, 0x1, 0x0, 0x0, 0x1,22
,0, 0, "RI", 0xFE, 0x2, 0x0, 0x0, 0x1, 22
,0, 0, "AI", 0xFE, 0x3, 0x0, 0x0, 0x1, 22
,0, 0, "DAI", 0xFE, 0x4, 0x0, 0x0, 0x1, 22
,0, 0, "TD", 0xFE, 0x5, 0x0, 0x0, 0x2, 22
,0, 0, "CD", 0xFE, 0x6, 0x0, 0x0, 0x2, 22
,0, 0, "CDL", 0xFE, 0x6, 0x0, 0x0, 0x0, 21
,0, 0, "DATA", 0x00, 0x0, 0x0, 0x0, 0x0, 29
,0, 0, "RES", 0x00, 0x0, 0x0, 0x0, 0x0, 41
,0, 0, "GEN", 0x00, 0x0, 0x0, 0x0, 0x0, 30
,0, 0, "EQU", 0x00, 0x0, 0x0, 0x1, 0x0, 40
,0, 0, "CEQU", 0x00, 0x0, 0x0, 0x1, 0x0, 68
,0, 0, "DEQU", 0x00, 0x0, 0x0, 0x1, 0x0, 66
,0, 0, "AC", 0x02, 0x0, 0x0, 0x1, 0x1, 13
,0, 0, "ACB", 0x02, 0x0, 0x0, 0x1, 0x1, 13
,0, 0, "ACH", 0x02, 0x0, 0x1, 0x1, 0x1, 13
,0, 0, "ACW", 0x02, 0x0, 0x2, 0x1, 0x1, 13
,0, 0, "ACD", 0x02, 0x0, 0x3, 0x1, 0x1, 13
,0, 0, "BACH", 0x02, 0x0, 0x1, 0x1, 0x1, 23
,0, 0, "BACW", 0x02, 0x0, 0x2, 0x1, 0x1, 23
,0, 0, "ORG", 0x00, 0x0, 0x0, 0x0, 0x0, 37
,0, 0, "CORG", 0x00, 0x0, 0x0, 0x0, 0x0, 69
,0, 0, "DORG", 0x00, 0x0, 0x0, 0x0, 0x0, 67
,0, 0, "SSECT", 0x00, 0x1, 0x0, 0x0, 0x0, 47
,0, 0, "SORG", 0x00, 0x2, 0x0, 0x0, 0x0, 47
,0, 0, "SEXT", 0x00, 0x3, 0x0, 0x0, 0x0, 47
,0, 0, "REL", 0x00, 0x4, 0x0, 0x0, 0x0, 38
,0, 0, "ABS", 0x00, 0x0, 0x0, 0x0, 0x0, 38
,0, 0, "DEF", 0x00, 0x0, 0x0, 0x0, 0x0, 36
,0, 0, "SDEF", 0x00, 0x2, 0x0, 0x0, 0x0, 36
,0, 0, "PAGE", 0x00, 0x0, 0x0, 0x0, 0x0, 44
,0, 0, "LIST", 0x00, 0x0, 0x0, 0x0, 0x0, 45
,0, 0, "REIS", 0x00, 0x0, 0x0, 0x0, 0x0, 33
,0, 0, "SEIS", 0x00, 0x0, 0x0, 0x0, 0x0, 33
,0, 0, "EXT", 0x00, 0x1, 0x0, 0x0, 0x0, 36
,0, 0, "REZ", 0x00, 0x0, 0x0, 0x0, 0x0, 65
,0, 0, "END", 0x02, 0x0, 0x0, 0x1, 0x0, 34
,0, 0, "ANOP", 0x00, 0x0, 0x0, 0x0, 0x0, 48
,0, 0, "IFF", 0x01, 0x0, 0x0, 0x0, 0x0, 49
,0, 0, "IFT", 0x00, 0x0, 0x0, 0x0, 0x0, 49
,0, 0, "IFTDEF", 0x02, 0x0, 0x0, 0x0, 0x0, 49
,0, 0, "IFFDEF", 0x03, 0x0, 0x0, 0x0, 0x0, 49
,0, 0, "IFP", 0x14, 0x0, 0x0, 0x0, 0x0, 49
,0, 0, "IFA", 0x15, 0x0, 0x0, 0x0, 0x0, 49
,0, 0, "SETF", 0x00, 0x0, 0x0, 0x0, 0x0, 52
,0, 0, "SETT", 0x01, 0x0, 0x0, 0x0, 0x0, 52
,0, 0, "SET", 0x02, 0x0, 0x0, 0x0, 0x0, 52
,0, 0, "OPTS", 0x03, 0x0, 0x0, 0x0, 0x0, 52
,0, 0, "OPTR", 0x04, 0x0, 0x0, 0x0, 0x0, 52
,0, 0, "OPTT", 0x05, 0x0, 0x0, 0x0, 0x0, 52
,0, 0, "DEFM", 0x00, 0x0, 0x0, 0x0, 0x0, 50
,0, 0, "ENDM", 0x00, 0x0, 0x0, 0x0, 0x0, 51
,0, 0, "GOTO", 0x00, 0x0, 0x0, 0x0, 0x0, 53
,0, 0, "ENDR", 0x00, 0x0, 0x0, 0x0, 0x0, 54
,0, 0, "REPT", 0x00, 0x0, 0x0, 0x0, 0x0, 55
,0, 0, "FORM", 0x00, 0x0, 0x0, 0x0, 0x0, 57
#ifndef CAID
/* New debugger opcodes */
,0, 0, ".SRC", 0x00, 0x0, 0x0, 0x0, 0x0, 61
,0, 0, ".COM", 0x00, 0x1, 0x0, 0x0, 0x0, 61
,0, 0, ".STAB", 0x00, 0x2, 0x0, 0x0, 0x0, 61
,0, 0, ".STABC", 0x00, 0x3, 0x0, 0x0, 0x0, 61
,0, 0, ".SYM", 0x00, 0x4, 0x0, 0x0, 0x0, 61
,0, 0, ".END", 0x00, 0x5, 0x0, 0x0, 0x0, 61
,0, 0, ".XEQ", 0x00, 0x6, 0x0, 0x0, 0x0, 61
,0, 0, ".ARG", 0x00, 0x7, 0x0, 0x0, 0x0, 61
/* */
#endif
,0, 0, "LPSDCM", 0xFA, 0x5, 0x2, 0x1, 0x1, 16
,0, 0, "TMAPR", 0x2D, 0xA, 0x0, 0x0, 0x2, 6
,0, 0, "SETCPU", 0x2D, 0x9, 0x0, 0x0, 0x0, 71
,0, 0, "RDSTS", 0x01, 0x9, 0x0, 0x0, 0x0, 71
,0, 0, "RPSWT", 0x05, 0xB, 0x0, 0x0, 0x0, 71
,0, 0, "CMC", 0x05, 0xA, 0x0, 0x0, 0x0, 71
,0, 0, "SMC", 0x05, 0x7, 0x0, 0x0, 0x0, 71
,0, 0, "UNDEF", 0x05, 0x9, 0x0, 0x0, 0x0, 1
,0, 0, "ADRFW", 0x39, 0x1, 0x0, 0x0, 0x2, 6
,0, 0, "SURFW", 0x39, 0x3, 0x0, 0x0, 0x2, 6
,0, 0, "MPRFW", 0x39, 0x6, 0x0, 0x0, 0x2, 6
,0, 0, "DVRFW", 0x39, 0x4, 0x0, 0x0, 0x2, 6
,0, 0, "FLTW", 0x39, 0x7, 0x0, 0x0, 0x2, 6
,0, 0, "FIXW", 0x39, 0x5, 0x0, 0x0, 0x2, 6
,0, 0, "ADRFD", 0x39, 0x9, 0x0, 0x0, 0xE, 6
,0, 0, "SURFD", 0x39, 0xB, 0x0, 0x0, 0xE, 6
,0, 0, "MPRFD", 0x39, 0xE, 0x0, 0x0, 0xE, 6
,0, 0, "DVRFD", 0x39, 0xC, 0x0, 0x0, 0xE, 6
,0, 0, "FLTD", 0x39, 0xF, 0x0, 0x0, 0xE, 6
,0, 0, "FIXD", 0x39, 0xD, 0x0, 0x0, 0xE, 6
,0, 0, "STPIO", 0xFE, 0x7, 0x4, 0x0, 0x3, 74
,0, 0, "RSCHNL", 0xFE, 0x7, 0x5, 0x0, 0x3, 74
,0, 0, "RSCTL", 0xFE, 0x7, 0x8, 0x0, 0x3, 74
,0, 0, "ECWCS", 0xFE, 0x7, 0x9, 0x0, 0x3, 74
,0, 0, "WCWCS", 0xFE, 0x7, 0xB, 0x0, 0x3, 74
,0, 0, "PROGRAM", 0x00, 0x0, 0x0, 0x0, 0x0, 35
,0, 0, "BOUND", 0x00, 0x0, 0x0, 0x0, 0x0, 39
,0, 0, "COMMON", 0x00, 0x0, 0x0, 0x0, 0x0, 42
,0, 0, "TITLE", 0x00, 0x0, 0x0, 0x0, 0x0, 43
,0, 0, "SPACE", 0x00, 0x0, 0x0, 0x0, 0x0, 46
,0, 0, "LPOOL", 0x02, 0x0, 0x0, 0x0, 0x0, 64
,0, 0, "CSECT", 0x00, 0xC, 0x0, 0x0, 0x0, 38
,0, 0, "DSECT", 0x00, 0x4, 0x0, 0x0, 0x0, 38
,0, 0, "EXITM", 0x00, 0x0, 0x0, 0x0, 0x0, 56
,0, 0, "DATAONLY", 0x00, 0x0, 0x0, 0x0, 0x0, 62
,0, 0, "ENDDATA", 0x00, 0x0, 0x0, 0x0, 0x0, 63
,0, 0, "SCSR", 0x05, 0x1, 0x0, 0x0, 0x0, 7
,0, 0, "SDSR", 0x05, 0x2, 0x0, 0x0, 0x0, 7
,0, 0, "BLKMV", 0x05, 0x3, 0x0, 0x0, 0x0, 1
,0, 0, "PIT", 0x05, 0x4, 0x0, 0x0, 0x0, 1
,0, 0, "DCSR", 0x05, 0x5, 0x0, 0x0, 0x0, 7
,0, 0, "DDSR", 0x05, 0x6, 0x0, 0x0, 0x0, 7
,0, 0, "SEAR", 0x05, 0xE, 0x0, 0x0, 0x0, 1
,0, 0, "CEAR", 0x05, 0xF, 0x0, 0x0, 0x0, 1
,0, 0, "DMSINT", 0x0D, 0x1, 0x0, 0x0, 0x2, 6
,0, 0, "RMSINT", 0x0D, 0x1, 0x0, 0x0, 0x2, 6
,0, 0, "MDMSW", 0x0D, 0x2, 0x0, 0x0, 0x6, 6
,0, 0, "MRMSW", 0x0D, 0x2, 0x0, 0x0, 0x6, 6
,0, 0, "ZBDMS", 0x0D, 0x1, 0x0, 0x0, 0x2, 9
,0, 0, "ZBRMS", 0x0D, 0x1, 0x0, 0x0, 0x2, 9
,0, 0, "RDMSW", 0x0D, 0x3, 0x0, 0x0, 0x2, 6
,0, 0, "RRMSW", 0x0D, 0x3, 0x0, 0x0, 0x2, 6
,0, 0, "SBDMS", 0x0D, 0x3, 0x0, 0x0, 0x2, 9
,0, 0, "SBRMS", 0x0D, 0x3, 0x0, 0x0, 0x2, 9
,0, 0, "WDMSCS", 0x0D, 0x9, 0x0, 0x0, 0x0, 7
,0, 0, "WRMSCS", 0x0D, 0x9, 0x0, 0x0, 0x0, 7
,0, 0, "RDMSCS", 0x0D, 0xA, 0x0, 0x0, 0x0, 7
,0, 0, "RRMSCS", 0x0D, 0xA, 0x0, 0x0, 0x0, 7
,0, 0, "CGEW", 0x29, 0x6, 0x0, 0x0, 0x2, 6
,0, 0, "CGED", 0x29, 0x7, 0x0, 0x0, 0x2, 6
,0, 0, "CEGW", 0x29, 0xA, 0x0, 0x0, 0x2, 6
,0, 0, "CEGD", 0x29, 0xB, 0x0, 0x0, 0x2, 6
,0, 0, "CXIW", 0x29, 0x6, 0x0, 0x0, 0x2, 6
,0, 0, "CXID", 0x29, 0x7, 0x0, 0x0, 0x2, 6
,0, 0, "CIXW", 0x29, 0xA, 0x0, 0x0, 0x2, 6
,0, 0, "CIXD", 0x29, 0xB, 0x0, 0x0, 0x2, 6
,0, 0, "TC", 0xCA, 0x8, 0x0, 0x0, 0x1, 73
,0, 0, "PINTV", 0xCA, 0x9, 0x0, 0x0, 0x2, 19
,0, 0, "RINTV", 0xCA, 0xA, 0x0, 0x0, 0x2, 19
/*
 *        RISC STYLE FLOATING POINT INSTRUCTIONS
 */
,0, 0, "MAFW", 0x09, 0x1, 0x0, 0x0, 0x2, 6
,0, 0, "MAFD", 0x09, 0x2, 0x0, 0x0, 0xE, 6
,0, 0, "ATFW", 0x09, 0x5, 0x0, 0x0, 0x2, 77
,0, 0, "ATFD", 0x09, 0x6, 0x0, 0x0, 0xE, 77
,0, 0, "MTFW", 0x09, 0x3, 0x0, 0x0, 0x2, 77
,0, 0, "MTFD", 0x09, 0x4, 0x0, 0x0, 0xE, 77
,0, 0, "DFWD", 0x09, 0x7, 0x0, 0x0, 0x2, 6
,0, 0, "DFDD", 0x09, 0x9, 0x0, 0x0, 0xE, 6
,0, 0, "DFWN", 0x09, 0xA, 0x0, 0x0, 0x2, 6
,0, 0, "DFDN", 0x09, 0xB, 0x0, 0x0, 0xE, 6
,0, 0, "ABSW", 0x05, 0xC, 0x0, 0x0, 0x2, 6
,0, 0, "ABSD", 0x05, 0xD, 0x0, 0x0, 0xE, 6
/*-----------------------------------------*/
,0, 0, ".CF2D", 0x01, 0x0, 0x0, 0x0, 0x0, 79
,0, 0, ".CD2F", 0x01, 0x0, 0x0, 0x0, 0x0, 80
/*-----------------------------------------*/
,0, 0, "TFWR", 0x29, 0xD, 0x0, 0x0, 0x1, 75
,0, 0, "TFDR", 0x29, 0xF, 0x0, 0x0, 0x9, 75
,0, 0, "TRFW", 0x09, 0xE, 0x0, 0x0, 0x1, 75
,0, 0, "TRFD", 0x09, 0xF, 0x0, 0x0, 0x9, 75
,0, 0, "AFFW", 0x09, 0xC, 0x0, 0x0, 0x1, 75
,0, 0, "AFFD", 0x09, 0xD, 0x0, 0x0, 0x9, 75
,0, 0, "SFFW", 0x09, 0xC, 0x2, 0x0, 0x1, 75
,0, 0, "SFFD", 0x09, 0xD, 0x2, 0x0, 0x9, 75
,0, 0, "MFFW", 0x09, 0xC, 0x4, 0x0, 0x1, 75
,0, 0, "MFFD", 0x09, 0xD, 0x4, 0x0, 0x9, 75
,0, 0, "HLD1", 0x0D, 0xB, 0x2, 0x0, 0x0, 76
,0, 0, "HLD2", 0x0D, 0xB, 0x4, 0x0, 0x0, 76
,0, 0, "HLD3", 0x0D, 0xB, 0x6, 0x0, 0x0, 76
,0, 0, "TSPR", 0x29, 0xD, 0x2, 0x0, 0x1, 75
,0, 0, "TDPR", 0x29, 0xF, 0x2, 0x0, 0x9, 75
,0, 0, "FLFW", 0x09, 0xE, 0x2, 0x0, 0x1, 75
,0, 0, "FLFD", 0x09, 0xF, 0x2, 0x0, 0x9, 75
,0, 0, "TSFR", 0x29, 0xD, 0x4, 0x0, 0x1, 75
,0, 0, "TDFR", 0x29, 0xF, 0x4, 0x0, 0x9, 75
,0, 0, "CAFW", 0x29, 0x9, 0x0, 0x0, 0x2, 6
,0, 0, "CAFD", 0x2D, 0x6, 0x0, 0x0, 0xE, 6
,0, 0, "LPSDR", 0x05, 0x3, 0x2, 0x0, 0x1, 75
,0, 0, "LPSDCMR", 0x05, 0x3, 0x4, 0x0, 0x1, 75
,0, 0, "ERF", 0x05, 0x4, 0x2, 0x0, 0x0, 75
,0, 0, "DRF", 0x05, 0x4, 0x4, 0x0, 0x0, 75
,0, 0, "RST", 0x05, 0x3, 0x0, 0x0, 0x0, 1
,0, 0, "GFPC", 0xCA, 0xD, 0x0, 0x0, 0x6, 78
,0, 0, "RFPW", 0xCA, 0xE, 0x0, 0x0, 0x2, 78
,0, 0, "RFPD", 0xCA, 0xF, 0x0, 0x0, 0x6, 78
,0, 0, "MMBR", 0x0D, 0x1, 0x0, 0x0, 0x1, 75
,0, 0, 0, 0, 0, 0, 0, 0, 0	/* zero last entry for table end */
};

/*
 * optabba is optab for base made instructions
 */

struct optab opstabba[] = {
 0, 0, "LPSD", 0xFA, 0x3, 0x2, 0x1, 0x1, 16
,0, 0, "LB", 0xAE, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "LH", 0xAE, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "LW", 0xAE, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "LD", 0xAE, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "LWBR", 0x5E, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "STB", 0xD6, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "STH", 0xD6, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "STW", 0xD6, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "STD", 0xD6, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "STWBR", 0x56, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "LCB", 0xAE, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "LCH", 0xAE, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "LCW", 0xAE, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "LCD", 0xAE, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "STCB", 0xD6, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "STCH", 0xD6, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "STCW", 0xD6, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "STCD", 0xD6, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "REIS", 0x00, 0x0, 0x0, 0x0, 0x0, 48
,0, 0, "SEIS", 0x00, 0x0, 0x0, 0x0, 0x0, 48
,0, 0, "LNB", 0xB6, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "LNH", 0xB6, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "LNW", 0xB6, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "LND", 0xB6, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "LMB", 0xB2, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "LMH", 0xB2, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "LMW", 0xB2, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "LMD", 0xB2, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "STMB", 0xDA, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "STMH", 0xDA, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "STMW", 0xDA, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "STMD", 0xDA, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "ADMB", 0xBA, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "ADMH", 0xBA, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "ADMW", 0xBA, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "ADMD", 0xBA, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "SUMB", 0xBE, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "SUMH", 0xBE, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "SUMW", 0xBE, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "SUMD", 0xBE, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "CAMB", 0x92, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "CAMH", 0x92, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "CAMW", 0x92, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "CAMD", 0x92, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "CMMB", 0x96, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "CMMH", 0x96, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "CMMW", 0x96, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "CMMD", 0x96, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "ANMB", 0x86, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "ANMH", 0x86, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "ANMW", 0x86, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "ANMD", 0x86, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "ORMB", 0x8A, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "ORMH", 0x8A, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "ORMW", 0x8A, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "ORMD", 0x8A, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "EOMB", 0x8E, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "EOMH", 0x8E, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "EOMW", 0x8E, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "EOMD", 0x8E, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "ARMB", 0xEA, 0x8, 0x0, 0x2, 0x3, 15
,0, 0, "ARMH", 0xEA, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "ARMW", 0xEA, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "ARMD", 0xEA, 0x0, 0x3, 0x2, 0xB, 15
,0, 0, "BGT", 0xEE, 0x2, 0x1, 0x1, 0x1, 16
,0, 0, "BLT", 0xEE, 0x3, 0x1, 0x1, 0x1, 16
,0, 0, "BEQ", 0xEE, 0x4, 0x1, 0x1, 0x1, 16
,0, 0, "BGE", 0xEE, 0x5, 0x1, 0x1, 0x1, 16
,0, 0, "BLE", 0xEE, 0x6, 0x1, 0x1, 0x1, 16
,0, 0, "BNE", 0xF2, 0x4, 0x1, 0x1, 0x1, 16
,0, 0, "BOV", 0xEE, 0x1, 0x1, 0x1, 0x1, 16
,0, 0, "BP", 0xEE, 0x2, 0x1, 0x1, 0x1, 16
,0, 0, "BN", 0xEE, 0x3, 0x1, 0x1, 0x1, 16
,0, 0, "BZ", 0xEE, 0x4, 0x1, 0x1, 0x1, 16
,0, 0, "BNOV", 0xF2, 0x1, 0x1, 0x1, 0x1, 16
,0, 0, "BNP", 0xF2, 0x2, 0x1, 0x1, 0x1, 16
,0, 0, "BNN", 0xF2, 0x3, 0x1, 0x1, 0x1, 16
,0, 0, "BNZ", 0xF2, 0x4, 0x1, 0x1, 0x1, 16
,0, 0, "BS", 0xEE, 0x1, 0x1, 0x1, 0x1, 16
,0, 0, "BNS", 0xF2, 0x1, 0x1, 0x1, 0x1, 16
,0, 0, "BANY", 0xEE, 0x7, 0x1, 0x1, 0x1, 16
,0, 0, "BAZ", 0xF2, 0x7, 0x1, 0x1, 0x1, 16
,0, 0, "DATAB", 0x00, 0x0, 0x0, 0x0, 0x0, 29
,0, 0, "DATAH", 0x01, 0x0, 0x0, 0x0, 0x0, 29
,0, 0, "DATAW", 0x02, 0x0, 0x0, 0x0, 0x0, 29
,0, 0, "DATAD", 0x03, 0x0, 0x0, 0x0, 0x0, 29
,0, 0, "BEI", 0x01, 0x6, 0x0, 0x0, 0x0, 1
,0, 0, "UEI", 0x01, 0x7, 0x0, 0x0, 0x0, 1
,0, 0, "RWCS", 0x01, 0xB, 0x0, 0x0, 0x2, 6
,0, 0, "WWCS", 0x01, 0xC, 0x0, 0x0, 0x2, 6
,0, 0, "JWCS", 0xFA, 0x4, 0x0, 0x1, 0x1, 16
,0, 0, "SVC", 0xCA, 0x6, 0x0, 0x0, 0x1, 72
,0, 0, "LEAR", 0x82, 0x0, 0x4, 0x2, 0x3, 15
,0, 0, "LCRA", 0x82, 0x0, 0x4, 0x2, 0x3, 15
,0, 0, "SIO", 0xFE, 0x7, 0x2, 0x0, 0x3, 74
,0, 0, "TIO", 0xFE, 0x7, 0x3, 0x0, 0x3,74
,0, 0, "HIO", 0xFE, 0x7, 0x6, 0x0, 0x3, 74
,0, 0, "GRIO", 0xFE, 0x7, 0x7, 0x0, 0x3, 74
,0, 0, "ECI", 0xFE, 0x7, 0xC, 0x0, 0x3, 74
,0, 0, "DCI", 0xFE, 0x7, 0xD, 0x0, 0x3, 74
,0, 0, "ACI", 0xFE, 0x7, 0xE, 0x0, 0x3, 74
,0, 0, "DACI", 0xFE, 0x7, 0xF, 0x0, 0x3, 74
,0, 0, "LA", 0x52, 0x0, 0x4, 0x2, 0x3, 15
,0, 0, "LABR", 0x5A, 0x8, 0x6, 0x2, 0x3, 15
,0, 0, "SUABR", 0x5A, 0x0, 0x7, 0x2, 0x3, 15
,0, 0, "LMAP", 0x2E, 0x7, 0x2, 0x0, 0x0, 20
,0, 0, "EAE", 0x01, 0x8, 0x0, 0x0, 0x0, 1
,0, 0, "DAE", 0x01, 0xE, 0x0, 0x0, 0x0, 1
,0, 0, "LCS", 0x01, 0x3, 0x0, 0x0, 0x0, 7
,0, 0, "ES", 0x01, 0x4, 0x0, 0x0, 0x8, 7
,0, 0, "RND", 0x01, 0x5, 0x0, 0x0, 0x8, 7
,0, 0, "HALT", 0x01, 0x0, 0x0, 0x0, 0x0, 1
,0, 0, "WAIT", 0x01, 0x1, 0x0, 0x0, 0x0, 1
,0, 0, "NOP", 0x01, 0x2, 0x0, 0x0, 0x0, 1
,0, 0, "SIPU", 0x01, 0xA, 0x0, 0x0, 0x0, 1
,0, 0, "ANR", 0x05, 0x0, 0x0, 0x0, 0x2, 6
,0, 0, "ORR", 0x09, 0x0, 0x0, 0x0, 0x2, 6
,0, 0, "ORRM", 0x09, 0x8, 0x0, 0x0, 0x2, 6
,0, 0, "EOR", 0x0D, 0x0, 0x0, 0x0, 0x2, 6
,0, 0, "EORM", 0x0D, 0x8, 0x0, 0x0, 0x2, 6
,0, 0, "ZR", 0x0D, 0x0, 0x0, 0x0, 0x0, 12
,0, 0, "CAR", 0x11, 0x0, 0x0, 0x0, 0x2, 6
,0, 0, "CMR", 0x15, 0x0, 0x0, 0x0, 0x2, 6
,0, 0, "SBR", 0x19, 0x0, 0x0, 0x0, 0x2, 9
,0, 0, "ZBR", 0x19, 0x1, 0x0, 0x0, 0x2, 9
,0, 0, "ABR", 0x19, 0x2, 0x0, 0x0, 0x2, 9
,0, 0, "TBR", 0x19, 0x3, 0x0, 0x0, 0x2, 9
,0, 0, "TRSW", 0x29, 0x0, 0x0, 0x0, 0x0, 8
,0, 0, "CALL", 0x29, 0x8, 0x0, 0x0, 0x2, 6
,0, 0, "CALLM", 0x5E, 0x0, 0x6, 0x2, 0x3, 15
,0, 0, "BSUB", 0x29, 0x8, 0x0, 0x0, 0x0, 7
,0, 0, "BSUBM", 0x5E, 0x0, 0x6, 0x1, 0x1, 15
,0, 0, "RETURN", 0x29, 0xE, 0x0, 0x0, 0x0, 1
,0, 0, "TRCC", 0x29, 0x5, 0x0, 0x0, 0x0, 7
,0, 0, "TCCR", 0x29, 0x4, 0x0, 0x0, 0x0, 7
,0, 0, "TPCBR", 0x29, 0xC, 0x0, 0x0, 0x0, 7
,0, 0, "TRR", 0x2D, 0x0, 0x0, 0x0, 0x2, 6
,0, 0, "TRBR", 0x2D, 0x1, 0x0, 0x0, 0x2, 6
,0, 0, "TBRR", 0x2D, 0x2, 0x0, 0x0, 0x2, 6
,0, 0, "TRC", 0x2D, 0x3, 0x0, 0x0, 0x2, 6
,0, 0, "TRN", 0x2D, 0x4, 0x0, 0x0, 0x2, 6
,0, 0, "XCR", 0x2D, 0x5, 0x0, 0x0, 0x2, 6
,0, 0, "XCBR", 0x29, 0x2, 0x0, 0x0, 0x2, 6
,0, 0, "TRRM", 0x2D, 0x8, 0x0, 0x0, 0x2, 6
,0, 0, "TRCM", 0x2D, 0xB, 0x0, 0x0, 0x2, 6
,0, 0, "TRNM", 0x2D, 0xC, 0x0, 0x0, 0x2, 6
,0, 0, "XCRM", 0x2D, 0xD, 0x0, 0x0, 0x2, 6
,0, 0, "TRSC", 0x2D, 0xE, 0x0, 0x0, 0x2, 6
,0, 0, "TSCR", 0x2D, 0xF, 0x0, 0x0, 0x2, 6
,0, 0, "ADR", 0x39, 0x0, 0x0, 0x0, 0x2, 6
,0, 0, "ADRM", 0x39, 0x8, 0x0, 0x0, 0x2, 6
,0, 0, "SUR", 0x3D, 0x0, 0x0, 0x0, 0x2, 6
,0, 0, "SURM", 0x3D, 0x8, 0x0, 0x0, 0x2, 6
,0, 0, "MPR", 0x39, 0x2, 0x0, 0x0, 0x6, 6
,0, 0, "DVR", 0x39, 0xA, 0x0, 0x0, 0x6, 6
,0, 0, "SCZ", 0x11, 0x8, 0x0, 0x0, 0x2, 11
,0, 0, "SLA", 0x1D, 0x1, 0x0, 0x0, 0x2, 10
,0, 0, "SRA", 0x1D, 0x0, 0x0, 0x0, 0x2, 10
,0, 0, "SLL", 0x1D, 0x3, 0xC, 0x0, 0x2, 10
,0, 0, "SRL", 0x1D, 0x2, 0x0, 0x0, 0x2, 10
,0, 0, "SLC", 0x25, 0x1, 0x0, 0x0, 0x2, 10
,0, 0, "SRC", 0x25, 0x0, 0x0, 0x0, 0x2, 10
,0, 0, "SLAD", 0x21, 0x1, 0x0, 0x0, 0xA, 10
,0, 0, "SRAD", 0x21, 0x0, 0x0, 0x0, 0xA, 10
,0, 0, "SLLD", 0x21, 0x3, 0xC, 0x0, 0xA, 10
,0, 0, "SRLD", 0x21, 0x2, 0x0, 0x0, 0xA, 10
,0, 0, "SBM", 0x9A, 0x0, 0x0, 0x2, 0x3, 5
,0, 0, "ZBM", 0x9E, 0x0, 0x0, 0x2, 0x3, 5
,0, 0, "ABM", 0xA2, 0x0, 0x0, 0x2, 0x3, 5
,0, 0, "TBM", 0xA6, 0x0, 0x0, 0x2, 0x3, 5
,0, 0, "EXM", 0xAA, 0x0, 0x1, 0x1, 0x1, 16
,0, 0, "MPMB", 0xC2, 0x0, 0x0, 0x2, 0xB, 15
,0, 0, "MPMH", 0xC2, 0x0, 0x1, 0x2, 0xB, 15
,0, 0, "MPMW", 0xC2, 0x0, 0x2, 0x2, 0xB, 15
,0, 0, "DVMB", 0xC6, 0x0, 0x0, 0x2, 0xB, 15
,0, 0, "DVMH", 0xC6, 0x0, 0x1, 0x2, 0xB, 15
,0, 0, "DVMW", 0xC6, 0x0, 0x2, 0x2, 0xB, 15
,0, 0, "LI", 0xCA, 0x0, 0x0, 0x0, 0x2, 19
,0, 0, "ADI", 0xCA, 0x1, 0x0, 0x0, 0x2, 19
,0, 0, "SUI", 0xCA, 0x2, 0x0, 0x0, 0x2, 19
,0, 0, "MPI", 0xCA, 0x3, 0x0, 0x0, 0xA, 19
,0, 0, "DVI", 0xCA, 0x4, 0x0, 0x0, 0xA, 19
,0, 0, "CI", 0xCA, 0x5, 0x0, 0x0, 0x2, 19
,0, 0, "EXR", 0xCA, 0x7, 0x0, 0x0, 0x0, 20
,0, 0, "EXRR", 0xCA, 0x7, 0x2, 0x0, 0x0, 20
,0, 0, "LF", 0xCE, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "LFBR", 0xCE, 0x0, 0x6, 0x2, 0x3, 15
,0, 0, "STF", 0xDE, 0x0, 0x2, 0x2, 0x3, 15
,0, 0, "STFBR", 0xDE, 0x0, 0x6, 0x2, 0x3, 15
,0, 0, "ADFW", 0xE2, 0x1, 0x2, 0x2, 0x3, 18
,0, 0, "ADFD", 0xE2, 0x1, 0x3, 0x2, 0x3, 18
,0, 0, "SUFW", 0xE2, 0x0, 0x2, 0x2, 0x3, 18
,0, 0, "SUFD", 0xE2, 0x0, 0x3, 0x2, 0x3, 18
,0, 0, "MPFW", 0xE6, 0x1, 0x2, 0x2, 0x3, 18
,0, 0, "MPFD", 0xE6, 0x1, 0x3, 0x2, 0x3, 18
,0, 0, "DVFW", 0xE6, 0x0, 0x2, 0x2, 0x3, 18
,0, 0, "DVFD", 0xE6, 0x0, 0x3, 0x2, 0x3, 18
,0, 0, "BCT", 0xEE, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "BU", 0xEE, 0x0, 0x1, 0x1, 0x1, 16
,0, 0, "BFT", 0xF2, 0x0, 0x1, 0x1, 0x1, 16
,0, 0, "BCF", 0xF2, 0x0, 0x1, 0x2, 0x3, 15
,0, 0, "BIB", 0xF6, 0x0, 0x1, 0x2, 0x2, 17
,0, 0, "BIH", 0xF6, 0x1, 0x1, 0x2, 0x2, 17
,0, 0, "BIW", 0xF6, 0x2, 0x1, 0x2, 0x2, 17
,0, 0, "BID", 0xF6, 0x3, 0x1, 0x2, 0x2, 17
#ifdef OLDWAY
,0, 0, "ZMB", 0xFA, 0x0, 0x0, 0x1, 0x1, 16
,0, 0, "ZMH", 0xFA, 0x0, 0x1, 0x1, 0x1, 16
,0, 0, "ZMW", 0xFA, 0x0, 0x2, 0x1, 0x1, 16
,0, 0, "ZMD", 0xFA, 0x0, 0x3, 0x1, 0x1, 16
#else
,0, 0, "ZMB", 0xFA, 0x0, 0x0, 0x1, 0x1, 24
,0, 0, "ZMH", 0xFA, 0x0, 0x1, 0x1, 0x1, 24
,0, 0, "ZMW", 0xFA, 0x0, 0x2, 0x1, 0x1, 24
,0, 0, "ZMD", 0xFA, 0x0, 0x3, 0x1, 0x1, 24
#endif
,0, 0, "BL", 0xFA, 0x1, 0x1, 0x1, 0x1, 16
,0, 0, "EI", 0xFE, 0x0, 0x0, 0x0, 0x1, 22
,0, 0, "DI", 0xFE, 0x1, 0x0, 0x0, 0x1,22
,0, 0, "RI", 0xFE, 0x2, 0x0, 0x0, 0x1, 22
,0, 0, "AI", 0xFE, 0x3, 0x0, 0x0, 0x1, 22
,0, 0, "DAI", 0xFE, 0x4, 0x0, 0x0, 0x1, 22
,0, 0, "TD", 0xFE, 0x5, 0x0, 0x0, 0x2, 22
,0, 0, "CD", 0xFE, 0x6, 0x0, 0x0, 0x2, 22
,0, 0, "CDL", 0xFE, 0x6, 0x0, 0x0, 0x0, 21
,0, 0, "DATA", 0x00, 0x0, 0x0, 0x0, 0x0, 29
,0, 0, "RES", 0x00, 0x0, 0x0, 0x0, 0x0, 41
,0, 0, "GEN", 0x00, 0x0, 0x0, 0x0, 0x0, 30
,0, 0, "EQU", 0x00, 0x0, 0x0, 0x1, 0x0, 40
,0, 0, "CEQU", 0x00, 0x0, 0x0, 0x1, 0x0, 68
,0, 0, "DEQU", 0x00, 0x0, 0x0, 0x1, 0x0, 66
,0, 0, "AC", 0x02, 0x0, 0x0, 0x1, 0x1, 13
,0, 0, "ACB", 0x02, 0x0, 0x0, 0x1, 0x1, 13
,0, 0, "ACH", 0x02, 0x0, 0x1, 0x1, 0x1, 13
,0, 0, "ACW", 0x02, 0x0, 0x2, 0x1, 0x1, 13
,0, 0, "ACD", 0x02, 0x0, 0x3, 0x1, 0x1, 13
,0, 0, "BACH", 0x02, 0x0, 0x1, 0x1, 0x1, 23
,0, 0, "BACW", 0x02, 0x0, 0x2, 0x1, 0x1, 23
,0, 0, "ORG", 0x00, 0x0, 0x0, 0x0, 0x0, 37
,0, 0, "CORG", 0x00, 0x0, 0x0, 0x0, 0x0, 69
,0, 0, "DORG", 0x00, 0x0, 0x0, 0x0, 0x0, 67
,0, 0, "SSECT", 0x00, 0x1, 0x0, 0x0, 0x0, 47
,0, 0, "SORG", 0x00, 0x2, 0x0, 0x0, 0x0, 47
,0, 0, "SEXT", 0x00, 0x3, 0x0, 0x0, 0x0, 47
,0, 0, "REL", 0x00, 0x4, 0x0, 0x0, 0x0, 38
,0, 0, "ABS", 0x00, 0x0, 0x0, 0x0, 0x0, 38
,0, 0, "DEF", 0x00, 0x0, 0x0, 0x0, 0x0, 36
,0, 0, "SDEF", 0x00, 0x2, 0x0, 0x0, 0x0, 36
,0, 0, "PAGE", 0x00, 0x0, 0x0, 0x0, 0x0, 44
,0, 0, "LIST", 0x00, 0x0, 0x0, 0x0, 0x0, 45
,0, 0, "EXT", 0x00, 0x1, 0x0, 0x0, 0x0, 36
,0, 0, "REZ", 0x00, 0x0, 0x0, 0x0, 0x0, 65
,0, 0, "END", 0x02, 0x0, 0x0, 0x1, 0x0, 34
,0, 0, "ANOP", 0x00, 0x0, 0x0, 0x0, 0x0, 48
,0, 0, "IFF", 0x01, 0x0, 0x0, 0x0, 0x0, 49
,0, 0, "IFT", 0x00, 0x0, 0x0, 0x0, 0x0, 49
,0, 0, "IFTDEF", 0x02, 0x0, 0x0, 0x0, 0x0, 49
,0, 0, "IFFDEF", 0x03, 0x0, 0x0, 0x0, 0x0, 49
,0, 0, "IFP", 0x14, 0x0, 0x0, 0x0, 0x0, 49
,0, 0, "IFA", 0x15, 0x0, 0x0, 0x0, 0x0, 49
,0, 0, "SETF", 0x00, 0x0, 0x0, 0x0, 0x0, 52
,0, 0, "SETT", 0x01, 0x0, 0x0, 0x0, 0x0, 52
,0, 0, "SET", 0x02, 0x0, 0x0, 0x0, 0x0, 52
,0, 0, "OPTS", 0x03, 0x0, 0x0, 0x0, 0x0, 52
,0, 0, "OPTR", 0x04, 0x0, 0x0, 0x0, 0x0, 52
,0, 0, "OPTT", 0x05, 0x0, 0x0, 0x0, 0x0, 52
,0, 0, "DEFM", 0x00, 0x0, 0x0, 0x0, 0x0, 50
,0, 0, "ENDM", 0x00, 0x0, 0x0, 0x0, 0x0, 51
,0, 0, "GOTO", 0x00, 0x0, 0x0, 0x0, 0x0, 53
,0, 0, "ENDR", 0x00, 0x0, 0x0, 0x0, 0x0, 54
,0, 0, "REPT", 0x00, 0x0, 0x0, 0x0, 0x0, 55
,0, 0, "FORM", 0x00, 0x0, 0x0, 0x0, 0x0, 57
#ifndef CAID
/* New debugger opcodes */
,0, 0, ".SRC", 0x00, 0x0, 0x0, 0x0, 0x0, 61
,0, 0, ".COM", 0x00, 0x1, 0x0, 0x0, 0x0, 61
,0, 0, ".STAB", 0x00, 0x2, 0x0, 0x0, 0x0, 61
,0, 0, ".STABC", 0x00, 0x3, 0x0, 0x0, 0x0, 61
,0, 0, ".SYM", 0x00, 0x4, 0x0, 0x0, 0x0, 61
,0, 0, ".END", 0x00, 0x5, 0x0, 0x0, 0x0, 61
,0, 0, ".XEQ", 0x00, 0x6, 0x0, 0x0, 0x0, 61
,0, 0, ".ARG", 0x00, 0x7, 0x0, 0x0, 0x0, 61
/* */
#endif
,0, 0, "LPSDCM", 0xFA, 0x5, 0x2, 0x1, 0x1, 16
,0, 0, "TMAPR", 0x2D, 0xA, 0x0, 0x0, 0x2, 6
,0, 0, "SETCPU", 0x2D, 0x9, 0x0, 0x0, 0x0, 71
,0, 0, "RDSTS", 0x01, 0x9, 0x0, 0x0, 0x0, 71
,0, 0, "RPSWT", 0x05, 0xB, 0x0, 0x0, 0x0, 71
,0, 0, "CMC", 0x05, 0xA, 0x0, 0x0, 0x0, 71
,0, 0, "UNDEF", 0x05, 0x9, 0x0, 0x0, 0x0, 1
,0, 0, "ADRFW", 0x39, 0x1, 0x0, 0x0, 0x2, 6
,0, 0, "SURFW", 0x39, 0x3, 0x0, 0x0, 0x2, 6
,0, 0, "MPRFW", 0x39, 0x6, 0x0, 0x0, 0x2, 6
,0, 0, "DVRFW", 0x39, 0x4, 0x0, 0x0, 0x2, 6
,0, 0, "FLTW", 0x39, 0x7, 0x0, 0x0, 0x2, 6
,0, 0, "FIXW", 0x39, 0x5, 0x0, 0x0, 0x2, 6
,0, 0, "ADRFD", 0x39, 0x9, 0x0, 0x0, 0xE, 6
,0, 0, "SURFD", 0x39, 0xB, 0x0, 0x0, 0xE, 6
,0, 0, "MPRFD", 0x39, 0xE, 0x0, 0x0, 0xE, 6
,0, 0, "DVRFD", 0x39, 0xC, 0x0, 0x0, 0xE, 6
,0, 0, "FLTD", 0x39, 0xF, 0x0, 0x0, 0xE, 6
,0, 0, "FIXD", 0x39, 0xD, 0x0, 0x0, 0xE, 6
,0, 0, "STPIO", 0xFE, 0x7, 0x4, 0x0, 0x3, 74
,0, 0, "RSCHNL", 0xFE, 0x7, 0x5, 0x0, 0x3, 74
,0, 0, "RSCTL", 0xFE, 0x7, 0x8, 0x0, 0x3, 74
,0, 0, "ECWCS", 0xFE, 0x7, 0x9, 0x0, 0x3, 74
,0, 0, "WCWCS", 0xFE, 0x7, 0xB, 0x0, 0x3, 74
,0, 0, "PROGRAM", 0x00, 0x0, 0x0, 0x0, 0x0, 35
,0, 0, "BOUND", 0x00, 0x0, 0x0, 0x0, 0x0, 39
,0, 0, "COMMON", 0x00, 0x0, 0x0, 0x0, 0x0, 42
,0, 0, "TITLE", 0x00, 0x0, 0x0, 0x0, 0x0, 43
,0, 0, "SPACE", 0x00, 0x0, 0x0, 0x0, 0x0, 46
,0, 0, "LPOOL", 0x02, 0x0, 0x0, 0x0, 0x0, 64
,0, 0, "CSECT", 0x00, 0xC, 0x0, 0x0, 0x0, 38
,0, 0, "DSECT", 0x00, 0x4, 0x0, 0x0, 0x0, 38
,0, 0, "EXITM", 0x00, 0x0, 0x0, 0x0, 0x0, 56
,0, 0, ".SRC", 0x00, 0x0, 0x0, 0x0, 0x0, 61
,0, 0, "DATAONLY", 0x00, 0x0, 0x0, 0x0, 0x0, 62
,0, 0, "ENDDATA", 0x00, 0x0, 0x0, 0x0, 0x0, 63
,0, 0, "SCSR", 0x05, 0x1, 0x0, 0x0, 0x0, 7
,0, 0, "SDSR", 0x05, 0x2, 0x0, 0x0, 0x0, 7
,0, 0, "BLKMV", 0x05, 0x3, 0x0, 0x0, 0x0, 1
,0, 0, "PIT", 0x05, 0x4, 0x0, 0x0, 0x0, 1
,0, 0, "DCSR", 0x05, 0x5, 0x0, 0x0, 0x0, 7
,0, 0, "DDSR", 0x05, 0x6, 0x0, 0x0, 0x0, 7
,0, 0, "DMSINT", 0x0D, 0x1, 0x0, 0x0, 0x2, 6
,0, 0, "RMSINT", 0x0D, 0x1, 0x0, 0x0, 0x2, 6
,0, 0, "MDMSW", 0x0D, 0x2, 0x0, 0x0, 0x6, 6
,0, 0, "MRMSW", 0x0D, 0x2, 0x0, 0x0, 0x6, 6
,0, 0, "ZBDMS", 0x0D, 0x1, 0x0, 0x0, 0x2, 9
,0, 0, "ZBRMS", 0x0D, 0x1, 0x0, 0x0, 0x2, 9
,0, 0, "RDMSW", 0x0D, 0x3, 0x0, 0x0, 0x2, 6
,0, 0, "RRMSW", 0x0D, 0x3, 0x0, 0x0, 0x2, 6
,0, 0, "SBDMS", 0x0D, 0x3, 0x0, 0x0, 0x2, 9
,0, 0, "SBRMS", 0x0D, 0x3, 0x0, 0x0, 0x2, 9
,0, 0, "WDMSCS", 0x0D, 0x9, 0x0, 0x0, 0x0, 7
,0, 0, "WRMSCS", 0x0D, 0x9, 0x0, 0x0, 0x0, 7
,0, 0, "RDMSCS", 0x0D, 0xA, 0x0, 0x0, 0x0, 7
,0, 0, "RRMSCS", 0x0D, 0xA, 0x0, 0x0, 0x0, 7
,0, 0, "CGEW", 0x29, 0x6, 0x0, 0x0, 0x2, 6
,0, 0, "CGED", 0x29, 0x7, 0x0, 0x0, 0x2, 6
,0, 0, "CEGW", 0x29, 0xA, 0x0, 0x0, 0x2, 6
,0, 0, "CEGD", 0x29, 0xB, 0x0, 0x0, 0x2, 6
,0, 0, "CXIW", 0x29, 0x6, 0x0, 0x0, 0x2, 6
,0, 0, "CXID", 0x29, 0x7, 0x0, 0x0, 0x2, 6
,0, 0, "CIXW", 0x29, 0xA, 0x0, 0x0, 0x2, 6
,0, 0, "CIXD", 0x29, 0xB, 0x0, 0x0, 0x2, 6
,0, 0, "TC", 0xCA, 0x8, 0x0, 0x0, 0x1, 73
,0, 0, "PINTV", 0xCA, 0x9, 0x0, 0x0, 0x2, 19
,0, 0, "RINTV", 0xCA, 0xA, 0x0, 0x0, 0x2, 19
,0, 0, 0, 0, 0, 0, 0, 0, 0	/* zero last entry for table end */
};

/*
 * opscan - scan table for matching opcode
 * input - pointer to opcode string
 * output - pointer to opcode table entry or 0 if not found
 */

struct optab *opscan(opp)
char *opp;
{
	struct optab *otp;		/* opcode table pointer */
	int	val;
	char	tmpop[9];

	str2upr(opp);			/* uppercase scan */
	for (val=0; val < 8 && *opp != ' ';)
	  tmpop[val++] = *opp++;
	tmpop[val] = '\0';
	if (BM & option)		/* doing base mode? */
	  otp = opstabba;		/* point to base mode table */
	else
	  otp = opstab;	/* point to non base table */
	for(;;) {			/* do forever */
	  val = strncmp(tmpop, otp->opcode, 8);	/* test opcode */
	  if (val == 0)return(otp);	/* return if found */
	  if (val < 0)
	    otp = otp->llink;		/* if less, follow decending link */
	  else
	    otp = otp->rlink;		/* else, follow asending link */
	  if(otp)continue;		/* if valid link, continue */
	  break;			/* not here, return */
	}
	return ((struct optab *)0);	/* not found */
}

/*
 * opinit - routine to initialize base mode and non base mode opcode
 *	    tables.  Calls xopinit to do initialization
 * input - none
 * output - none
 */

void	opinit()
{
	xopinit(opstab);		/* initialize non base table */
	xopinit(opstabba);		/* initialize base table */
}

/*
 * xopinit routine to initialize opcode table
 * input - base address of table to initialized
 * output - none
 */

void	xopinit(otbasep)
struct optab *otbasep;		/* base address of table to be initialized */
{
	struct optab *otp = otbasep;	/* pointer to table */
	struct optab *otp2;
	int	val;

	for (; otp->opcode; otp++) {	/* scan all of the opcode table */
	  otp2 = otbasep;		/* start scan at start of table */
	  for (;;) {			/* scan until opening found */
	    val = strcmp(otp->opcode, otp2->opcode);	/* do compare */
	    if ( val < 0) {		/* new less than last, decend */
	      if (otp2->llink) {	/* is there a link here? */
		otp2 = otp2->llink;	/* get next decending link address */
		continue;		/* follow link */
	      }
	      otp2->llink = otp;	/* set decending link to new entry */
	    } else
	    if ( val > 0) {		/* new greater than last, ascend */
	      if (otp2->rlink) {	/* is there a link here? */
		otp2 = otp2->rlink;	/* get next decending link address */
		continue;		/* follow link */
	      }
	      otp2->rlink = otp;	/* set ascending link to new entry */
	    }
	    otp->llink = (struct optab *)0;	/* clear new entry */
	    otp->rlink = (struct optab *)0;	/* clear new entry */
	    break;			/* go do next entry */
	  }		/* end of forloop for insertion */
	}		/* end of forloop for whole table */
}
