/*~!newio.c*/
/* Name:  newio.c Part No.: _______-____r
 *
 * Copyright 1990 - International Software Corporation, Denver, Co.
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of International Software Corp.
 *
 *                     RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure by the Government is  subject  to
 * restriction  as  set forth in paragraph (b) (3) (B) of the Rights
 * in Technical Data and Computer Software  Clause  in  DAR  7-104.9
 * (a).
 */
/*
 *      NEWIO.C
 *
 *      UNIX I/O emulation routines - by JCB
 */

/* this version opens mode 1 as mpx update.   */
/* This is because write mode in MPX is not   */
/* sufficiently similar to write mode on UNIX */

#define _ERRNODEF
#include <errno.h>
#include "lio.h"
#include <types.h>
#include <stat.h>
#include <string.h>

#undef WHY

/*    data transfer routines */

/* write primitive */

int write (fd, buf, n)
int fd;
char *buf;
int n;
{
  register int mode;
  register int dev;

  BADFD (fd, EOF);
  INIT;
  mode = curfprm->mode;
  dev =  curfprm->device;
  if (mode == NOTUSED) {
    errno = E010;
    return (EOF);
  }
  if (mode == READMODE) {
    errno = E011;
    return (EOF);
  }
  if (dev == NULLFILE) return (n);

  return (curfprm->block ? _wbl (buf, (n>254) ? 254 : n)
    : _wub (buf, n));
}

/* read primitive */

int read (fd, buf, n)
int fd;
char *buf;
int n;
{
  register int mode;
  register int dev;

  BADFD (fd, EOF);
  INIT;
  mode = curfprm->mode;
  dev =  curfprm->device;
  if (mode == NOTUSED) {
    errno = E012;
    return (EOF);
  }
  if (mode == WRITMODE) {
    errno = E013;
    return (EOF);
  }
  if (dev == NULLFILE) {
    curfprm->eof = 1;
    return (0);
  }
  if (!n) return (0);

  return ((curfprm->block ? _rbl : _rub) (buf, n));
}

/* seek primitive */

int seek (fd, off, rel)
int  fd, rel;
long off;
{

  BADFD (fd, 0);
  INIT;
  if ((rel > 2) || (rel < 0)) {
    errno = E014;
    return (EOF);
  }

  if (curfprm->mode == NOTUSED) {
    errno = E015;
    return (EOF);
  }
  if (curfprm->device == NULLFILE) return (0);
  if (curfprm->block && (rel==1 || off)) {
    errno=E016;
    return (EOF);
  }
  if (curfprm->device != DISCFILE && curfprm->device != TERMINAL) {
    if (rel==1 || off) {
      errno = E016;
      return (EOF);
    }
    else {
      return (_skdv (rel));
    }
  }
  else {
    return ((curfprm->block?_skbl:_skub) (off, rel));
  }
}

static int _wbl (buf, n)
char *buf;
int n;
{
  register int count = 0;
  char *linadrs;
  int i;

  /* version of wbl for buffered blocked records */
  linadrs = curfil->line;

  if (curfprm->device == TERMINAL || curfprm->device == SPOOLFILE) {
    if (carcont) {
      /* put correct carriage control for terminal or SLO*/
      if (*buf == 0x0c) {
        buf++;
        *linadrs++ = '1';
        count++;
      }
      else{
        *linadrs++ = ' ';
      }
    }
  }
  while (count < n) {
    *linadrs++ = *buf++;
    count++;
  }

  if (! (curfprm->linptr=linadrs-curfil->line)) {
  /* MPX does'nt support zero length records, so we write a space */
    curfprm->linptr = 1;
    curfil->line [0] = ' ';
  }
  return (i = _putrec (curfprm->linptr, curfil->line) ? i : count);
}

static int _rbl (buf, n)
char *buf;
int n;
{
  register int count = 0;
  register char *cp;
  int i;
  char *linadrs = curfil->line;

  if (!curfprm->cmpop) {    /* see if we tested for compressed */
    curfprm->cmpop = 1;     /* set comp tested flag */
    /* read in the first record */
    if ((i = _getrec ()) == -1) return (EOF);  /* this means error */
    if (i == -2) return (0);                  /* this means eof */
    linadrs = curfil->line;
    if (*linadrs == 0xbf) { /* is this file compressed */
      curfprm->cmpflg = 1; /* set comp data flag */
      curfprm->bcnt = linadrs[1];     /* set record count */
      curfprm->bptr = &linadrs[6];      /* set data address */
    } else goto re00;
  }

  if (curfprm->cmpflg) {      /* reading compressed data? */
    if (curfprm->bcnt == 0) { /* any data left in buffer */
re18:
      /* read in a data record */
      if ((i = _getrec ()) == -1) return (EOF);  /* this means error */
      if (i == -2) return (0);                /* this means eof */
      linadrs = curfil->line;
      if ((*linadrs & 0xdf) != 0x9f)    /* is this valid rec */
        return (EOF);         /* error if not */
      curfprm->bcnt = linadrs[1];     /* set record count */
      curfprm->bptr = &linadrs[6];      /* set data address */
    }
re20:
    /* see if any blanks */
    if (i = *curfprm->bptr++) {       /* next buffer pointer */
      if (i == 0xff)goto re60;      /* if eol, get out */
      while (i--) {
        if(count < n) {
          *buf++ = ' ';       /* put blank in buffer */
          count++;
        }
      }
    }
      if (--curfprm->bcnt <= 0)goto re18; /* read next record */

    if (i = *curfprm->bptr++) {       /* next buffer pointer */
      while (i--) {
        if(count < n)
          *buf++ = *curfprm->bptr;  /* put char in buffer */
          curfprm->bcnt--;        /* decr count */
        curfprm->bptr++;        /* next buffer pointer */
        count++;
      }
    }
      if (--curfprm->bcnt <= 0)goto re18; /* read next record */
    goto re20;

re60:
      curfprm->bcnt--;      /* decr count */
    if ((*--buf == ' ') && (count == 1)) {
      *buf = '\n';      /* put new line at eol */
    } else {
      *++buf = '\n';      /* put new line at eol */
      count++;
    }

  } else {

    /* non compressed read here */

#ifdef WHY
    curfprm->linptr = 0;
#endif
    /* read the next record */
    if ((i = _getrec ()) == -1) return (EOF);  /* this means error */
    if (i == -2) return (0);                  /* this means eof */

re00:
    /* here we need to strip off blank put in during write */
    /* this is because mpx does not support zero length blocks */
    if ((curfcb->recl == 1) && (*linadrs == ' ')) curfcb->recl = 0;
    /* now append new line to end of buffer */
    * (cp=linadrs+curfcb->recl) = '\n';       /* point to last char */

    /* copy this layer buffer to upper caller's buffer */

    while (count < n) {
      if (linadrs > cp) break;
      *buf++ = *linadrs++;
      count++;
    }
  }

  return (count);

}

/*  getrec function   */

static int _getrec () {

  int reg [8];

  ZREG (reg, 8);
  curfcb->bufaddr = curfil->line;
  curfcb->excount = (curfprm->block?254:BLKSIZ);
  curfcb->exracc = curfprm->blkptr;
  reg [1] = (int) curfcb;
  mpxsvc (0x1031, reg, reg);

  if (curfcb->devstat & 0x40000000) {
    errno = E017;
    return (EOF);  /* error encountered */
  }
  if (curfcb->devstat & 0x01000000) {
    errno = E018;
    return (-2);  /* eom   encountered */
  }
  if (curfcb->devstat & 0x02000000) {  /* eof encountered */
    errno = E019;
    curfprm->eof = 1;
    return (-2);
  }
  return (0);
}

/*  putrec function  */

static int _putrec (count, plinad)
int count;
char *plinad;
{

  int reg [8];

  ZREG (reg, 8);

  curfcb->excount = count;
  curfcb->bufaddr = plinad;
  curfcb->exracc = curfprm->blkptr;
  reg [1] = (int) curfcb;
  mpxsvc (0x1032, reg, reg);
  if (curfcb->devstat & 0x40000000) {
    errno = E020;
    return (EOF);  /* error */
  }
  if (curfcb->devstat & 0x02000000) {
    errno = E021;
    return (EOF);  /* eof  */
  }

  curfprm->linptr = 0;
  if (curfcb->devstat & 0x01000000) {
    errno = E022;
    return (-2);   /* eom   encountered */
  }
  return (0);
}

/*    data transfer unblocked routines
_wub() and _rub */

static int _wub (buf, n)
char *buf;
int n;
{
  int i;
  register int count = 0;
  register int mode = curfprm->mode;    /* should be 1 or 2 */
  long l, m;
  char *linadrs;

  linadrs = curfprm->linptr + curfil->line;

  if (!BUFVALID && (mode==READWRIT)) GETR
    BUFVALID = 1;

  while (count <n) {

    if (curfprm->linptr >= BLKSIZ) {
      if (BUFALTER) PUTR
        curfprm->blkptr++;
      l = (BLKSIZ * curfprm->blkptr);
      if ((mode == READWRIT) || (l <= curfprm->eofptr)) {
        int i = 0;
        if ((i=_getrec ()) == EOF) return (i);
        if (i == EOM) {
        /* EOM is OK here, read is not allowed to extend file */
          for (i=0;i<BLKSIZ;i++)curfil->line [i]=0;
          BUFALTER = 0;
        }
      }
      else{
        int i;
        for (i=0;i<BLKSIZ;i++)curfil->line [i]=0;
        BUFALTER = 0;
      }
      linadrs = curfil->line;
      curfprm->linptr = 0;
    }
    *linadrs++ = *buf++;
    BUFALTER = 1;
    count++;
    curfprm->linptr++;
  }

  l = curfprm->linptr + (BLKSIZ * curfprm->blkptr);
  if ((mode == READWRIT) || (mode == WRITMODE)) {
    /* update mode, eofpos is max of previous and current */
    if (l > curfprm->eofptr) curfprm->eofptr = l;
  }
  else {
    /* write mode, eofpos is current */
    curfprm->eofptr = l;
  }
  return (count);

}

static int _rub (buf, n)
char *buf;
int n;
{
  register int count = 0;
  char *linadrs;

  if (curfprm->eof) {
    errno = E023;
    return (-1);
  }
  linadrs = curfprm->linptr + curfil->line;

  if (!BUFVALID) GETR
    BUFVALID = 1;

  while (count <n) {

    if (curfprm->linptr >= BLKSIZ) {
      if (BUFALTER) PUTR    /* mode presumed to be READWRIT here */
      curfprm->blkptr++;
      GETR
        linadrs = curfil->line;
      curfprm->linptr = 0;
    }
    *buf++ = *linadrs++;
    count++;
    curfprm->linptr++;
    if (BLKSIZ*curfprm->block+curfprm->linptr>=curfprm->eofptr) {
      curfprm->eof = 1;
      break;
    }
  }

  return (count);
}

/*    seek unblocked function */

static int _skub (off, type)
int type;
long off;
{

  register int mode, despos;
  int curpos, desoff, desblk;
  int curblk, i;
  int ebl;

  mode = curfprm->mode;    /* should be 0 or 1 or 2 */

  /* evaluate to where seek is desired */

  curpos = curfprm->blkptr*BLKSIZ + curfprm->linptr;
        /* clear error status */
      curfcb->devstat &= 0x00ffffff;

  despos = off;
  if (type == 1) despos += curpos;
  if (type == 2) despos += curfprm->eofptr;
  if (despos < 0) {
    errno = E024;
    return (EOF);
  }
  desoff = despos % BLKSIZ;
  desblk = despos / BLKSIZ;

  /* check eof validity */
  if (despos > curfprm->eofptr) {
    if (mode == READMODE) {   /* read mode can't go beyond eof */
      curfprm->eof = 1;
      despos = curfprm->eofptr;
    }
  }
  else {
    curfprm->eof = 0;           /* clear eof flag */
  }

  curblk = curfprm->blkptr;
  if (BUFVALID && BUFALTER && (mode!=READMODE)) {
    /* need to write out the current buffer */
    PUTR
  }
  BUFALTER = 0;

  curfprm->blkptr = desblk;

  /* ebl is the current EOF block  */
/*  if (mode == WRITMODE && ((ebl=curfprm->eofptr/BLKSIZ) < desblk)) */
  if (mode != READMODE && ((ebl=curfprm->eofptr/BLKSIZ) < desblk))
    /* write mode, seeking into a block
    that we haven't written to before */
    for (i=0;i<BLKSIZ;i++) curfil->line [i] = 0;
  else
    if (!BUFVALID || (desblk != curblk)) GETR

    BUFVALID = 1;
  curfprm->linptr = desoff;

  if (mode != READMODE && despos>curfprm->eofptr)
    curfprm->eofptr = despos;

  return (despos);
}

/*    seek blocked function */

static int _skbl (off, mode)
long off;
int mode;
{
  int reg [8];

  if (curfprm->device == TERMINAL) return (0);
  if (curfprm->mode!=READMODE && curfprm->linptr) {
    /* chars left in buff and write mode */
    curfcb->excount = curfprm->linptr;
    curfcb->bufaddr = curfil->line;
    ZREG (reg, 8);
    reg [1] = (int) curfcb;
    mpxsvc (0x1032, reg, reg);
  }

  ZREG (reg, 8);
  reg [1] = (int) curfcb;
  if (mode) {
    /* goto end of file */
    mpxsvc (0x1034, reg, reg);
    mpxsvc (0x1035, reg, reg);
  }
  else
    /* goto beginning of file */
    mpxsvc (0x1037, reg, reg);
  return(0);
}

/* seek on non-disc device */

static int _skdv (rel)
int rel;
{
  int reg [8];

  ZREG (reg, 8);
  reg [1] = (int) curfcb;
  if (rel)
    mpxsvc (0x1034, reg, reg);   /* goto end of file */
  else
    mpxsvc (0x1037, reg, reg);   /* goto beginning of file */
}

int readraw (fd, buf, n)
int fd;
char *buf;
int n;
{
  register int mode, dev;
  int reg [8];

  BADFD (fd, EOF);
  INIT;
  mode = curfprm->mode;
  dev =  curfprm->device;
  if (mode == NOTUSED) {
    errno = E012;
    return (EOF);
  }
  if (mode == WRITMODE) {
    errno = E013;
    return (EOF);
  }
  if (dev == NULLFILE) {
    curfprm->eof = 1;
    return (0);
  }
  if (!n) return (0);

  ZREG (reg, 8);

/* insure sequential write, not random */
  curfcb->cntl.ran = 0;
/* clear error status */
  curfcb->devstat &= 0x00ffffff;

  curfcb->bufaddr = buf;
  curfcb->excount = n;
  reg [1] = (int) curfcb;
  mpxsvc (0x1031, reg, reg);

  if (curfcb->devstat & 0x40000000) {
    errno = E017;
    return (EOF);  /* error encountered */
  }
  if (curfcb->devstat & 0x01000000) {
    errno = E018;
    return (-2);  /* eom   encountered */
  }
  if (curfcb->devstat & 0x02000000) {  /* eof   encountered */
    errno = E019;
    curfprm->eof = 1;
    return (-2);
  }
  return (curfcb->recl);
}

/*  writraw function  */

int writraw (fd, buf, n)
int fd;
char *buf;
int n;
{
  register int mode, dev;
  int reg [8];

  BADFD (fd, EOF);
  INIT;
  mode = curfprm->mode;
  dev =  curfprm->device;
  if (mode == NOTUSED) {
    errno = E010;
    return (EOF);
  }
  if (mode == READMODE) {
    errno = E011;
    return (EOF);
  }
  if (dev == NULLFILE) return (n);

  ZREG (reg, 8);

/* insure sequential write, not random */
  curfcb->cntl.ran = 0;
/* clear error status */
  curfcb->devstat &= 0x00ffffff;

  curfcb->excount = n;
  curfcb->bufaddr = buf;
  reg [1] = (int) curfcb;
  mpxsvc (0x1032, reg, reg);
  if (curfcb->devstat & 0x40000000) {
    errno = E020;
    return (EOF);  /* error */
  }
  if (curfcb->devstat & 0x02000000) {
    errno = E021;
    return (EOF);  /* eof  */
  }

  if (curfcb->devstat & 0x01000000) {
    errno = E022;
    return (-2);   /* eom   encountered */
  }
  return (curfcb->recl);
}

/*    open function     */

int open (path, mode)
char *path;
int mode;
{
  int fd;
  struct rrstag *rptr = &_rrs;
  char pname [64];

  if (path == 0 || *path == 0) {
    errno = E025;
    return (EOF);
  }
  strcpy (pname, path);   /* copy pathname */
  unix2mpx(pname);      /* make u/c mpx name */

  fd = getfd ();
  BADFD (fd, EOF);

  INIT;

  if (_cassg (pname)) {
    errno = E025;
    return (EOF);      /*parse pathname and build RRS */
  }

  if (assn (mode)) return (EOF);  /* assign with correct acc rghts */
  if (cnpo (mode)) return (EOF);  /* open */

  if ((mode == READWRIT) &&
    ((curfprm->device == TERMINAL) || (curfprm->device == SPOOLFILE)))
  {
    errno = E001;
    return (EOF);
  }

  curfil->line = bufrsio+ (BLKSIZ*fd);
  curfprm->mode = mode;              /* mark table entry open */

  if ((curfprm->block) && (curfprm->device == DISCFILE) &&
    (ieofbl == 0) && (mode == WRITMODE)) {
    /* we assume here that the file was created by TSM or Volmgr
    but has had nothing written into it: hence it has no end of
    file markers in it, and a subsequent seek to end of file
    would give IO06 errors without this. */

    int reg [8];
    ZREG (reg, 8);
    reg [1] = (int) curfcb;
    mpxsvc (0x1038, reg, reg);  /* write EOF on file */
    mpxsvc (0x1035, reg, reg);  /* and backspace over the EOF */
  }

  return (fd);
}

/* place for storing default access rights */
static  int fileacc[3]={0x3f, 0x3f, 0x20};
/* place for storing default file sizes */
#ifndef MPX1X
static  int orgs = 0;
static  int minx = 0;
static  int maxx = 0;
#else
static  int orgs = 100;
static  int minx = 100;
static  int maxx = 300;
#endif

/*  setsiz - set default sizes for created files */
int setsiz (ssiz, mini, maxi)
int ssiz, mini, maxi;
{
  orgs = ssiz;  /* starting size */
  minx = mini;  /* minimum increment */
  maxx = maxi;  /* maximum increment */
  return (0);       /* return o.k. */
}

/*  setacc - set default access for created files */
int setacc (owner, group, other)
int owner, group, other;
{
  fileacc[0] = owner;   /* set owner rights */
  fileacc[1] = group;   /* set group rights */
  fileacc[2] = other;   /* set other rights */
  return (0);       /* return o.k. */
}

/* getacc - get access rights of file */

int * getacc(pname)
char *pname;
{
#ifndef MPX1X
  int reg [8];
  int rdu[192];
  int pnblk [18];
  int pnbvec;

  if (prspn (pname, pnblk, &pnbvec)) return ((int *) -1);
  ZREG (reg, 8);
  reg [1] = pnbvec;
  reg [6] = (int) rdu;
  mpxsvc (0x202c, reg, reg);    /* log resource */
  if (reg [7]) return ((int *) -1);
  return (&rdu[30]);        /* return pointer to access rights */
#else
  if (access (pname, 0666) == (-1))
    return ((int *)(-1));
  return(fileacc);	/* return default 3X type of accesses */
#endif
}

/*    creat function    */

int creat (path, perm)
char *path;
int perm;                  /* permissions */
{
  int reg [8];
  int mode;
  int fd;
  int hadtocreate = 0;

  struct rrstag *rptr = &_rrs;
#ifdef MPX1X
  extern struct finfo * _fib;	/* definied in _cassg */
#else
  struct rcbtag rcb;
#endif
  char pname [64];

  if (path == 0 || *path == 0) {
    errno = E026;
    return (EOF);
  }
  strcpy (pname, path);   /* copy pathname */
  unix2mpx(pname);      /* make u/c mpx name */

  fd = getfd ();
  BADFD (fd, EOF);

  INIT;

  if (_cassg (pname)) {
    errno = E026;
    return (EOF);      /*parse pathname and build RRS */
  }

#ifdef MPX1X
 if ((rptr->flags & 0x80) && (access (pname, 0) == -1)) {
  /* create perminate file */

  /* set username for this file, save old */
  if (setuser(_fib->username, _fib->userkey) != NULL) {
    errno = E002;		/* can't creat file, error */
    return (mpxerr = 9);	/* show RM09 err, invalid usage */
  }
  ZREG (reg, 8);
  reg[1] = 0xee;	/* filetype will be EE */
  if (!_fib->username[0])reg[1] |= 0x80000000;	/* set system file */
  reg[2] = rptr->size;	/* get file size to create */
  reg[3] = rptr->wd2 & 0x8000ffff;	/* get chan/sa */
  reg[3] |= ((rptr->wd2 & 0x7f000000) > 8);  /* get dev type */
  if (_fib->password[0] || _fib->password[1]) {
    /* we have a password, set password req'd */
    reg[2] |= 0x01000000;	/* set password flag */
    reg[4] = _fib->password[0];	/* set password */
    reg[5] = _fib->password[1];	/* set password */
  }
  reg[6] = _fib->filename[0];  /* first part of filename */
  reg[7] = _fib->filename[1];  /* second part of filename */
  mpxsvc (0x1075, reg, reg);  /* m.create service */
  /* if r6 returned 0, file not found */
   if (reg[6] == 0) {
    resetuser();    /* reset username to what it was */
    errno = E002;		/* can't creat file, error */
    return (mpxerr = 9);	/* show RM09 err, invalid usage */
  }
  /* must reset username to what it before log */
  resetuser();    /* reset username to what it was */
  hadtocreate = 1;
 }
#else
  if ((rptr->type == 1) &&
    !prspn (pname, curfil->_pnb, &PNBWRDX) && exist (PNBWRDX)) {
    /* it's a type 1 RRS, so a permanent file,
    it can make a pathname block, and it doesn't currently exist */

    ZINT (&rcb, (sizeof (rcb) /sizeof (int)));
    /* set defaults in rcb */
  rcb._owri = ((fileacc[0] << 26) | ((fileacc[0] & 1)?0x400000:0));
  rcb._ugri = ((fileacc[1] << 26) | ((fileacc[1] & 1)?0x400000:0));
  rcb._otri = ((fileacc[2] << 26) | ((fileacc[2] & 1)?0x400000:0));
    rcb._osiz = orgs; /* starting size */
    rcb._mnei = minx; /* minimum increment */
    rcb._mxei = maxx; /* maximum increment */

    if (perm) {
      char own, pro, oth;
      /* MPX access rights R W M U A D done here */
      /* UNIX are R W X */
      /* if perm & ~0x1ff is not zero, them MPX, else */
      /* assume UNIX flags given and translate to MPX */

      if ((perm & ~0x1ff) == 0) {
        /* simulate UNIX */
        if ((oth = (perm & 7) << 3) && 0x10) oth |= 0x3f;
        if ((pro = ((perm >> 3) & 7) << 3) && 0x10) pro |= 0x3f;
        if ((own = ((perm >> 6) & 7) << 3) && 0x10) own |= 0x3f;
      }
      else {
        oth = perm&63;
        pro = (perm >> 8) &63;
        own = (perm >> 16) &63;
      }
      if (oth) {
        if (oth&1) rcb._otri = 0x400000;
        oth &= 62;
        rcb._otri |= (oth << 26);
      }
      if (pro) {
        if (pro&1) rcb._ugri = 0x400000;
        pro &= 62;
        rcb._ugri |= (pro << 26);
      }
      if (own) {
        if (own&1) rcb._owri = 0x400000;
        own &= 62;
        rcb._owri |= (own << 26);
      }
      if (!rcb._otri) rcb._opts = 0x20000000;
      if (!rcb._ugri) rcb._opts |= 0x40000000;
      if (!rcb._owri) rcb._opts |= 0x80000000;
    }

    ZREG (reg, 8);
    reg [1] = PNBWRDX;
    reg [2] = (int) &rcb;
    if (rptr->opts.unblk) rcb._flags._eofm = 1;
    mpxsvc (0x2020, reg, reg);
    if (reg [7]) {
      errno = E002;
      return (mpxerr=reg [7]);
    }
    hadtocreate = 1;
  }
#endif /* MPX1X */

  mode = WRITMODE;        /* creat opens in write mode */
  if (assn (mode)) return (EOF);  /* assign with correct acc rghts */

  if (cnpo (mode)) return (EOF);  /* open */
  curfprm->eofptr = 0;      /* all creatted files have 0 len */
  curfil->line = bufrsio+ (BLKSIZ*fd);

  curfprm->mode = mode;     /* mark table entry open */

  if (curfprm->block && (curfprm->device == DISCFILE)) {
    ZREG (reg, 8);
    reg [1] = (int) curfcb;
    mpxsvc (0x1038, reg, reg);  /* write EOF on file */
    mpxsvc (0x1035, reg, reg);  /* and backspace over the EOF */
  }

  return (fd);
}
/*    creatd function  -  create directory  */

int creatd (path, perm)
char *path;
int perm;                                 /* permissions */
{
#ifdef MPX1X
/* there is no conversion of creat dir in 1x, give error */
  errno = E026;
  return(EOF);
#else
  int reg [8];
  int mode;
  int fd;

  struct rrstag *rptr = &_rrs;
  struct rcbtag rcb;
  char pname [64];

  if (path == 0 || *path == 0) {
    errno = E026;
    return (EOF);
  }
  strcpy (pname, path);   /* copy pathname */
  unix2mpx(pname);      /* make u/c mpx name */

  fd = getfd ();
  BADFD (fd, EOF);

  INIT;

  if (_cassg (pname)) {
    errno = E026;
    return (EOF);      /*parse pathname and build RRS */
  }

  if ((rptr->type == 1) &&
    !prspn (pname, curfil->_pnb, &PNBWRDX) && exist (PNBWRDX)) {
    /* it's a type 1 RRS, so a permanent file,
    it can make a pathname block, and it doesn't currently exist */

    ZINT (&rcb, (sizeof (rcb) /sizeof (int)));
    /* set defaults in rcb */
    rcb._owri = 0xf8f00000;
    rcb._ugri = 0xf8f00000;
    rcb._otri = 0xf8f00000;
    rcb._osiz = 0;  /* starting size */
    rcb._mnei = 0;  /* minimum increment */
    rcb._mxei = 0;  /* maximum increment */

#ifdef JUNK
    if (perm) {
      char own, pro, oth;
      /* MPX access rights R W M U A D done here */
      /* UNIX are R W X */
      /* if perm & ~0x1ff is not zero, them MPX, else */
      /* assume UNIX flags given and translate to MPX */

      if ((perm & ~0x1ff) == 0) {
        /* simulate UNIX */
        if ((oth = (perm & 7) << 4) && 0x10) oth &= 0x3f;
        if ((pro = ((perm >> 3) & 7) << 4) && 0x10) pro &= 0x3f;
        if ((own = ((perm >> 6) & 7) << 4) && 0x10) own &= 0x3f;
      }
      else {
        oth = perm&63;
        pro = (perm >> 8) &63;
        own = (perm >> 16) &63;
      }
      if (oth) {
        if (oth&1) rcb._otri = 0x400000;
        oth &= 62;
        rcb._otri |= (oth << 26);
      }
      if (pro) {
        if (pro&1) rcb._ugri = 0x400000;
        pro &= 62;
        rcb._ugri |= (pro << 26);
      }
      if (own) {
        if (own&1) rcb._owri = 0x400000;
        own &= 62;
        rcb._owri |= (own << 26);
      }
      if (!rcb._otri) rcb._opts = 0x20000000;
      if (!rcb._ugri) rcb._opts |= 0x40000000;
      if (!rcb._owri) rcb._opts |= 0x80000000;
    }

#endif /* JUNK */

    ZREG (reg, 8);
    reg [1] = PNBWRDX;
    reg [2] = (int) &rcb;
    mpxsvc (0x2023, reg, reg);
    if (reg [7]) {
      errno = E002;
      return (mpxerr=reg [7]);
    }
  }

  return (0);
#endif
}

/*  close function  */

int close (fd)
int   fd;
{
  int reg [8];
  double dumbound;
  int usrrd [32];
  register int mode, dev;

  BADFD (fd, EOF);
  INIT;
#ifndef MPX1X
  PNBWRDX = curfil->pnbw;
#endif

  if ((mode=curfprm->mode) == NOTUSED) return (EOF);

  if (mode!=READMODE) {         /* write or update */
    curfcb->bufaddr = curfil->line;
    ZREG (reg, 8);
    reg [1] = (int) curfcb;
    if (curfprm->block) {
      curfcb->excount = curfprm->linptr;
      if (curfprm->linptr) {
        mpxsvc (0x1032, reg, reg);
        curfprm->linptr = 0;
      }
    }
    else {
      curfcb->excount = BLKSIZ;
      if (BUFVALID && BUFALTER) {
        curfcb->exracc = curfprm->blkptr;
        mpxsvc (0x1032, reg, reg);
      }
    }
  }

#ifndef MPX1X
  /* there is no user rd area in 1X, delete code */

  /* write back the eof position  */
  if ((dev==DISCFILE) && mode!=READMODE) {
    ZREG (reg, 8);
    reg [1] = curfil->_pnb [8];   /* keeping the RID here */
    reg [6] = (int) usrrd;
    mpxsvc (0x2031, reg, reg);
    if (!reg [7]) {
      if (curfprm->block) {
        /* try to type the file as CBLFIL */
        usrrd [CUBFL1 - CUBFUS] = CBLFIL;   /* type it */
      }
      else {
        usrrd [CUBFL1 - CUBFUS] = CUBFIL;   /* type it */
        usrrd [CUBFL2 - CUBFUS] = curfprm->eofptr;  /* length it */
      }
      ZREG (reg, 8);
      reg [6] = (int) usrrd;
      mpxsvc (0x2032, reg, reg);
    }
  }
#endif /* MPX1X */

  if (curfprm->block&& (curfprm->device==DISCFILE) && (mode==WRITMODE))
    {

    /* The purpose of this code here is to more completely emulate
    the UNIX write mode of file operation. If no data was written
    to the file, then an EOF should be written at the beginning.
    Here, an EOF is written to the current position (which will be
    at the start of the file if no data has been written). To avoid
    potential problems when two streams are opened to the same file,
    we backspace over the EOF after writing it. */

    int reg [8];
    ZREG (reg, 8);
    reg [1] = (int) curfcb;
    mpxsvc (0x1038, reg, reg);  /* write EOF on file */
    mpxsvc (0x1035, reg, reg);  /* and backspace over the EOF */
  }

  ZREG (reg, 8)
  reg [1] = (int) curfcb;
#ifdef MPX1X
  mpxsvc (0x1038, reg, reg);	/* write EOF on file */
  mpxsvc (0x1037, reg, reg);    /* rewind the file */
  mpxsvc (0x1039, reg, reg);    /* close the file */
  reg [5] = (int)(*(int*)curfcb) & 0xffffff; /* get lfc */
  mpxsvc (0x1041, reg, reg);	/* deallocate the file */
#else
  mpxsvc (0x2053, reg, reg);    /* deassign the file */
  if (reg [7]) {
    errno = E003;
    mpxerr = reg [7];
    return (EOF);
  }
#endif

  curfprm->mode = NOTUSED;
  curfprm->linptr = curfprm->blkptr = curfprm->block =
    curfprm->eofptr = curfprm->eof = curfprm->device = 0;
  BUFVALID = BUFALTER = 0;   /* Version G Fix */

  return (0);
}

#ifdef MPX1X
static int reg5, reg6, reg7;
#endif

/* assign function */
static int assn (mode)
int mode;
{
  int i, reg [8];
  struct rrstag *rptr = &_rrs;
#ifdef MPX1X
  extern struct finfo * _fib;	/* definied in _cassg */

  reg5 = *(int *)(curfcb);	/* get LFC */
  curfcb->cntl.exp = 1;         /* ensure expanded fcb */
  reg5 |= 0x20000000;		/* wait for resource */
  if (rptr->flags & 0x04)reg5 |= 0x40000000;  /* set unblocked */
  if (rptr->flags & 0x02)reg5 |= 0x80000000;  /* set inhb mnt */
  if (rptr->flags & 0x80) {	/* perm file */
    reg5 |= 0x01000000;			/* type 1 rrs */
    reg6 = (int)_fib->filename;	/* set filename address */
    if (_fib->password[0] || _fib->password[1])
      reg7 = (int)_fib->password;	/* set password address */
  }
  if (rptr->flags & 0x60) {        	/* sys file code */
    reg5 |= 0x02000000;			/* type 2 rrs */
    reg6 = (int)&rptr->wd2;		/* slo or sbo */
    reg7 = rptr->size;			/* file size */
  }
  if (rptr->flags & 0x10) {     	/* device code */
    reg5 |= 0x03000000;			/* type 3 rrs */
    reg6 = (int)&rptr->wd2;		/* type, ch, sa*/
    reg7 = rptr->size;			/* file size or reel id */
  }
  if (rptr->flags & 0x08) {     	/* as lfc=lfc */
    reg5 |= 0x04000000;			/* type 4 rrs */
    reg6 = (int)&rptr->wd2;		/* lfc to assign */
    reg7 = 0;				/* zero */
  }
  asm (" la 1,altret");			/* set error ret addr */
  asm (" lw 5,_reg5");			/* get type & LFC */
  asm (" lw 6,_reg6");			/* get chan & sa */
  asm (" lw 7,_reg7");			/* get size */
  asm (" svc 1,x'40'");			/* M.ALOC	 */
  asm (" li 6,-1");			/* o.k. return	 */
  asm ("altret stw 6,_reg6");		/* save error code */
  if (reg6 == -1) return(0);		/* return ok */
  mpxerr = reg6;			/* set error code */
  errno = E004;				/* set error code */
  return (reg6);			/* return error */
#else
  for (i = 0; i < 3; i++)
    rptr->lfc [i] = curfcb->lfc [i]; /* put LFC in RRS */

  if (mode!=READMODE) rptr->accs.updat = 1;
  else     rptr->accs.read  = 1;

  curfcb->cntl.exp = 1;              /* ensure expanded fcb */

  if (rptr->type == 4) {
    rptr->accs.read = 0;
    rptr->accs.write = 0;
    rptr->accs.modfy = 0;
    rptr->accs.updat = 0;
    rptr->accs.appnd = 0;
  }

  ZREG (reg, 8);
  reg [1] = (int) rptr;
  mpxsvc (0x2052, reg, reg);            /* assign */

  if (reg [7]) {
    mpxerr = reg [7];
    errno = E004;
  }
  return (reg [7]);
#endif
}

static int cnpo (mode)
int mode;
{
  int reg [8], i;
#ifndef MPX1X
  int *parinq [8];
  struct fattag *fatptr;
  double dumb1;
  int rd [192];
  struct cnptag cnp;
#else
  int diskfile=0;
#endif
  struct rrstag *rptr = &_rrs;
  int sgofil = 0;

  ZREG (reg, 8);
#ifdef MPX1X
  for (i=0;i<3;i++) {
    reg [5] <<= 8;
    reg [5] |= curfcb->lfc [i];
  }
  mpxsvc (0x1042, reg, reg);            /* device inquiry */
  if (!reg[6]) {                        /* error if r6 = 0 */
    errno = E005;                       /* r7 is returned, but */
    return (EOF);                       /* can be zero for console */
  }                                     /* so we test r6 for zero */
  sgofil = (reg[7] & 0x00070000) >> 16;   /* get sys file type if any */
  switch ((reg[7] >> 24) & 0xff) {      /* switch on device type */
    case 0:     /* console */
    case 0x0c:  /* tty */
    case 0x0d:  /* console ct */
      curfprm->device = TERMINAL;     /* terminal */
      break;
    case 0x01:  /* disk */
    case 0x02:  /* disk */
    case 0x03:  /* disk */
      diskfile = 1;
    default:
      curfprm->device = DISCFILE;     /* file */
      break;
    case 0x0f:  /* null device */
      curfprm->device = NULLFILE;
      return (0);
    case 0x0a:  /* lineprinter */
      curfprm->device = SPOOLFILE;    /* SLO */
  }
  if (sgofil == 3)
    curfprm->device = SPOOLFILE;    /* SLO */
  /* get correct blocking info */
  curfprm->block = ((reg[7] & 0x00800000) ? 1 : 0);
  /* set blocked bits */
  /* ensure terminals are opened blocked */
  if (curfprm->device == TERMINAL ||
    curfprm->device == SPOOLFILE) curfprm->block = 1;

  /* fudge blocking and access rights for
  some special files */
  if (rptr->flags & 0x08) {
    if (mode!=READMODE) {
      /* mode is write or update */
      if (( sgofil == 3) || curfprm->device == TERMINAL) {
        curfprm->block = 1;
      }
      else if (sgofil) {        /* open in default mode */
        curfprm->block = 1;
      }
    }
  }
#else
  for (i=0;i<3;i++) {
    reg [4] <<= 8;
    reg [4] |= curfcb->lfc [i];
  }
  reg [1] = (int) parinq;
  mpxsvc (0x2048, reg, reg);            /* resource inquiry service */

  fatptr = (struct fattag *) parinq [1];
  if (!fatptr) {
    errno = E005;
    return (EOF);
  }
#endif

#ifndef MPX1X
  /* set device info */
  if (fatptr->null) {                 /* null device */
    curfprm->device = NULLFILE;
    return (0);
  }
  else if ((fatptr->acf & 0x7) ==3)
    curfprm->device = SPOOLFILE;    /* SLO */
  else if (fatptr->tsm)
    curfprm->device = TERMINAL;     /* terminal */
  else  curfprm->device = DISCFILE;     /* file */

  sgofil = ((fatptr->acf&0x7) == 2);

  /* get correct blocking info */
  curfprm->block = ((fatptr->attr & UNBLASS) ?0:1);
  /* set blocked bits */
  /* ensure terminals are opened blocked */
  if (curfprm->device == TERMINAL ||
    curfprm->device == SPOOLFILE) curfprm->block = 1;

  cnp.abrtn = cnp.status = cnp.resvd[0] = cnp.resvd[1] =
    cnp.resvd[2] = cnp.timeout = 0;
  cnp.options = 0;
  if (curfprm->block) {
    cnp.options = OBL;
    curfcb->cntl.bl = 1;
  }
  else{
    cnp.options = OUB;
    curfcb->cntl.bl = 0;
  }

  /* fudge blocking and access rights for
  some special files */
  if (rptr->type ==4) {
    if (mode!=READMODE) {
      /* mode is write or update */
      if (((fatptr->acf & 0x7) ==3) || fatptr->tsm) {
        curfprm->block = 1;
        cnp.options &= ~ (OBL|OUB); /* clear blocking info */
        cnp.options |= OBL;
      }
      else if (sgofil) {        /* open in default mode */
      }
      else {
        cnp.options |= OUPD;    /* open in update mode */
      }
    }
  }
#endif
  curfcb->cntl.ran = (curfprm->block ? 0 : 1);
#ifdef MPX1X
  reg [1] = (int) curfcb;
  if (mode != READMODE && (sgofil != 1))
    reg[1] |= 0x40000000;               /* set read/write */
  mpxsvc (0x1030, reg, reg);            /* open resource */
#else
  ZREG (reg, 8);
  reg [7] = (int) &cnp;
  reg [1] = (int) curfcb;
  mpxsvc (0x2042, reg, reg);            /* open resource */

  if (cnp.status) {
    errno = E006;
    return (mpxerr=cnp.status);
  }
#endif
  curfprm->blkptr = 0;
  curfprm->linptr = 0;
  curfprm->eof    = 0;
  curfprm->cmpop   = 0;     /* clear tested for compressed flag */
  curfprm->cmpflg  = 0;     /* clear compressed file flag */
#ifndef MPX1X
  ZREG (curfil->_pnb, 9);              /* for the RID */
#endif

  curfprm->eofptr = 0x7FFFFFFF;
#ifdef MPX1X
  if (curfprm->device == DISCFILE && diskfile ) {  /* file */
    curfprm->eofptr = (BLKSIZ * reg[5]) -1;
    /* if no value in RD, try to work out a value */
    ieofbl = 0;
  }
#else
  if (curfprm->device == DISCFILE) {  /* file */
    ZREG (reg, 8);
    reg [1] = (int) curfcb;
    reg [6] = (int) rd;
    mpxsvc (0x202c, reg, reg);
    ieofbl = -1;
    if (!reg [7]) {
      int i;         /* save RID */
      for (i = 0; i < 8; i++)
        curfil->_pnb [i] = rd [i];  /* RID copy */
      curfil->_pnb [8] = (32 << 24) | (int) curfil->_pnb;
      if ((rd [7]&0x0000ffff) == 12)
        /* it's a TEMP file, so length is zero */
        curfprm->eofptr = 0;
      else if (rd [CUBFL1] == CUBFIL)
        /* if the file has been previously typed by
          the C library, it will have been lengthed */
        curfprm->eofptr = rd [CUBFL2];
      else
        curfprm->eofptr = BLKSIZ * rd [69] -1;
      /* if no value in RD, try to work out a value */
      ieofbl = rd [REOFBL];
    }
  }
#endif
  return (0);
}

#ifndef MPX1X
/* pathname parse */

static int prspn (pname, pnblk, pnbvec)
char *pname;
int  *pnblk;
int *pnbvec;
{
  struct rrstag *rptr = &_rrs;
  char name [54], *nam = name, c;
  int reg [8];
  register int l;

  *pnbvec = 0;
  while (c = *pname++) {
    if (c>='a' && c<='z') c -= ('a' - 'A');
    *nam++ = c;
  }
  *nam = '\0';

  if ((l = strlen (name)) > 52) {
    errno = E007;
    return (1);
  }
  else if (!l) {
    errno = E008;
    return (-1);
  }

  ZREG (reg, 8);
  reg [1] = l;
  reg [1] <<= 24;
  reg [1] |= (int) name;
  reg [4] = 18 * sizeof (int);
  reg [4] <<= 24;
  reg [4] |= (int) pnblk;
  mpxsvc (0x202e, reg, reg);    /* make pathname block */

  if (reg [7]) {
    mpxerr = reg [7];
    errno = E009;
    return (-1);
  }
  *pnbvec = reg [4];
  return (0);
}
#endif

#ifndef MPX1X
/*    exist internal function */

static int exist (pnbvec)
int pnbvec;
{
  int reg [8];
  int rdu [192];

  ZREG (reg, 8);
  reg [1] = pnbvec;
  reg [6] = (int) rdu;
  mpxsvc (0x202c, reg, reg);
  return (reg [7]);
}
#endif

/*   getfd function     */

static int getfd ()
{
  int fd;

  for (fd=0;fd<FILECNT;fd++)
    if (filtabl [fd].filparm.mode == NOTUSED) return (fd);
  return (EOF);
}

/*  __isblk function */

int __isblk (fd)
int fd;
{
  struct flprmtag  *p;

  BADFD (fd, EOF);
  p = & (filtabl [fd].filparm);
  if (p->mode == NOTUSED) return (-1);
  return (p->block);
}

/* isatty function */

int  isatty (fd)
int fd;
{
  struct flprmtag  *p;

  BADFD (fd, 0);
  p = & (filtabl [fd].filparm);
  if (p->mode == NOTUSED) return (-1);
  return (p->device == TERMINAL);
}

/*  fcbadr function   */

struct fcbtag *fcbadr (fd)
int fd;
{
  BADFD (fd, 0);
  if (filtabl [fd].filparm.mode == NOTUSED) return (0);
  return (& (filtabl [fd].fcb));
}

/*    access function (not currently used, if required,
    will be converted to use MPX access modes like creat does).
    Currently not compiled */

#ifdef INCACCESS

int access (name, amode)
char *name;
int amode;
{
  int reg [8];
  int rdu [192];
  int ow, pr, ot;
  register int acc=0;
  int owr, prr, otr;
  int wacc = 0X40000000;             /* write access */
  int uacc = 0X20000000;             /* update access */
  int pnblk [18];
  int pnbvec;

  if (prspn (name, pnblk, &pnbvec)) return (-1);
  ZREG (reg, 8);
  reg [1] = pnbvec;
  reg [6] = (int) rdu;
  mpxsvc (0x202c, reg, reg);
  if (reg [7]) return (-1);
  ow = rdu [30];
  pr = rdu [31];
  ot = rdu [32];
  owr = ow<0;
  prr = pr<0;
  otr = ot<0;
  acc |= owr;      /* owner read access */
  acc <<= 1;
  acc |= (ow&wacc && ow&uacc);       /* owner write access */
  acc <<= 1;
  acc |= 1;        /* owner assumed execute access */
  acc <<= 1;
  acc |= prr;      /* project read access */
  acc <<= 1;
  acc |= (pr&wacc && pr&uacc);       /* project write access */
  acc <<= 1;
  acc |= 1;        /* project assumed execute access */
  acc <<= 1;
  acc |= otr;      /* other read access */
  acc <<= 1;
  acc |= (ot&wacc && ot&uacc);       /* other write access */
  acc <<= 1;
  acc |= 1;        /* other assumed execute access */

  return acc;
}

#endif

/* delete function (unlink if you insist) */

int delete (pname)
char *pname;
{
  int reg [8];
#ifdef MPX1X
  return (unlink(pname));       /* delete the file */
#else
  int pnblk [18];
  int pnbvec;

  if (prspn (pname, pnblk, &pnbvec)) return (-1);
  if (exist (pnbvec)) return (0);
  ZREG (reg, 8);
  reg [1] = pnbvec;
  mpxsvc (0x2024, reg, reg);
  if (reg [7]) {
    errno = E029;
    return (-1);
  }
  return (0);
#endif
}

/* carriage control toggler */
void mpxccset (tog)
int tog;
{
  carcont = tog;
}

#ifdef MPX1X

/* if not MPX 1X, these routines defined in misc.c */
/* fid is rel file number in _iob or in parallel filtabl here.
 * value is 0 > fid < _NFILE.  To get fid from _iob[fid] address
 * call:  fid = fileno(fd);
 */

char *
getpath(fid)     /* reconstruct pathname from file i.d. of open file */
int     fid;
{
  char * bad = (char *)-1;
  char pathname[64];
  char * p;

  BADFD (fid, bad);
  if (filtabl [fid].filparm.mode == NOTUSED) return (bad);
  strcpy (pathname, "@SYSTEM(");
  CPYNAME ((char *)filtabl[fid].fib.username, (p=strchr(pathname, '\0')));
  p = strchr(pathname, '\0');
  if (*(char *)filtabl[fid].fib.userkey != '\0') {
    *p++ = ',';
    CPYNAME ((char *)filtabl[fid].fib.userkey, p);
    p = strchr(pathname,'\0');
  }
  p = strchr(pathname, ')');
  *p++ = ')';
  CPYNAME ((char *)filtabl[fid].fib.filename, p);
  p = strchr(pathname,'\0');
  if (*(char *)filtabl[fid].fib.password != '\0') {
    *p++ = ',';
    CPYNAME ((char *)filtabl[fid].fib.userkey, p);
    p = strchr(pathname,'\0');
  }
  return (pathname);
}

fstat(fid, sb)    /* get file status */
int     fid;      /* file number */
struct stat *sb;  /* status buffer pointer */
{
  int bad = -1;

  BADFD (fid, bad);
  if (fcbadr(fid) <= 0)return (bad);
  return (stat (getpath(fid), sb));   /* get file status */
}

struct finfo * pn2fib();  /* stop the errors */

/* setuser
 * will set current username to that specified by caller
 * old username and key will be saved so it can be restored
 * by restuser routine defined below
 */
int tmpuser[2]; /* where we save username for restuser */
      /* if tmpuser[0] == 0:  -> no username */
      /* if tmpuser[0] != 0:  -> ascii username */
short tmpkey;   /* where we save compressed key */
short chgun;    /* set non zero if username changed */

extern short userkey;	/* defined in mpxini.c */
extern curwdir[];	/* defined in mpxini.c */

setuser(un, ky)
int * un; /* new username to set */
    /* if un[0] == 0:     -> no username */
    /* if un[0] and un[1] == 'SYSTEM':  -> no username */
    /* if un[0] and un[1] == all blanks:  -> no username */
    /* if un[0] != 0:     -> have username */
int * ky; /* new userkey to set */
    /* if ky[0] == 0 and ky[1] == val:  -> comp key */
    /* if ky[0] == 0 and ky[1] ==0:   -> no key */
    /* if ky[0] and ky[1] are ascii blanks: -> no key */
    /* if ky[0] != 0:     -> ascii key */
{
  int tempuser[2];
  int tempkey[2];
  int reg[8];

  getcwvd();      /* get current username info */
  chgun = 0;      /* username not changed yet */
  tmpuser[0] = curwdir[0];  /* save curr username */
  tmpuser[1] = curwdir[1];  /* save curr username */
  tmpkey = userkey;   /* save compressed key */

  /* if curwdir is null, no username associated with task */
  /* i.e., it is system.  Userkey would also be null */
  /* set up new username, assume system fisrt */
  tempuser[0] = 0;  /* assume no username */
  tempuser[1] = 0;  /* assume no username */
  tempkey[0] = 0;   /* assume no userkey */
  tempkey[1] = 0;   /* assume no userkey */
  if (un[0] != 0) {
    /* we have a name, check for system or blanks */
    if (strncmp ((char *)un, "SYSTEM  ", 8) == 0)
      ;
    else if (strncmp ((char *)un, "        ", 8) == 0)
      ;
    /* not system or blanks, must have username */
    else strncpy ((char *)tempuser, (char *)un, 8);
  }
  /* tempuser now has null or username, check if the same as old */
  /* see if using same username */
  if ((tempuser[0] != tmpuser[0]) ||
    (tempuser[1] != tmpuser[1])) {
    /* we need to change username, first determine key */
    if (strncmp ((char *)ky, "        ", 8) == 0)
      ;
    /* not blanks, copy userkey, could be null or ascii */
    else {
      tempkey[0] = ky[0]; /* set userkey */
      tempkey[1] = ky[1]; /* set userkey */
    }
    /* set key in r4 & r5 */
    reg[4] = tempkey[0];
    reg[5] = tempkey[1];
    /* set username in r6 & r7 */
    reg[6] = tempuser[0];
    reg[7] = tempuser[1];
    mpxsvc (0x1074, reg, reg);  /* set new username, m.user */
    if (reg[6] != tempuser[0])  /* if changed, not valid */
      return (0);   /* return error */
    /* we have valid username, key */
    chgun = 1;    /* show we changed username */
  }
  return (1); /* success */
}

/* resetuser
 * will reset the username to what it was before calling setuser
 * only reset if chgun flag was set
 */
resetuser()
{
  int reg[8];

  if (chgun == 0)return;    /* not changed, return */
  /* set old key in r4 & r5 */
  reg[4] = 0;
  reg[5] = tmpkey;
  /* set old username in r6 & r7 */
  reg[6] = tmpuser[0];
  reg[7] = tmpuser[1];
  mpxsvc (0x1074, reg, reg);  /* reset username, m.user */
  /* we have reset username, key */
  chgun = 0;      /* show we changed username */
}

/* test for the existance of a file */
/* returns -1 if file not found */
/*   else returns status buffer */

stat(pname, sb)     /* get file status */
char *pname;
struct stat *sb;  /* status buffer pointer */
{
  int reg[8];
  int smd[8];   /* SMD entry buffer */
  struct finfo * foo; /* file info block pointer */
  char path[64];

  if (pname == 0 || *pname == 0) {
    errno=ENOENT;   /* set file not found error */
    return(-1);   /* error return value */
  }
        strcpy(path, pname);  /* make a local copy */
        unix2mpx(path);   /* convert to MPX path */
  if ((foo = pn2fib(path)) == NULL) {
    errno=ENOENT;   /* set file not found error */
    return(-1);   /* error return value */
  }

  /* set username for this file, save old */
  if (setuser(foo->username, foo->userkey) != NULL) {
    errno=ENOENT;   /* set file not found error */
    return(-1);   /* error return value */
  }

  ZINT (smd, 8);      /* clear SMD entry */
  reg[4] = 0;
  reg[5] = (int)smd;    /* where SMD entry goes */
  reg[6] = foo->filename[0];  /* first part of filename */
  reg[7] = foo->filename[1];  /* second part of filename */
  mpxsvc (0x1073, reg, reg);  /* m.log service */
  /* if r5 returned 0, file not found */
  if (reg[5] == 0) {
    resetuser();    /* reset username to what it was */
    errno=ENOENT;   /* set file not found error */
    return(-1);   /* error return value */
  }
  /* must reset username to what it before log */
  resetuser();    /* reset username to what it was */

  /* simulate status buffer info from SMD entry */
  sb->st_dev = smd[5] & 0xffff; /* use udt index for dev */
  sb->st_ino = smd[2] & 0xffffff; /* use starting blk # for inode */
  sb->st_nlink = (smd[2] >> 24) & 0xff; /* use file type for link cnt */
  sb->st_uid = (smd[3] >> 24) & 0xff; /* use uid for file inds */
  sb->st_gid = 0;       /* unused fields */
  sb->st_rdev = (smd[6] >> 16) & 0xffff;  /* password for file */
  sb->st_size = (smd[8] & 0xffffff) * 768; /* eof size in bytes */
  /* no time are available, set to zero */
  sb->st_atime = sb->st_ctime = 0;  /* last access was read */
  sb->st_mtime = 0;     /* last modify time */
  sb->st_mode = 0666;   /* assume r/w for everybody */
  if (sb->st_nlink == 0 || sb->st_nlink == 0xed ||
    sb->st_nlink == 0xee || sb->st_nlink == 0x40)
    sb->st_mode |= S_IFCHR; /* set char file type */
  else
    sb->st_mode |= S_IFREG;  /* set to regular file */
  return (0);     /* return o.k. */
}

/* the following finfo is used by pn2fib to store converted path */
/* it's definition is in lllio5.h */

static struct finfo fibx;

/* pn2fib converts a pathname to file infomation block
 * path has following forms: @SYSTEM(USERNAME,USERKEY)FILENAME,PASSWORD
 *           ^(USERNAME,USERKEY)FILENAME,PASSWORD
 *           (USERNAME)FILENAME
 *           FILENAME
 * Note: USERNAME, USERKEY, or PASSWORD can be blanks to represent NULL
 *
 * address of fibx above is returned if O.K., else 0
 */

/* set l chars in array p to blanks */
#define SETBLK(p,l) memset((p),' ',(l))
char * xt8ch();

struct finfo *
pn2fib(path)
char * path;
{

  int i;
  char *p = path;
  char *tp;

  ZINT ((int *)&fibx,9);    /* clear temp fib */
  if ( !p || !(*p))return(NULL);  /* error if no path */
  /* see if pseudo volume name present, if so, strip path to '(' */
  if (*p == '@' || *p == '^')
    if ((p = strchr(p, '(')) == NULL)return(NULL);
  /* see if username present, if so, copy up to ',' or ')' found */
  if (*p == '(') {
    p++;  /* skip over '(' */
    tp = (char *)fibx.username;
    /* extract username, stop on ',' or ')' */
    if ((p = xt8ch(p, tp, ')')) == NULL)return(NULL);
    if (!(*p))return(NULL); /* if no more chars, error */
    /* if we have a ',' userkey is present */
    if (*p == ',') {
      p++;  /* skip over ',' */
      tp = (char *)fibx.userkey;
      /* extract userkey, stop on ',' or ')' */
      if ((p = xt8ch(p, tp, ')')) == NULL)return(NULL);
      if (!(*p))return(NULL); /* if no more chars, error */
      if (*p == ',')return(NULL); /* bad delimiter */
    }
    /* here, we should be pointing at a ')'. Skip over it */
    ++p;  /* skip over ')' */
  }
  /* now we can process filename and maybe password */
  if (!(*p))return(NULL); /* if no more chars, error */
  tp = (char *)fibx.filename;
  /* extract filename, stop on ',' or EOL */
  if ((p = xt8ch(p, tp, '\0')) == NULL)return(NULL);
  /* if we have a ',' password is present */
  if (*p == ',') {
    p++;  /* skip over ',' */
    tp = (char *)fibx.password;
    /* extract password, stop on ',' or EOL */
    if ((p = xt8ch(p, tp, '\0')) == NULL)return(NULL);
    if (*p == ',')return(NULL); /* bad delimiter */
  }
  /* now we are at end of line, exit if no more chars */
  if ((*p))return(NULL);  /* if more chars, error */
  return (&fibx);
}

/* extract an 8 char name and blank fill if required */
/* return updated pointer on sucess or NULL on failure */

char *
xt8ch(p, tp, tc)
char * p; /* input char string */
char * tp;  /* output char string */
char   tc;  /* secondary delimiter to check for */
    /* for none, use ' ' */
    /* if EOL ('\0') allowed, use '\0' */
{
  int i;

  for (i=0; i < 8; i++){
    /* char must be 0x20 -> 5f */
    /* blanks will specify null */
    if (!(*p) || (*p < 0x20 || *p > 0x5f))
      if (tc != '\0')return(NULL);
    if(*p == ',' || *p == tc)break;
    *tp++ = *p++;
  }
  /* error if no chars found, report error */
  /* if tc is ')' then '()' sequence is ok, null username defined */
  if (tc != ')')
    if (i == 0)return (NULL);

  /* if less than 8 chars, blank fill */
  if (i < 8)SETBLK(tp,(8-i));

  /* if username is > 8 chars, skip over unused chars */
  while (*p && *p != ',' && *p != tc)++p;

  return(p);  /* return updated pointer */
}

access(pname,i)       /* get file access */
char *pname;
int i;
{
  struct stat *sb;  /* status buffer pointer */

  if (stat(pname, sb) != 0) return(-1); /* errno already set */

  return(0);        /* assume all accesses */
}

unlink(pname)       /* delete file */
char *pname;
{
  int reg[8];
  struct finfo * foo; /* file info block pointer */
  char path[64];

  if (pname == 0 || *pname == 0) {
    errno=ENOENT;   /* set file not found error */
    return(-1);   /* error return value */
  }
  strcpy(path, pname);  /* make a local copy */
  unix2mpx(path);   /* convert to MPX path */
  if ((foo = pn2fib(path)) == NULL) {
    errno=ENOENT;   /* set file not found error */
    return(-1);   /* error return value */
  }

  /* set username for this file, save old */
  if (setuser(foo->username, foo->userkey) != NULL) {
    errno=ENOENT;   /* set file not found error */
    return(-1);   /* error return value */
  }

  /* assume no password for file */
  reg[4] = reg[5] = 0;
  /* we need to check for blank (null) password */
  if (strncmp ((char *)foo->password, "        ", 8) == 0)
    ;
  /* not blanks, copy password, could be null or ascii */
  else {
    reg[4] = foo->password[0];  /* set password */
    reg[5] = foo->password[1];  /* set password */
  }
  /* if username is null, delete system file */
  if (tmpuser[0]) reg[3] = 'S'; /* delete system file */
  else reg[3] = 0;    /* delete user file */
  reg[6] = foo->filename[0];  /* first part of filename */
  reg[7] = foo->filename[1];  /* second part of filename */
  mpxsvc (0x1077, reg, reg);  /* m.delete service */
  /* if r7 returned 0, file not deleted */
  if (reg[7] == 0) {
    resetuser();    /* reset username to what it was */
    errno=ENOENT;   /* set file not found error */
    return(-1);   /* error return value */
  }
  /* must reset username to what it before delete */
  resetuser();    /* reset username to what it was */

  return(0);        /* return o.k. */
}

link(path1, path2) /* rename path1 to path2 */
char *path1, *path2;
{
  int reg[8];
  char ppath1[64], ppath2[64];

#ifdef MPX1X
  /* need to fix this someday when I figure out how to do a rename */
  /* for now, just give an error */
  errno = ENOENT;
  return (-1);
#else
  if (path1 == 0 || *path1 == 0) {
    errno=ENOENT;                  /* set file not found error */
    return(-1);                    /* error return value */
  }
  if (path2 == 0 || *path2 == 0) {
    errno=ENOENT;                  /* set file not found error */
    return(-1);                    /* error return value */
  }
  strcpy(ppath1, path1);
  strcpy(ppath2, path2);
  unix2mpx(ppath1);
  unix2mpx(ppath2);

  reg[1] =  (int) ppath1;    /* get address of path1 */
  reg[1] |= (strlen(ppath1) << 24);      /* get path length */
  reg[2] =  (int) ppath2;    /* get address of path2 */
  reg[2] |= (strlen(ppath2) << 24);      /* get path length */
  reg [7] = 0;                      /* no cnp */
  mpxsvc (0x202d, reg, reg);        /* m.renam service */
  if (reg[7] != 0) {
    errno=ENOENT;                  /* set file not found error */
    return(-1);                    /* error return value */
  }
  return(NULL);     /* file renamed */
#endif
}

#ifdef JUNK1X /* not usable in MPX 1X */

mkdir(path, mode)
char * path;
int mode;
{
return (creatd(path,mode));
}
#endif

#endif
