
     Name
          chmod - Changes the access permissions of a file or
          directory.

     Syntax
          chmod [-d] mode file[directory] ...

               chmod [who] +-= [permission ...] file[directory] ...

     Description
          The chmod command changes the access permissions (or mode)
          of a specified file or directory. It is used to control file
          and directory access by users other than the owner and
          super-user.  The mode may be an expression composed of
          letters and operators (called symbolic mode), or a number
          (called absolute mode).  The d option is used to specify
          a directory name instead of a file name.

          A chmod command using symbolic mode has the form:

               chmod [-d] [who] +-= [permission ...] filename[directory]

          In place of who you can use one or any combination of the
          following letters:

          a    Stands for ``all users''. If who is not indicated on
               the command line, a is the default.

          g    Stands for ``group'', all users who have the same project
               name as the owner of the file or directory.

          o    Stands for ``others'', all users on the system.

          u    Stands for ``user'', the owner of the file or
               directory.

          The operators are:

          +    Adds permission

          -    Removes permission

          =    Assigns the indicated permission and removes all other
               permissions (if any) for that who. If no permission is
               assigned, existing permissions are removed.

          Permissions can be any combination of the following letters:

          x    Execute (search permission for directories)

          r    Read

          w    Write

          s    Ignored option

          t    Ignored option

          l    Ignored option

          Multiple symbolic modes may be given, separated by commas,
          on a single command line. See the following Examples section
          for sample permission settings.

          A chmod command using absolute mode has the form:

               chmod mode filename

          where mode is an octal number constructed by performing
          logical OR on the following:

          0400     Read by owner

          0200     Write by owner

          0100     Execute (search in directory) by owner

          0040     Read by project group

          0020     Write by project group

          0010     Execute (search in directory) by project group

          0004     Read by others

          0002     Write by others

          0001     Execute (search in directory) by others

          0000     No permissions

     Examples
        Symbolic Mode
          The following command gives all users execute permission for
          file:

               chmod +x file

          The following command removes read and write permission for
          project group and others from file:

               chmod go-rw file

          The following command gives other users read and write
          permission for file:

               chmod o+rw file

          The following command gives read permission to project group
          and other:

               chmod g+r,o+r file

        Absolute Mode
          The following command gives all users read, write and
          execute permission for file:

               chmod 0777 file

          The following command gives read and write permission to all
          users for file:

               chmod 0666 file

          The following command gives read and write permission to the
          owner of file only:

               chmod 0600 file

     See Also
          ls.m, (NBC)chmod.m

     Notes
          Only the owner or the super-user (SYSTEM) can change the
          permissions of a file or directory.


          (printed 5/7/94 - J B Systems)

