
     Name
          string, strcat, strncat, strcmp, strncmp, strcpy, strncpy,
          strlen, strchr, strrchr, strpbrk, strspn, strcspn, strtok,
          strdup - Performs string operations.

     Syntax
          char *strcat (s1, s2)
          char *s1, *s2;

          char *strncat	(s1, s2, n)
          char *s1, *s2;
          int n;

          int strcmp (s1, s2)
          char *s1, *s2;

          int strncmp (s1, s2, n)
          char *s1, *s2;
          int n;

          char *strcpy (s1, s2)
          char *s1, *s2;

          char *strncpy	(s1, s2, n)
          char *s1, *s2;
          int n;

          int strlen (s)
          char *s;

          char *strchr (s, c)
          char *s;
          int c;

          char *strrchr	(s, c)
          char *s;
          int c;

          char *strpbrk	(s1, s2)
          char *s1, *s2;

          int strspn (s1, s2)
          char *s1, *s2;

          int strcspn (s1, s2)
          char *s1, *s2;

          char *strtok (s1, s2)
          char *s1, *s2;

          char *strdup (s)
          char *s;

     Description
          These	functions operate on null-terminated strings.  They do
          not check for	overflow of any	receiving string.

          strcat appends a copy	of string s2 to	the end	of string s1.
          strncat copies at most n characters.	Both return a pointer
          to the null-terminated result.

          strcmp compares its arguments	and returns an integer greater
          than,	equal to, or less than 0, according to whether s1 is
          lexicographically greater than, equal	to, or less than s2.
          strncmp makes	the same comparison but	looks at no more than
          n characters.

          strcpy copies	string s2 to s1, stopping after	the null
          character has	been moved.  strncpy copies exactly n
          characters, truncating or null-padding s2; the target	may
          not be null-terminated if the	length of s2 is	n or more.
          Both return s1.

          strlen returns the number of non-null	characters in s.

          strchr (strrchr) returns a pointer to	the first (last)
          occurrence of	character c in string s, or NULL if c does not
          occur	in the string.	The null character terminating a
          string is considered to be part of the string.

          strpbrk returns a pointer to the first occurrence in string
          s1 of	any character from string s2, or NULL if no character
          from s2 exists in s1.

          strspn (strcspn) returns the length of the initial segment
          of string s1 which consists entirely of characters from (not
          from)	string s2.

          strtok considers the string s1 to consist of a sequence of
          zero or more text tokens separated by	spans of one or	more
          characters from the separator	string s2.  The	first call
          (with	pointer	s1 specified) returns a	pointer	to the first
          character of the first token,	and will have written a	NULL
          character into s1 immediately	following the returned token.
          Subsequent calls cast	as type	char, with NULL	for the	first
          argument, will work through the string s1 in this way	until
          no tokens remain.  The separator string s2 may be different
          from call to call.  When no token remains in s1, a NULL is
          returned.

          strdup returns a pointer to a	duplicate copy of the string
          pointed to by	s.  The	duplicate string is automatically
          allocated storage using a malloc call.  This call
          allocates the	exact number of	bytes needed to	store the
          string and its terminating null character.

     Notes
          For user convenience,	all the	string functions are declared
          in the <string.h> header file.

          strcmp uses native character comparison, which is unsigned on
          the Encore (Gould) machines.  

          All string movement is performed character by	character
          starting at the left.	 Thus overlapping moves	toward the
          left will work as expected, but overlapping moves to the
          right	may yield surprises.


          (printed 9/16/90 J B Systems)
