  @  /*~!ctscan.c*/  */* Name:  ctscan.c Part No.: _______-____r *  *  - * Copyright 1990 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */      #ident	"@(#)nbclib:ctscan.c	1.0"      /*      @  + * ctscan - syntax scanner for command line +  *  @ *	Gets a string from the line buffer at current cursor position @ ; *	Each call gets one argument of a maximum of N characters ;  *  $ *	1X - T_LINBUF + 17b is scan index $ ; *	     T_LINBUF + 16b is total line buffer length in words ;  *  # *	3X - T_LINBUF + 9b is scan index # : *	     T_LINBUF + 8b is total line buffer length in words :  *  0 *	Calling sequence len = ctscan(buffer, maxlen) 0 	 *	where: 	 2 *		len:	length of line returned, 0 if end of line 2 1 *		buffer:	char pointer to callers return buffer 1 3 *		maxlen:	maximum length of buffer to be returned 3  *   */     #include <mosde.h>     5static char input[255];	/* local copy of scan line */ 5                             @  =static char *linep = 0;	/* current position in input array */ = Dstatic int eol = 0;	/*  end of line flag, set when c/r or ! found */ D    int ctscan(bufr, mlen)  char *	bufr;  	int	mlen; 	 {  $  char cib;	/* current input byte */ $ 4  char sb = 0;	/* zero if skipping leading blanks */ 4 .  char pt = 0;	/* non zero if skipping text */ . )  int cnt = 0;	/* num of chars in bufr */ )    7  /* set output string to null,to show no output yet */ 7 ,  *bufr = '\0';		/* terminate output line */ , 7  if (eol) {		/* at end of line, reset & return null */ 7     eol = 0;  "    return (0);		/* return null */ "   }  I  if (linep == 0 && get_lbuf() == 0) return(0);	/* all done if nothing */ I 3  /* process chars till end of line or max count */ 3       @  &  while ((cib = *linep++) && mlen--) { &     switch (cib) {        case ' ':		/* a blank */  ?        if (pt)goto putout;	/* if passing text, output blank */ ? 6        if (!sb) continue;	/* ignore leading blanks */ 6 .        /* drop thru if not ignoring blanks */ . )      case ',':		/* comma is delimiter */ ) .      case '=':		/* equal sign is delimiter */ . C        if (pt)goto putout;	/* if passing text, output character */ C K        if (cnt == 0) continue;	/* if nothing found yet, ignor delimiter */ K -        goto detok;		/* done with is entry */ - ,      case '\n':	/* new line is delimiter */ , '      case '\r':	/* c/r is delimiter */ ' (      case '\0':	/* null is delimiter */ ( %      case '!':		/* ! is delimiter */ %                     @  -        eol = 1;	/* we are at end of input */ - -        goto detok;		/* done with is entry */ - )      case '\'':	/* apost is delimiter */ ) B        if (pt) goto detok;	/* if passing text, now a delimiter */ B 9        pt = 1;		/* now passing text, throw away apost */ 9         continue;        default:  putout:  2        sb = 1;		/* not skipping blanks anymore */ 2 6        *bufr++ = cib;	/* put char in output buffer */ 6 $        cnt++;		/* bump the count */ $ +        continue;	/* continue processing */ +     }    }  detok:  *  *bufr = '\0';		/* null terminate line */ * A  if (eol) linep = 0;	/* reset linepointer to read input again */ A (  return (cnt);		/* return what we go */ (    }     int get_lbuf()  {                   @  ?  int * tsaa = (int *)(*((int *)C_TSAD));	/* get tsa address */ ? N  char * llba = (char *)tsaa[T_LINBUF/sizeof(int)]; /* get ptr to line bufr */ N >  int maxl = llba[T_LBLEN] << 2;	/* get max length in bytes */ > 8  int lbsi = llba[T_LBSI];		/* get current scan index */ 8 /  int gotone = 0;			/* set when a char found */ /    ?  if (linep != 0)return(0);		/* return if scan buffer active */ ? 2  linep = input;			/* set local pointer address */ 2      while (lbsi < maxl) {  9    if (llba[lbsi] == '\n') break;	/* if C/R, all done */ 9 6    *linep++ = llba[lbsi++];		/* put char in output */ 6 ,    gotone++;				/* count of chars copied */ ,   }  0  if (gotone) {				/* see if any chars copied */ 0 ,    *linep = 0;				/* null terminate line */ ,       @  /    linep = input;			/* reset buffer pointer */ /   } else  6    linep = 0;				/* nothing found reset buffer ptr */ 6 '  return (gotone);			/* return count */ ' }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                