  @  /*~!directory.c*/  -/* Name:  directory.c Part No.: _______-____r -  *  - * Copyright 1992 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */     ##ident	"@(#)nbclib:directory.c	1.1" #     @  #ifdef MPX1X  #include <finfo.h>  #endif     #include <types.h>  #include <string.h>  #include <dirent.h>  #include <ctype.h>  #include <limits.h>  #include <errno.h>  #include <fcntl.h>     extern void	free();  extern int	open();  extern int	close();  extern long	lseek();     #ifdef MPX1X  =static struct finfo foosave;		/* file info block save area */ = $static int smd[8];			/* SMD entry */ $ static int reg[8];  #endif     /*   * open a directory.  * * name is a valid pathname to a directory *  */     DIR * opendir (name)  char *name;  {      DIR *dirp;      int fd;  #ifdef MPX1X  8    static struct finfo *foo;		/* file info block ptr */ 8 #endif         char dirnam[PATH_MAX+32];      @  
    int slen; 
        strcpy(dirnam, name);  0    unix2mpx(dirnam);		/* convert to mpx name */ 0 +    slen = strlen(dirnam);	/* get length */ + /    /* see if name has ^ or @ or ( as 1st char. / +     * if not, try to make it a volume name +      */      switch (*dirnam) {  "      case '\'':		/* it is O.K. */ "         break;  "      case '@':			/* it is O.K. */ " #ifdef JUNK  '    	/* see if @vol^, if so delete ^ */ '     	if (dirnam[slen-1] == '^')      	    dirnam[slen-1] = '\0';  #endif          break;  0      case '^':			/* if just ^, will log dirs */ 0 5    				/* else make sure it has ( around dir name */ 5         if (dirnam[1] == 0)  
    	  break; 
 9    	if (dirnam[1] != '(') {		/* put in () around name */ 9           @  <    	  /* use bcopy because name overlaps. Leave 1 spaces */ < <    	  bcopy (&dirnam[1], &dirnam[2], slen-1);	/* copy it */ <     	  dirnam[1] = '(';      	  dirnam[slen+1] = ')';  0    	  dirnam[slen+2] = '\0';	/* terminate it */ 0 
    	  break; 
     	}  .      case '(':			/* need to add ^ to start */ . :    	/* use bcopy because name overlaps. Leave 1 spaces */ : 4    	bcopy (dirnam, &dirnam[1], slen);	/* copy it */ 4 )    	*dirnam = '^';		/* current volume */ ) .    	dirnam[slen+1] = '\0';	/* terminate it */ .     	break;  %      default:			/* we need to fix */ % :    	/* use bcopy because name overlaps. Leave 2 spaces */ : 4    	bcopy (dirnam, &dirnam[2], slen);	/* copy it */ 4 0    	/* now set ^( at beginning, and ) at end */ 0         @  )    	*dirnam = '^';		/* current volume */ )     	dirnam[1] = '(';      	dirnam[slen+2] = ')';  .    	dirnam[slen+3] = '\0';	/* terminate it */ .     }  #ifdef MPX1X  )    if ((foo = pn2fib(dirnam)) == NULL) { ) 5      errno = ENOTDIR;		/* set dir not found error */ 5 .      return (NULL);		/* error return value */ .     }     -    /* set username for this dir, save old */ - 7    if (setuser(foo->username, foo->userkey) != NULL) { 7 5      errno = ENOTDIR;		/* set dir not found error */ 5 .      return (NULL);		/* error return value */ .     }     >    if ((strncmp((char*)foo->username, "SYSTEM  ", 8) == 0) || > <      (strncmp((char*)foo->username, "        ", 8) == 0) || <                                                                @  ;      ((foo->username[0] == 0) && (foo->username[1] == 0))) ; *      reg[4] = 2;		/* system files only */ *     else  (      reg[4] = 3;		/* user files only */ ( 2    reg[5] = (int)smd;		/* where SMD entry goes */ 2    #else /* MPX1X */     #ifdef JUNK  'printf("opendir:3 dir = %s\n", dirnam); '   if (*dirnam != '\'') {  +    slen = strlen(dirnam);	/* get length */ + 8    /* use bcopy because name overlaps. Leave 1 space */ 8 3    bcopy (dirnam, &dirnam[1], slen);	/* copy it */ 3 ,    *dirnam = '\'';		/* set leading quote */ , -    dirnam[slen+1] = '\0';	/* terminate it */ - (printf("opendir:3a dir = %s\n", dirnam); (     strcat(dirnam, " SHAR=Y'");    }  (printf("opendir:3b dir = %s\n", dirnam); ( #endif                            @    /* open directory */  7  if ((fd = open (dirnam, O_RDONLY | O_UNBLK)) == -1) { 7 #ifdef JUNK  Bprintf("opendir:4 bad OPEN dir = [%s], errno = %x, mpxerr = %x\n", B  dirnam, errno, mpxerr);  #endif      errno = ENOTDIR;      return (NULL);    }  #endif     )  /* get space for the directory entry */ ) 7  if ((dirp = (DIR *) malloc (sizeof (DIR))) == NULL) { 7 #ifdef MPX1X  5    resetuser();		/* reset username to what it was */ 5 #else      close (fd);  #endif      errno = ENOMEM;      return (NULL);    }     *  /* get space for the directory buffer */ * :  if ((dirp->dd_buf = (char *) malloc (DIRBUF)) == NULL) { :     errno = ENOMEM;  #ifdef MPX1X  5    resetuser();		/* reset username to what it was */ 5 #else    @      close (fd);  #endif      free (dirp);      return (NULL);    }     #ifdef MPX1X    dirp->dd_fd = reg[4];    dirp->dd_size = reg[5];  #else    dirp->dd_fd = fd;    dirp->dd_size = 0;  #endif    dirp->dd_loc = 0;  3  /* copy directory name into dirp for later use */ 3 #ifdef MPX1X    strcpy(dirp->dd_dir, dirnam);  #else  $  strcpy(dirp->dd_dir, getpath(fd)); $ #endif  =  return (dirp);        /* return pointer to dir structure */ = }     /*  ! * get next entry in a directory. ! % * dirp is dir ptr from opendir call. %  * this is the unix interface   */     struct dirent *  readdir (dirp)  
DIR *dirp; 
 {    struct dirent *dp;    char *ptr;    char *tp;  	  int  i; 	                           @  2  dp = readmdir(dirp);  /* read directory entry */ 2   if (dp == NULL)return (NULL);     !  /* make lower case file name */ !   ptr = dp->d_name;    ptr--;  6  while (*++ptr)if(isupper(*ptr))*ptr = tolower(*ptr); 6 6  for (i=0; ((i < PATH_MAX) && (ptr[i] != ' ')); i++); 6   ptr = dp->d_name;    if (ptr[0] == '@')  4    ptr[0] = '/';         /* replace @ with slash */ 4 ,  tp = strchr(ptr, '(');     /*  find '(' */ ,   if (tp)*tp = '/';  ,  tp = strchr(ptr, ')');     /*  find ')' */ ,   if (tp)*tp = '/';     #ifdef JUNK  &printf("readdir: file = [%s]\n", ptr); & #endif       return (dp);  }     /*  ! * get next entry in a directory. ! % * dirp is dir ptr from opendir call. %  * this is the mpx interface   */        @  struct dirent * readmdir (dirp)  0register DIR		*dirp;	/* stream from opendir() */ 0 {  7    register struct dirent	*dp;	/* -> directory data */ 7     char *ptr;      int  i;     #ifdef MPX1X  0    if (dirp->dd_size == 0)		/* we are at end */ 0       return (NULL);      reg[4] = dirp->dd_fd;      reg[5] = dirp->dd_size;  3    mpxsvc (0x1073, reg, reg);		/* m.log service */ 3     if (reg[5] == 0) {        dirp->dd_fd = reg[4];        dirp->dd_size = reg[5];        return (NULL);      }  '    dp = (struct dirent *)dirp->dd_buf; '    <    /* copy in anything else we want from smd into dirent */ < ?    memcpy(dp->d_name, (char *)smd, 8);	/* get the file name */ ? 5    dp->d_ino = smd[2] & 0xffffff;	/* disk address */ 5         @  >    dp->d_flags = (unsigned int)smd[3] >> 16;	/* file flags */ > =    dp->d_rdflg = (unsigned int)smd[2] >> 16;	/* file type */ = ,    dp->d_rtype = 10;			/* perminate file */ , /    dp->d_diri = reg[4];		/* smd index value */ / >    memcpy(dp->d_ownr, (char *)&smd[4], 8);	/* get username */ >    "    /* null terminate file name */ "     ptr = dp->d_name;  1    for (i=0; ((i < 8) && (ptr[i] != ' ')); i++); 1     ptr[i] = 0;     "    /* null terminate ownername */ "     ptr = dp->d_ownr;  1    for (i=0; ((i < 8) && (ptr[i] != ' ')); i++); 1     ptr[i] = 0;         dirp->dd_fd = reg[4];      dirp->dd_size = reg[5];      return (dp);     #else       for (;;) {      if (dirp->dd_size == 0) {                                    @  E      dirp->dd_size = readraw (dirp->dd_fd, dirp->dd_buf, DIRBLKSIZ); E       if (dirp->dd_size <= 0)          return (NULL);      }  (    if (dirp->dd_loc >= dirp->dd_size) { ( '      dirp->dd_loc = dirp->dd_size = 0; '       continue;      }  9    dp = (struct dirent *) (dirp->dd_buf + dirp->dd_loc); 9    "    dirp->dd_loc += DIRENTSIZ(dp); "    '    /* if not active entry, continue */ ' $    if (!(dp->d_flags & 0x80000000)) $       continue;         /* null terminate string */      ptr = dp->d_name;  9    for (i=0; ((i < MAXNAMLEN) && (ptr[i] != ' ')); i++); 9     ptr[i] = 0;         return (dp);    }  #endif  }     /*  * * closedir -- C library extension routine *  * close a directory.   */     int     @  closedir( dirp )  0register DIR	*dirp;		/* stream from opendir() */ 0 {      free( dirp->dd_buf );      free( (char *)dirp );  #ifdef MPX1X  5    resetuser();		/* reset username to what it was */ 5     return(0);  #else  !    return(close( dirp->dd_fd )); ! #endif  }     /*   * rewind a directory   */     void rewinddir (dirp)  register DIR *dirp;  {  
#ifndef MPX1X 
 /  lseek(dirp->dd_fd, 0, 0);     /* rewind it */ /   dirp->dd_loc = 0;  #endif  	  return; 	 }     /*  ) * seekdir -- C library extension routine )  */     void  seekdir(dirp, loc)  0register DIR	*dirp;		/* stream from opendir() */ 0 )long		loc;		/* position from telldir() */ ) {     
#ifndef MPX1X 
                                   @       register struct dirent * dp;       if (telldir(dirp) == loc)        return; 		/* save time */      dirp->dd_loc = 0;      lseek(dirp->dd_fd, loc, 0);      dirp->dd_size = 0;  #endif  }     /*  ) * telldir -- C library extension routine )  */     long  telldir( dirp )  (DIR	*dirp;			/* stream from opendir() */ ( {  
#ifndef MPX1X 
     struct dirent *dp;  C    if (lseek(dirp->dd_fd, 0, 1) == 0)	/* if at beginning of dir */ C !      return(0);			/* return 0 */ ! 6    dp = (struct dirent *)&dirp->dd_buf[dirp->dd_loc]; 6 /    return(dp->d_diri * sizeof(struct dirent)); / #else      return(0);			/* return 0 */  #endif  }                                                                                             