  @  /*~!signal.c*/  */* Name:  signal.c Part No.: _______-____r *  *  - * Copyright 1991 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */      #ident	"@(#)nbclib:signal.c	1.1"                @  #include <signal.h>  #include <errno.h>     @static int (*sigfun[NSIG])();	/* function address for signals */ @ <static int abrset = 0;		/* non zero if abort receiver set */ < <static int brkset = 0;		/* non zero if break receiver set */ < 1static int sigval = 0;		/* storage for signals */ 1 3static int signum;		/* storage for signal number */ 3    int (*signal(sig, funct))()  int sig;  int (*funct)();  {      int (*ret)();     1    if (!brkset) {		/* see if we are setup yet */ 1 #    	asm(" zr r4");		/* our task */ #     	asm(" zr r5");  %    	asm(" li r6,3");	/* set value */ % #    	asm(" li r7,0");	/* to zero */ # *    	asm(" svc 1,x'48'");	/* set status */ * $    	brkset++;		/* don't do again */ $                               @  9    	asm(" la r7,BREAK");	/* our break routine address */ 9 4    	asm(" svc 1,x'6e'");	/* tell system about it */ 4     }  !    if (sig <= 0 || sig > NSIG) { !     	errno = EINVAL;  7    	return((int(*)())-1);		/* invalid signal number */ 7     }  0    /* SIGINT is the break receiver interrupt */ 0 1    /* SIGKILL is the abort receiver interrupt */ 1 .    ret = sigfun[sig];		/* return old value */ . 3    sigfun[sig] = funct;	/* set function address */ 3 )    /* test for abort receiver request */ ) ;    if (sig == SIGKILL && (!abrset) && ((int)funct > 16)) { ; <    	asm (" la r7,ABORT");	/* get our abort receiver addr */ < -    	asm (" svc 1,x'60'");	/* set it to us */ - /    	abrset = 1;		/* so we won't do it again */ /     }                   @      return (ret);		/* return */  }     8/* abort receiver established when user requests SIGKILL 8 . * we will enter here 1st before calling user. .  */  
static int 
 4abrtrcv()	/* just a dummy name, we enter at ABORT */ 4 {  '    asm(" bound 1w");		/* word bound */ ' 8    asm("ABORT la sp,STKA-32F");	/* get stack pointer */ 8 $    asm(" sea");		/* run extended */ $ B    if ((int)sigfun[SIGKILL] > 16)	/* see if we have a function */ B +    	sigfun[SIGKILL]();	/* call the user */ + .    asm(" svc 1,x'55'");	/* never to return */ . }     ;/* break receiver for signal functions.  The program option ; ; * word will be read and the signal bits processed.  If non ; ; * are set, we will call the user break receiver because we ;                  @  = * must have got a 'real' break.  The user must read and save = < * the program option word before calling the signal routine < ? * to save any options set during task activation.  The options ? 2 * will be initially zeroed when we are connected. 2  */  
static int 
 brkrcv()  {  '    asm(" bound 1w");		/* word bound */ ' 8    asm("BREAK zr r6");		/* setup for get status word */ 8     asm(" zr r7");  $    asm(" sea");		/* run extended */ $ )    asm(" svc 1,x'49'");	/* get status */ ) 2    asm(" stw r7,_sigval");	/* save the signals */ 2 0    asm(" la sp,STKA");		/* get stack pointer */ 0      /* now process the signal */       if (sigval) {  +    	signum = 1;		/* start with signal 1 */ +     	while (sigval) {      	    if(sigval & 1) {   @  %    		/* found a signal to process */ % $    		asm(" zr r4");		/* our task */ $     		asm(" zr r5");  &    		asm(" li r6,2");	/* reset bit */ & 2    		asm(" li r7,32");	/* bits start from left */ 2 6    		asm(" sumw r7,_signum");	/* get signal number */ 6 1    		asm(" svc 1,x'48'");	/* reset signal bit */ 1 %    		/* see if we have a function */ % #    		if ((int)sigfun[signum] > 16) # 5    		    sigfun[signum](signum);	/* call the user */ 5 
    	    } 
 &    	    signum++;			/* next signal */ & .    	    sigval >>= 1;		/* next bit to test */ .     	}  (    } else if ((int)sigfun[SIGINT] > 16) ( 1    	sigfun[SIGINT](SIGINT);		/* call the user */ 1 3    asm(" svc 1,x'70'");		/* exit break receiver */ 3 }                                         @  '/* just a dummy for stack definition */ ' 
static int 
 dummy()  {  *    asm(" dsect");		/* data is in dsect */ *     asm(" bound 1f");  )    asm(" res 64f");		/* 2k byte stack */ ) .    asm("STKA equ  $");		/* bottom of stack */ . -    asm(" res 1f");		/* for stack bounding */ - B    asm("PARM res 1w");		/* parameter storage location for call */ B 2    asm(" rez 7w");		/* just for the hell of it */ 2     asm(" csect");  }                                                                                                                                                                                                                                                                                                                                  