  @  /*~!time_comm.c*/  -/* Name:  time_comm.c Part No.: _______-____r -  *  - * Copyright 1992 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */     ##ident	"@(#)nbclib:time_comm.c	1.1" #     @  /*  8 * Functions that are common to ctime(3C) and cftime(3C) 8  */  #include	<ctype.h>  #include  	<stdio.h>  #include  	<sys/types.h>  #include 	<time.h>     !#define SEC_IN_DAY	(24 * 60 * 60) ! #define MAXTZNAME	3  ,#define	year_size(A)	(((A) % 4) ? 365 : 366) ,    time_t	timezone = 0;  time_t	altzone = 0;  int 	daylight = 0;  extern char 	*getenv();     Estatic time_t 	start_dst ;    /* Start date of alternate time zone */ E Cstatic time_t  	end_dst;      /* End date of alternate time zone */ C !char 		*tzname[] = {"GMT","   "}; ! 7static short	month_size[12] = { 31, 28, 31, 30, 31, 30, 7 $    				   31, 31, 30, 31, 30, 31 }; $    struct tm *  localtime(tim)  time_t	*tim;  {  	register struct tm *ct;          @  	static void getusa();  	long daybegin, dayend;  	time_t	copyt, curr;     		tzset(); 	 	copyt = *tim - timezone;  	ct = gmtime(&copyt);  	if (!daylight)  
		return(ct); 
    2	curr = ct->tm_yday*SEC_IN_DAY + ct->tm_hour*60*60 2 %    	   + ct->tm_min*60 + ct->tm_sec; %    %	if ( start_dst == 0 && end_dst == 0) % !		getusa(&daybegin, &dayend, ct); ! 	else  	{  		daybegin = start_dst;  		dayend  = end_dst;  	}  '	if (curr >= daybegin && curr < dayend) ' 	{  		copyt = *tim - altzone;  		ct = gmtime(&copyt);  		ct->tm_isdst = 1;  	}  	return(ct);  }     struct tm *  gmtime(tim)  time_t	*tim;  {  	register int		d0, d1;  	long			hms, day;  	static struct tm	xtime;                                      @  %	/* Break initial number into days */ % 	hms = *tim % SEC_IN_DAY;  	day = *tim / SEC_IN_DAY;  	if(hms < 0) {  		hms += SEC_IN_DAY;  		day -= 1;  	}     %	/* Generate hours:minutes:seconds */ % 	xtime.tm_sec = hms % 60;  	d1 = hms / 60;  	xtime.tm_min = d1 % 60;  
	d1 /= 60; 
 	xtime.tm_hour = d1;     	/* Generate day of the week.  8    	 * The addend is 4 mod 7 (1/1/1970 was Thursday) */ 8    &	xtime.tm_wday = (day + 7340036L) % 7; &    	/* Generate year number */  
	if(day >= 0) 
 (		for(d1=70; day >= year_size(d1); d1++) ( 			day -= year_size(d1);  	else  		for(d1=70; day < 0; d1--)  			day += year_size(d1-1);  	xtime.tm_year = d1;  	xtime.tm_yday = d0 = day;     	/* Generate month */                   @  	if(year_size(d1) == 366)  		month_size[1] = 29;  (	for(d1 = 0; d0 >= month_size[d1]; d1++) ( 		d0 -= month_size[d1];  	month_size[1] = 28;  	xtime.tm_mday = d0 + 1;  	xtime.tm_mon = d1;  	xtime.tm_isdst = 0;  	return(&xtime);  }     void  tzset()  {  ,  char *getzname(), *gettime(), *getdigit(); ,   int getdst();    char *ptr;        #	if ( (ptr = getenv("TZ")) == NULL) # 			return; 	 	  6	/* Get main time zone name and difference from GMT */ 6 /	if ( ((ptr = getzname(ptr,tzname[0])) == 0) || / 1    	    ((ptr = gettime(ptr,&timezone,1)) == 0)) 1 			return; 	    	altzone = timezone - 60 * 60;  	start_dst = end_dst = 0;  	daylight = 0;     	  #	/* Get alternate time zone name */ #                          @  +	if ( (ptr = getzname(ptr,tzname[1])) == 0) + 			return; 	 	daylight = 1;     5	/* If the difference between alternate time zone and 5 .	 * GMT is not given, use one hour as default. . 	 */  	if (*ptr == '\0')  			return; 	 	if (*ptr != ';')  ;		if ( (ptr = gettime(ptr,&altzone,1)) == 0 || *ptr != ';') ; 
			return; 
 &	getdst(ptr + 1,&start_dst, &end_dst); & }     
static char * 
 getzname(p,tz)  
char *p, *tz; 
 {    int n = MAXTZNAME;       if (!isalpha(*p))  	return(0);    do    {  
	*tz++ = *p ; 
 &  } while (--n > 0 && isalpha(*++p) ); &   while(isalpha(*p))  	p++;    while(--n >= 0)  $	*tz++ = ' ';		/* Pad with blanks */ $ 
  return(p);	 
 }     
static char * 
 gettime(p,timez,f)  char *p;            @  time_t *timez;  int f;  {  	register time_t t = 0;  	int d, sign = 0;     	d = 0;  	if (f)  +		if ( (sign = (*p == '-')) || (*p == '+')) + 			p++;   	if ( (p = getdigit(p,&d)) != 0)   	{  		t = d * 60 * 60;  		if (*p == ':')  		{  #			if( (p = getdigit(p+1,&d)) != 0) # 			{  				t += d * 60;  				if (*p == ':')  				{  %					if( (p = getdigit(p+1,&d)) != 0) % 
						t += d; 
 				}  			}  		}  	}  		if(sign) 	 		*timez = -t;  	else  
		*timez = t; 
 	return(p);  }     
static char * 
 getdigit(ptr,d)  
char *ptr; 
 int * d;  {        	if (!isdigit(*ptr))  		return(0);  	 	*d = 0; 	 	do  	{  		*d *= 10;  		*d += *ptr - '0';  	}while( (isdigit(*++ptr)));  
	return(ptr); 
 }     @     
static int 
 
getdst(p,s,e) 
 char *p;  time_t *s, *e;  {  
	int lsd,led; 
 	time_t st,et;  >	st = et = 0;	/* Default for start and end time is 00:00:00 */ > #	if ( (p = getdigit(p,&lsd)) == 0 ) # 		return(0);  <	lsd -= 1; 	/* keep julian count in sync with date  1-366 */ < 7	if ( (*p == '/') &&  ((p = gettime(p+1,&st,0)) == 0) ) 7 
			return(0); 
 	if (*p == ',')  	{  &		if ( (p = getdigit(p+1,&led)) == 0 ) & 
			return(0); 
 =		led -= 1; 	/* keep julian count in sync with date  1-366 */ = 7		if ((*p == '/') &&  ((p = gettime(p+1,&et,0)) == 0) ) 7 				return(0);  	}  $	/* Convert the time into seconds */ $ $	*s = (long)(lsd * SEC_IN_DAY + st); $ ;	*e = (long)(led * SEC_IN_DAY + et - (timezone - altzone)); ; 	return(1);  }   @     static struct {      int	yrbgn;      int	daylb;      int	dayle;  } daytab[] = {  9    87,	96,	303,	/* new legislation - 1st Sun in April	*/ 9     76,	119,	303,  >    75,	58,	303,	/* 1975: Last Sun in Feb - last Sun in Oct */ > 4    74,	5,	333,	/* 1974: Jan 6 - last Sun. in Nov */ 4 !    70,	119,	303,	/* start GMT	*/ ! };     static void  
getusa(s,e,t) 
 
int *s,*e; 
 
struct tm *t; 
 {      int i = 0;     C    while (t->tm_year < daytab[i].yrbgn) /* can't be less than 7 */ C 		i++;  8    /* fall through the loop when in correct interval	*/ 8     *s = daytab[i].daylb;      *e = daytab[i].dayle;         *s = sunday(t, *s);      *e = sunday(t, *e);  *    *s = (long)(*s * SEC_IN_DAY +2*60*60); *                     @  (    *e = (long)(*e * SEC_IN_DAY +60*60); (     return;  }     
static int 
 sunday(t, d)  register struct tm *t;  register int d;  {  	if(d >= 58)  #		d += year_size(t->tm_year) - 365; # 5	return(d - (d - t->tm_yday + t->tm_wday + 700) % 7); 5 }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               